/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemoser;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.MultiRequestReference;
import com.cognos.xqe.source.ISource;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqemoser.IMoserModule;
import com.cognos.xqemoser.ModuleIdPair;
import com.cognos.xqemoser.MoserCalculation;
import com.cognos.xqemoser.MoserDataSource;
import com.cognos.xqemoser.MoserEnv;
import com.cognos.xqemoser.MoserFilter;
import com.cognos.xqemoser.MoserMetadataConnection;
import com.cognos.xqemoser.MoserModuleManager;
import com.cognos.xqemoser.MoserModuleUtil;
import com.cognos.xqemoser.MoserParameter;
import com.cognos.xqemoser.MoserQuerySubject;
import com.cognos.xqemoser.MoserRelationship;
import com.cognos.xqemoser.ParameterMapsModule;
import com.ibm.bi.platform.moser.common.utils.IdentifierUtil;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections.map.CaseInsensitiveMap;

public class MoserModule
implements IMoserModule {
    private static final String MOSER_COMMA = ",";
    private static final String SPLIT_DOT = "\\.";
    protected String label = null;
    protected IMoserModule.ModuleType moduleType;
    protected String modificationTime;
    protected TreeSet<ModuleIdPair> importModules = new TreeSet();
    protected String moduleUniqueName;
    protected String identifier;
    @Deprecated
    protected String container;
    protected Locale expressionLocale;
    protected String dataCacheExpiry = null;
    protected ArrayList<MoserQuerySubject> querySubjects = new ArrayList();
    protected Map<String, IMetadata> querySubjectsById = new HashMap<String, IMetadata>();
    protected ArrayList<MoserRelationship> relationships = new ArrayList();
    protected ArrayList<MoserCalculation> calculations = new ArrayList();
    protected ArrayList<MoserFilter> filters = new ArrayList();
    protected ParameterMapsModule parameterMaps = null;
    protected ArrayList<MoserDataSource> datasources = new ArrayList();
    protected HashMap<String, IMetadata> expressionObjects = new HashMap();
    private MoserMetadataConnection metadataConnection;
    private Date lastModifiedDate;
    private String cacheKey;
    private Set<String> missingModules = new TreeSet<String>();
    private ISource source = null;
    private Map<String, Object> moduleInfo = new HashMap<String, Object>();
    protected List<JSONObject> mUseSpecs = new ArrayList<JSONObject>();
    protected Set<String> allTopObjId = new HashSet<String>();
    protected Map<String, MoserParameter> parameters = new HashMap<String, MoserParameter>();
    private final Lock readLock;
    private final Lock writeLock;
    private String mType;
    protected final MultiRequestReference<MoserMetadataConnection> refWrappedMetadataConnection = new MultiRequestReference();
    protected Map<String, Object> properties = new HashMap<String, Object>();

    public MoserModule(MoserMetadataConnection mdConn) {
        this.metadataConnection = mdConn;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.parameterMaps = new ParameterMapsModule(mdConn);
    }

    public String getModificationTime() {
        return this.modificationTime;
    }

    public void setModificationTime(String md) {
        this.modificationTime = md;
    }

    public void addImportModule(ModuleIdPair idPair) {
        this.importModules.add(idPair);
    }

    public void setIdentifier(String id) {
        this.identifier = id;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Deprecated
    public void setContainer(String c) {
        this.container = c;
    }

    @Deprecated
    public String getContainer() {
        return this.container;
    }

    public Locale getExpressionLocale() {
        return this.expressionLocale;
    }

    public void setExpressionLocale(String lc) {
        this.expressionLocale = new Locale(lc);
    }

    public String getDataCacheExpiry() {
        return this.dataCacheExpiry;
    }

    public void setDataCacheExpiry(String theDataCacheExpiry) {
        this.dataCacheExpiry = theDataCacheExpiry;
    }

    public void addQuerySubject(MoserQuerySubject qs) {
        try {
            this.writeLock.lock();
            this.querySubjects.add(qs);
            this.querySubjectsById.put(qs.getName(), qs);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void addCalculation(MoserCalculation calc) {
        this.calculations.add(calc);
    }

    public void addFilter(MoserFilter f) {
        this.filters.add(f);
    }

    public List<IModelDataSource> getModelDataSources(String userPassport, Map<String, String> cookiesToMoser) {
        ArrayList<IModelDataSource> rt = new ArrayList<IModelDataSource>();
        rt.addAll(this.datasources);
        MoserEnv env = new MoserEnv();
        for (ModuleIdPair importModule : this.importModules) {
            if (IMoserModule.ModuleType.REPORT == importModule.getModuleType()) continue;
            MoserModule importModuleObj = (MoserModule)this.metadataConnection.getModule(importModule, userPassport, cookiesToMoser, env);
            rt.addAll(importModuleObj.getModelDataSources(userPassport, cookiesToMoser));
        }
        return rt;
    }

    public void addDataSource(MoserDataSource ds) {
        this.datasources.add(ds);
    }

    public List<MoserDataSource> getDataSourcesInThis() {
        return new ArrayList<MoserDataSource>(this.datasources);
    }

    public void registerExpressionObject(String uName, IMetadata obj) {
        this.expressionObjects.put(uName, obj);
    }

    public IMetadata getExpressionObjectByUName(String uName, String userPassport, Map<String, String> cookiesToMoser, boolean bTryShortName, MoserEnv env) {
        IMetadata rt;
        block13: {
            String[] nameParts = uName.split(SPLIT_DOT);
            rt = null;
            boolean skipSelf = nameParts[0].equals("SKIP_SELF");
            String alias = null;
            if (skipSelf) {
                int four = 4;
                if (nameParts.length < 4) {
                    uName = uName.substring("SKIP_SELF".length() + 1);
                } else {
                    int endAliasIndex = 0;
                    for (int i = 0; i < nameParts.length - 2; ++i) {
                        endAliasIndex += nameParts[i].length() + 1;
                    }
                    alias = uName.substring("SKIP_SELF".length() + 1, endAliasIndex - 1);
                    uName = uName.substring(endAliasIndex);
                }
            } else {
                String prefix;
                if (bTryShortName) {
                    rt = this.getExpressionObjectByShortNameThis(uName);
                }
                if (rt == null) {
                    rt = this.getExpressionObjectByUNameThis(uName);
                }
                if (rt == null && uName.startsWith(prefix = this.getContainer() + "." + this.getIdentifier() + ".")) {
                    String uNameFull = uName.substring(prefix.length());
                    uNameFull = MoserModuleUtil.buildFullQualifiedIdentifier(this, uNameFull);
                    rt = this.getExpressionObjectByUNameThis(uNameFull);
                }
            }
            boolean bl = bTryShortName = bTryShortName || skipSelf;
            if (rt != null) break block13;
            int three = 3;
            if (nameParts.length < 3 && env.getExecutionEnvironment().getRequestEnvironment().isValidateRequest()) {
                return rt;
            }
            if (alias != null) {
                MoserModule importModuleObj = (MoserModule)MoserModuleUtil.getImportModuleByAlias(this, nameParts, userPassport, cookiesToMoser, null, env);
                if (importModuleObj == null) {
                    throw new XQERuntimeException(XQEMessageKeys.MD_MetadataConnectionFailed, this.getSearchPath(alias));
                }
                rt = importModuleObj.getExpressionObjectByUName(uName, userPassport, cookiesToMoser, bTryShortName, env);
            } else {
                for (ModuleIdPair importModule : this.importModules) {
                    MoserModule importModuleObj;
                    if (IMoserModule.ModuleType.REPORT != importModule.getModuleType() && (rt = (importModuleObj = (MoserModule)this.metadataConnection.getModule(importModule, userPassport, cookiesToMoser, env)).getExpressionObjectByUName(uName, userPassport, cookiesToMoser, bTryShortName, env)) != null) break;
                }
            }
        }
        return rt;
    }

    public IMetadata getExpressionObjectByUNameThis(String uName) {
        return this.expressionObjects.get(uName);
    }

    public IMetadata getExpressionObjectByShortNameThis(String shortName) {
        String uName = MoserModuleUtil.buildFullQualifiedIdentifier(this, shortName);
        return this.getExpressionObjectByUNameThis(uName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IMetadata> getRelationships(String userPassport, Map<String, String> cookiesToMoser) {
        ArrayList<IMetadata> rt = new ArrayList<IMetadata>();
        try {
            this.readLock.lock();
            rt.addAll(this.relationships);
        }
        finally {
            this.readLock.unlock();
        }
        MoserEnv env = new MoserEnv();
        for (ModuleIdPair importModule : this.importModules) {
            if (IMoserModule.ModuleType.REPORT == importModule.getModuleType()) continue;
            MoserModule importModuleObj = (MoserModule)this.metadataConnection.getModule(importModule, userPassport, cookiesToMoser, env);
            rt.addAll(importModuleObj.getRelationships(userPassport, cookiesToMoser));
        }
        return rt;
    }

    public void addRelationship(MoserRelationship r) {
        try {
            this.writeLock.lock();
            this.relationships.add(r);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public IMetadata getQuerySubjectByUName(String uName) {
        IMetadata qs = this.getQuerySubjectInThis(this.resolve(uName));
        if (qs != null) {
            return qs;
        }
        return this.getMetadataConnection().bindMetadataReference(uName);
    }

    public List<ModuleIdPair> getImports() {
        return new ArrayList<ModuleIdPair>(this.importModules);
    }

    public List<IMetadata> getPhysicalMetadata(String dataSource, String catalog, String schema, String name, String userPassport, Map<String, String> cookiesToMoser, IPlanningEnvironment planEnv) {
        ArrayList<IMetadata> rt = new ArrayList<IMetadata>(this.getPhysicalMetadataInThis(dataSource, catalog, schema, name, planEnv));
        MoserEnv env = new MoserEnv();
        for (ModuleIdPair importModule : this.importModules) {
            if (IMoserModule.ModuleType.REPORT == importModule.getModuleType()) continue;
            MoserModule importModuleObj = (MoserModule)this.metadataConnection.getModule(importModule, userPassport, cookiesToMoser, env);
            List<IMetadata> mList = importModuleObj.getPhysicalMetadata(dataSource, catalog, schema, name, userPassport, cookiesToMoser, planEnv);
            for (IMetadata m : mList) {
                if (rt.contains(m)) continue;
                rt.add(m);
            }
        }
        return rt;
    }

    public List<IMetadata> getPhysicalMetadataInThis(String dataSource, String catalog, String schema, String name, IPlanningEnvironment planEnv) {
        ArrayList<IMetadata> rt = new ArrayList<IMetadata>();
        for (MoserDataSource ds : this.datasources) {
            IMetadata a;
            if (!ds.matchCMNameCatalogSchema(dataSource, catalog, schema, planEnv) || (a = ds.getTableByName(name)) == null) continue;
            rt.add(a);
        }
        return rt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IMetadata> getEntities(String userPassport, Map<String, String> cookiesToMoser) {
        ArrayList<IMetadata> rt = new ArrayList<IMetadata>();
        if (IMoserModule.ModuleType.PHYSICAL != this.moduleType) {
            try {
                this.readLock.lock();
                rt.addAll(this.querySubjects);
            }
            finally {
                this.readLock.unlock();
            }
        }
        MoserEnv env = new MoserEnv();
        for (ModuleIdPair importModule : this.importModules) {
            if (IMoserModule.ModuleType.REPORT == importModule.getModuleType()) continue;
            MoserModule importModuleObj = (MoserModule)this.metadataConnection.getModule(importModule, userPassport, cookiesToMoser, env);
            rt.addAll(importModuleObj.getEntities(userPassport, cookiesToMoser));
        }
        return rt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IMetadata> getJoins(String userPassport, Map<String, String> cookiesToMoser) {
        ArrayList<IMetadata> rt = null;
        try {
            this.readLock.lock();
            rt = new ArrayList<IMetadata>(this.relationships);
        }
        finally {
            this.readLock.unlock();
        }
        MoserEnv env = new MoserEnv();
        for (ModuleIdPair importModule : this.importModules) {
            if (IMoserModule.ModuleType.REPORT == importModule.getModuleType()) continue;
            MoserModule importModuleObj = (MoserModule)this.metadataConnection.getModule(importModule, userPassport, cookiesToMoser, env);
            rt.addAll(importModuleObj.getJoins(userPassport, cookiesToMoser));
        }
        return rt;
    }

    public List<MoserQuerySubject> getQuerySubjects() {
        try {
            this.readLock.lock();
            List<MoserQuerySubject> list = Collections.unmodifiableList(this.querySubjects);
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public List<MoserRelationship> getRelationships() {
        try {
            this.readLock.lock();
            List<MoserRelationship> list = Collections.unmodifiableList(this.relationships);
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public List<MoserCalculation> getCalculations() {
        return this.calculations;
    }

    public List<MoserFilter> getFilters() {
        return this.filters;
    }

    public List<MoserDataSource> getDataSources() {
        return this.datasources;
    }

    public TreeSet<ModuleIdPair> getImportModules() {
        return this.importModules;
    }

    @Override
    public MoserMetadataConnection getMetadataConnection() {
        MoserMetadataConnection mc = this.refWrappedMetadataConnection.get();
        if (mc != null) {
            return mc;
        }
        return this.metadataConnection;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject result = new JSONObject();
        result.put((Object)"identifier", (Object)this.identifier);
        result.put((Object)"modificationTime", (Object)this.modificationTime);
        return result;
    }

    @Override
    public IMoserModule.ModuleType getModuleType() {
        return this.moduleType;
    }

    public ParameterMapsModule getParameterMaps() {
        return this.parameterMaps;
    }

    public void setModuleType(IMoserModule.ModuleType t) {
        this.moduleType = t;
    }

    public void setUniqueName(String mUniqueName) {
        this.moduleUniqueName = mUniqueName;
    }

    public String getUniqueName() {
        if (this.moduleUniqueName == null) {
            this.moduleUniqueName = this.getContainer() + "." + this.getIdentifier();
        }
        return this.moduleUniqueName;
    }

    private static int getSize(Object objList) {
        if (objList == null) {
            return 0;
        }
        if (objList instanceof List) {
            return ((List)objList).size();
        }
        if (objList instanceof Set) {
            return ((Set)objList).size();
        }
        return 0;
    }

    private int getQueryItemsSize() {
        if (this.getQuerySubjects() == null) {
            return 0;
        }
        int count = 0;
        for (MoserQuerySubject qs : this.getQuerySubjects()) {
            if (qs.getQueryItemsAndMeasures() == null) continue;
            count += qs.getQueryItemsAndMeasures().size();
        }
        return count;
    }

    public String toString() {
        return "Module=" + this.getIdentifier() + " has: Import modules=" + MoserModule.getSize(this.getImportModules()) + MOSER_COMMA + " DataSources=" + MoserModule.getSize(this.getDataSources()) + MOSER_COMMA + " QuerySubjects=" + MoserModule.getSize(this.getQuerySubjects()) + MOSER_COMMA + " Relationships=" + MoserModule.getSize(this.getRelationships()) + MOSER_COMMA + " QueryItems=" + this.getQueryItemsSize() + MOSER_COMMA + " Calculations=" + MoserModule.getSize(this.getCalculations());
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String lb) {
        this.label = lb;
    }

    public void setDatasetLastModifiedDate(Date date) {
        this.lastModifiedDate = date;
    }

    @Override
    public Date getDatasetLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setCacheKey(String key) {
        this.cacheKey = key;
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public void addMissingModule(String searchPath) {
        this.missingModules.add(searchPath);
    }

    public Set<String> getMissingModules() {
        return this.missingModules;
    }

    public ISource getSource() {
        return this.source;
    }

    public void setSource(ISource src) {
        this.source = src;
    }

    public void setModuleInfo(JSONObject info) {
        if (info == null) {
            return;
        }
        this.moduleInfo.putAll((Map<String, Object>)info);
    }

    public Map<String, Object> getModuleInfo() {
        return this.moduleInfo;
    }

    public void addUseSpec(JSONObject importUseSpec) {
        this.mUseSpecs.add(importUseSpec);
    }

    private String getSearchPath(String useID) {
        for (JSONObject jObj : this.mUseSpecs) {
            if (!useID.equals(jObj.get((Object)"identifier"))) continue;
            return (String)jObj.get((Object)"searchPath");
        }
        return null;
    }

    public void removeQuerySubject(MoserQuerySubject moserQuerySubject) {
        try {
            this.writeLock.lock();
            this.querySubjects.remove(moserQuerySubject);
            this.querySubjectsById.remove(moserQuerySubject.getName());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeRelationship(MoserRelationship moserRelationship) {
        try {
            this.writeLock.lock();
            this.relationships.remove(moserRelationship);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected IMetadata getQuerySubjectOrRelationshipThis(String id) {
        if (this.querySubjectsById.containsKey(id)) {
            return this.querySubjectsById.get(id);
        }
        for (MoserRelationship join : this.relationships) {
            if (!id.equals(join.getName())) continue;
            return join;
        }
        return null;
    }

    public void convertLWOLAPToPackages(String userPassport, MoserEnv env) {
        MoserModuleManager mm = this.getMetadataConnection().getModuleManager();
        for (JSONObject useSpec : this.mUseSpecs) {
            String type = (String)useSpec.get((Object)"type");
            if ("report".equals(type)) continue;
            String alias = (String)useSpec.get((Object)"identifier");
            String storeID = (String)useSpec.get((Object)"storeID");
            ModuleIdPair idPair = new ModuleIdPair(storeID, storeID, alias);
            MoserModule subModule = (MoserModule)mm.getExistModuleWrapper(idPair, userPassport);
            if (subModule == null) {
                String searchPath = this.getSearchPath(alias);
                if (this.mUseSpecs.size() == 1 && "lwOLAP".equals(type)) {
                    throw new XQERuntimeException(XQEMessageKeys.MD_MetadataConnectionFailed, searchPath);
                }
                MoserModuleManager.log(LogLevel.WARN, String.format("Unable to establish a metadata connection to data source (%s).", searchPath));
                continue;
            }
            if ("lwOLAP".equals(type)) {
                subModule.getMetadataConnection().addPackageForLWOLAP(alias, subModule, userPassport, new HashMap(useSpec), env);
                continue;
            }
            if (!"module".equals(type)) continue;
            subModule.convertLWOLAPToPackages(userPassport, env);
        }
    }

    public boolean isLWOLAP() {
        return this.mUseSpecs.size() == 1 && "lwOLAP".equals(this.mUseSpecs.get(0).get((Object)"type"));
    }

    private String resolve(String aName) {
        if (aName.startsWith(this.moduleUniqueName) && aName.length() > this.moduleUniqueName.length()) {
            return aName.substring(this.moduleUniqueName.length() + 1);
        }
        return aName;
    }

    public String generateTopLevelObjectID(String name) {
        CaseInsensitiveMap existing = new CaseInsensitiveMap();
        for (String id : this.allTopObjId) {
            existing.put((Object)id, (Object)Boolean.TRUE);
        }
        return IdentifierUtil.makeUniqueAndValidIdentifier((String)name, (CaseInsensitiveMap)existing);
    }

    public Lock getReadLock() {
        return this.readLock;
    }

    public Lock getWriteLock() {
        return this.writeLock;
    }

    public void setType(String theType) {
        this.mType = theType;
    }

    public String getType() {
        return this.mType;
    }

    public MoserParameter getParameter(String name) {
        return this.parameters.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMetadata getQuerySubjectInThis(String uName) {
        try {
            this.readLock.lock();
            IMetadata element = this.querySubjectsById.get(uName);
            if (element != null) {
                IMetadata iMetadata = element;
                return iMetadata;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return null;
    }

    public void setRefWrappedMetadataConnection(MoserMetadataConnection mc, IExecutionEnvironment execEnv, String userPassport, Map<String, String> cookiesToMoser) {
        this.refWrappedMetadataConnection.set(execEnv, mc);
        MoserEnv env = new MoserEnv();
        for (ModuleIdPair importModule : this.importModules) {
            if (IMoserModule.ModuleType.REPORT == importModule.getModuleType()) continue;
            MoserModule importModuleObj = (MoserModule)this.metadataConnection.getModule(importModule, userPassport, cookiesToMoser, env);
            importModuleObj.setRefWrappedMetadataConnection(mc, execEnv, userPassport, cookiesToMoser);
        }
    }

    public void clearRefWrappedMetadataConnection(IExecutionEnvironment execEnv, String userPassport, Map<String, String> cookiesToMoser) {
        this.refWrappedMetadataConnection.clear(execEnv);
        MoserEnv env = new MoserEnv();
        for (ModuleIdPair importModule : this.importModules) {
            if (IMoserModule.ModuleType.REPORT == importModule.getModuleType()) continue;
            MoserModule importModuleObj = (MoserModule)this.metadataConnection.getModule(importModule, userPassport, cookiesToMoser, env);
            importModuleObj.clearRefWrappedMetadataConnection(execEnv, userPassport, cookiesToMoser);
        }
    }
}

