/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemoser;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqemoser.BaseHTTPClient;
import com.cognos.xqemoser.HTTPClientResponse;
import java.util.Map;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.PutMethod;

public class ParquetsUpgradeClient
extends BaseHTTPClient {
    private final String parquetsBasePath = MetadataService.getInstance().getMoserParquetsBasePath();

    public ParquetsUpgradeClient(String passp, Map<String, String> c) {
        super(passp, c);
    }

    public HTTPClientResponse doUpgradeRequest(String theStoreId, String thePQVersion) {
        String moserParquetsURL = this.parquetsBasePath + BaseHTTPClient.encodeURIComponent(theStoreId + "?version=" + thePQVersion);
        PutMethod httpPut = null;
        try {
            httpPut = new PutMethod(moserParquetsURL);
            httpPut.setRequestHeader("Accept", "application/json");
            BaseHTTPClient.setAcceptEncoding((HttpMethodBase)httpPut, this.useHttpCompression);
            BaseHTTPClient.setCookies((HttpMethodBase)httpPut, this.camPassport, this.cookies);
            int code = this.client.executeMethod((HttpMethod)httpPut);
            HTTPClientResponse hTTPClientResponse = new HTTPClientResponse(code, (HttpMethodBase)httpPut);
            return hTTPClientResponse;
        }
        catch (Exception e) {
            throw new XQERuntimeException(XQEMessageKeys.MSR_FailMoserService, (Throwable)e, moserParquetsURL);
        }
        finally {
            if (null != httpPut) {
                httpPut.releaseConnection();
            }
        }
    }
}

