/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemoser;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ReportServiceResponse
extends JSONObject {
    private static final long serialVersionUID = -6307346785109347230L;
    private static final String STR_DATA = "data";
    private static final String STR_ETAG = "eTag";
    private static final String STR_LAST_MODIFIED = "lastModified";
    private static final String STR_RESPONSE_CODE = "responseCode";
    private static final String STR_SEARCH_PATH = "searchPath";
    private static final String STR_SPECIFICATION = "specification";
    private static final String STR_STORE_ID = "storeId";
    private static final Pattern STOREID_PATTERN = Pattern.compile("i[A-F0-9]{32}");
    private final JSONArray data = new JSONArray();
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);

    public ReportServiceResponse() {
        this.put(STR_DATA, this.data);
    }

    public String getEtag() {
        return (String)this.get(STR_ETAG);
    }

    public String setEtag(String value) {
        return (String)this.put(STR_ETAG, value);
    }

    public Long getLastModified() {
        return (Long)this.get(STR_LAST_MODIFIED);
    }

    public Long setLastModified(String value) {
        return (Long)this.put(STR_LAST_MODIFIED, this.extractMillis(value));
    }

    private long extractMillis(String value) {
        try {
            return this.dateFormatter.parse(value).getTime();
        }
        catch (ParseException e) {
            return 0L;
        }
    }

    public Integer getResponseCode() {
        return (Integer)this.get(STR_RESPONSE_CODE);
    }

    public Integer setResponseCode(Integer value) {
        return (Integer)this.put(STR_RESPONSE_CODE, value);
    }

    public String getSearchPath() {
        return (String)this.get(STR_SEARCH_PATH);
    }

    public String setSearchPath(String value) {
        return (String)this.put(STR_SEARCH_PATH, value);
    }

    public String getSpecification() {
        return this.data.isEmpty() ? null : (String)((JSONObject)this.data.get(0)).get((Object)STR_SPECIFICATION);
    }

    public String setSpecification(String value) {
        if (value == null) {
            String result = this.getSpecification();
            this.data.clear();
            return result;
        }
        if (this.data.isEmpty()) {
            this.data.add((Object)new JSONObject());
        }
        return (String)((JSONObject)this.data.get(0)).put((Object)STR_SPECIFICATION, (Object)value);
    }

    public String getStoreId() {
        return (String)this.get(STR_STORE_ID);
    }

    public String setStoreId(String value) {
        this.setSearchPath(ReportServiceResponse.isStoreId(value) ? this.storeIdAsSearchPath(value) : value);
        return (String)this.put(STR_STORE_ID, value);
    }

    public static boolean isStoreId(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        return STOREID_PATTERN.matcher(value).matches();
    }

    private String storeIdAsSearchPath(String value) {
        return "storeID(\"" + value + "\")";
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

