/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemoser;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.OperationEnum;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqemoser.BaseHTTPClient;
import com.cognos.xqemoser.HTTPClientResponse;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.net.HttpCookie;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;

public class UserProfileServiceClient
extends BaseHTTPClient {
    private static final String LOGIN_URL = "/bi/v1/login";
    private static final String UPS_URL = "/bi/v1/users/~/";
    private static final XQELogger WARN_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.WARN);

    public UserProfileServiceClient(String passp, Map<String, String> c) {
        super(passp, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTTPClientResponse getCredentialsFromCM() {
        String url = "/bi/v1/users/~/credentials/datasources";
        GetMethod httpGet = null;
        try {
            if (UserProfileServiceClient.loggingEnabled()) {
                UserProfileServiceClient.log(LogLevel.INFO, OperationEnum.START, "start reading cmcredentials " + url);
            }
            httpGet = new GetMethod();
            httpGet.setPath(url);
            httpGet.setRequestHeader("Accept", "application/json");
            UserProfileServiceClient.setAcceptEncoding((HttpMethodBase)httpGet, this.useHttpCompression);
            UserProfileServiceClient.setCookies((HttpMethodBase)httpGet, this.camPassport, this.cookies);
            int code = this.client.executeMethod((HttpMethod)httpGet);
            HTTPClientResponse resp = new HTTPClientResponse(code, (HttpMethodBase)httpGet);
            if (UserProfileServiceClient.loggingEnabled()) {
                UserProfileServiceClient.log(LogLevel.INFO, OperationEnum.END, "end reading cmcredentials " + url);
            }
            HTTPClientResponse hTTPClientResponse = resp;
            return hTTPClientResponse;
        }
        catch (Exception exception) {
        }
        finally {
            if (httpGet != null) {
                httpGet.releaseConnection();
            }
        }
        return null;
    }

    public String[] getPersonalDataSourceCredential(String dataSourceName, String dataSourceConnectionName) {
        HTTPClientResponse resp = this.getCredentialsFromCM();
        if (resp == null) {
            return null;
        }
        if (resp.getRespondeCode() >= 400) {
            XQERuntimeException e = new XQERuntimeException(XQEMessageKeys.GEN_InvalidResponse, resp.getRespondeCode(), (Object)resp.toString());
            WARN_LOGGER.log(e);
            return null;
        }
        JSONArray data = resp.getJSONArrayResponse();
        if (data == null || data.isEmpty()) {
            return null;
        }
        String[] signon = new String[2];
        for (int i = 0; i < data.size(); ++i) {
            String encryptedValue;
            JSONObject obj = (JSONObject)data.get(i);
            String dsName = (String)obj.get((Object)"dataSourceName");
            String dsConnectionName = (String)obj.get((Object)"dataSourceConnectionName");
            String dsCredentialId = null;
            if (dataSourceName.equals(dsName) && (dataSourceConnectionName.equals(dsConnectionName) || data.size() == 1)) {
                dsCredentialId = (String)obj.get((Object)"id");
            }
            if (dsCredentialId == null) continue;
            signon[0] = dsCredentialId;
            JSONObject cre = (JSONObject)obj.get((Object)"credentials");
            if (cre == null || (encryptedValue = (String)cre.get((Object)"encryptedValue")) == null) continue;
            signon[1] = encryptedValue;
            return signon;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> loginAndGetCookies() {
        String url = LOGIN_URL;
        GetMethod httpGet = null;
        try {
            if (UserProfileServiceClient.loggingEnabled()) {
                UserProfileServiceClient.log(LogLevel.INFO, OperationEnum.START, "start anonymous login " + url);
            }
            httpGet = new GetMethod();
            httpGet.setPath(url);
            httpGet.setRequestHeader("Accept", "application/json");
            UserProfileServiceClient.setAcceptEncoding((HttpMethodBase)httpGet, this.useHttpCompression);
            UserProfileServiceClient.setCookies((HttpMethodBase)httpGet, this.camPassport, this.cookies);
            int code = this.client.executeMethod((HttpMethod)httpGet);
            HTTPClientResponse resp = new HTTPClientResponse(code, (HttpMethodBase)httpGet);
            if (UserProfileServiceClient.loggingEnabled()) {
                UserProfileServiceClient.log(LogLevel.INFO, OperationEnum.END, "end anonymous login " + url);
            }
            HashMap<String, String> cookies = new HashMap<String, String>();
            for (HttpCookie cookie : resp.getCookies()) {
                cookies.put(cookie.getName(), cookie.getValue());
            }
            HashMap<String, String> hashMap = cookies;
            return hashMap;
        }
        catch (Exception exception) {
        }
        finally {
            if (httpGet != null) {
                httpGet.releaseConnection();
            }
        }
        return null;
    }
}

