/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemoser.report;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.util.pool.XQESAXReaderPool;
import com.cognos.xqemoser.IMoserModule;
import com.cognos.xqemoser.ModuleIdPair;
import com.cognos.xqemoser.MoserEnv;
import com.cognos.xqemoser.MoserMetadataConnection;
import com.cognos.xqemoser.MoserModuleManager;
import com.cognos.xqemoser.ReportService;
import com.cognos.xqemoser.ReportServiceResponse;
import com.cognos.xqemoser.report.MoserModuleForReport;
import com.ibm.json.java.JSONObject;
import java.io.StringReader;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;

public final class MoserReportUtil {
    public static IMoserModule loadReport(MoserMetadataConnection mc, MoserModuleManager mm, ModuleIdPair idPair, String userPassport, Map<String, String> cookiesToMoser, JSONObject importUseSpec, MoserEnv env) {
        IMoserModule rtModule = mm.getExistModuleWrapper(idPair, userPassport);
        if (rtModule != null) {
            return rtModule;
        }
        RequestEnvironment reqEnv = (RequestEnvironment)env.getExecutionEnvironment().getRequestEnvironment();
        ReportService rs = reqEnv.getReportService();
        String sId = (String)importUseSpec.get((Object)"storeID");
        String modelPath = (String)importUseSpec.get((Object)"searchPath");
        ReportServiceResponse resp = rs.getSpecification(sId, null);
        long lastModified = resp.getLastModified();
        String specification = resp.getSpecification();
        Document document = null;
        String modelPathOfReport = null;
        String modelTypeOfReport = null;
        String reportName = null;
        Element queries = null;
        String exprLocale = null;
        SAXReader xmlReader = null;
        try {
            xmlReader = XQESAXReaderPool.getInstance().borrowReader();
            document = xmlReader.read(new InputSource(new StringReader(specification)));
            Element root = document.getRootElement();
            if (root == null) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidReportSpec);
            }
            Attribute lc = root.attribute("expressionLocale");
            if (lc != null) {
                exprLocale = lc.getValue();
            }
            List children = root.elements();
            for (Element child : children) {
                String nodeName = child.getName();
                if ("modelPath".equals(nodeName)) {
                    Attribute type = child.attribute("type");
                    if (type != null) {
                        modelTypeOfReport = type.getValue();
                    }
                    modelPathOfReport = child.getText();
                    continue;
                }
                if ("reportName".equals(nodeName)) {
                    reportName = child.getText();
                    continue;
                }
                if (!"queries".equals(nodeName)) continue;
                queries = child;
            }
        }
        catch (Exception e) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidReportSpec);
        }
        finally {
            if (xmlReader != null) {
                try {
                    XQESAXReaderPool.getInstance().returnReader(xmlReader);
                }
                catch (Exception exception) {}
            }
        }
        if (queries == null || modelPathOfReport == null) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidReportSpec);
        }
        MoserModuleForReport newModule = new MoserModuleForReport(mc);
        if (reportName != null) {
            newModule.identifier = reportName;
        }
        if (exprLocale != null) {
            newModule.expressionLocale = exprLocale;
        }
        newModule.lastModifiedDate = new Date(lastModified);
        newModule.document = document;
        newModule.modelPath = modelPathOfReport;
        newModule.modelType = modelTypeOfReport;
        newModule.storeId = sId;
        mm.addModule(idPair, userPassport, newModule);
        return newModule;
    }
}

