/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemoser.time;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5ValueExpression;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.types.DateType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQEAbortGetParametersQueryException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.query.engine.BaseExecutionEnvironment;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTree;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.transformation.v5.util.V5SubQueryBuilder;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqemoser.IMoserModule;
import com.cognos.xqemoser.MoserBaseMetadata;
import com.cognos.xqemoser.MoserCalculation;
import com.cognos.xqemoser.MoserEnv;
import com.cognos.xqemoser.MoserFacet;
import com.cognos.xqemoser.MoserFilter;
import com.cognos.xqemoser.MoserItemNormalization;
import com.cognos.xqemoser.MoserMember;
import com.cognos.xqemoser.MoserModule;
import com.cognos.xqemoser.MoserModuleManager;
import com.cognos.xqemoser.MoserModuleUtil;
import com.cognos.xqemoser.MoserQueryItem;
import com.cognos.xqemoser.MoserQuerySubject;
import com.cognos.xqemoser.MoserRelationship;
import com.cognos.xqemoser.QsClassifierType;
import com.cognos.xqemoser.time.CalendarType;
import com.cognos.xqemoser.time.MoserTimePeriod;
import com.cognos.xqemoser.time.MoserTimeQuerySubject;
import com.cognos.xqemoser.time.TimePeriodType;
import com.ibm.bi.platform.moser.common.utils.FormatConverter;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;

public final class MoserTimeUtil {
    public static final String STR_EQ = " = ";
    public static final String STR_BETWEEN = " between ";
    public static final String STR_AND = " and ";
    public static final String STR_CAST = "cast(";
    public static final String STR_AS_DATE = " as date)";

    public static MoserCalculation initializeItemCalculation(IMoserModule module, MoserQuerySubject qs, JSONObject jQI, IMetadata pParentObj, int locationIdx) {
        String id = (String)jQI.get((Object)"identifier");
        String label = (String)jQI.get((Object)"label");
        MoserCalculation calc = new MoserCalculation(module.getMetadataConnection().getNextId(), id, label, locationIdx);
        calc.setScopesForExpr(MoserQuerySubject.QUERYSUBJECT_AND_MODULE);
        calc.setParentModule((MoserModule)module);
        ((MoserModule)module).addCalculation(calc);
        calc.setDefaultLocale(((MoserModule)module).getExpressionLocale());
        String parentV5UName = null;
        String parentUniqueID = null;
        if (pParentObj != null) {
            calc.setParent(pParentObj);
            parentV5UName = MoserModuleUtil.getV5UniqueName(pParentObj);
            parentUniqueID = MoserModuleUtil.getUniqueId(pParentObj);
        } else if (qs != null) {
            calc.setParent(qs);
            parentV5UName = qs.getV5UniqueName();
            parentUniqueID = qs.getUniqueID();
        } else {
            parentV5UName = ((MoserModule)module).getUniqueName();
            parentUniqueID = ((MoserModule)module).getUniqueName();
        }
        calc.setUniqueID(parentUniqueID + "." + calc.getName());
        calc.setV5UniqueName(UniqueNameGenerator.createEscapedUniqueName(parentV5UName, calc.getName()));
        String expr = (String)jQI.get((Object)"expression");
        calc.setExpression(expr);
        String regAgg = (String)jQI.get((Object)"regularAggregate");
        if (regAgg != null) {
            calc.setRegularAggregate(regAgg);
        }
        ((MoserModule)module).registerExpressionObject(calc.getUniqueID(), calc);
        return calc;
    }

    public static void initializeItemFilter(IMoserModule module, MoserQuerySubject qs, JSONObject jFilter, IMetadata pObj, int location) {
        String id = (String)jFilter.get((Object)"identifier");
        MoserFilter filter = new MoserFilter(module.getMetadataConnection().getNextId(), id, location);
        filter.setParent(qs);
        filter.setParentModule((MoserModule)module);
        ((MoserModule)module).addFilter(filter);
        filter.setDefaultLocale(((MoserModule)module).getExpressionLocale());
        String parentV5UName = null;
        String parentUniqueID = null;
        if (pObj != null) {
            filter.setParent(pObj);
        } else {
            filter.setParent(qs);
        }
        IMetadata pQIorCalc = MoserModuleUtil.getParentQueryItemOrCalculation(pObj);
        if (pQIorCalc != null) {
            parentV5UName = MoserModuleUtil.getV5UniqueName(pQIorCalc);
            parentUniqueID = MoserModuleUtil.getUniqueId(pQIorCalc);
        } else {
            parentV5UName = qs.getV5UniqueName();
            parentUniqueID = qs.getUniqueID();
        }
        filter.setUniqueID(parentUniqueID + "." + filter.getName());
        filter.setV5UniqueName(UniqueNameGenerator.createEscapedUniqueName(parentV5UName, filter.getName()));
        String expr = (String)jFilter.get((Object)"expression");
        filter.setExpression(expr);
        ((MoserModule)module).registerExpressionObject(filter.getUniqueID(), filter);
    }

    public static void createQSforSplitDefinition(MoserModule module, MoserQuerySubject spQS, MoserQueryItem spQI) {
        String ref = spQI.getSplitRef();
        if (ref == null || ref.isEmpty() || "none".equalsIgnoreCase(ref)) {
            return;
        }
        MoserQuerySubject calendarQS = null;
        try {
            calendarQS = (MoserQuerySubject)module.getQuerySubjectByUName(ref);
        }
        catch (Exception e) {
            if (MoserModuleManager.loggingEnabled()) {
                MoserModuleManager.log(LogLevel.TRACE, e.getLocalizedMessage());
            }
            return;
        }
        if (calendarQS == null) {
            return;
        }
        MoserItemNormalization itemNorm = calendarQS.getItemNormalization();
        if (itemNorm == null) {
            return;
        }
        MoserQueryItem pkQI = null;
        List<List<MoserQueryItem>> keys = itemNorm.getUniqueKeys();
        IDataType leftDT = spQI.getDataType();
        for (List<MoserQueryItem> k : keys) {
            IDataType dt;
            if (k.size() != 1 || !DataTypeComparator.areCompatibleDataTypes(leftDT, dt = k.get(0).getDataType())) continue;
            pkQI = k.get(0);
            break;
        }
        if (pkQI == null) {
            return;
        }
        String newQSId = spQS.getName() + "." + spQI.getName();
        MoserQuerySubject newQS = new MoserQuerySubject(module.getMetadataConnection().getNextId(), newQSId, -1);
        newQS.setIsTransient(true);
        newQS.setParentModule(module);
        module.addQuerySubject(newQS);
        newQS.setClassifier(QsClassifierType.QUERY_SUBJECT);
        newQS.setDefinitionType("modelQuery");
        newQS.setQuerySubjectType(IQuerySubject.QuerySubjectTypeEnum.MODELQUERYSUBJECT);
        newQS.setUniqueID(module.getUniqueName() + "." + newQS.getName());
        newQS.setV5UniqueName(UniqueNameGenerator.createEscapedUniqueName(module.getUniqueName(), newQS.getName()));
        MoserQueryItem newPKQI = null;
        List<IMetadata> qis = calendarQS.getQueryItemsAndMeasures();
        int qiPos = 0;
        for (IMetadata md : qis) {
            MoserQueryItem cQI = (MoserQueryItem)md;
            MoserQueryItem newQI = new MoserQueryItem(module.getMetadataConnection().getNextId(), cQI.getName(), qiPos);
            ++qiPos;
            newQI.setQuerySubject(newQS);
            newQS.addQueryItem(newQI);
            newQI.setDefaultLocale(module.getExpressionLocale());
            newQI.setUniqueID(newQS.getUniqueID() + "." + newQI.getName());
            newQI.setV5UniqueName(UniqueNameGenerator.appendUniqueName(newQS.getV5UniqueName(), newQI.getName()));
            newQI.setUsage(cQI.getUsage());
            newQI.setDataType(cQI.getDataType());
            newQI.setIsNullable(cQI.isNullable());
            newQI.setRegularAggregate(cQI.getRegularAggregate());
            newQI.setFormat(cQI.getFormat());
            newQI.setExpression(cQI.getV5UniqueName());
            newQI.setFacet((MoserFacet)cQI.getFacet());
            module.registerExpressionObject(newQI.getUniqueID(), newQI);
            if (!pkQI.equals(cQI)) continue;
            newPKQI = newQI;
        }
        String newJoinName = spQS.getName() + "_" + newQS.getName();
        MoserRelationship r = new MoserRelationship(module.getMetadataConnection().getNextId(), newJoinName);
        r.setLeftRefObject(spQS);
        r.setLeftRefObjectId(spQS.getID());
        r.setLeftCardinality(IRelationship.Cardinality.ONE_MANY);
        r.setRightRefObject(newQS);
        r.setRightRefObjectId(newQS.getID());
        r.setRightCardinality(IRelationship.Cardinality.ONE_ONE);
        IDataType rightDT = newPKQI.getDataType();
        boolean toDateType = false;
        if (!leftDT.equals(rightDT)) {
            toDateType = leftDT.equals(DateType.DATETYPE) || rightDT.equals(DateType.DATETYPE);
        }
        StringBuilder sb = new StringBuilder();
        if (toDateType && !leftDT.equals(DateType.DATETYPE)) {
            sb.append(STR_CAST);
            sb.append(UniqueNameGenerator.appendUniqueName(spQS.getV5UniqueName(), spQI.getName()));
            sb.append(STR_AS_DATE);
        } else {
            sb.append(UniqueNameGenerator.appendUniqueName(spQS.getV5UniqueName(), spQI.getName()));
        }
        sb.append(STR_EQ);
        if (toDateType && !rightDT.equals(DateType.DATETYPE)) {
            sb.append(STR_CAST);
            sb.append(UniqueNameGenerator.appendUniqueName(newQS.getV5UniqueName(), newPKQI.getName()));
            sb.append(STR_AS_DATE);
        } else {
            sb.append(UniqueNameGenerator.appendUniqueName(newQS.getV5UniqueName(), newPKQI.getName()));
        }
        r.setExpression(sb.toString());
        r.setUniqueID(module.getUniqueName() + "." + newJoinName);
        r.setDefaultLocale(module.getExpressionLocale());
        spQS.setInvolvedInJoins(true);
        newQS.setInvolvedInJoins(true);
        r.setParentModule(module);
        module.addRelationship(r);
    }

    public static void createTimeQuerySubject(JSONObject jQS, IMoserModule module, String userPassport, List<MoserModuleUtil.ExpressionResolveContext> c, Map<String, String> cookiesToMoser, boolean bTop, MoserEnv env, FormatConverter fc) {
        String name = (String)jQS.get((Object)"identifier");
        MoserTimeQuerySubject qs = new MoserTimeQuerySubject(module.getMetadataConnection().getNextId(), name);
        qs.setParentModule((MoserModule)module);
        ((MoserModule)module).addQuerySubject(qs);
        qs.setDefaultLocale(((MoserModule)module).getExpressionLocale());
        qs.setClassifier(QsClassifierType.QUERY_SUBJECT);
        String qsUsage = (String)jQS.get((Object)"querySubjectUsage");
        String calendarType = qsUsage.substring("time".length());
        if (calendarType.startsWith("/")) {
            calendarType = calendarType.substring(1);
            CalendarType tp = CalendarType.fromValue(calendarType);
            qs.setCalendarType(tp);
        }
        MoserModuleUtil.initializeQuerySubject(module, qs, jQS, userPassport, c, cookiesToMoser, bTop, env, fc);
    }

    public static void initializeTimePeriod(IMoserModule module, MoserTimeQuerySubject qs, MoserQueryItem qi, JSONArray calcMembers) {
        if (calcMembers == null || calcMembers.size() == 0) {
            return;
        }
        for (int i = 0; i < calcMembers.size(); ++i) {
            JSONObject calc = (JSONObject)calcMembers.get(i);
            String id = (String)calc.get((Object)"identifier");
            TimePeriodType tp = TimePeriodType.fromValue(id);
            String expr = (String)calc.get((Object)"expression");
            MoserTimeUtil.createMoserTimePeriod(module, qs, qi, tp, id, expr);
        }
    }

    protected static MoserTimePeriod createMoserTimePeriod(IMoserModule module, MoserTimeQuerySubject qs, MoserQueryItem qi, TimePeriodType tp, String id, String expr) {
        MoserTimePeriod tmP = new MoserTimePeriod(module.getMetadataConnection().getNextId(), id, tp);
        tmP.setOwnerQueryItem(qi);
        qi.addTimePeriod(tmP);
        if (expr != null) {
            tmP.setExpression(expr);
        }
        if (tp == TimePeriodType.AS_OF_DATE) {
            qs.addTimePeriod(tp, tmP);
        }
        String uniqueId = qs.getName() + "." + qi.getName() + "." + id;
        tmP.setUniqueID(uniqueId);
        ((MoserModule)module).registerExpressionObject(uniqueId, tmP);
        return tmP;
    }

    public static void initializeSplitDefinition(MoserModule module, MoserQuerySubject qs, MoserQueryItem qi, JSONArray split) {
        if (split == null || split.size() == 0) {
            return;
        }
        for (int i = 0; i < split.size(); ++i) {
            JSONObject sp = (JSONObject)split.get(i);
            String ref = (String)sp.get((Object)"ref");
            MoserQuerySubject calendarQS = (MoserQuerySubject)module.getQuerySubjectByUName(ref);
            if (calendarQS == null) continue;
            List<IMetadata> qis = calendarQS.getQueryItemsAndMeasures();
            for (IMetadata md : qis) {
                MoserQueryItem cQI = (MoserQueryItem)md;
                List<MoserTimePeriod> cPeriods = cQI.getTimePeriods();
                for (MoserTimePeriod cp : cPeriods) {
                    String uniqueId = qs.getName() + "." + qi.getName() + "." + cp.getUniqueID();
                    MoserTimePeriod tmP = new MoserTimePeriod(module.getMetadataConnection().getNextId(), uniqueId, cp.getType());
                    tmP.setOwnerQueryItem(qi);
                    tmP.setTargetPeriod(cp);
                    qi.addTimePeriod(tmP);
                    tmP.setUniqueID(uniqueId);
                    module.registerExpressionObject(uniqueId, tmP);
                }
            }
        }
    }

    public static IXQEQueryNode createFilter(PlanningEnvironment environment, MoserTimePeriod tp) {
        MoserQueryItem dateCol = tp.getOwnerQueryItem();
        MoserBaseMetadata target = tp.getTargetPeriod();
        if (!(target instanceof MoserTimePeriod)) {
            return null;
        }
        MoserTimePeriod timePeriod = (MoserTimePeriod)target;
        TimePeriodType tpType = timePeriod.getType();
        if (tpType == TimePeriodType.PERIOD_TO_DATE) {
            return MoserTimeUtil.createPeriodToDateFilter(environment, dateCol, timePeriod, TimePeriodType.AS_OF_DATE);
        }
        if (tpType == TimePeriodType.PY_PERIOD_TO_DATE) {
            return MoserTimeUtil.createPeriodToDateFilter(environment, dateCol, timePeriod, TimePeriodType.PY_AS_OF_DATE);
        }
        return null;
    }

    public static IXQEQueryNode createCalculation(PlanningEnvironment environment, MoserMember moserMember, MoserTimePeriod tp) {
        MoserQueryItem measure = moserMember.getOwnerQueryItem();
        MoserQueryItem dateCol = tp.getOwnerQueryItem();
        MoserBaseMetadata target = tp.getTargetPeriod();
        if (!(target instanceof MoserTimePeriod)) {
            return null;
        }
        MoserTimePeriod timePeriod = (MoserTimePeriod)target;
        TimePeriodType tpType = timePeriod.getType();
        if (tpType == TimePeriodType.PERIOD_TO_DATE) {
            return MoserTimeUtil.createPeriodToDate(environment, measure, dateCol, timePeriod, TimePeriodType.AS_OF_DATE);
        }
        if (tpType == TimePeriodType.PY_PERIOD_TO_DATE) {
            return MoserTimeUtil.createPeriodToDate(environment, measure, dateCol, timePeriod, TimePeriodType.PY_AS_OF_DATE);
        }
        if (tpType == TimePeriodType.PERIOD_TO_DATE_CHANGE_PY) {
            IXQEQueryNode a = MoserTimeUtil.createPeriodToDate(environment, measure, dateCol, timePeriod, TimePeriodType.AS_OF_DATE);
            IXQEQueryNode b = MoserTimeUtil.createPeriodToDate(environment, measure, dateCol, timePeriod, TimePeriodType.PY_AS_OF_DATE);
            XQENodeFactory nodeFactory = environment.getNodeFactory();
            V5ValueExpression minusOp = (V5ValueExpression)nodeFactory.createNode(201014);
            minusOp.setSubType(1);
            minusOp.addChild(a);
            minusOp.addChild(b);
            return minusOp;
        }
        return null;
    }

    protected static String adjustTimePeriodName(MoserTimePeriod timePeriod, TimePeriodType anchor) {
        String rt = null;
        TimePeriodType tpType = timePeriod.getType();
        if (tpType == TimePeriodType.PERIOD_TO_DATE_CHANGE_PY) {
            if (anchor == TimePeriodType.AS_OF_DATE) {
                rt = TimePeriodType.PERIOD_TO_DATE.value();
            } else if (anchor == TimePeriodType.PY_AS_OF_DATE) {
                rt = TimePeriodType.PY_PERIOD_TO_DATE.value();
            }
        }
        if (rt != null) {
            return rt;
        }
        return timePeriod.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static IXQEQueryNode createPeriodToDateFilter(PlanningEnvironment environment, MoserQueryItem dateCol, MoserTimePeriod timePeriod, TimePeriodType anchor) {
        List<MoserFilter> filters;
        StringBuilder sb = new StringBuilder();
        sb.append(dateCol.getQuerySubject().getName());
        sb.append("_");
        sb.append(dateCol.getName());
        sb.append("_");
        sb.append(timePeriod.getOwnerQueryItem().getQuerySubject().getName());
        sb.append("_");
        sb.append(timePeriod.getOwnerQueryItem().getName());
        sb.append("_");
        sb.append(MoserTimeUtil.adjustTimePeriodName(timePeriod, anchor));
        String newName = sb.toString();
        MoserQuerySubject qs = (MoserQuerySubject)dateCol.getQuerySubject();
        MoserModule module = qs.getParentModule();
        MoserFilter filterForTP = null;
        Lock rLock = module.getReadLock();
        Lock wLock = module.getWriteLock();
        try {
            rLock.lock();
            filters = module.getFilters();
            for (MoserFilter f : filters) {
                if (!newName.equals(f.getName())) continue;
                filterForTP = f;
                break;
            }
        }
        finally {
            rLock.unlock();
        }
        if (filterForTP == null) {
            try {
                wLock.lock();
                filters = module.getFilters();
                for (MoserFilter f : filters) {
                    if (!newName.equals(f.getName())) continue;
                    filterForTP = f;
                    break;
                }
                if (filterForTP == null) {
                    filterForTP = MoserTimeUtil.createFilterForTimePeriod(environment, newName, dateCol, timePeriod, anchor);
                }
            }
            finally {
                wLock.unlock();
            }
        }
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5BoundModelIdentifier boundNode = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
        boundNode.setMetadata(filterForTP);
        boundNode.setIdentifier(filterForTP.getUniqueID());
        return boundNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static IXQEQueryNode createPeriodToDate(PlanningEnvironment environment, MoserQueryItem measure, MoserQueryItem dateCol, MoserTimePeriod timePeriod, TimePeriodType anchor) {
        List<MoserCalculation> cals;
        StringBuilder sb = new StringBuilder();
        sb.append(measure.getQuerySubject().getName());
        sb.append("_");
        sb.append(measure.getName());
        sb.append("_");
        sb.append(dateCol.getQuerySubject().getName());
        sb.append("_");
        sb.append(dateCol.getName());
        sb.append("_");
        sb.append(timePeriod.getOwnerQueryItem().getQuerySubject().getName());
        sb.append("_");
        sb.append(timePeriod.getOwnerQueryItem().getName());
        sb.append("_");
        sb.append(MoserTimeUtil.adjustTimePeriodName(timePeriod, anchor));
        String newName = sb.toString();
        MoserQuerySubject qs = (MoserQuerySubject)measure.getQuerySubject();
        MoserModule module = qs.getParentModule();
        MoserCalculation calcForTP = null;
        Lock rLock = module.getReadLock();
        Lock wLock = module.getWriteLock();
        try {
            rLock.lock();
            cals = module.getCalculations();
            for (MoserCalculation c : cals) {
                if (!newName.equals(c.getName())) continue;
                calcForTP = c;
                break;
            }
        }
        finally {
            rLock.unlock();
        }
        if (calcForTP == null) {
            try {
                wLock.lock();
                cals = module.getCalculations();
                for (MoserCalculation c : cals) {
                    if (!newName.equals(c.getName())) continue;
                    calcForTP = c;
                    break;
                }
                if (calcForTP == null) {
                    calcForTP = MoserTimeUtil.createCalculationForMeasureForTimePeriod(environment, newName, measure, dateCol, timePeriod, anchor);
                }
            }
            finally {
                wLock.unlock();
            }
        }
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5BoundModelIdentifier boundNode = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
        boundNode.setMetadata(calcForTP);
        boundNode.setIdentifier(calcForTP.getUniqueID());
        return boundNode;
    }

    protected static MoserFilter createFilterForTimePeriod(PlanningEnvironment environment, String mName, MoserQueryItem dateCol, MoserTimePeriod timePeriod, TimePeriodType anchor) {
        MoserQuerySubject srcQS = (MoserQuerySubject)dateCol.getQuerySubject();
        MoserModule module = srcQS.getParentModule();
        MoserFilter filter = new MoserFilter(module.getMetadataConnection().getNextId(), mName, -1);
        filter.setParentModule(module);
        module.addFilter(filter);
        filter.setDefaultLocale(module.getExpressionLocale());
        filter.setUniqueID(module.getUniqueName() + "." + filter.getName());
        filter.setV5UniqueName(UniqueNameGenerator.createEscapedUniqueName(module.getUniqueName(), filter.getName()));
        MoserQueryItem cQI = timePeriod.getOwnerQueryItem();
        MoserTimeQuerySubject cQS = (MoserTimeQuerySubject)cQI.getQuerySubject();
        StringBuilder sb = new StringBuilder();
        MoserTimePeriod anchorTP = MoserTimeUtil.getAnchorTimePeriod(module, cQS, anchor);
        if (anchorTP == null) {
            sb.append("null");
        } else {
            String filterStr = cQS.getName() + "." + anchorTP.getOwnerQueryItem().getName() + STR_EQ + anchorTP.expression;
            String expr = cQS.getName() + "." + cQI.getName();
            String startDate = MoserTimeUtil.queryValue(environment, expr, filterStr);
            if (startDate == null) {
                sb.append("null");
            } else {
                sb.append(dateCol.getV5UniqueName());
                sb.append(STR_BETWEEN);
                sb.append(startDate);
                sb.append(STR_AND);
                sb.append(anchorTP.expression);
            }
        }
        filter.setExpression(sb.toString());
        return filter;
    }

    protected static MoserCalculation createCalculationForMeasureForTimePeriod(PlanningEnvironment environment, String mName, MoserQueryItem measure, MoserQueryItem dateCol, MoserTimePeriod timePeriod, TimePeriodType anchor) {
        MoserQuerySubject srcQS = (MoserQuerySubject)measure.getQuerySubject();
        MoserModule module = srcQS.getParentModule();
        MoserCalculation calc = new MoserCalculation(module.getMetadataConnection().getNextId(), mName, -1);
        calc.setParentModule(module);
        module.addCalculation(calc);
        calc.setDefaultLocale(module.getExpressionLocale());
        calc.setUniqueID(module.getUniqueName() + "." + calc.getName());
        calc.setV5UniqueName(UniqueNameGenerator.createEscapedUniqueName(module.getUniqueName(), calc.getName()));
        calc.setRegularAggregate(measure.getRegularAggregate());
        MoserQueryItem cQI = timePeriod.getOwnerQueryItem();
        MoserTimeQuerySubject cQS = (MoserTimeQuerySubject)cQI.getQuerySubject();
        StringBuilder sb = new StringBuilder();
        MoserTimePeriod anchorTP = MoserTimeUtil.getAnchorTimePeriod(module, cQS, anchor);
        if (anchorTP == null) {
            sb.append("null");
        } else {
            String filterStr = cQS.getName() + "." + anchorTP.getOwnerQueryItem().getName() + STR_EQ + anchorTP.expression;
            String expr = cQS.getName() + "." + cQI.getName();
            String startDate = MoserTimeUtil.queryValue(environment, expr, filterStr);
            if (startDate == null) {
                sb.append("null");
            } else {
                sb.append("case when ");
                sb.append(dateCol.getV5UniqueName());
                sb.append(STR_BETWEEN);
                sb.append(startDate);
                sb.append(STR_AND);
                sb.append(anchorTP.expression);
                sb.append(" then ");
                sb.append(measure.getV5UniqueName());
                sb.append(" end");
            }
        }
        calc.setExpression(sb.toString());
        return calc;
    }

    protected static MoserTimePeriod getAnchorTimePeriod(MoserModule module, MoserTimeQuerySubject cQS, TimePeriodType anchor) {
        MoserTimePeriod tp = cQS.getTimePeriod(anchor);
        if (tp != null) {
            if (anchor == TimePeriodType.AS_OF_DATE && tp.expression == null) {
                tp.expression = "current_date";
            }
            return tp;
        }
        if (anchor == TimePeriodType.PY_AS_OF_DATE && cQS.calendarType == CalendarType.GREGORIAN) {
            MoserTimePeriod asOfDate = MoserTimeUtil.getAnchorTimePeriod(module, cQS, TimePeriodType.AS_OF_DATE);
            if (asOfDate == null) {
                return null;
            }
            String expr = "_add_years(" + asOfDate.expression + "; -1)";
            return MoserTimeUtil.createMoserTimePeriod(module, cQS, asOfDate.getOwnerQueryItem(), anchor, anchor.value(), expr);
        }
        return null;
    }

    /*
     * Loose catch block
     */
    protected static String queryValue(PlanningEnvironment environment, String expr, String filter) {
        ExecutionEnvironmentContext env;
        PlanningEnvironment subQueryEnvironment;
        String v5Str;
        block18: {
            v5Str = null;
            subQueryEnvironment = V5SubQueryBuilder.createPlanningEnvironmentWithoutTracing((ExecutionEnvironment)environment.getExecutionEnvironment(), environment);
            V5QuerySet v5QuerySet = V5SubQueryBuilder.createSingleExpressionQuery(expr, subQueryEnvironment);
            if (filter != null) {
                XQENodeFactory nf = subQueryEnvironment.getNodeFactory();
                V5DetailFilter detailFilter = (V5DetailFilter)nf.createNode(101008);
                detailFilter.setPostAutoAggregation(false);
                IXQEQueryNode filterExpressionNode = nf.createNode(101013);
                filterExpressionNode.setPropertyValue("expression", filter);
                detailFilter.addChild(filterExpressionNode);
                IXQEQueryNode[] queries = v5QuerySet.getChildrenOfType(101006);
                queries[0].addChild(detailFilter);
            }
            RequestEnvironment subRequestEnvironment = (RequestEnvironment)subQueryEnvironment.getRequestEnvironment();
            BaseExecutionEnvironment execEnv = null;
            env = null;
            XDataContext dataContext = null;
            try {
                PlannedV5QuerySet plannedQuery = QueryPlanner.getInstance().planQuery(v5QuerySet, subQueryEnvironment);
                subQueryEnvironment.setPlanningActive(subRequestEnvironment);
                execEnv = (ExecutionEnvironment)subQueryEnvironment.getExecutionEnvironment();
                env = ExecutionEnvironmentContext.enter(execEnv);
                dataContext = execEnv.pushDataContext();
                XTree xTree = (XTree)plannedQuery.getFirstDescendantOfTypeOrdered(501021, false);
                IHybridResultSet hybridResultSet = V5SubQueryBuilder.executeSubQuery(dataContext, xTree);
                try {
                    IValue v = V5SubQueryBuilder.getValueFromSubQuery(hybridResultSet);
                    if (v != null && !v.isNull()) {
                        v5Str = v.toString();
                    }
                }
                catch (Throwable t) {
                    throw t;
                }
                finally {
                    hybridResultSet.release();
                }
                if (execEnv == null || dataContext == null) break block18;
            }
            catch (XQEAbortGetParametersQueryException e) {
                String string = null;
                return string;
            }
            catch (Throwable t) {
                throw t;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (execEnv != null && dataContext != null) {
                    execEnv.popDataContext(dataContext);
                }
                if (env != null) {
                    env.exit();
                }
            }
            execEnv.popDataContext(dataContext);
        }
        if (env != null) {
            env.exit();
        }
        subQueryEnvironment.setPlanningInactive();
        return v5Str;
    }
}

