/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqeqte;

import com.cognos.xqeqte.QTEPlanningEnvironment;
import com.cognos.xqeqte.QTEQueryNode;
import com.cognos.xqeqte.QTESharedPassNumbers;
import com.cognos.xqeqte.QTETransformationLibrary;
import com.cognos.xqeqte.exceptions.QTENoOpTransformationAppliedException;
import com.cognos.xqeqte.exceptions.QTERuntimeException;

public abstract class QTEAbstractTransformation<N extends QTEQueryNode, P extends QTEPlanningEnvironment<N>> {
    public static final String PASSES_QUERY_CONDITION = "passesQueryCondition";
    public static final String PASSES_NODE_CONDITION = "passesNodeCondition";
    public static final String EXCEPTION_MESSAGE = "exceptionMessage";
    public static final String NO_QUERY_CONDITION = "No Query Condition";
    public static final String NO_NODE_CONDITION = "No Node Condition";
    public static final String PASS = "pass";
    protected int[] mPassNumbers = new int[]{-1};
    protected int[] mTypes = null;
    protected String mName = null;
    protected boolean mBottomUpRestart = false;
    protected Mode mMode = Mode.UNDEFINED;
    protected ApplicableIterations mApplicableIterations = ApplicableIterations.UNDEFINED;
    private QTETransformationLibrary<N, P> mLibrary;
    private static boolean mDeterminedIfLibraryPreceedsName = false;
    private static boolean mPreceedNameByLibraryName;
    private boolean mSharedPassNumbers = false;

    public QTEAbstractTransformation() {
        this.mSharedPassNumbers = false;
    }

    public QTEAbstractTransformation(QTESharedPassNumbers sharedPassNumbers) {
        this.mPassNumbers = sharedPassNumbers.getPassNumbers();
        this.mSharedPassNumbers = true;
    }

    public void incrementUsage() {
    }

    public void beginPassesNodeConditionUsage() {
    }

    public void endPassesNodeConditionUsage(boolean pass) {
    }

    public void beginApplyUsage() {
    }

    public void endApplyUsage() {
    }

    public final int[] getPassNumbers() {
        return this.mPassNumbers;
    }

    public final int[] getTypes() {
        return this.mTypes;
    }

    public final String getName() {
        String name;
        if (this.mName == null) {
            name = this.getClass().getName();
            name = name.substring(name.lastIndexOf(46) + 1);
        } else {
            name = this.mName;
        }
        this.determineIfNamePreceededByLibraryName();
        if (mPreceedNameByLibraryName) {
            name = this.getTransformationLibrary().getLibraryName() + ":" + name;
        }
        return name;
    }

    public final Mode getMode() {
        return this.mMode;
    }

    public void resolveMode(Mode libraryValue) {
        if (this.mMode == Mode.UNDEFINED) {
            this.mMode = libraryValue;
            if (this.mMode == Mode.UNDEFINED) {
                this.mMode = Mode.INDEXED;
            }
        }
    }

    public final boolean getBottomUpRestart() {
        return this.mBottomUpRestart;
    }

    public final ApplicableIterations getApplicableIterations() {
        return this.mApplicableIterations;
    }

    public final void resolveApplicableIterations(ApplicableIterations libraryValue) {
        if (this.mApplicableIterations == ApplicableIterations.UNDEFINED) {
            this.mApplicableIterations = libraryValue;
            if (this.mApplicableIterations == ApplicableIterations.UNDEFINED) {
                this.mApplicableIterations = ApplicableIterations.UNLIMITED;
            }
        }
    }

    public boolean passesQueryCondition(N node, P environment) {
        return true;
    }

    public boolean passesNodeCondition(N node, P environment) {
        return true;
    }

    public abstract void apply(N var1, P var2);

    void setTransformationLibrary(QTETransformationLibrary<N, P> library) {
        this.mLibrary = library;
    }

    public QTETransformationLibrary<N, P> getTransformationLibrary() {
        return this.mLibrary;
    }

    private void determineIfNamePreceededByLibraryName() {
        if (mDeterminedIfLibraryPreceedsName) {
            return;
        }
        boolean preceededByLibraryName = this.transformationNamePreceededByLibraryName();
        mPreceedNameByLibraryName = preceededByLibraryName;
        mDeterminedIfLibraryPreceedsName = true;
    }

    protected boolean transformationNamePreceededByLibraryName() {
        return false;
    }

    protected void alignPassNumbersWithLibraryBasePassNumber(int startingPassNumber) {
        if (this.mSharedPassNumbers) {
            return;
        }
        for (int i = 0; i < this.mPassNumbers.length; ++i) {
            if (this.mPassNumbers[i] == -1) continue;
            this.mPassNumbers[i] = this.mPassNumbers[i] + startingPassNumber;
        }
    }

    protected void handleNoOpTransformation() throws QTERuntimeException {
        throw new QTENoOpTransformationAppliedException(this);
    }

    public static enum ApplicableIterations {
        UNDEFINED,
        INITIAL,
        UNLIMITED;

    }

    public static enum Mode {
        UNDEFINED,
        TOP_DOWN,
        TOP_DOWN_FAST,
        BOTTOM_UP,
        INDEXED;

    }
}

