/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqerdp.flint;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqerdp.flint.ClientRequestExecutor;
import com.cognos.xqerdp.flint.FlintApiFacade;
import com.ibm.ba.flint.client.Services;
import com.ibm.ba.flint.thrift.buffer.NoSuchRowBufferException;
import com.ibm.ba.flint.thrift.buffer.RowBufferService;
import com.ibm.ba.flint.thrift.buffer.RowBufferSpec;
import com.ibm.ba.flint.thrift.core.CoreService;
import com.ibm.ba.flint.thrift.dataset.CacheOptions;
import com.ibm.ba.flint.thrift.dataset.DatasetInfo;
import com.ibm.ba.flint.thrift.dataset.DatasetService;
import com.ibm.ba.flint.thrift.dataset.DatasetSpec;
import com.ibm.ba.flint.thrift.dataset.NoSuchDatasetException;
import com.ibm.ba.flint.thrift.query.CursorInfo;
import com.ibm.ba.flint.thrift.query.CursorOptions;
import com.ibm.ba.flint.thrift.query.NoSuchCursorException;
import com.ibm.ba.flint.thrift.query.QueryService;
import com.ibm.ba.flint.thrift.query.SamplingOptions;
import com.ibm.ba.flint.thrift.query.SerializedResultInfo;
import com.ibm.ba.flint.thrift.sinks.AnySink;
import com.ibm.ba.flint.thrift.sinks.SaveOptions;
import com.ibm.ba.flint.thrift.types.ResultSet;
import com.ibm.ba.flint.thrift.types.Row;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import org.apache.thrift.TException;

class FlintApiFacadeImpl
implements FlintApiFacade {
    private final ClientRequestExecutor requestExecutor;

    FlintApiFacadeImpl(ClientRequestExecutor requestExecutor) {
        this.requestExecutor = requestExecutor;
    }

    @Override
    public ZoneId getServerZoneId() {
        try {
            return ZoneId.of(this.requestExecutor.executeWithResponse(client -> ((CoreService.Iface)client.getService(Services.CORE_SERVICE)).getTimeZoneId()));
        }
        catch (TException e) {
            FlintApiFacadeImpl.handleTException(e);
            return null;
        }
    }

    @Override
    public boolean cancelByClientId(long clientId) {
        try {
            return this.requestExecutor.executeWithResponse(client -> ((CoreService.Iface)client.getService(Services.CORE_SERVICE)).cancelByClientId(clientId));
        }
        catch (TException e) {
            FlintApiFacadeImpl.handleTException(e);
            return false;
        }
    }

    @Override
    public boolean touchDataset(String datasetName) {
        try {
            return this.requestExecutor.executeWithResponse(client -> ((DatasetService.Iface)client.getService(Services.DATASET_SERVICE)).touchDataset(datasetName));
        }
        catch (TException e) {
            FlintApiFacadeImpl.handleTException(e);
            return false;
        }
    }

    @Override
    public DatasetInfo getDataset(String datasetName) throws NoSuchDatasetException {
        try {
            return this.requestExecutor.executeWithResponse(client -> ((DatasetService.Iface)client.getService(Services.DATASET_SERVICE)).getDataset(datasetName));
        }
        catch (NoSuchDatasetException ex) {
            throw ex;
        }
        catch (TException e) {
            FlintApiFacadeImpl.handleTException(e);
            return null;
        }
    }

    @Override
    public void prepareDataset(DatasetSpec spec, CacheOptions cacheOpts) {
        try {
            this.requestExecutor.execute(client -> ((DatasetService.Iface)client.getService(Services.DATASET_SERVICE)).prepareDataset(spec, cacheOpts));
        }
        catch (TException e) {
            FlintApiFacadeImpl.handleTException(e);
        }
    }

    @Override
    public void removeDataset(String datasetName) throws NoSuchDatasetException {
        try {
            this.requestExecutor.execute(client -> ((DatasetService.Iface)client.getService(Services.DATASET_SERVICE)).removeDataset(datasetName));
        }
        catch (NoSuchDatasetException ex) {
            throw ex;
        }
        catch (TException e) {
            FlintApiFacadeImpl.handleTException(e);
        }
    }

    @Override
    public String createRowBuffer(RowBufferSpec spec) {
        try {
            return this.requestExecutor.executeWithResponse(client -> ((RowBufferService.Iface)client.getService(Services.ROW_BUFFER_SERVICE)).createRowBuffer(spec));
        }
        catch (TException e) {
            FlintApiFacadeImpl.handleTException(e);
            return null;
        }
    }

    @Override
    public void putRowBufferAvro(String bufferId, int batchIndex, List<ByteBuffer> avroBuffers) throws NoSuchRowBufferException {
        try {
            this.requestExecutor.execute(client -> ((RowBufferService.Iface)client.getService(Services.ROW_BUFFER_SERVICE)).putRowBufferAvro(bufferId, batchIndex, avroBuffers));
        }
        catch (NoSuchRowBufferException ex) {
            throw ex;
        }
        catch (TException e) {
            FlintApiFacadeImpl.handleTException(e);
        }
    }

    @Override
    public void putRowBufferList(String bufferId, int batchIndex, List<Row> rows) throws NoSuchRowBufferException {
        try {
            this.requestExecutor.execute(client -> ((RowBufferService.Iface)client.getService(Services.ROW_BUFFER_SERVICE)).putRowBufferList(bufferId, batchIndex, rows));
        }
        catch (NoSuchRowBufferException ex) {
            throw ex;
        }
        catch (TException e) {
            FlintApiFacadeImpl.handleTException(e);
        }
    }

    @Override
    public void saveRowBuffer(String bufferId, AnySink sink, SaveOptions saveOpts) throws NoSuchRowBufferException {
        try {
            this.requestExecutor.execute(client -> ((RowBufferService.Iface)client.getService(Services.ROW_BUFFER_SERVICE)).saveRowBuffer(bufferId, sink, saveOpts));
        }
        catch (NoSuchRowBufferException ex) {
            throw ex;
        }
        catch (TException e) {
            FlintApiFacadeImpl.handleTException(e);
        }
    }

    @Override
    public void removeRowBuffer(String bufferId) throws NoSuchRowBufferException {
        try {
            this.requestExecutor.execute(client -> ((RowBufferService.Iface)client.getService(Services.ROW_BUFFER_SERVICE)).removeRowBuffer(bufferId));
        }
        catch (NoSuchRowBufferException ex) {
            throw ex;
        }
        catch (TException e) {
            FlintApiFacadeImpl.handleTException(e);
        }
    }

    @Override
    public SerializedResultInfo executeSqlToSerializedFile(String sqlText, int queryTimeoutSec, SamplingOptions samplingOpts) {
        try {
            return this.requestExecutor.executeWithResponse(client -> ((QueryService.Iface)client.getService(Services.QUERY_SERVICE)).executeSqlToSerializedFile(sqlText, queryTimeoutSec, samplingOpts));
        }
        catch (TException e) {
            FlintApiFacadeImpl.handleTException(e);
            return null;
        }
    }

    @Override
    public ResultSet executeSqlToResultSet(String sqlText, int queryTimeoutSec, SamplingOptions samplingOpts) {
        try {
            return this.requestExecutor.executeWithResponse(client -> ((QueryService.Iface)client.getService(Services.QUERY_SERVICE)).executeSqlToResultSet(sqlText, queryTimeoutSec, samplingOpts));
        }
        catch (TException e) {
            FlintApiFacadeImpl.handleTException(e);
            return null;
        }
    }

    @Override
    public ResultSet executeSqlToResultSetCacheOFF(String sqlText, int queryTimeoutSec, SamplingOptions samplingOpts) {
        try {
            return this.requestExecutor.executeWithResponse(client -> ((QueryService.Iface)client.getService(Services.QUERY_SERVICE)).executeSqlToResultSetCacheOFF(sqlText, queryTimeoutSec, samplingOpts));
        }
        catch (TException e) {
            FlintApiFacadeImpl.handleTException(e);
            return null;
        }
    }

    @Override
    public CursorInfo executeSqlToCursor(String sqlText, int queryTimeoutSec, CursorOptions cursorOpts, SamplingOptions samplingOpts) {
        try {
            return this.requestExecutor.executeWithResponse(client -> ((QueryService.Iface)client.getService(Services.QUERY_SERVICE)).executeSqlToCursor(sqlText, queryTimeoutSec, cursorOpts, samplingOpts));
        }
        catch (TException e) {
            FlintApiFacadeImpl.handleTException(e);
            return null;
        }
    }

    @Override
    public List<Row> fetchCursorRowsList(String cursorId, int batchSize) throws NoSuchCursorException {
        try {
            return this.requestExecutor.executeWithResponse(client -> ((QueryService.Iface)client.getService(Services.QUERY_SERVICE)).fetchCursorRowsList(cursorId, batchSize));
        }
        catch (NoSuchCursorException ex) {
            throw ex;
        }
        catch (TException e) {
            FlintApiFacadeImpl.handleTException(e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<ByteBuffer> fetchCursorRowsAvro(String cursorId, int batchSize) throws NoSuchCursorException {
        try {
            return this.requestExecutor.executeWithResponse(client -> ((QueryService.Iface)client.getService(Services.QUERY_SERVICE)).fetchCursorRowsAvro(cursorId, batchSize));
        }
        catch (NoSuchCursorException ex) {
            throw ex;
        }
        catch (TException e) {
            FlintApiFacadeImpl.handleTException(e);
            return Collections.emptyList();
        }
    }

    @Override
    public void closeCursor(String cursorId) throws NoSuchCursorException {
        try {
            this.requestExecutor.execute(client -> ((QueryService.Iface)client.getService(Services.QUERY_SERVICE)).closeCursor(cursorId));
        }
        catch (NoSuchCursorException ex) {
            throw ex;
        }
        catch (TException e) {
            FlintApiFacadeImpl.handleTException(e);
        }
    }

    private static void handleTException(TException e) {
        throw new XQERuntimeException(XQEMessageKeys.DAT_DataSourceAdapterError, (Throwable)e, e.toString());
    }
}

