/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqerdp.flint.result;

import com.cognos.xqerdp.flint.result.DeserializePartitionsFromFiles;
import com.ibm.ba.flint.avro.AvroRowReader;
import com.ibm.ba.flint.crypto.BlockCryptoInputStream;
import com.ibm.ba.flint.crypto.ICryptoProvider;
import com.ibm.ba.flint.io.InputStreamDecorator;
import com.ibm.ba.flint.thrift.query.SerializationFormat;
import com.ibm.ba.flint.thrift.types.Schema;
import com.ibm.ba.flint.thrift.util.ThriftStreamRowReader;
import com.ibm.ba.flint.util.RowReader;
import com.ibm.ba.flint.util.StreamRowReaderFactory;
import java.io.IOException;
import java.io.Serializable;
import shaded.org.apache.hadoop.conf.Configurable;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.fs.Path;
import shaded.org.apache.hadoop.io.compress.GzipCodec;
import shaded.org.apache.hadoop.io.compress.SnappyCodec;

public class ResultDeserializer {
    private static final String MSG_UNSUPPORTED_SERIALIZATION_FORMAT = "Unsupported serialization format: ";
    private final Configuration hadoopConf;
    private final ICryptoProvider cryptoProvider;

    public ResultDeserializer(Configuration hadoopConf) {
        this(hadoopConf, null);
    }

    public ResultDeserializer(Configuration hadoopConf, ICryptoProvider cryptoProvider) {
        if (null == hadoopConf) {
            throw new IllegalArgumentException("hadoopConf was null");
        }
        this.hadoopConf = hadoopConf;
        this.cryptoProvider = cryptoProvider;
    }

    public RowReader deserialize(Schema schema, Path inPath, SerializationFormat format) throws IOException {
        String fileExtension = ResultDeserializer.getFileExtension(format);
        StreamRowReaderFactory readerFactory = this.getRowReaderFactory(format);
        return new DeserializePartitionsFromFiles(schema, inPath, fileExtension, this.hadoopConf, readerFactory).deserialize();
    }

    private static String getFileExtension(SerializationFormat format) {
        switch (format) {
            case AVRO: {
                return "avro";
            }
            case THRIFT: {
                return "thrift";
            }
            case THRIFT_GZIP: {
                return "thrift.gz";
            }
            case THRIFT_SNAPPY: {
                return "thrift.snappy";
            }
        }
        throw new IllegalArgumentException(MSG_UNSUPPORTED_SERIALIZATION_FORMAT + format);
    }

    private StreamRowReaderFactory getRowReaderFactory(SerializationFormat format) {
        StreamRowReaderFactory & Serializable baseReaderFactory;
        InputStreamDecorator streamDecorator = InputStreamDecorator.identity();
        switch (format) {
            case AVRO: {
                baseReaderFactory = AvroRowReader::new;
                break;
            }
            case THRIFT: {
                baseReaderFactory = ThriftStreamRowReader::new;
                break;
            }
            case THRIFT_GZIP: {
                baseReaderFactory = ThriftStreamRowReader::new;
                streamDecorator = in -> {
                    GzipCodec codec = new GzipCodec();
                    ((Configurable)codec).setConf(this.hadoopConf);
                    return codec.createInputStream(in);
                };
                break;
            }
            case THRIFT_SNAPPY: {
                baseReaderFactory = ThriftStreamRowReader::new;
                streamDecorator = in -> {
                    SnappyCodec codec = new SnappyCodec();
                    ((Configurable)codec).setConf(this.hadoopConf);
                    return codec.createInputStream(in);
                };
                break;
            }
            default: {
                throw new IllegalArgumentException(MSG_UNSUPPORTED_SERIALIZATION_FORMAT + format);
            }
        }
        if (null != this.cryptoProvider) {
            streamDecorator = streamDecorator.compose((InputStreamDecorator & Serializable)in -> new BlockCryptoInputStream(in, this.cryptoProvider));
        }
        return baseReaderFactory.decorateStream(streamDecorator);
    }
}

