/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqerdp.odata;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.QueryFormatter;
import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.ast.sql.SQLBetween;
import com.cognos.xqe.ast.sql.SQLCall;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLExtract;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLFunction;
import com.cognos.xqe.ast.sql.SQLIdentifier;
import com.cognos.xqe.ast.sql.SQLIsNull;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLParameter;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.SQLSelect;
import com.cognos.xqe.ast.sql.SQLSort;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.ast.sql.SQLSortKeyList;
import com.cognos.xqe.ast.sql.SQLTableFunction;
import com.cognos.xqe.ast.sql.SQLTop;
import com.cognos.xqe.ast.sql.SQLValueExpression;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.SQLXid;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ODataQueryBuilder
extends QueryFormatter {
    private static final String QUESTION_MARK = "?";
    private static final String S_DESC = "%s+desc";
    private static final String S_ASC = "%s+asc";
    private static final String FORWARD_SLASH = "/";
    private String[] paths;
    private Map<String, String> qualifiedNames = new HashMap<String, String>();
    private static boolean lazyLoading;

    public void addEncodedText(String text) {
        try {
            this.addText(URLEncoder.encode(text, "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new XQERuntimeException(e);
        }
    }

    public ODataQueryBuilder() {
    }

    public ODataQueryBuilder(ODataQueryBuilder builder) {
        this();
        this.qualifiedNames = builder.qualifiedNames;
    }

    @Override
    public String bufferToString() {
        return this.buffer.toString();
    }

    private Object[] dumpChildren(SQLQueryNode node, IDataSourceCapabilities capabilities) {
        ODataQueryBuilder formatter = new ODataQueryBuilder(this);
        int nArgs = node.getNumberChildren();
        Object[] argValues = new Object[nArgs];
        for (int i = 0; i < nArgs; ++i) {
            ((SQLQueryNode)node.getChild(i)).accept(formatter, capabilities);
            argValues[i] = ((QueryFormatter)formatter).bufferToString();
            formatter.clear();
        }
        return argValues;
    }

    @Override
    public void visit(SQLAbstractFunction node, IDataSourceCapabilities capabilities) {
        this.addText(String.format(node.getPattern(capabilities), this.dumpChildren(node, capabilities)));
    }

    @Override
    public void visit(SQLBetween node, IDataSourceCapabilities capabilities) {
        this.visit((SQLAbstractFunction)node, capabilities);
    }

    @Override
    public void visit(SQLCall node, IDataSourceCapabilities capabilities) {
        this.addEncodedText(node.getName());
        SQLQueryItemList args = node.getArguments();
        if (args.size() > 0) {
            this.addText(QUESTION_MARK);
            for (int i = 0; i < args.size(); ++i) {
                this.addText(((SQLQueryItem)args.get(i)).getName());
                this.addText("=");
                ((SQLQueryNode)node.getChild(i)).accept(this, capabilities);
            }
            this.addText("&");
        }
    }

    @Override
    public void visit(SQLComparison node, IDataSourceCapabilities capabilities) {
        this.visit((SQLAbstractFunction)node, capabilities);
    }

    @Override
    public void visit(SQLExtract node, IDataSourceCapabilities capabilities) {
        this.visit((SQLAbstractFunction)node, capabilities);
    }

    @Override
    public void visit(SQLFid node, IDataSourceCapabilities capabilities) {
        if (node.getNumberChildren() > 0) {
            ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
            this.addText(FORWARD_SLASH);
        }
        if (DataTypeCode.isMultisetType(node.getDataType().getCCLTypeCode())) {
            if (node.getSourceNo() > 0) {
                String name = node.getName();
                String qualifier = this.qualifiedNames.get(name);
                if (qualifier == null) {
                    qualifier = name;
                }
                this.addText(qualifier);
            } else {
                this.addText(node.getName());
            }
        } else {
            String qualifier = this.qualifiedNames.get(node.getTableName());
            if (qualifier == null) {
                this.addText(node.getName());
            } else {
                this.addText(String.format("%s/%s", qualifier, node.getName()));
            }
        }
    }

    @Override
    public void visit(SQLFilter node, IDataSourceCapabilities capabilities) {
        ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
        this.addText("$filter=");
        node.getPredicate().accept(this, capabilities);
        this.addText("&");
    }

    @Override
    public void visit(SQLFunction node, IDataSourceCapabilities capabilities) {
        String pattern = node.getPattern(capabilities);
        Object[] argValues = this.dumpChildren(node, capabilities);
        String sqlStr = SQLAbstractFunction.format(pattern, argValues);
        this.addText(sqlStr);
    }

    @Override
    public void visit(SQLIdentifier node, IDataSourceCapabilities capabilities) {
        this.addText(node.getName());
    }

    @Override
    public void visit(SQLIsNull node, IDataSourceCapabilities capabilities) {
        this.visit((SQLAbstractFunction)node, capabilities);
    }

    @Override
    public void visit(SQLLiteral node, IDataSourceCapabilities capabilities) {
        this.addText(node.getValue().getSPARQLLiteral());
    }

    @Override
    public void visit(SQLParameter node, IDataSourceCapabilities capabilities) {
        this.addText(String.format(":%s:", node.getName().replace(":", "::")));
    }

    @Override
    public void visit(SQLLogical node, IDataSourceCapabilities capabilities) {
        String pattern = node.getPattern(capabilities);
        Object[] argValues = this.dumpChildren(node, capabilities);
        String fName = node.getFunctionName();
        if (node.getSubType() == SQLLogical.SubType.OR) {
            IXQEQueryNode parent = node.getParent();
            if (parent.getType() == 301027 && ((SQLLogical)parent).getSubType() == SQLLogical.SubType.AND) {
                StringBuffer sBuffer = new StringBuffer();
                sBuffer.append("(");
                sBuffer.append(this.buildFormattedPatternForLogicalOperator(pattern, fName));
                sBuffer.append(")");
                pattern = sBuffer.toString();
            } else {
                pattern = this.buildFormattedPatternForLogicalOperator(pattern, fName);
            }
        } else if (node.getSubType() == SQLLogical.SubType.AND) {
            pattern = this.buildFormattedPatternForLogicalOperator(pattern, fName);
        }
        this.addText(String.format(pattern, argValues));
    }

    @Override
    public void visit(SQLProject node, IDataSourceCapabilities capabilities) {
        ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
        this.addText("$select=");
        SQLValueList vList = node.getOutputList();
        for (int i = 0; i < vList.getNumberChildren(); ++i) {
            if (i > 0) {
                this.addText(",");
            }
            ((SQLQueryNode)vList.getChild(i)).accept(this, capabilities);
        }
        this.addText("&");
    }

    @Override
    public void visit(SQLQueryBlock node, IDataSourceCapabilities capabilities) {
        List<SQLXid> fidList;
        if (!lazyLoading && (fidList = node.getXidList()) != null) {
            int nSources = fidList.size() + 1;
            this.paths = new String[nSources];
            int i = 1;
            for (SQLXid fid : fidList) {
                String name = fid.getName();
                int sourceNo = fid.getSourceNo();
                this.paths[i] = sourceNo == 0 ? name : this.paths[sourceNo] + FORWARD_SLASH + name;
                this.qualifiedNames.put(name, this.paths[i]);
                ++i;
            }
        }
        ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
        if (this.buffer.length() == 0) {
            this.addText(QUESTION_MARK);
        }
        this.addText("$format=json");
    }

    @Override
    public void visit(SQLRangeVar node, IDataSourceCapabilities capabilities) {
        ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
    }

    @Override
    public void visit(SQLRelation node, IDataSourceCapabilities capabilities) {
        this.addEncodedText(node.getName());
        this.addText(QUESTION_MARK);
        if (this.paths != null && !lazyLoading) {
            this.addText("$expand=");
            for (int i = 1; i < this.paths.length; ++i) {
                if (i > 1) {
                    this.addText(",");
                }
                this.addText(this.paths[i]);
            }
            this.addText("&");
        }
    }

    @Override
    public void visit(SQLSelect node, IDataSourceCapabilities capabilities) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(SQLSort node, IDataSourceCapabilities capabilities) {
        SQLProject projNode = (SQLProject)node.getChild(0);
        SQLValueList vList = projNode.getOutputList();
        ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
        this.addText("$orderby=");
        IXQEQueryNode sortKeyList = node.getChild(1);
        for (int i = 0; i < sortKeyList.getNumberChildren(); ++i) {
            if (i > 0) {
                this.addText(",");
            }
            ODataQueryBuilder tmpFormatter = new ODataQueryBuilder();
            SQLSortKey sortKey = (SQLSortKey)sortKeyList.getChild(i);
            SQLFid fid = (SQLFid)sortKey.getChild(0);
            ((SQLQueryNode)vList.getChild(fid.getColumnNo())).accept(tmpFormatter, capabilities);
            String name = ((QueryFormatter)tmpFormatter).bufferToString();
            if (sortKey.isAscending()) {
                this.addText(String.format(S_ASC, name));
                continue;
            }
            this.addText(String.format(S_DESC, name));
        }
        this.addText("&");
    }

    @Override
    public void visit(SQLSortKeyList node, IDataSourceCapabilities capabilities) {
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            if (i > 0) {
                this.addText(",");
            }
            ((SQLQueryNode)node.getChild(i)).accept(this, capabilities);
        }
    }

    @Override
    public void visit(SQLSortKey node, IDataSourceCapabilities capabilities) {
        SQLFid fid = (SQLFid)node.getChild(0);
        String name = fid.getName();
        if (node.isAscending()) {
            this.addEncodedText(String.format(S_ASC, name));
        } else {
            this.addEncodedText(String.format(S_DESC, name));
        }
    }

    @Override
    public void visit(SQLTop node, IDataSourceCapabilities capabilities) {
        ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
        Value value = ((SQLLiteral)node.getChild(1)).getValue();
        int nRows = value.getInteger();
        String pattern = node.getPattern(capabilities);
        this.addText(String.format(pattern, nRows));
        this.addText("&");
    }

    @Override
    public void visit(SQLTableFunction node, IDataSourceCapabilities capabilities) {
        this.addText(QUESTION_MARK);
    }

    @Override
    public void visit(SQLValueExpression node, IDataSourceCapabilities capabilities) {
        IXQEQueryNode parent = node.getParent();
        if (parent.getType() == 301025 && node.getSubType().precedence() >= ((SQLValueExpression)parent).getSubType().precedence()) {
            this.addText("(");
            this.visit((SQLAbstractFunction)node, capabilities);
            this.addText(")");
        } else {
            this.visit((SQLAbstractFunction)node, capabilities);
        }
    }

    static {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        lazyLoading = configuration.getBooleanProperty("queryExecution.OData.lazyLoading[@value]", true);
    }
}

