/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.xqe.resultsdk.wrapper;

import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.trace.XQETrace;
import com.ibm.cognos.xqe.resultsdk.ICell;
import com.ibm.cognos.xqe.resultsdk.ValueStateEnum;
import com.ibm.cognos.xqe.resultsdk.wrapper.V5ResultSetWrapper;
import com.ibm.cognos.xqe.resultsdk.wrapper.V5ValueWrapper;

class V5CellWrapper
implements ICell {
    private V5ResultSetWrapper mResultSetWrapper;
    private com.cognos.xqe.resultset.interfaces.ICell mCell;

    V5CellWrapper(V5ResultSetWrapper resultSetWrapper, com.cognos.xqe.resultset.interfaces.ICell cell) {
        this.mResultSetWrapper = resultSetWrapper;
        this.mCell = cell;
    }

    @Override
    public long getOrdinal() {
        return this.mCell.getOrdinal();
    }

    @Override
    public long[] getEdgeOrdinals() {
        return this.mResultSetWrapper.getEdgeOrdinals(this.mCell.getOrdinal());
    }

    @Override
    public V5ValueWrapper getValue() {
        Value cellValue = (Value)this.mCell.getValue();
        if (cellValue != null) {
            return new V5ValueWrapper(cellValue);
        }
        return null;
    }

    @Override
    public void setValue(Object theValue) {
        Value oldValue = (Value)this.mCell.getValue();
        Value newValue = null;
        if (oldValue == null) {
            newValue = DataValueFactory.convertObjectToIValue(theValue);
        } else {
            newValue = (Value)oldValue.getDataType().createValue();
            newValue.copyFrom(oldValue);
            newValue.set(theValue);
        }
        this.mCell.setValue(newValue);
    }

    @Override
    public void setValueState(ValueStateEnum theValueState) {
        Value oldValue = (Value)this.mCell.getValue();
        if (oldValue != null) {
            Value newValue = (Value)oldValue.getDataType().createValue();
            newValue.setState(V5ValueWrapper.toValueState(theValueState));
            this.mCell.setValue(newValue);
        }
    }

    @Override
    public void trace() {
        if (!this.mResultSetWrapper.hasTracingStarted()) {
            return;
        }
        XQETrace trace = this.mResultSetWrapper.getTrace();
        trace.beginElement("Cell");
        trace.attribute("ordinal", this.getOrdinal());
        this.getValue().trace(trace);
        trace.endElement();
    }
}

