/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.xqe.resultsdk.wrapper;

import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.trace.XQETrace;
import com.ibm.cognos.xqe.resultsdk.IDataType;
import com.ibm.cognos.xqe.resultsdk.IValue;
import com.ibm.cognos.xqe.resultsdk.ValueStateEnum;
import com.ibm.cognos.xqe.resultsdk.wrapper.DataTypeWrapper;
import java.math.BigDecimal;

class V5ValueWrapper
implements IValue {
    private Value mValue;

    V5ValueWrapper(Value value) {
        this.mValue = value;
    }

    @Override
    public IDataType getDataType() {
        return new DataTypeWrapper(this.mValue.getDataType());
    }

    @Override
    public ValueStateEnum getValueState() {
        return V5ValueWrapper.toValueStateEnum(this.mValue.getState());
    }

    @Override
    public String getString() {
        if (this.mValue.isOK()) {
            return this.mValue.getString();
        }
        return null;
    }

    @Override
    public Double getDouble() {
        if (this.mValue.isOK()) {
            return this.mValue.getDouble();
        }
        return null;
    }

    @Override
    public BigDecimal getBigDecimal() {
        if (this.mValue.isOK()) {
            return this.mValue.getBigDecimal();
        }
        return null;
    }

    @Override
    public Integer getInteger() {
        if (this.mValue.isOK()) {
            return this.mValue.getInteger();
        }
        return null;
    }

    static ValueStateEnum toValueStateEnum(ValueState valueState) {
        switch (valueState) {
            case OK: {
                return ValueStateEnum.OK;
            }
            case NULL: {
                return ValueStateEnum.NULL;
            }
            case SECURITY_VIOLATION: {
                return ValueStateEnum.SECURITY_VIOLATION;
            }
        }
        return ValueStateEnum.ERROR;
    }

    static ValueState toValueState(ValueStateEnum valueStateEnum) {
        switch (valueStateEnum) {
            case OK: {
                return ValueState.OK;
            }
            case NULL: {
                return ValueState.NULL;
            }
            case SECURITY_VIOLATION: {
                return ValueState.SECURITY_VIOLATION;
            }
        }
        return ValueState.ERROR;
    }

    void trace(XQETrace trace) {
        ValueStateEnum state = this.getValueState();
        trace.beginElement("Value");
        if (state == ValueStateEnum.OK) {
            trace.attribute("value", this.getString());
            trace.attribute("dataType", this.getDataType().toString());
        } else {
            trace.attribute("state", state.toString());
        }
        trace.endElement();
    }
}

