/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.xqe.resultsdk.wrapper;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import com.ibm.cognos.xqe.resultsdk.ILogger;
import com.ibm.cognos.xqe.resultsdk.LogLevelEnum;

public class XQELoggerWrapper
implements ILogger {
    private XQELogger mLogger;

    public XQELoggerWrapper(XQELogger logger) {
        this.mLogger = logger;
    }

    @Override
    public boolean isOn() {
        return this.mLogger.isOn();
    }

    @Override
    public boolean isOn(LogLevelEnum logLevel) {
        return this.mLogger.isOn(this.toLogLevel(logLevel));
    }

    @Override
    public void log(String message) {
        this.mLogger.log(message);
    }

    @Override
    public void log(String fileName, String message) {
        this.mLogger.log(fileName, message);
    }

    @Override
    public void log(LogLevelEnum logLevel, String message) {
        this.mLogger.log(this.toLogLevel(logLevel), message);
    }

    @Override
    public LogLevelEnum getDefaultLogLevel() {
        return this.toLogLevelEnum(this.mLogger.getDefaultLevel());
    }

    private LogLevel toLogLevel(LogLevelEnum logLevelEnum) {
        switch (logLevelEnum) {
            case TRACE: {
                return LogLevel.TRACE;
            }
            case INFO: {
                return LogLevel.INFO;
            }
            case WARN: {
                return LogLevel.WARN;
            }
            case ERROR: {
                return LogLevel.ERROR;
            }
        }
        return LogLevel.NONE;
    }

    private LogLevelEnum toLogLevelEnum(LogLevel logLevel) {
        switch (logLevel) {
            case TRACE: {
                return LogLevelEnum.TRACE;
            }
            case INFO: {
                return LogLevelEnum.INFO;
            }
            case WARN: {
                return LogLevelEnum.WARN;
            }
            case ERROR: 
            case CRITICAL: {
                return LogLevelEnum.ERROR;
            }
        }
        return LogLevelEnum.NONE;
    }

    @Override
    public void raiseError(String message) {
        throw new XQERuntimeException(XQEMessageKeys.EXE_GenericExecutionProblem, message);
    }

    @Override
    public void raiseAssert(String message) {
        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, message);
    }
}

