/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.rolap;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.MetadataProviderBase;
import com.cognos.xqe.data.providers.olap.MetadataQueryArguments;
import com.cognos.xqe.data.providers.olap.OLAPDataProviderBase;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.olap.cache.CacheParameters;
import com.cognos.xqe.data.providers.olap.rolap.ROLAPDataProvider;
import com.cognos.xqe.data.providers.olap.rolap.ROLAPMessageKeys;
import com.cognos.xqe.data.providers.olap.rolap.ROLAPRuntimeException;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.MeasureType;
import com.cognos.xqe.data.types.StringType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.metadata.AggregateRule;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.IAggregateRule;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.INamedSet;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.metadata.TreeOperatorEnum;
import com.cognos.xqe.metadata.record.ActionRecord;
import com.cognos.xqe.metadata.record.AliasRecord;
import com.cognos.xqe.metadata.record.CatalogRecord;
import com.cognos.xqe.metadata.record.CubeRecord;
import com.cognos.xqe.metadata.record.DimensionRecord;
import com.cognos.xqe.metadata.record.HierarchyNamedSetRecord;
import com.cognos.xqe.metadata.record.HierarchyRecord;
import com.cognos.xqe.metadata.record.LevelRecord;
import com.cognos.xqe.metadata.record.MacroRecord;
import com.cognos.xqe.metadata.record.MeasureRecord;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.metadata.record.NamedSetRecord;
import com.cognos.xqe.metadata.record.PropertyRecord;
import com.cognos.xqe.metadata.record.RecordType;
import com.cognos.xqe.metadata.record.VariableRecord;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPFolder;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPNamedSet;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPProperty;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPFolder;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMemberOperations;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPProperty;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ShareableROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAttribute;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCalculatedMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCalculatedMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCalculatedMemberDef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCubeDef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualProperty;
import com.cognos.xqe.runtree.olap.mdx.security.SecurityManagerInterface;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocalizedString;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ROLAPMetadataProvider
extends MetadataProviderBase
implements IOLAPMetadataProvider {
    private static final String MEASURES_STRING = "[Measures]";
    private static final String OPEN_BRACE = "[";
    private static final String CLOSE_BRACE = "]";
    private static final String KEY_SUFFIX = " - Key";
    private static final String ERR_MSG_MISSING_REQUIRED_RESTRICTION = "Required RestrictionType ";
    private static final String ERR_MSG_HIER_NOT_FOUND = "Hierarchy not found ";
    private static final String ERR_MSG_LVL_NOT_FOUND = "Level not found ";
    private static final String ERR_MSG_PROP_NOT_FOUND = "Property not found ";
    public static final String ROLAP_CATALOG_NAME = "ROLAP Catalog";
    private static final String CALCULATED_MEASURE_EXPRESSION_DYNAMIC_FIELD_NAME = "calculatedMeasureExpression";
    private static final String CALCULATED_MEASURE_SOLVE_ORDER_DYNAMIC_FIELD_NAME = "calculatedMeasureSolveOrder";
    private static final String CALCULATED_MEMBER_EXPRESSION_DYNAMIC_FIELD_NAME = "calculatedMemberExpression";
    private static final String CALCULATED_MEMBER_SOLVE_ORDER_DYNAMIC_FIELD_NAME = "calculatedMemberSolveOrder";
    private static final String EXTENDED_CALCULATED_MEMBER_DYNAMIC_FIELD_NAME = "extendedCalculatedMember";
    private static final CatalogRecord CATALOG_RECORD = new CatalogRecord();
    private final XQELogger logger = XQELog.getLogger((ServiceEnumeration)ServiceEnumeration.XQEODP, (String)"ROLAP", (String)"Metadata", (LogLevel)LogLevel.INFO);
    private ROLAPCube mCube;
    private static boolean recursiveCall;

    public ROLAPMetadataProvider(ROLAPDataProvider provider, MetadataQueryArguments theQueryArguments) {
        super((OLAPDataProviderBase)provider);
        String cubeName = (String)theQueryArguments.getDataSource().getMetadataProperties().get("cube");
        this.mCube = ROLAPCubeManager.getInstance().getCube(cubeName);
    }

    public void releaseImpl() {
    }

    public CacheParameters getCacheParameters(IRestrictions restrictions) {
        return null;
    }

    public List<CatalogRecord> getCatalogs(IRestrictions restrictions) {
        this.checkForMissingRestrictions(restrictions, CUBES_RESTRICTIONS);
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        if (!catalogName.equalsIgnoreCase(ROLAP_CATALOG_NAME)) {
            return null;
        }
        ArrayList<CatalogRecord> list = new ArrayList<CatalogRecord>();
        list.add(CATALOG_RECORD);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CubeRecord> getCubes(IRestrictions restrictions) {
        ROLAPContext.queryEnter((IExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment(), (ROLAPCube)this.mCube);
        try {
            this.checkForMissingRestrictions(restrictions, CUBES_RESTRICTIONS);
            String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
            String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
            ArrayList<ROLAPCube> cubesFound = new ArrayList<ROLAPCube>(1);
            this.getROLAPCubes(catalogName, cubeName, cubesFound);
            int countCubesFound = cubesFound.size();
            ArrayList<CubeRecord> result = new ArrayList<CubeRecord>(countCubesFound);
            for (int i = 0; i < countCubesFound; ++i) {
                result.add(this.createCubeRecord((ROLAPCube)cubesFound.get(i)));
            }
            ArrayList<CubeRecord> arrayList = result;
            return arrayList;
        }
        finally {
            ROLAPContext.queryExit((IExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCubeDefaultMeasure(IRestrictions restrictions) {
        ROLAPContext.queryEnter((IExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment(), (ROLAPCube)this.mCube);
        try {
            IMember defaultMeasure;
            Hierarchy measureHierarchy;
            ROLAPCube cube;
            IDimension measureDim;
            this.checkForMissingRestrictions(restrictions, MEASURES_RESTRICTIONS);
            String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
            String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
            ArrayList<ROLAPCube> cubesFound = new ArrayList<ROLAPCube>(1);
            this.getROLAPCubes(catalogName, cubeName, cubesFound);
            if (cubesFound.size() == 1 && (measureDim = (cube = (ROLAPCube)cubesFound.get(0)).getMeasureDimension()) != null && (measureHierarchy = (Hierarchy)measureDim.getDefaultHierarchy()) != null && (defaultMeasure = measureHierarchy.getDefaultMemberWithSecurity((ICube)cube)) != null) {
                StringBuilder buf = new StringBuilder();
                buf.append(OPEN_BRACE).append(measureDim.getName()).append("].[");
                buf.append(defaultMeasure.getName()).append(CLOSE_BRACE);
                String string = buf.toString();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            ROLAPContext.queryExit((IExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DimensionRecord> getDimensions(IRestrictions restrictions) {
        ROLAPContext.queryEnter((IExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment(), (ROLAPCube)this.mCube);
        boolean needToRemoveCubeName = ROLAPContext.setCurrentCubeName((String)this.mCube.getName());
        try {
            this.checkForMissingRestrictions(restrictions, DIMENSIONS_RESTRICTIONS);
            String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
            String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
            String dimensionUniqueName = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
            ArrayList<DimensionRecord> result = new ArrayList<DimensionRecord>();
            ArrayList<IDimension> dimensionsFound = new ArrayList<IDimension>();
            this.getROLAPDimensions(catalogName, cubeName, dimensionUniqueName, dimensionsFound);
            int countDimsFound = dimensionsFound.size();
            IDimension measuresDimension = null;
            for (int i = 0; i < countDimsFound; ++i) {
                IDimension dim = (IDimension)dimensionsFound.get(i);
                if (dim.isMeasuresDimension()) {
                    measuresDimension = dim;
                    continue;
                }
                result.add(this.createDimensionRecord(dim, cubeName));
            }
            if (measuresDimension != null) {
                result.add(this.createDimensionRecord(measuresDimension, cubeName));
            }
            ArrayList<DimensionRecord> arrayList = result;
            return arrayList;
        }
        finally {
            ROLAPContext.queryExit((IExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment());
            ROLAPContext.removeCurrentCubeName((boolean)needToRemoveCubeName);
        }
    }

    private DimensionRecord getDimensionRecord(IRestrictions restrictions, String dimensionUniqueName) {
        IRestrictions newRestrictions = restrictions.duplicate(new RestrictionType[]{RestrictionType.CATALOG, RestrictionType.CUBE});
        newRestrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, (Object)dimensionUniqueName);
        List<DimensionRecord> records = this.getDimensions(newRestrictions);
        DimensionRecord dimRec = null;
        if (!records.isEmpty()) {
            dimRec = records.get(0);
        }
        return dimRec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HierarchyRecord> getHierarchies(IRestrictions restrictions) {
        ROLAPContext.queryEnter((IExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment(), (ROLAPCube)this.mCube);
        boolean needToRemoveCubeName = ROLAPContext.setCurrentCubeName((String)this.mCube.getName());
        try {
            this.checkForMissingRestrictions(restrictions, HIERARCHIES_RESTRICTIONS);
            String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
            String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
            String dimensionUniqueName = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
            String hierarchyUniqueName = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
            ArrayList<HierarchyRecord> result = new ArrayList<HierarchyRecord>();
            ArrayList<IHierarchy> hierarchiesFound = new ArrayList<IHierarchy>();
            this.getROLAPHierarchies(catalogName, cubeName, dimensionUniqueName, hierarchyUniqueName, hierarchiesFound);
            int countHierFound = hierarchiesFound.size();
            for (int i = 0; i < countHierFound; ++i) {
                result.add(this.createHierarchyRecord((IHierarchy)hierarchiesFound.get(i), cubeName));
            }
            ArrayList<HierarchyRecord> arrayList = result;
            return arrayList;
        }
        finally {
            ROLAPContext.queryExit((IExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment());
            ROLAPContext.removeCurrentCubeName((boolean)needToRemoveCubeName);
        }
    }

    private HierarchyRecord getHierarchyRecord(IRestrictions restrictions, String sHUN) {
        IRestrictions newRestrictions = restrictions.duplicate(new RestrictionType[]{RestrictionType.CATALOG, RestrictionType.SCHEMA, RestrictionType.CUBE});
        newRestrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, (Object)sHUN);
        List<HierarchyRecord> hiers = this.getHierarchies(newRestrictions);
        if (null != hiers && hiers.size() > 0) {
            return hiers.get(0);
        }
        return null;
    }

    private HierarchyRecord getHierarchyRecordFromPropRestrictions(IRestrictions restrictions) {
        int lastLeftBracket;
        HierarchyRecord hierRec = null;
        String originalHUN = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        String sHUNRes = originalHUN;
        if (null != sHUNRes && null == (hierRec = this.getHierarchyRecord(restrictions, sHUNRes))) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, ERR_MSG_HIER_NOT_FOUND + sHUNRes);
        }
        String propertyRestriction = (String)restrictions.getValueOf(RestrictionType.PROPERTY);
        if (null != propertyRestriction && (lastLeftBracket = propertyRestriction.lastIndexOf(OPEN_BRACE)) >= 0) {
            String tempRes = propertyRestriction;
            propertyRestriction = tempRes.substring(lastLeftBracket + 1, tempRes.length() - 1);
            sHUNRes = tempRes.substring(0, lastLeftBracket - 1);
            hierRec = this.getHierarchyRecord(restrictions, sHUNRes);
            if (null != hierRec) {
                restrictions.replace(RestrictionType.PROPERTY, (Object)propertyRestriction);
                if (null != originalHUN) {
                    if (!originalHUN.equals(hierRec.getUniqueName())) {
                        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, String.format("Original HUN (%s) does not match HUN found in record (%s).", originalHUN, hierRec.getUniqueName()));
                    }
                } else {
                    restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, (Object)hierRec.getUniqueName());
                }
            }
        }
        return hierRec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MemberRecord> getHierarchyRootMembers(IRestrictions restrictions) {
        ROLAPContext.queryEnter((IExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment(), (ROLAPCube)this.mCube);
        boolean needToRemoveCubeName = ROLAPContext.setCurrentCubeName((String)this.mCube.getName());
        try {
            this.checkForMissingRestrictions(restrictions, HIERARCHY_ROOT_MEMBERS_RESTRICTIONS);
            String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
            String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
            String dimensionUniqueName = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
            String hierarchyUniqueName = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
            ArrayList<MemberRecord> result = new ArrayList<MemberRecord>();
            ArrayList<IHierarchy> hierarchiesFound = new ArrayList<IHierarchy>();
            this.getROLAPHierarchies(catalogName, cubeName, dimensionUniqueName, hierarchyUniqueName, hierarchiesFound);
            for (Hierarchy arrayList : hierarchiesFound) {
                IDimension dimension = arrayList.getDimension();
                ROLAPCube cube = dimension.isShareable() ? ((ShareableROLAPDimension)dimension).getCube(cubeName) : (ROLAPCube)dimension.getCube();
                SecurityManagerInterface sec = cube.getSecurityManager(cube.getProvider());
                List rootMembersList = arrayList.getLevel(0).getMembers();
                IMember[] rootMembers = rootMembersList.toArray(new IMember[0]);
                if (sec != null) {
                    rootMembers = sec.applySecurity(rootMembers, (IHierarchy)arrayList);
                }
                for (IMember rootMember : rootMembers) {
                    result.add(this.createMemberRecord(rootMember, cubeName));
                }
                ArrayList<ROLAPCalculatedMember> rootCalculatedMembers = new ArrayList<ROLAPCalculatedMember>();
                List calculatedMembers = ((IROLAPHierarchy)arrayList).getROLAPCalculatedMembers(cubeName);
                for (ROLAPCalculatedMember calculatedMember : calculatedMembers) {
                    if (calculatedMember.getParent() != null) continue;
                    rootCalculatedMembers.add(calculatedMember);
                }
                IMember[] rootCalculatedMembersArray = rootCalculatedMembers.toArray(new IMember[rootCalculatedMembers.size()]);
                if (sec != null) {
                    rootCalculatedMembersArray = sec.applySecurity(rootCalculatedMembersArray, (IHierarchy)arrayList);
                }
                for (IMember mem : rootCalculatedMembersArray) {
                    result.add(this.createMemberRecord(mem, cubeName));
                }
            }
            ArrayList<MemberRecord> arrayList = result;
            return arrayList;
        }
        finally {
            ROLAPContext.queryExit((IExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment());
            ROLAPContext.removeCurrentCubeName((boolean)needToRemoveCubeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LevelRecord> getLevels(IRestrictions restrictions) {
        ROLAPContext.queryEnter((IExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment(), (ROLAPCube)this.mCube);
        boolean needToRemoveCubeName = ROLAPContext.setCurrentCubeName((String)this.mCube.getName());
        try {
            this.checkForMissingRestrictions(restrictions, LEVELS_RESTRICTIONS);
            String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
            String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
            String dimensionUniqueName = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
            String hierarchyUniqueName = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
            String levelUniqueName = (String)restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME);
            int levelNumber = (Integer)restrictions.getValueOf(RestrictionType.LEVEL_NUMBER, (Object)-1);
            ArrayList<LevelRecord> result = new ArrayList<LevelRecord>();
            ArrayList<ILevel> levelsFound = new ArrayList<ILevel>();
            this.getROLAPLevels(catalogName, cubeName, dimensionUniqueName, hierarchyUniqueName, levelUniqueName, levelNumber, levelsFound);
            for (ILevel level : levelsFound) {
                result.add(this.createLevelRecord(level, cubeName));
            }
            ArrayList<LevelRecord> arrayList = result;
            return arrayList;
        }
        finally {
            ROLAPContext.queryExit((IExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment());
            ROLAPContext.removeCurrentCubeName((boolean)needToRemoveCubeName);
        }
    }

    private LevelRecord getLevelRecord(IRestrictions restrictions, String sLUN) {
        IRestrictions newRestrictions = restrictions.duplicate(new RestrictionType[]{RestrictionType.CATALOG, RestrictionType.CUBE});
        newRestrictions.add(RestrictionType.LEVEL_UNIQUE_NAME, (Object)sLUN);
        List<LevelRecord> levels = this.getLevels(newRestrictions);
        if (!levels.isEmpty()) {
            return levels.get(0);
        }
        return null;
    }

    private LevelRecord getLevelRecordFromPropRestrictions(IRestrictions restrictions, HierarchyRecord hierRec, String originalPUN) {
        int lastLeftBracket;
        LevelRecord levelRec = null;
        String originalLUN = (String)restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME);
        String sLUNRes = originalLUN;
        if (null != sLUNRes && null == (levelRec = this.getLevelRecord(restrictions, sLUNRes))) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, ERR_MSG_LVL_NOT_FOUND + sLUNRes);
        }
        String propertyRestriction = (String)restrictions.getValueOf(RestrictionType.PROPERTY);
        if (null != propertyRestriction && (lastLeftBracket = originalPUN.lastIndexOf(OPEN_BRACE)) >= 0) {
            String tempRes = originalPUN;
            originalPUN = tempRes.substring(lastLeftBracket + 1, tempRes.length() - 1);
            sLUNRes = tempRes.substring(0, lastLeftBracket - 1);
            levelRec = this.getLevelRecord(restrictions, sLUNRes);
            if (null != levelRec) {
                restrictions.replace(RestrictionType.PROPERTY, (Object)originalPUN);
                if (null != originalLUN) {
                    if (!originalLUN.equals(levelRec.getUniqueName())) {
                        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, String.format("Original LUN (%s) does not match LUN found in record (%s).", originalLUN, levelRec.getUniqueName()));
                    }
                } else {
                    restrictions.add(RestrictionType.LEVEL_UNIQUE_NAME, (Object)levelRec.getUniqueName());
                }
            } else {
                if (null != originalLUN && null != hierRec && !hierRec.isParentChild()) {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, String.format("Original LUN (%s) is not consistent with LUN portion of PUN (%s).", originalLUN, sLUNRes));
                }
                if (null == hierRec) {
                    String originalHUN = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
                    String val = (String)restrictions.getValueOf(RestrictionType.PROPERTY);
                    if (null != originalHUN) {
                        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, String.format("Original HUN (%s) is not consistent with PUN (%s).", originalHUN, val));
                    }
                }
            }
        }
        return levelRec;
    }

    private void getROLAPLevels(String catalogName, String cubeName, String dimensionUniqueName, String hierarchyUniqueName, String levelUniqueName, int levelNumber, List<ILevel> levelsFound) {
        ArrayList<IHierarchy> hierarchiesFound = new ArrayList<IHierarchy>();
        this.getROLAPHierarchies(catalogName, cubeName, dimensionUniqueName, hierarchyUniqueName, hierarchiesFound);
        for (IHierarchy hierarchy : hierarchiesFound) {
            List levels = hierarchy.getLevels();
            for (ILevel level : levels) {
                if (null != levelUniqueName) {
                    if (!level.getUniqueName().equals(levelUniqueName)) continue;
                    levelsFound.add(level);
                    continue;
                }
                if (levelNumber >= 0) {
                    if (level.getIndex() != levelNumber) continue;
                    levelsFound.add(level);
                    continue;
                }
                levelsFound.add(level);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MemberRecord> getMembers(IRestrictions restrictions) {
        ROLAPContext.queryEnter((IExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment(), (ROLAPCube)this.mCube);
        boolean needToRemoveCubeName = ROLAPContext.setCurrentCubeName((String)this.mCube.getName());
        try {
            this.checkForMissingRestrictions(restrictions, MEMBERS_RESTRICTIONS);
            if (restrictions.contains(RestrictionType.TREEOP) && !restrictions.contains(RestrictionType.MEMBER_UNIQUE_NAME)) {
                throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionMissing, RestrictionType.MEMBER_UNIQUE_NAME.toString());
            }
            String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
            String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
            String dimensionUniqueName = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
            String hierarchyUniqueName = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
            String levelUniqueName = (String)restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME);
            int levelNumber = (Integer)restrictions.getValueOf(RestrictionType.LEVEL_NUMBER, (Object)-1);
            String memberUniqueName = (String)restrictions.getValueOf(RestrictionType.MEMBER_UNIQUE_NAME);
            EnumSet treeOps = (EnumSet)restrictions.getValueOf(RestrictionType.TREEOP);
            int restrFrom = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
            int restrSize = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)Integer.MAX_VALUE);
            ArrayList<IMember> membersFound = new ArrayList<IMember>();
            ArrayList<IHierarchy> hierarchiesFound = new ArrayList<IHierarchy>();
            this.getROLAPHierarchies(catalogName, cubeName, dimensionUniqueName, hierarchyUniqueName, hierarchiesFound);
            if (levelUniqueName != null) {
                for (IHierarchy hierarchy : hierarchiesFound) {
                    List levels = hierarchy.getLevels();
                    for (ILevel level : levels) {
                        if (!level.getUniqueName().equals(levelUniqueName)) continue;
                        this.getROLAPMembersFromLevel(cubeName, level, memberUniqueName, membersFound);
                    }
                }
            } else if (levelNumber >= 0) {
                for (IHierarchy hierarchy : hierarchiesFound) {
                    if (levelNumber >= hierarchy.getLevelCount()) continue;
                    ILevel level = hierarchy.getLevel(levelNumber);
                    this.getROLAPMembersFromLevel(cubeName, level, memberUniqueName, membersFound);
                }
            } else {
                for (IHierarchy hierarchy : hierarchiesFound) {
                    if (memberUniqueName != null) {
                        IMember member = this.findMember(cubeName, (Hierarchy)hierarchy, memberUniqueName);
                        if (member == null) continue;
                        if (treeOps != null) {
                            this.getROLAPMembersFromRelation(member, treeOps, membersFound);
                            continue;
                        }
                        membersFound.add(member);
                        continue;
                    }
                    IMember[] members = hierarchy.getMembers();
                    for (int i = 0; i < members.length; ++i) {
                        membersFound.add(members[i]);
                    }
                    if (!(hierarchy instanceof IROLAPHierarchy)) continue;
                    IROLAPHierarchy rolapHierarchy = (IROLAPHierarchy)hierarchy;
                    List calcMembers = rolapHierarchy.getROLAPCalculatedMembers(cubeName);
                    for (ROLAPCalculatedMember calcMember : calcMembers) {
                        membersFound.add((IMember)calcMember);
                    }
                }
            }
            ArrayList<MemberRecord> result = new ArrayList<MemberRecord>();
            int index = restrFrom;
            for (int i = 0; i < restrSize && membersFound.size() > index; ++index, ++i) {
                IMember member = (IMember)membersFound.get(index);
                result.add(this.createMemberRecord(member, cubeName));
            }
            ArrayList<MemberRecord> arrayList = result;
            return arrayList;
        }
        finally {
            ROLAPContext.queryExit((IExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment());
            ROLAPContext.removeCurrentCubeName((boolean)needToRemoveCubeName);
        }
    }

    private IMember findMember(String cubeName, Hierarchy hierarchy, String memberUniqueName) {
        IMember member = hierarchy.findMember(memberUniqueName);
        if (member == null) {
            member = this.findCalculatedMember(cubeName, hierarchy, memberUniqueName);
        }
        return member;
    }

    private IMember findCalculatedMember(String cubeName, Hierarchy hierarchy, String memberUniqueName) {
        if (hierarchy instanceof IROLAPHierarchy) {
            IROLAPHierarchy rolapHierarchy = (IROLAPHierarchy)hierarchy;
            List calcMembers = rolapHierarchy.getROLAPCalculatedMembers(cubeName);
            for (ROLAPCalculatedMember calcMember : calcMembers) {
                if (!memberUniqueName.equals(calcMember.getUniqueName())) continue;
                return calcMember;
            }
        }
        return null;
    }

    private void getROLAPMembersFromRelation(IMember member, EnumSet<TreeOperatorEnum> treeOps, List<IMember> membersFound) {
        int csTtreeOps = 0;
        if (treeOps.contains(TreeOperatorEnum.PARENT)) {
            csTtreeOps |= 4;
        }
        if (treeOps.contains(TreeOperatorEnum.CHILDREN)) {
            csTtreeOps |= 1;
        }
        if (treeOps.contains(TreeOperatorEnum.SIBLINGS)) {
            csTtreeOps |= 2;
        }
        if (treeOps.contains(TreeOperatorEnum.ANCESTORS)) {
            csTtreeOps |= 0x20;
        }
        if (treeOps.contains(TreeOperatorEnum.DESCENDANTS)) {
            csTtreeOps |= 0x10;
        }
        if (treeOps.contains(TreeOperatorEnum.SELF)) {
            csTtreeOps |= 8;
        }
        ArrayList relationMembers = new ArrayList();
        try {
            ROLAPMemberOperations.getRelationsOf((IMember)member, (int)csTtreeOps, (boolean)true, relationMembers);
        }
        catch (Exception e) {
            throw new ROLAPRuntimeException(ROLAPMessageKeys.ERR_RELATED_MEMBERS_ERROR, member.getUniqueName());
        }
        for (IMember aMember : relationMembers) {
            if (aMember == null) continue;
            membersFound.add(aMember);
        }
    }

    private void getROLAPMembersFromLevel(String cubeName, ILevel level, String memberUniqueName, List<IMember> membersFound) {
        block4: {
            IHierarchy hierarchy;
            block5: {
                block6: {
                    hierarchy = level.getHierarchy();
                    if (memberUniqueName == null) break block5;
                    IMember member = level.getMember(memberUniqueName);
                    if (member == null) break block6;
                    membersFound.add(member);
                    break block4;
                }
                if (!(hierarchy instanceof IROLAPHierarchy)) break block4;
                IROLAPHierarchy rolapHierarchy = (IROLAPHierarchy)hierarchy;
                List calcMembers = rolapHierarchy.getROLAPCalculatedMembers(cubeName);
                for (ROLAPCalculatedMember calcMember : calcMembers) {
                    if (!memberUniqueName.equals(calcMember.getUniqueName()) || !level.equals(calcMember.getLevel())) continue;
                    membersFound.add((IMember)calcMember);
                    break block4;
                }
                break block4;
            }
            List members = level.getMembers();
            for (IMember member : members) {
                if (member == null) continue;
                membersFound.add(member);
            }
            if (hierarchy instanceof IROLAPHierarchy) {
                IROLAPHierarchy rolapHierarchy = (IROLAPHierarchy)hierarchy;
                List calcMembers = rolapHierarchy.getROLAPCalculatedMembers(cubeName);
                for (ROLAPCalculatedMember calcMember : calcMembers) {
                    if (!level.equals(calcMember.getLevel())) continue;
                    membersFound.add((IMember)calcMember);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MeasureRecord> getMeasures(IRestrictions restrictions) {
        ROLAPContext.queryEnter((IExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment(), (ROLAPCube)this.mCube);
        try {
            IMetadata aMeasure;
            this.checkForMissingRestrictions(restrictions, MEASURES_RESTRICTIONS);
            String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
            String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
            String measureUniqueName = (String)restrictions.getValueOf(RestrictionType.MEASURE_UNIQUE_NAME);
            EnumSet treeOps = (EnumSet)restrictions.getValueOf(RestrictionType.TREEOP);
            int restrFrom = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
            int restrSize = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)Integer.MAX_VALUE);
            ArrayList<MeasureRecord> result = new ArrayList<MeasureRecord>();
            ArrayList<IMetadata> measureItemsFound = new ArrayList<IMetadata>();
            this.getROLAPMeasureItems(catalogName, cubeName, measureUniqueName, treeOps, measureItemsFound);
            ROLAPMetaCube metaCube = null;
            if (measureItemsFound.size() > 0 && (aMeasure = (IMetadata)measureItemsFound.get(0)) instanceof ROLAPMeasure) {
                ROLAPMetaCube[] metaCubes = ((ROLAPMeasure)aMeasure).getROLAPMetaMeasure().getMdSchema().getCubes();
                if (metaCubes.length == 1) {
                    metaCube = metaCubes[0];
                } else {
                    for (ROLAPMetaCube c : metaCubes) {
                        if (!cubeName.equals(c.getName())) continue;
                        metaCube = c;
                    }
                }
            }
            int index = restrFrom;
            for (int i = 0; i < restrSize && measureItemsFound.size() > index; ++index, ++i) {
                IMetadata measure = (IMetadata)measureItemsFound.get(index);
                MeasureRecord record = null;
                record = measure instanceof IROLAPFolder ? this.createMeasureFolderRecord(metaCube, (IROLAPFolder)measure) : this.createMeasureRecord(metaCube, (IROLAPMeasure)measure);
                if (record == null) continue;
                result.add(record);
            }
            ArrayList<MeasureRecord> arrayList = result;
            return arrayList;
        }
        finally {
            ROLAPContext.queryExit((IExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PropertyRecord> getProperties(IRestrictions restrictions) {
        ROLAPContext.queryEnter((IExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment(), (ROLAPCube)this.mCube);
        boolean needToRemoveCubeName = ROLAPContext.setCurrentCubeName((String)this.mCube.getName());
        try {
            LevelRecord levelRec;
            this.checkForMissingRestrictions(restrictions, PROPERTIES_RESTRICTIONS);
            String sHUNRes = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
            String sDUNRes = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
            if (null != sHUNRes && sHUNRes.equals(MEASURES_STRING)) {
                List<PropertyRecord> list = Collections.emptyList();
                return list;
            }
            if (null != sDUNRes && sDUNRes.equals(MEASURES_STRING)) {
                List<PropertyRecord> list = Collections.emptyList();
                return list;
            }
            String propertyRestriction = (String)restrictions.getValueOf(RestrictionType.PROPERTY);
            String sLUNRes = (String)restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME);
            List<PropertyRecord> propertyRecords = new ArrayList<PropertyRecord>();
            HierarchyRecord hierRec = this.getHierarchyRecordFromPropRestrictions(restrictions);
            if (null != hierRec) {
                sHUNRes = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
            }
            if (null != (levelRec = this.getLevelRecordFromPropRestrictions(restrictions, hierRec, propertyRestriction))) {
                if (levelRec.getHierarchyUniqueName().equals(MEASURES_STRING)) {
                    ArrayList<PropertyRecord> arrayList = propertyRecords;
                    return arrayList;
                }
                String levelHUN = levelRec.getHierarchyUniqueName();
                sLUNRes = levelRec.getUniqueName();
                if (null == sHUNRes || sHUNRes.length() == 0) {
                    restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, (Object)levelHUN);
                    sHUNRes = levelHUN;
                }
            }
            if (null == hierRec && null != sHUNRes) {
                hierRec = this.getHierarchyRecord(restrictions, sHUNRes);
            }
            if (null == hierRec && (null != sHUNRes || null != propertyRestriction || null != sLUNRes)) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, ERR_MSG_HIER_NOT_FOUND + sHUNRes);
            }
            if (null != propertyRestriction) {
                if (hierRec.isParentChild()) {
                    this.getPropertiesInternal(restrictions, propertyRecords, hierRec, null);
                } else {
                    this.getPropertiesInternal(restrictions, propertyRecords, hierRec, levelRec);
                }
                this.addFakePropertyForOneProperty(restrictions, propertyRecords, hierRec, levelRec);
            } else if (null != sLUNRes) {
                if (!hierRec.isParentChild()) {
                    this.getPropertiesInternal(restrictions, propertyRecords, hierRec, levelRec);
                }
                this.addFakeIntrinsicHierProperties(propertyRecords, restrictions, hierRec);
            } else if (null != sHUNRes) {
                if (!hierRec.getUniqueName().equals(MEASURES_STRING)) {
                    this.getPropertiesInternal(restrictions, propertyRecords, hierRec, null);
                    this.addFakeIntrinsicHierProperties(propertyRecords, restrictions, hierRec);
                }
            } else if (null != sDUNRes) {
                propertyRecords = this.getAllProperties(restrictions);
                propertyRecords = this.filterPropertyRecords(propertyRecords, sDUNRes, sHUNRes, sLUNRes);
            } else {
                propertyRecords = this.getAllProperties(restrictions);
            }
            int from = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
            int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)Integer.MAX_VALUE);
            if (null != propertyRecords) {
                if (from != 0) {
                    int toIndex = propertyRecords.size();
                    if (size != 0) {
                        size = Math.min(size, propertyRecords.size());
                        toIndex = Math.min(from + size, propertyRecords.size());
                    }
                    if (from >= toIndex) {
                        List<PropertyRecord> list = Collections.emptyList();
                        return list;
                    }
                    List<PropertyRecord> list = propertyRecords.subList(from, toIndex);
                    return list;
                }
                if (0 != size) {
                    int toIndex = propertyRecords.size();
                    toIndex = Math.min(size, propertyRecords.size());
                    List<PropertyRecord> list = propertyRecords.subList(from, toIndex);
                    return list;
                }
            } else {
                List<PropertyRecord> list = Collections.emptyList();
                return list;
            }
            List<PropertyRecord> list = propertyRecords;
            return list;
        }
        finally {
            ROLAPContext.queryExit((IExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment());
            ROLAPContext.removeCurrentCubeName((boolean)needToRemoveCubeName);
        }
    }

    private List<PropertyRecord> filterPropertyRecords(List<PropertyRecord> list, String dunRes, String hunRes, String lunRes) {
        if (dunRes == null && hunRes == null && lunRes == null) {
            if (list == null) {
                return Collections.emptyList();
            }
            return list;
        }
        ArrayList<PropertyRecord> answer = new ArrayList<PropertyRecord>();
        for (PropertyRecord propRec : list) {
            if (dunRes != null && !dunRes.equals(propRec.getDimensionUniqueName()) || hunRes != null && !hunRes.equals(propRec.getHierarchyUniqueName()) || lunRes != null && !lunRes.equals(propRec.getUniqueName())) continue;
            answer.add(propRec);
        }
        return answer;
    }

    private void addFakePropertyForOneProperty(IRestrictions restrictions, List<PropertyRecord> propertyRecords, HierarchyRecord hierRec, LevelRecord levelRec) {
        String propertyRes = (String)restrictions.getTypedValueOf(RestrictionType.PROPERTY, String.class);
        if (hierRec == null) {
            String sHUNRes = (String)restrictions.getTypedValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME, String.class);
            if (sHUNRes != null && sHUNRes.length() > 0) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, ERR_MSG_HIER_NOT_FOUND + sHUNRes);
            }
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, ERR_MSG_PROP_NOT_FOUND + propertyRes);
        }
        if (propertyRes.equals("_rollupType")) {
            if (hierRec.isParentChild()) {
                this.addFakeIntrinsicPropertyForHierarchy(restrictions, propertyRecords, hierRec, RoleTypeEnum.MEMBER_ROLLUP);
            } else {
                this.addFakeIntrinsicPropertyForLevel(restrictions, propertyRecords, levelRec, RoleTypeEnum.MEMBER_ROLLUP);
            }
        } else if (propertyRes.equals("PPDS_CODE")) {
            if (hierRec.isParentChild()) {
                this.addFakeIntrinsicPropertyForHierarchy(restrictions, propertyRecords, hierRec, RoleTypeEnum.PPDS_CODE);
            } else {
                this.addFakeIntrinsicPropertyForLevel(restrictions, propertyRecords, levelRec, RoleTypeEnum.PPDS_CODE);
            }
        }
    }

    private PropertyRecord createFakeProperty(String propertyName, String sDUN, String sHUN, String sLUN, RoleTypeEnum roleType, IDataType dataType, LocalizedString caption) {
        PropertyRecord property = new PropertyRecord();
        property.setUniqueName(propertyName);
        if (null != sDUN) {
            property.setDimensionUniqueName(sDUN);
        }
        if (null != sHUN) {
            property.setHierarchyUniqueName(sHUN);
        }
        if (null != sLUN) {
            property.setLevelUniqueName(sLUN);
        }
        property.setName(propertyName);
        property.setRoleType(roleType);
        property.setUniqueId(RecordType.PROPERTY, propertyName);
        property.setDataType(dataType);
        property.setCaption((ILocalizedString)caption);
        return property;
    }

    private void getPropertiesInternal(IRestrictions restrictions, List<PropertyRecord> propertyRecords, HierarchyRecord hierRec, LevelRecord levelRec) {
        restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, (Object)hierRec.getUniqueName());
        String propertyNameRes = (String)restrictions.getValueOf(RestrictionType.PROPERTY);
        String hierarchyUniqueName = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        String dimensionUniqueName = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String levelUniqueName = (String)restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME);
        String memberUniqueName = (String)restrictions.getValueOf(RestrictionType.MEMBER_UNIQUE_NAME);
        if (null != memberUniqueName) {
            if (memberUniqueName.contains(MEASURES_STRING)) {
                return;
            }
            ArrayList<IHierarchy> hierarchiesFound = new ArrayList<IHierarchy>();
            this.getROLAPHierarchies(catalogName, cubeName, null, null, hierarchiesFound);
            IMember member = null;
            for (IHierarchy hierarchy : hierarchiesFound) {
                member = hierarchy.getMember(memberUniqueName);
            }
            if (null != member) {
                levelUniqueName = member.getLevel().getUniqueName();
            } else {
                return;
            }
        }
        ArrayList<ILevel> levelsFound = new ArrayList<ILevel>();
        this.getROLAPLevels(catalogName, cubeName, dimensionUniqueName, hierarchyUniqueName, levelUniqueName, -1, levelsFound);
        ArrayList<IProperty> propsFound = new ArrayList<IProperty>();
        for (ILevel level : levelsFound) {
            this.getROLAPProperties(cubeName, level, propertyNameRes, propsFound);
        }
        HashMap punsAddedByHier = new HashMap();
        for (IProperty prop : propsFound) {
            ILocalizedString caption;
            String propName = prop.getName();
            if (this.skipProperty(propName)) continue;
            String propLUN = prop.getLevel().getUniqueName();
            String propHUN = prop.getHierarchy().getUniqueName();
            String propDUN = prop.getDimension().getUniqueName();
            String propUniqueName = prop.getUniqueName();
            if (hierRec.isParentChild()) {
                HashSet<String> punsAdded = (HashSet<String>)punsAddedByHier.get(hierRec.getUniqueName());
                if (null != punsAdded) {
                    if (punsAdded.contains(propUniqueName)) continue;
                    punsAdded.add(propUniqueName);
                } else {
                    punsAdded = new HashSet<String>();
                    punsAdded.add(propUniqueName);
                    punsAddedByHier.put(hierRec.getUniqueName(), punsAdded);
                }
            }
            PropertyRecord propRec = new PropertyRecord();
            propRec.setCatalogName(catalogName);
            propRec.setCubeName(cubeName);
            propRec.setName(propName);
            propRec.setUniqueName(propUniqueName);
            propRec.setUniqueId(RecordType.PROPERTY, propUniqueName);
            propRec.setDimensionUniqueName(propDUN);
            propRec.setHierarchyUniqueName(propHUN);
            if (!hierRec.isParentChild()) {
                propRec.setLevelUniqueName(propLUN);
            }
            if ((caption = ((IROLAPProperty)prop).getLocalizedCaption()) != null) {
                propRec.setCaption(caption);
            } else {
                propRec.setCaption((ILocalizedString)new LocalizedString(this.mCube.getDefaultLocale(), prop.getCaption()));
            }
            propRec.setDescription(prop.getDescription());
            propRec.setDataType(prop.getDataType());
            if (propName.equals("MEMBER_KEY")) {
                propRec.setRoleType(RoleTypeEnum.BUSINESS_KEY);
            }
            propertyRecords.add(propRec);
        }
    }

    private List<PropertyRecord> getAllProperties(IRestrictions restrictions) {
        IRestrictions newRestrictions = restrictions.duplicate();
        newRestrictions.remove(RestrictionType.FROM);
        newRestrictions.remove(RestrictionType.SIZE);
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        ArrayList<ILevel> levelsFound = new ArrayList<ILevel>();
        this.getROLAPLevels(catalogName, cubeName, null, null, null, -1, levelsFound);
        ArrayList<IProperty> propsFound = new ArrayList<IProperty>();
        for (ILevel level : levelsFound) {
            this.getROLAPProperties(cubeName, level, null, propsFound);
        }
        HashMap punsAddedByHier = new HashMap();
        LevelRecord levelRec = null;
        DimensionRecord dimRec = null;
        HierarchyRecord hierRec = null;
        ArrayList<PropertyRecord> propertyRecords = new ArrayList<PropertyRecord>(propsFound.size());
        for (IProperty prop : propsFound) {
            String propName = prop.getName();
            if (this.skipProperty(propName)) continue;
            String propLUN = prop.getLevel().getUniqueName();
            String propHUN = prop.getHierarchy().getUniqueName();
            String propDUN = prop.getDimension().getUniqueName();
            if (MEASURES_STRING.equals(propDUN)) continue;
            if (null == dimRec || !propDUN.equals(dimRec.getUniqueName())) {
                dimRec = this.getDimensionRecord(newRestrictions, propDUN);
                hierRec = null;
                levelRec = null;
            }
            if (null == hierRec || !propHUN.equals(hierRec.getUniqueName())) {
                hierRec = this.getHierarchyRecord(newRestrictions, propHUN);
                levelRec = null;
            }
            if (null == levelRec || !propLUN.equals(levelRec.getUniqueName())) {
                levelRec = this.getLevelRecord(newRestrictions, propLUN);
            }
            String propUniqueName = prop.getUniqueName();
            if (hierRec.isParentChild()) {
                HashSet<String> punsAdded = (HashSet<String>)punsAddedByHier.get(hierRec.getUniqueName());
                if (null != punsAdded) {
                    if (punsAdded.contains(propUniqueName)) continue;
                    punsAdded.add(propUniqueName);
                } else {
                    punsAdded = new HashSet<String>();
                    punsAdded.add(propUniqueName);
                    punsAddedByHier.put(hierRec.getUniqueName(), punsAdded);
                }
            }
            String propCaption = propName.equals("MEMBER_KEY") ? this.constructMemberKeyCaption(restrictions, hierRec, propLUN, levelRec) : propName;
            PropertyRecord propRec = new PropertyRecord();
            propRec.setCatalogName(catalogName);
            propRec.setCubeName(cubeName);
            propRec.setName(propName);
            propRec.setUniqueName(propUniqueName);
            propRec.setUniqueId(RecordType.PROPERTY, propUniqueName);
            propRec.setDimensionUniqueName(propDUN);
            propRec.setHierarchyUniqueName(propHUN);
            if (!hierRec.isParentChild()) {
                propRec.setLevelUniqueName(propLUN);
            }
            propRec.setCaption((ILocalizedString)new LocalizedString(this.mCube.getDefaultLocale(), propCaption));
            propRec.setDescription(prop.getDescription());
            propRec.setDataType(prop.getDataType());
            if (propName.equals("MEMBER_KEY")) {
                propRec.setRoleType(RoleTypeEnum.BUSINESS_KEY);
            }
            propertyRecords.add(propRec);
        }
        return propertyRecords;
    }

    private String constructMemberKeyCaption(IRestrictions restrictions, HierarchyRecord hierRec, String lunRestriction, LevelRecord level) {
        StringBuilder newCaption = new StringBuilder();
        if (null != lunRestriction && lunRestriction.length() > 0) {
            if (null == level) {
                level = this.getLevelRecord(restrictions, lunRestriction);
            }
            if (null != level) {
                if (null != hierRec && hierRec.isParentChild()) {
                    newCaption.append(hierRec.getCaption().toString());
                    newCaption.append(KEY_SUFFIX);
                } else {
                    newCaption.append(level.getCaption().toString());
                    newCaption.append(KEY_SUFFIX);
                }
            }
        } else if (null != hierRec) {
            newCaption.append(hierRec.getCaption().toString());
            newCaption.append(KEY_SUFFIX);
        }
        return newCaption.toString();
    }

    private boolean skipProperty(String propertyName) {
        boolean skipThisProperty = false;
        if (propertyName.equals("MEMBER_VALUE")) {
            skipThisProperty = true;
        } else if (propertyName.equals("SKIPPED_LEVELS")) {
            skipThisProperty = true;
        } else if (propertyName.equals("CUSTOM_ROLLUP")) {
            skipThisProperty = true;
        } else if (propertyName.equals("NAME")) {
            skipThisProperty = true;
        } else if (propertyName.equals("UNARY_OPERATOR")) {
            skipThisProperty = true;
        }
        return skipThisProperty;
    }

    private void addFakeIntrinsicHierProperties(List<PropertyRecord> propertyRecords, IRestrictions restrictions, HierarchyRecord hierRec) {
        if (hierRec.isParentChild()) {
            this.addFakeIntrinsicPropertyForHierarchy(restrictions, propertyRecords, hierRec, RoleTypeEnum.MEMBER_ROLLUP);
            this.addFakeIntrinsicPropertyForHierarchy(restrictions, propertyRecords, hierRec, RoleTypeEnum.PPDS_CODE);
        } else {
            IRestrictions newRestrictions = restrictions.duplicate();
            newRestrictions.remove(RestrictionType.FROM);
            newRestrictions.remove(RestrictionType.SIZE);
            List<LevelRecord> levelRecords = this.getLevels(newRestrictions);
            for (LevelRecord levelRec : levelRecords) {
                this.addFakeIntrinsicPropertyForLevel(newRestrictions, propertyRecords, levelRec, RoleTypeEnum.MEMBER_ROLLUP);
                this.addFakeIntrinsicPropertyForLevel(newRestrictions, propertyRecords, levelRec, RoleTypeEnum.PPDS_CODE);
            }
        }
    }

    private void addFakeIntrinsicPropertyForHierarchy(IRestrictions restrictions, List<PropertyRecord> propertyRecords, HierarchyRecord hierRec, RoleTypeEnum roleType) {
        String propertyName = "";
        String caption = "";
        if (roleType == RoleTypeEnum.BUSINESS_KEY) {
            propertyName = "MEMBER_KEY";
            StringBuilder newCaption = new StringBuilder();
            newCaption.append(hierRec.getCaption().toString());
            newCaption.append(KEY_SUFFIX);
            caption = newCaption.toString();
        } else if (roleType == RoleTypeEnum.MEMBER_ROLLUP) {
            propertyName = "_rollupType";
            caption = "_rollupType";
        } else if (roleType == RoleTypeEnum.PPDS_CODE) {
            propertyName = "PPDS_CODE";
            caption = "PPDS_CODE";
        }
        LocalizedString propCaption = new LocalizedString(this.mCube.getDefaultLocale(), caption);
        PropertyRecord property = this.createFakeProperty(propertyName, hierRec.getDimensionUniqueName(), hierRec.getUniqueName(), null, roleType, (IDataType)StringType.DEFAULTSTRINGTYPE, propCaption);
        property.setCatalogName((String)restrictions.getTypedValueOf(RestrictionType.CATALOG, String.class));
        property.setCubeName((String)restrictions.getTypedValueOf(RestrictionType.CUBE, String.class));
        propertyRecords.add(property);
    }

    private void addFakeIntrinsicPropertyForLevel(IRestrictions restrictions, List<PropertyRecord> propertyRecords, LevelRecord levelRec, RoleTypeEnum roleType) {
        String propertyName = "";
        String caption = "";
        if (roleType == RoleTypeEnum.BUSINESS_KEY) {
            propertyName = "MEMBER_KEY";
            StringBuilder newCaption = new StringBuilder();
            newCaption.append(levelRec.getCaption().toString());
            newCaption.append(KEY_SUFFIX);
            caption = newCaption.toString();
        } else if (roleType == RoleTypeEnum.MEMBER_ROLLUP) {
            propertyName = "_rollupType";
            caption = "_rollupType";
        } else if (roleType == RoleTypeEnum.PPDS_CODE) {
            propertyName = "PPDS_CODE";
            caption = "PPDS_CODE";
        }
        LocalizedString propCaption = new LocalizedString(this.mCube.getDefaultLocale(), caption);
        PropertyRecord property = this.createFakeProperty(propertyName, levelRec.getDimensionUniqueName(), levelRec.getHierarchyUniqueName(), levelRec.getUniqueName(), roleType, (IDataType)StringType.DEFAULTSTRINGTYPE, propCaption);
        property.setCatalogName((String)restrictions.getTypedValueOf(RestrictionType.CATALOG, String.class));
        property.setCubeName((String)restrictions.getTypedValueOf(RestrictionType.CUBE, String.class));
        propertyRecords.add(property);
    }

    private void getROLAPProperties(String cubeName, ILevel level, String propertyName, List<IProperty> propsFound) {
        IROLAPLevel rolapLevel = (IROLAPLevel)level;
        List propertyList = rolapLevel.getMemberProperties(cubeName);
        for (IProperty property : propertyList) {
            if (propertyName != null && propertyName.equals(property.getName())) {
                propsFound.add(property);
                break;
            }
            propsFound.add(property);
        }
        ROLAPVirtualProperty businessKeyProp = null;
        if (rolapLevel instanceof ROLAPVirtualLevel) {
            businessKeyProp = new ROLAPVirtualProperty("MEMBER_KEY", (ILevel)rolapLevel);
        } else {
            ROLAPMetaLevel metaLevel = rolapLevel.getMetaLevel();
            ROLAPMetaAttribute businessKeyAttribute = null;
            if (null != metaLevel) {
                businessKeyAttribute = null != metaLevel.getBusinessKey() ? metaLevel.getBusinessKey() : (null != metaLevel.getCaption() ? metaLevel.getCaption() : metaLevel.getLastLevelKey());
            }
            businessKeyProp = new ROLAPProperty("MEMBER_KEY", businessKeyAttribute);
        }
        businessKeyProp.setUniqueName("MEMBER_KEY");
        businessKeyProp.setCaption("MEMBER_KEY");
        businessKeyProp.setDimension(rolapLevel.getHierarchy().getDimension());
        businessKeyProp.setHierarchy(rolapLevel.getHierarchy());
        businessKeyProp.setLevel((ILevel)rolapLevel);
        businessKeyProp.setInitialised();
        propsFound.add((IProperty)businessKeyProp);
    }

    public List<ActionRecord> getActions(IRestrictions restrictions) {
        return Collections.emptyList();
    }

    public List<AliasRecord> getAliases(IRestrictions restrictions) {
        return Collections.emptyList();
    }

    public List<String> getDatasourceLocales(IRestrictions restrictions) {
        return Collections.emptyList();
    }

    public List<MacroRecord> getMacros(IRestrictions restrictions) {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NamedSetRecord> getNamedSets(IRestrictions restrictions) {
        ROLAPContext.queryEnter((IExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment(), (ROLAPCube)this.mCube);
        try {
            this.checkForMissingRestrictions(restrictions, NAMEDSETS_RESTRICTIONS);
            String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
            String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
            String setName = (String)restrictions.getValueOf(RestrictionType.SET);
            ArrayList<INamedSet> namedSetsFound = new ArrayList<INamedSet>();
            this.getROLAPNamedSets(catalogName, cubeName, setName, namedSetsFound);
            ArrayList<NamedSetRecord> result = new ArrayList<NamedSetRecord>();
            for (INamedSet namedSet : namedSetsFound) {
                IMember firstMember = ((IROLAPNamedSet)namedSet).getFirstMember();
                SecurityManagerInterface securityManager = this.mCube.getSecurityManager();
                if (securityManager != null && firstMember != null) {
                    IDimension dim = firstMember.getDimension();
                    if (dim == null || securityManager.isDimensionSecured(dim)) continue;
                    result.add(this.createNamedSetRecord(namedSet));
                    continue;
                }
                result.add(this.createNamedSetRecord(namedSet));
            }
            ArrayList<NamedSetRecord> arrayList = result;
            return arrayList;
        }
        finally {
            ROLAPContext.queryExit((IExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment());
        }
    }

    public List<HierarchyNamedSetRecord> getHierarchyNamedSets(IRestrictions restrictions) {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MemberRecord> getNamedSetMembers(IRestrictions restrictions) {
        ROLAPContext.queryEnter((IExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment(), (ROLAPCube)this.mCube);
        boolean needToRemoveCurrentCubeName = ROLAPContext.setCurrentCubeName((String)this.mCube.getName());
        try {
            this.checkForMissingRestrictions(restrictions, NAMEDSETS_RESTRICTIONS);
            String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
            String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
            String setName = (String)restrictions.getValueOf(RestrictionType.SET);
            ArrayList<INamedSet> namedSetsFound = new ArrayList<INamedSet>();
            this.getROLAPNamedSets(catalogName, cubeName, OPEN_BRACE + setName + CLOSE_BRACE, namedSetsFound);
            if (namedSetsFound.size() != 1) {
                List<MemberRecord> list = Collections.emptyList();
                return list;
            }
            ArrayList<ROLAPCube> cubesFound = new ArrayList<ROLAPCube>(1);
            this.getROLAPCubes(catalogName, cubeName, cubesFound);
            if (cubesFound.size() != 1) {
                List<MemberRecord> list = Collections.emptyList();
                return list;
            }
            ArrayList<MemberRecord> result = new ArrayList<MemberRecord>();
            IROLAPNamedSet namedSet = (IROLAPNamedSet)namedSetsFound.get(0);
            IMember nsMember = namedSet.getFirstMember();
            if (nsMember != null) {
                result.add(this.createMemberRecord(nsMember, cubeName));
            } else {
                List dimensions = ((ROLAPCube)cubesFound.get(0)).getDimensions();
                IDimension dimWithHierarchy = null;
                for (IDimension dim : dimensions) {
                    if (dim.isMeasuresDimension()) continue;
                    dimWithHierarchy = dim;
                    break;
                }
                if (null == dimWithHierarchy) {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Unable to find non-measure dimension in cube");
                }
                nsMember = ((Dimension)dimWithHierarchy).getNullMember();
                result.add(this.createMemberRecord(nsMember, cubeName));
            }
            ArrayList<MemberRecord> arrayList = result;
            return arrayList;
        }
        finally {
            ROLAPContext.removeCurrentCubeName((boolean)needToRemoveCurrentCubeName);
            ROLAPContext.queryExit((IExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment());
        }
    }

    public List<String> getNamedSetLevelUniqueNames(IRestrictions restrictions) {
        return Collections.emptyList();
    }

    public List<VariableRecord> getVariables(IRestrictions restrictions) {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MemberRecord> getHierarchyCalculatedMembers(IRestrictions restrictions) {
        ROLAPContext.queryEnter((IExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment(), (ROLAPCube)this.mCube);
        boolean needToRemoveCubeName = ROLAPContext.setCurrentCubeName((String)this.mCube.getName());
        try {
            this.checkForMissingRestrictions(restrictions, HIERARCHY_ROOT_MEMBERS_RESTRICTIONS);
            String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
            String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
            String dimensionUniqueName = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
            String hierarchyUniqueName = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
            ArrayList<MemberRecord> result = new ArrayList<MemberRecord>();
            ArrayList<IHierarchy> hierarchiesFound = new ArrayList<IHierarchy>();
            this.getROLAPHierarchies(catalogName, cubeName, dimensionUniqueName, hierarchyUniqueName, hierarchiesFound);
            for (IROLAPHierarchy arrayList : hierarchiesFound) {
                List calculatedMembers = arrayList.getROLAPCalculatedMembers(cubeName);
                for (ROLAPCalculatedMember calcMember : calculatedMembers) {
                    MemberRecord record = this.createMemberRecord((IMember)calcMember, cubeName);
                    record.setDynamicFieldAsString(CALCULATED_MEMBER_EXPRESSION_DYNAMIC_FIELD_NAME, calcMember.getCalculationString());
                    record.setDynamicFieldAsString(CALCULATED_MEMBER_SOLVE_ORDER_DYNAMIC_FIELD_NAME, String.valueOf(calcMember.getSolveOrder()));
                    record.setDynamicFieldAsString(EXTENDED_CALCULATED_MEMBER_DYNAMIC_FIELD_NAME, String.valueOf(calcMember.isExtendedCalculatedMember()));
                    result.add(record);
                }
            }
            ArrayList<MemberRecord> arrayList = result;
            return arrayList;
        }
        finally {
            ROLAPContext.queryExit((IExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment());
            ROLAPContext.removeCurrentCubeName((boolean)needToRemoveCubeName);
        }
    }

    private void getROLAPMeasureItems(String catalogName, String cubeName, String measureUniqueName, EnumSet<TreeOperatorEnum> treeOps, List<IMetadata> measuresItemsFound) {
        ArrayList<ROLAPCube> cubesFound = new ArrayList<ROLAPCube>();
        this.getROLAPCubes(catalogName, cubeName, cubesFound);
        if (cubesFound.size() == 1) {
            ROLAPCube cube = (ROLAPCube)cubesFound.get(0);
            SecurityManagerInterface securityManager = cube.getSecurityManager(cube.getProvider());
            ROLAPFolder measureFolder = cube.getRootMeasureFolder();
            if ((measureFolder = measureFolder.applySecurity(securityManager)) != null) {
                if (treeOps != null && measureUniqueName != null) {
                    IMetadata measureItem = measureFolder.findChild(measureUniqueName);
                    if (measureItem != null) {
                        if (measureItem instanceof IROLAPFolder) {
                            this.getROLAPMeasureItemsFromRelation(cube, measureItem, treeOps, measuresItemsFound);
                        } else {
                            ArrayList<IMember> membersFound = new ArrayList<IMember>();
                            this.getROLAPMembersFromRelation((IMember)measureItem, treeOps, membersFound);
                            measuresItemsFound.addAll(membersFound);
                        }
                    }
                } else {
                    List measureItems = measureFolder.getChildren();
                    for (IMetadata measureItem : measureItems) {
                        if (measureUniqueName != null && measureUniqueName.equals(measureItem.getUniqueName())) {
                            measuresItemsFound.add(measureItem);
                            break;
                        }
                        measuresItemsFound.add(measureItem);
                    }
                }
            }
            if (cube.getSchema().getVersion().equals("1.0.0")) {
                Comparator<IMetadata> measureComparator = new Comparator<IMetadata>(){

                    @Override
                    public int compare(IMetadata m1, IMetadata m2) {
                        return m1.getName().compareTo(m2.getName());
                    }
                };
                Collections.sort(measuresItemsFound, measureComparator);
            }
        }
    }

    private MeasureRecord createMeasureFolderRecord(ROLAPMetaCube metaCube, IROLAPFolder measureFolder) {
        MeasureRecord measureRecord = new MeasureRecord();
        measureRecord.setName(measureFolder.getName());
        measureRecord.setUniqueName(measureFolder.getUniqueName());
        measureRecord.setUniqueId(RecordType.MEASURE, measureFolder.getUniqueName());
        measureRecord.setCaption(measureFolder.getLocalizedCaption());
        measureRecord.setDescription(measureFolder.getDescription());
        measureRecord.setCatalogName(ROLAP_CATALOG_NAME);
        measureRecord.setMeasureFolder(Boolean.valueOf(true));
        ROLAPCube rolapCube = (ROLAPCube)measureFolder.getCube();
        IDimension dimension = rolapCube.getMeasureDimension();
        measureRecord.setCubeName(dimension.getCube().getName());
        measureRecord.setDimensionUniqueName(dimension.getUniqueName());
        measureRecord.setHierarchyUniqueName(dimension.getDefaultHierarchy().getUniqueName());
        measureRecord.setHidden(Boolean.valueOf(!measureFolder.isVisible()));
        IDataType dataType = measureFolder.getDataType();
        if (dataType != null) {
            measureRecord.setDataType(dataType);
        } else {
            measureRecord.setDataType((IDataType)MeasureType.MEASURETYPE);
        }
        measureRecord.setDataType((IDataType)DataTypeFactory.getDoubleType());
        return measureRecord;
    }

    private MeasureRecord createMeasureRecord(ROLAPMetaCube metaCube, IROLAPMeasure measure) {
        MeasureRecord measureRecord = new MeasureRecord();
        measureRecord.setName(measure.getName());
        measureRecord.setUniqueName(measure.getUniqueName());
        measureRecord.setUniqueId(RecordType.MEASURE, measure.getUniqueName());
        measureRecord.setCaption(measure.getLocalizedCaption());
        measureRecord.setDescription(measure.getDescription());
        measureRecord.setCatalogName(ROLAP_CATALOG_NAME);
        IDimension dimension = measure.getDimension();
        measureRecord.setCubeName(dimension.getCube().getName());
        measureRecord.setDimensionUniqueName(dimension.getUniqueName());
        measureRecord.setHierarchyUniqueName(measure.getHierarchy().getUniqueName());
        measureRecord.setLevelUniqueName(measure.getLevel().getUniqueName());
        FormatId formatId = measure.getFormatId();
        if (formatId != null) {
            measureRecord.setDynamicFieldAsString("format", FormatService.getInstance().retrieveFormatString(formatId, true));
        }
        measureRecord.setHidden(Boolean.valueOf(!measure.isVisible()));
        IDataType dataType = measure.getDataType();
        if (dataType != null) {
            measureRecord.setDataType(dataType);
        } else {
            measureRecord.setDataType((IDataType)MeasureType.MEASURETYPE);
        }
        measureRecord.setDataType((IDataType)DataTypeFactory.getDoubleType());
        if (measure instanceof ROLAPMeasure) {
            ROLAPMetaMeasure metaMeasure = ((ROLAPMeasure)measure).getROLAPMetaMeasure();
            if (metaMeasure instanceof ROLAPMetaCalculatedMeasure) {
                int solveOrder;
                ROLAPMetaCalculatedMeasure calcMeasure = (ROLAPMetaCalculatedMeasure)metaMeasure;
                String v5Expression = calcMeasure.getV5Expression();
                measureRecord.setDynamicFieldAsString(CALCULATED_MEASURE_EXPRESSION_DYNAMIC_FIELD_NAME, v5Expression);
                if (metaCube != null && metaCube.isCubingServicesCompatible() && (solveOrder = calcMeasure.getSolveOrder()) >= 0) {
                    measureRecord.setDynamicFieldAsString(CALCULATED_MEASURE_SOLVE_ORDER_DYNAMIC_FIELD_NAME, String.valueOf(solveOrder));
                }
            }
        } else if (measure instanceof ROLAPVirtualCalculatedMeasure) {
            ROLAPVirtualCalculatedMemberDef def = ((ROLAPVirtualCalculatedMeasure)measure).getROLAPVirtualCalculatedMemberDef();
            String v5Expression = def.getV5Expression();
            measureRecord.setDynamicFieldAsString(CALCULATED_MEASURE_EXPRESSION_DYNAMIC_FIELD_NAME, v5Expression);
            int solveOrder = def.getSolveOrder();
            if (solveOrder >= 0) {
                measureRecord.setDynamicFieldAsString(CALCULATED_MEASURE_SOLVE_ORDER_DYNAMIC_FIELD_NAME, String.valueOf(solveOrder));
            }
        }
        measureRecord.setRegularAggregate(measure.getRegularAggregate());
        measureRecord.setSemiAggregate(measure.getSemiAggregate());
        measureRecord.setAggregateRules(ROLAPMetadataProvider.convertAggregationRulesForConsumptionByMFW(measure.getAggregateRules()));
        return measureRecord;
    }

    private static IAggregateRule[] convertAggregationRulesForConsumptionByMFW(IAggregateRule[] rolapAggrRules) {
        AggregateRule[] aggrRules = null;
        if (rolapAggrRules != null) {
            aggrRules = new AggregateRule[rolapAggrRules.length];
            int i = 0;
            for (IAggregateRule rolapRule : rolapAggrRules) {
                String dimName = rolapRule.getDimensionRef();
                String dimExternalName = null;
                if (dimName != null) {
                    dimExternalName = OPEN_BRACE + dimName + CLOSE_BRACE;
                }
                aggrRules[i++] = new AggregateRule(rolapRule.getAggregate(), dimExternalName);
            }
        }
        return aggrRules;
    }

    private LevelRecord createLevelRecord(ILevel level, String cubeName) {
        LevelRecord levelRecord = new LevelRecord();
        levelRecord.setName(level.getName());
        levelRecord.setUniqueName(level.getUniqueName());
        levelRecord.setUniqueId(RecordType.LEVEL, level.getUniqueName());
        levelRecord.setCaption(((IROLAPLevel)level).getLocalizedCaption());
        levelRecord.setDescription(level.getDescription());
        levelRecord.setCatalogName(ROLAP_CATALOG_NAME);
        IHierarchy hierarchy = level.getHierarchy();
        IDimension dimension = hierarchy.getDimension();
        levelRecord.setCubeName(cubeName);
        levelRecord.setDimensionUniqueName(dimension.getUniqueName());
        levelRecord.setHierarchyUniqueName(hierarchy.getUniqueName());
        levelRecord.setLevelNumber(level.getIndex());
        levelRecord.setCardinality(level.getCardinality());
        levelRecord.setUniqueMemberNames(level.isUnique());
        ROLAPCube cb = dimension.isShareable() ? ((ShareableROLAPDimension)dimension).getCube(cubeName) : (ROLAPCube)dimension.getCube();
        SecurityManagerInterface securityManager = cb.getSecurityManager();
        if (securityManager != null && securityManager.isDimensionSecured(dimension)) {
            levelRecord.setHidden(Boolean.valueOf(true));
            levelRecord.setNotAccessible(Boolean.valueOf(true));
        }
        return levelRecord;
    }

    private MemberRecord createMemberRecord(IMember member, String cubeName) {
        IDimension dimension = member.getDimension();
        MemberRecord memberRecord = new MemberRecord();
        memberRecord.setName(member.getName());
        memberRecord.setUniqueName(member.getUniqueName());
        memberRecord.setUniqueId(RecordType.MEMBER, member.getUniqueName());
        if (member instanceof IROLAPMember) {
            if (member instanceof ROLAPMemberProxy) {
                ((ROLAPMemberProxy)member).setCaption(memberRecord);
            } else {
                memberRecord.setCaption(((IROLAPMember)member).getLocalizedCaption());
            }
        } else {
            memberRecord.setCaption(member.getCaption());
        }
        memberRecord.setDescription(member.getDescription());
        memberRecord.setCatalogName(ROLAP_CATALOG_NAME);
        memberRecord.setCubeName(cubeName);
        memberRecord.setDimensionUniqueName(dimension.getUniqueName());
        memberRecord.setHierarchyUniqueName(member.getHierarchy().getUniqueName());
        ILevel level = member.getLevel();
        memberRecord.setLevelUniqueName(level.getUniqueName());
        IMember dataMember = member.getDataMember();
        if (dataMember != null) {
            memberRecord.setDataMemberUniqueName(dataMember.getUniqueName());
        } else {
            memberRecord.setDataMemberUniqueName(null);
        }
        memberRecord.setLevelNumber(level.getIndex());
        memberRecord.setType(member.getType());
        memberRecord.setRollupType(member.getRollupType());
        memberRecord.setChildCardinality(member.getChildrenCardinality());
        memberRecord.setParentCount(member.getNumberOfParents());
        memberRecord.setParentLevelNumber(member.getParentLevelNumber());
        memberRecord.setParentUniqueName(member.getParentUniqueName());
        return memberRecord;
    }

    private HierarchyRecord createHierarchyRecord(IHierarchy hierarchy, String cubeName) {
        IMember highestRollupMember;
        IDimension dimension = hierarchy.getDimension();
        ROLAPCube cb = dimension.isShareable() ? ((ShareableROLAPDimension)dimension).getCube(cubeName) : (ROLAPCube)dimension.getCube();
        HierarchyRecord hierarchyRecord = new HierarchyRecord();
        hierarchyRecord.setCaption(((IROLAPHierarchy)hierarchy).getLocalizedCaption());
        hierarchyRecord.setDescription(hierarchy.getDescription());
        hierarchyRecord.setName(hierarchy.getName());
        hierarchyRecord.setUniqueId(RecordType.HIERARCHY, hierarchy.getUniqueName());
        hierarchyRecord.setUniqueName(hierarchy.getUniqueName());
        hierarchyRecord.setCatalogName(ROLAP_CATALOG_NAME);
        hierarchyRecord.setDimensionUniqueName(hierarchy.getDimension().getUniqueName());
        IMember defaultMember = this.getHierarchyDefaultMember(hierarchy, (ICube)cb);
        if (defaultMember != null) {
            hierarchyRecord.setDefaultMemberUniqueName(defaultMember.getUniqueName());
        }
        if ((highestRollupMember = hierarchy.getHighestLevelRollup()) != null) {
            hierarchyRecord.setHighestRollupMemberUniqueName(highestRollupMember.getUniqueName());
        } else {
            hierarchyRecord.setHighestRollupMemberUniqueName(null);
        }
        hierarchyRecord.setCardinality(hierarchy.getLevelCount());
        if (hierarchy.isParentChild()) {
            hierarchyRecord.setStructure((byte)1);
        } else {
            hierarchyRecord.setStructure((byte)4);
        }
        SecurityManagerInterface securityManager = cb.getSecurityManager();
        if (securityManager != null && securityManager.isDimensionSecured(dimension)) {
            hierarchyRecord.setHidden(Boolean.valueOf(true));
            hierarchyRecord.setNotAccessible(Boolean.valueOf(true));
        }
        return hierarchyRecord;
    }

    private IMember getHierarchyDefaultMember(IHierarchy hierarchy, ICube cube) {
        Hierarchy hier = (Hierarchy)hierarchy;
        return hier.getDefaultMemberWithSecurity(cube);
    }

    private DimensionRecord createDimensionRecord(IDimension dimension, String cubeName) {
        ROLAPCube cb;
        String dimensionName = dimension.getName();
        DimensionRecord dimensionRecord = new DimensionRecord();
        dimensionRecord.setCaption(((IROLAPDimension)dimension).getLocalizedCaption());
        dimensionRecord.setDescription(dimension.getDescription());
        dimensionRecord.setName(dimensionName);
        dimensionRecord.setUniqueId(RecordType.DIMENSION, dimension.getUniqueName());
        dimensionRecord.setUniqueName(dimension.getUniqueName());
        dimensionRecord.setCatalogName(ROLAP_CATALOG_NAME);
        dimensionRecord.setCubeName(cubeName);
        if (dimension.isShareable()) {
            cb = ((ShareableROLAPDimension)dimension).getCube(cubeName);
            dimensionRecord.setMembersRollup(((ShareableROLAPDimension)dimension).getMembersRollup((ICube)cb));
        } else {
            cb = (ROLAPCube)dimension.getCube();
            dimensionRecord.setMembersRollup(dimension.getMembersRollup());
        }
        dimensionRecord.setType(dimension.getType());
        dimensionRecord.setCardinality(dimension.getCardinality());
        dimensionRecord.setDefaultHierarchyUniqueName(dimension.getDefaultHierarchy().getUniqueName());
        SecurityManagerInterface securityManager = cb.getSecurityManager();
        if (securityManager != null && securityManager.isDimensionSecured(dimension)) {
            dimensionRecord.setHidden(Boolean.valueOf(true));
            dimensionRecord.setNotAccessible(Boolean.valueOf(true));
        }
        return dimensionRecord;
    }

    private CubeRecord createCubeRecord(ROLAPCube cube) {
        CubeRecord cubeRecord = new CubeRecord();
        cubeRecord.setCaption(cube.getLocalizedCaption());
        cubeRecord.setDescription(cube.getDescription());
        cubeRecord.setName(cube.getName());
        cubeRecord.setUniqueId(RecordType.CUBE, cube.getName());
        cubeRecord.setUniqueName(cube.getName());
        cubeRecord.setCatalogName(ROLAP_CATALOG_NAME);
        cubeRecord.setSuppressionType(ICube.CubeSuppressionTypeEnum.NULL);
        cubeRecord.setCreatedDate(cube.getCreatedDate());
        cubeRecord.setDataUpdateDate(cube.getUpdatedDate());
        cubeRecord.setSchemaUpdateDate(cube.getSchemaUpdatedDate());
        cubeRecord.setCurrentPeriod(null);
        cubeRecord.setIsOptimized(true);
        return cubeRecord;
    }

    private NamedSetRecord createNamedSetRecord(INamedSet namedSet) {
        NamedSetRecord namedSetRec = new NamedSetRecord();
        namedSetRec.setName(namedSet.getName());
        namedSetRec.setUniqueName(namedSet.getUniqueName());
        namedSetRec.setCaption(((IROLAPNamedSet)namedSet).getLocalizedCaption());
        namedSetRec.setCatalogName(ROLAP_CATALOG_NAME);
        namedSetRec.setCubeName(((IROLAPNamedSet)namedSet).getCube().getName());
        namedSetRec.setExpression(namedSet.getExpression());
        namedSetRec.setUniqueId(RecordType.NAMEDSET, namedSetRec.getUniqueName());
        ILocalizedString displayPath = ((IROLAPNamedSet)namedSet).getLocalizedDisplayPath();
        if (displayPath != null) {
            namedSetRec.setLocalizedDisplayPath(displayPath);
        }
        return namedSetRec;
    }

    private void getROLAPHierarchies(String catalogName, String cubeName, String dimensionUniqueName, String hierarchyUniqueName, List<IHierarchy> hierarchiesFound) {
        ArrayList<IDimension> dimensionsFound = new ArrayList<IDimension>();
        this.getROLAPDimensions(catalogName, cubeName, dimensionUniqueName, dimensionsFound);
        if (!dimensionsFound.isEmpty()) {
            for (IDimension dim : dimensionsFound) {
                ROLAPCube cube = (ROLAPCube)dim.getCube();
                List hiersList = dim.getHierarchies();
                for (IHierarchy hier : hiersList) {
                    if (dim.isShareable()) {
                        ROLAPVirtualCubeDef cubeDef;
                        ShareableROLAPDimension sharedDimension = (ShareableROLAPDimension)dim;
                        if (cube.isVirtual() && (cubeDef = (ROLAPVirtualCubeDef)((ROLAPVirtualCube)cube).getROLAPVirtualCubeDef()) != null && cubeDef.isSourceHierarchyHidden(sharedDimension.getCubeLoadingHierarchies(), hier)) continue;
                    }
                    if (hierarchyUniqueName != null) {
                        if (!hier.getUniqueName().equals(hierarchyUniqueName)) continue;
                        hierarchiesFound.add(hier);
                        return;
                    }
                    hierarchiesFound.add(hier);
                }
            }
        }
    }

    private void getROLAPDimensions(String catalogName, String cubeName, String dimensionUniqueName, List<IDimension> dimensionsFound) {
        block4: {
            ArrayList<ROLAPCube> cubesFound = new ArrayList<ROLAPCube>(1);
            this.getROLAPCubes(catalogName, cubeName, cubesFound);
            if (cubesFound.size() != 1) break block4;
            List dimsList = ((ROLAPCube)cubesFound.get(0)).getDimensions();
            if (dimensionUniqueName != null) {
                for (IDimension dim : dimsList) {
                    if (!dim.getUniqueName().equals(dimensionUniqueName)) continue;
                    dimensionsFound.add(dim);
                    return;
                }
            } else {
                for (IDimension dim : dimsList) {
                    if (dim.getType() == DimensionTypeEnum.INTERNAL) continue;
                    dimensionsFound.add(dim);
                }
            }
        }
    }

    private void getROLAPCubes(String catalogName, String cubeName, List<ROLAPCube> cubesFound) {
        List<ROLAPCube> cubesList = this.getCubesFromDataSource(catalogName);
        if (cubesList == null) {
            throw new ROLAPRuntimeException(ROLAPMessageKeys.ERR_INVALID_CATALOG_NAME, catalogName);
        }
        if (cubeName != null) {
            for (ROLAPCube cube : cubesList) {
                if (!cube.getName().equalsIgnoreCase(cubeName)) continue;
                cubesFound.add(cube);
            }
            if (cubesFound.size() == 0) {
                throw new ROLAPRuntimeException(ROLAPMessageKeys.ERR_INVALID_CUBE_NAME, cubeName);
            }
        } else {
            cubesFound.addAll(cubesList);
        }
    }

    private void getROLAPNamedSets(String catalogName, String cubeName, String setName, List<INamedSet> namedSetsFound) {
        ArrayList<ROLAPCube> cubesFound = new ArrayList<ROLAPCube>(1);
        this.getROLAPCubes(catalogName, cubeName, cubesFound);
        if (cubesFound.size() != 1) {
            return;
        }
        Map namedSetMap = ((ROLAPCube)cubesFound.get(0)).getNamedSets();
        if (setName == null) {
            namedSetsFound.addAll(namedSetMap.values());
        } else {
            namedSetsFound.add((INamedSet)namedSetMap.get(setName));
        }
    }

    private List<ROLAPCube> getCubesFromDataSource(String catalogName) {
        if (!ROLAP_CATALOG_NAME.equalsIgnoreCase(catalogName)) {
            return null;
        }
        return new ArrayList<ROLAPCube>(ROLAPCubeManager.getInstance().getCubes());
    }

    private void checkForMissingRestrictions(IRestrictions restrictions, EnumSet<RestrictionType> type) {
        EnumSet missingTypes = restrictions.contains(type);
        if (missingTypes != null) {
            String missedRestrictions = missingTypes.toString();
            if (this.logger.isOn(LogLevel.ERROR)) {
                StringBuilder buf = new StringBuilder();
                buf.append(ERR_MSG_MISSING_REQUIRED_RESTRICTION);
                buf.append(missedRestrictions);
                buf.append(" are missing for metadata request.");
                this.logger.log(LogLevel.ERROR, buf.toString());
            }
            throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionMissing, missedRestrictions);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void getROLAPMeasureItemsFromRelation(ROLAPCube cube, IMetadata measureItem, EnumSet<TreeOperatorEnum> treeOps, List<IMetadata> measureItemsFound) {
        if (measureItem instanceof IROLAPFolder) {
            if (!treeOps.contains(TreeOperatorEnum.CHILDREN)) throw new ROLAPRuntimeException(ROLAPMessageKeys.ERR_RELATED_MEMBERS_ERROR, measureItem.getUniqueName());
            measureItemsFound.addAll(((IROLAPFolder)measureItem).getChildren());
            return;
        } else {
            ArrayList<IMember> membersFound = new ArrayList<IMember>();
            this.getROLAPMembersFromRelation((IMember)((IMeasure)measureItem), treeOps, membersFound);
            measureItemsFound.addAll(membersFound);
        }
    }

    static {
        CATALOG_RECORD.setName(ROLAP_CATALOG_NAME);
        CATALOG_RECORD.setUniqueName(ROLAP_CATALOG_NAME);
        CATALOG_RECORD.setUniqueId(RecordType.CATALOG, ROLAP_CATALOG_NAME);
        CATALOG_RECORD.setCaption(ROLAP_CATALOG_NAME);
        CATALOG_RECORD.setDescription(ROLAP_CATALOG_NAME);
        recursiveCall = false;
    }
}

