/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.snwodp;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.conn.bapi.JBapiException;
import com.cognos.xqe.conn.bapi.JBapiTable;
import com.cognos.xqe.data.providers.ProviderIteratorBase;
import com.cognos.xqe.data.providers.ProviderResultSetBase;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPAxisInfo;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPConfig;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPException;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPLog;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPMessageKeys;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPResultSet;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPSAPData;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPUtility;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.metadata.RollupTypeEnum;
import com.cognos.xqe.metadata.provider.Member;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.resultsets.md.Tuple;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.LRUMap;

public class SNWODPAxisIterator
extends ProviderIteratorBase {
    private volatile boolean isReleased = false;
    private long currRowIndex = 0L;
    private ICube mCube = null;
    private SNWODPAxisInfo mAxisInfo;
    private SNWODPSAPData mSapData;
    private boolean mHasNext;
    private int mAxisSize;
    private SNWODPResultSet mSapResultSet;
    private Map<String, Member> memberCache = null;
    private Map<Integer, Object> dimProperties = null;
    private Map<String, String>[] memberProperties = null;
    private final int id;
    private static final int STRING_POOL_SIZE = 100;
    private LRUMap stringPool = new LRUMap(100);

    private String poolString(String string) {
        String pooledString = (String)this.stringPool.get((Object)string);
        if (pooledString != null) {
            return pooledString;
        }
        this.stringPool.put((Object)string, (Object)string);
        return string;
    }

    public SNWODPAxisIterator(SNWODPResultSet resultSet, XDataContext xDataContext, ICube cube, SNWODPAxisInfo axisInfo, Integer nodeID, int iterID) throws SNWODPException {
        super((ProviderResultSetBase)resultSet, xDataContext, nodeID);
        try {
            this.mCube = cube;
            this.mAxisInfo = axisInfo;
            this.mSapResultSet = resultSet;
            this.id = iterID;
            super.setEdgeNumber(this.mAxisInfo.getAxisKey());
            this.mSapData = this.mSapResultSet.executeGetAxisDataFunction(this.mAxisInfo.getAxisKey(), 0, 0);
            this.mAxisSize = this.mSapData.getRowCount(2);
            if (SNWODPLog.isOn("DataQuery", LogLevel.INFO).booleanValue()) {
                int maxRows = SNWODPConfig.instance().getMaxTableDumpRows();
                SNWODPLog.getLogger("DataQuery").log(LogLevel.INFO, this.mSapData.getData(2).traceToString(maxRows));
            }
            this.memberCache = this.extractMembers();
            if (this.currRowIndex < (long)this.mAxisSize) {
                this.mHasNext = true;
            }
        }
        catch (SNWODPException e) {
            this.release();
            throw e;
        }
    }

    private void checkForCancel() throws OperationCanceledException {
        this.mSapResultSet.checkForCancel();
    }

    public int getID() {
        return this.id;
    }

    public Object nextImpl() throws SNWODPException {
        if (SNWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
            SNWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "NextImpl called on AxisIterator.");
        }
        if (!this.mHasNext) {
            if (SNWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
                SNWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "AxisIterator has no next tuple.");
            }
            return null;
        }
        IMember[] tuple = null;
        if (this.currRowIndex < (long)this.mAxisSize) {
            tuple = this.getNextTuple();
        }
        if (tuple == null || tuple.length == 0) {
            if (SNWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
                SNWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "AxisIterator next tuple is null or empty.");
            }
            return null;
        }
        ++this.currentIndex;
        this.mHasNext = this.currRowIndex < (long)this.mAxisSize;
        Tuple result = new Tuple(tuple, false);
        if (SNWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
            SNWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "AxisIterator.nextImpl found tuple: " + result.toString());
        }
        return result;
    }

    private IMember[] getNextTuple() throws SNWODPException {
        JBapiTable members = this.mSapData.getData(2);
        int tupleSize = this.mAxisInfo.getDimensionNum();
        int lastRowIndex = (int)this.currRowIndex + tupleSize;
        ArrayList<Member> axisMembers = new ArrayList<Member>(tupleSize);
        try {
            for (int i = (int)this.currRowIndex; i < lastRowIndex; ++i) {
                this.checkForCancel();
                members.moveTo(i);
                String uName = members.getFieldByIndex(2);
                Member member = this.memberCache.get(uName);
                if (member != null) {
                    axisMembers.add(member);
                    ++this.currRowIndex;
                    continue;
                }
                if (SNWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
                    SNWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "Member not found: " + uName);
                }
                return new IMember[0];
            }
        }
        catch (JBapiException e) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_GET_TUPLE, e);
        }
        return axisMembers.toArray(new IMember[0]);
    }

    private HashMap<String, Member> extractMembers() throws SNWODPException {
        HashMap<String, Member> tempCache = null;
        JBapiTable members = this.mSapData.getData(2);
        this.getOptionalProperties();
        try {
            int rowCount = members.getNumRows();
            tempCache = new HashMap<String, Member>(rowCount);
            for (int i = 0; i < rowCount; ++i) {
                this.checkForCancel();
                members.moveTo(i);
                String uName = members.getFieldByIndex(2);
                if (tempCache.containsKey(uName)) continue;
                Member member = new Member();
                Integer dimKey = XQEIntegerPool.getInteger((int)members.getFieldIntByIndex(1));
                int ordinal = members.getFieldIntByIndex(0);
                Map<String, String> memProps = this.getOptionalProperties(dimKey, ordinal);
                String name = "";
                String caption = members.getFieldByIndex(3);
                member.setProperty("DIM_KEY", (Object)dimKey);
                member.setChildrenCardinality(XQEIntegerPool.getInteger((int)members.getFieldIntByIndex(6)).intValue());
                member.setCaption(caption);
                int levelIndex = members.getFieldIntByIndex(5);
                member.setUniqueName(uName);
                if (memProps != null && !memProps.isEmpty()) {
                    Set<Map.Entry<String, String>> propSet = memProps.entrySet();
                    for (Map.Entry<String, String> entry : propSet) {
                        String propName = entry.getKey();
                        IDimension dim = this.mAxisInfo.getDimension(dimKey);
                        String dimUName = dim.getUniqueName();
                        if (propName.equals("[MEMBER_NAME]")) {
                            name = entry.getValue();
                            continue;
                        }
                        if (propName.equals("[PARENT_UNIQUE_NAME]")) {
                            member.setParentUniqueName(entry.getValue());
                            continue;
                        }
                        if (propName.equals("[PARENT_LEVEL]")) {
                            try {
                                member.setParentLevelNumber(Integer.parseInt(entry.getValue()));
                                continue;
                            }
                            catch (NumberFormatException nfe) {
                                throw new SNWODPException(SNWODPMessageKeys.ERR_NON_NUMERIC, "Parent Level", entry.getValue());
                            }
                        }
                        if (propName.equals("[DESCRIPTION]")) {
                            member.setDescription(entry.getValue());
                            continue;
                        }
                        if (propName.equals("[MEMBER_UNIQUE_NAME]")) {
                            member.setProperty("SAP_BUSINESS_KEY", (Object)uName);
                            IDimension aDimension = this.mCube.getDimension(dimUName);
                            String sapBusinessKey = SNWODPUtility.getSAPMemberUniqueNameKey(uName);
                            if (aDimension.isTimeDimension() && SNWODPUtility.DateUtils.isDateType(sapBusinessKey)) {
                                member.setProperty("SAP_BUSINESS_KEY", (Object)sapBusinessKey);
                            }
                            StringValue value = DataValueFactory.createStringValue();
                            value.set(sapBusinessKey);
                            member.setBusinessKey((Value)value);
                            continue;
                        }
                        member.setProperty(dimUName + "." + propName, (Object)entry.getValue());
                    }
                }
                member.setRollupType(RollupTypeEnum.ROLLUP);
                member.setType(MemberTypeEnum.UNKNOWN);
                if (name.equals("")) {
                    name = caption;
                }
                this.setLevel(member, dimKey, levelIndex);
                member.setName(name);
                tempCache.put(uName, member);
            }
        }
        catch (JBapiException e) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_GET_AXIS_MEMBERS, e);
        }
        this.memberProperties = null;
        this.dimProperties = null;
        return tempCache;
    }

    private void setLevel(Member member, int dimKey, int levelNo) {
        MetadataConnection connection;
        String memberUName = member.getUniqueName();
        IDimension dim = this.mAxisInfo.getDimension(dimKey);
        String dimUName = dim.getUniqueName();
        IDimension aDimension = this.mCube.getDimension(dimUName);
        if (aDimension == null && dimUName.equals("[Measures]")) {
            return;
        }
        ILevel aLevel = null;
        if (aDimension != null) {
            if (aDimension.isMeasuresDimension()) {
                if (SNWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
                    SNWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "AxisIterator.getNextTuple processing Measure Dimension");
                }
                IHierarchy aHierarchy = aDimension.getDefaultHierarchy();
                aLevel = aHierarchy.getLevel(0);
            } else {
                if (SNWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
                    SNWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "AxisIterator.getNextTuple processing non-Measure Dimension");
                }
                String hierUName = memberUName.substring(0, memberUName.indexOf("].[") + 1);
                String keyDate = this.mSapResultSet.getKeyDate();
                IHierarchy aHierarchy = aDimension.getHierarchy(hierUName, keyDate, null, null);
                aLevel = aHierarchy.getLevel(levelNo);
            }
        }
        if (aLevel != null) {
            member.setLevel(aLevel);
            connection = aLevel.getConnection();
            if (connection == null) {
                connection = this.mCube.getConnection();
            }
        } else {
            throw new SNWODPException(SNWODPMessageKeys.ERR_MEM_LVL_NOT_FOUND, memberUName);
        }
        member.setConnection(connection);
    }

    private Map<String, String> getOptionalProperties(int dimKey, int ordinal) throws SNWODPException {
        Map propertyName;
        HashMap<String, String> properties = null;
        if (this.memberProperties != null && this.dimProperties != null && (propertyName = (Map)this.dimProperties.get(dimKey)) != null) {
            properties = new HashMap<String, String>(propertyName.size());
            for (String key : propertyName.keySet()) {
                String value = this.memberProperties[ordinal].get(key);
                if (value == null) continue;
                properties.put(this.poolString((String)propertyName.get(key)), value);
            }
        }
        return properties;
    }

    private void getOptionalPropertiesKey() throws SNWODPException {
        if (this.dimProperties == null) {
            JBapiTable propertyKeys = this.mSapData.getData(1);
            if (propertyKeys == null) {
                throw new SNWODPException(SNWODPMessageKeys.ERR_TABLE_NOT_FOUND, "OPTION_PRPTYS_KEYS");
            }
            try {
                int rowCount = propertyKeys.getNumRows();
                if (rowCount > 0) {
                    this.dimProperties = new HashMap<Integer, Object>();
                    if (SNWODPLog.isOn("DataQuery", LogLevel.INFO).booleanValue()) {
                        SNWODPLog.getLogger("DataQuery").log(LogLevel.INFO, propertyKeys.traceToString(SNWODPConfig.instance().getMaxTableDumpRows()));
                    }
                    propertyKeys.moveTo(0);
                    HashMap<String, String> propertyNames = new HashMap<String, String>();
                    int dimKey = propertyKeys.getFieldIntByIndex(0);
                    int i = 1;
                    propertyNames.put(propertyKeys.getFieldByIndex(2), this.poolString(propertyKeys.getFieldByIndex(1)));
                    while (i < rowCount) {
                        propertyKeys.moveTo(i);
                        int tempKey = propertyKeys.getFieldIntByIndex(0);
                        if (tempKey == dimKey) {
                            propertyNames.put(propertyKeys.getFieldByIndex(2), this.poolString(propertyKeys.getFieldByIndex(1)));
                            ++i;
                            continue;
                        }
                        this.dimProperties.put(XQEIntegerPool.getInteger((int)dimKey), propertyNames);
                        dimKey = tempKey;
                        propertyNames = new HashMap();
                    }
                    this.dimProperties.put(XQEIntegerPool.getInteger((int)dimKey), propertyNames);
                }
            }
            catch (JBapiException e) {
                throw new SNWODPException(SNWODPMessageKeys.ERR_GET_AXIS_MEM_PROP_KEYS, e);
            }
        }
    }

    private void getOptionalProperties() throws SNWODPException {
        this.getOptionalPropertiesKey();
        if (this.memberProperties == null) {
            JBapiTable properties = this.mSapData.getData(0);
            if (properties == null) {
                throw new SNWODPException(SNWODPMessageKeys.ERR_TABLE_NOT_FOUND, "OPTION_PRPTYS_VALS");
            }
            int rowCount = properties.getNumRows();
            this.memberProperties = new Map[rowCount + 1];
            try {
                if (SNWODPLog.isOn("DataQuery", LogLevel.INFO).booleanValue()) {
                    SNWODPLog.getLogger("DataQuery").log(LogLevel.INFO, properties.traceToString(SNWODPConfig.instance().getMaxTableDumpRows()));
                }
                if (rowCount > 0) {
                    String val;
                    properties.moveTo(0);
                    HashMap<String, String> propertyNames = new HashMap<String, String>();
                    int i = 1;
                    int ordinal = properties.getFieldIntByIndex(0);
                    String key = properties.getFieldByIndex(1);
                    if (null != key && null != (val = properties.getFieldByIndex(2)) && !"".equals(val)) {
                        propertyNames.put(this.poolString(key), val);
                    }
                    while (i < rowCount) {
                        this.checkForCancel();
                        properties.moveTo(i);
                        int tempOrdinal = properties.getFieldIntByIndex(0);
                        if (tempOrdinal == ordinal) {
                            key = properties.getFieldByIndex(1);
                            if (null != key && null != (val = properties.getFieldByIndex(2)) && !"".equals(val)) {
                                propertyNames.put(this.poolString(key), val);
                            }
                            ++i;
                            continue;
                        }
                        this.memberProperties[ordinal] = propertyNames;
                        ordinal = tempOrdinal;
                        propertyNames = new HashMap();
                    }
                    this.memberProperties[ordinal] = propertyNames;
                }
            }
            catch (JBapiException e) {
                throw new SNWODPException(SNWODPMessageKeys.ERR_GET_AXIS_MEM_PROPS, e);
            }
        }
    }

    public synchronized void releaseImpl() {
        if (SNWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
            SNWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "Releasing axis iterator with ID: " + this.id);
        }
        if (this.isReleased) {
            SNWODPLog.getLogger("DataQuery").log(LogLevel.ERROR, "Attempt to Release previously released SNWODPAxisIterator with ID: " + this.id);
            return;
        }
        this.isReleased = true;
        try {
            this.mSapData.release();
        }
        catch (Exception ex) {
            SNWODPLog.getLogger("Exception").log(LogLevel.ERROR, (Throwable)ex);
        }
        finally {
            this.mSapData = null;
        }
        try {
            this.mAxisInfo.release();
        }
        catch (Exception ex) {
            SNWODPLog.getLogger("Exception").log(LogLevel.ERROR, (Throwable)ex);
        }
        finally {
            this.mAxisInfo = null;
        }
        if (this.memberCache != null) {
            this.memberCache.clear();
            this.memberCache = null;
        }
        this.mCube = null;
        this.mSapResultSet = null;
    }
}

