/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.snwodp;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.conn.bapi.JBapiException;
import com.cognos.xqe.conn.bapi.JBapiTable;
import com.cognos.xqe.data.providers.ProviderCellIteratorBase;
import com.cognos.xqe.data.providers.ProviderResultSetBase;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPCell;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPConfig;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPException;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPFormatInfo;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPLog;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPMessageKeys;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPResultSet;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPSAPData;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPUtility;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.TimeValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.format.string.IFormatInfo;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.map.Flat3Map;
import org.apache.commons.collections.map.LRUMap;

public class SNWODPCellIterator
extends ProviderCellIteratorBase {
    private volatile boolean isReleased = false;
    private SNWODPSAPData cellData;
    private boolean hasNext = false;
    private int axisSize = 0;
    private HashMap<Integer, Map<String, Object>> properties = null;
    private SNWODPResultSet sapResultSet;
    private final int id;
    private static final int STRING_POOL_SIZE = 100;
    private LRUMap stringPool = new LRUMap(100);
    private int sapFormatType = 5;

    private String poolString(String string) {
        String pooledString = (String)this.stringPool.get((Object)string);
        if (pooledString != null) {
            return pooledString;
        }
        this.stringPool.put((Object)string, (Object)string);
        return string;
    }

    SNWODPCellIterator(SNWODPResultSet resultSet, XDataContext xDataContext, SNWODPSAPData data, Integer theNodeId, int iterID) {
        super((ProviderResultSetBase)resultSet, xDataContext, theNodeId);
        this.id = iterID;
        this.sapResultSet = resultSet;
        this.cellData = data;
        this.axisSize = this.getAxisSize();
        if (SNWODPLog.isOn("DataQuery", LogLevel.INFO).booleanValue()) {
            SNWODPLog.getLogger("DataQuery").log(LogLevel.INFO, this.getCellDataTable().traceToString(SNWODPConfig.instance().getMaxTableDumpRows()));
        }
        if (this.axisSize > 0) {
            this.hasNext = true;
        }
        if (SNWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
            SNWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "Constructing CellIterator.");
        }
    }

    private void checkForCancel() throws OperationCanceledException {
        this.sapResultSet.checkForCancel();
    }

    private HashMap<Integer, Map<String, Object>> getProperties() {
        HashMap<Integer, Flat3Map> cellProperties = null;
        JBapiTable propTable = this.getPropertyTable();
        try {
            int rowCount;
            if (SNWODPLog.isOn("DataQuery", LogLevel.INFO).booleanValue()) {
                SNWODPLog.getLogger("DataQuery").log(LogLevel.INFO, propTable.traceToString(SNWODPConfig.instance().getMaxTableDumpRows()));
            }
            if ((rowCount = propTable.getNumRows()) > 0) {
                cellProperties = new HashMap<Integer, Flat3Map>(rowCount);
                int i = 0;
                propTable.moveTo(i);
                while (i < rowCount) {
                    int cellOrdinal;
                    int curOrdinal = cellOrdinal = propTable.getFieldIntByIndex(1);
                    Flat3Map propMap = new Flat3Map();
                    while (curOrdinal == cellOrdinal) {
                        this.checkForCancel();
                        propMap.put(this.poolString(propTable.getFieldByIndex(0)), this.poolString(propTable.getFieldByIndex(2)));
                        if (++i >= rowCount) break;
                        propTable.moveTo(i);
                        curOrdinal = propTable.getFieldIntByIndex(1);
                    }
                    cellProperties.put(XQEIntegerPool.getInteger((int)cellOrdinal), propMap);
                }
            }
        }
        catch (JBapiException e) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_GET_CELL_PROPS, e);
        }
        return cellProperties;
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public ICell nextImpl() throws SNWODPException {
        SNWODPCell c = null;
        try {
            if (this.hasNext) {
                if (this.properties == null) {
                    this.properties = this.getProperties();
                }
                JBapiTable table = this.getCellDataTable();
                int nextOrdinal = (int)(this.currentOrdinal + 1L);
                table.moveTo(nextOrdinal);
                String valueStatus = table.getFieldByIndex(9);
                if (!valueStatus.equals("E") && !valueStatus.equals("N")) {
                    c = new SNWODPCell();
                    c.setCellProperty("CELL_STATUS", valueStatus);
                    c.setOrdinal(nextOrdinal);
                    String type = table.getFieldByIndex(3);
                    String currency = table.getFieldByIndex(4);
                    String cellUnit = table.getFieldByIndex(5);
                    String tempScale = table.getFieldByIndex(7);
                    int scale = 0;
                    if (null != tempScale && !"".equals(tempScale)) {
                        scale = Integer.parseInt(tempScale);
                    }
                    this.setProperties(c);
                    IValue value = this.convertValue(c, table, type, currency, cellUnit, scale);
                    c.setCellProperty("UNIT", cellUnit);
                    c.setCellProperty("NUM_SCALE", XQEIntegerPool.getInteger((int)scale));
                    c.setCellProperty("NUM_PREC", table.getFieldByIndex(8));
                    c.setCellProperty("CURRENCY", currency);
                    if (!value.isNull()) {
                        c.setValue(value);
                        String formattedValue = table.getFieldByIndex(2);
                        c.setFormattedValue(formattedValue);
                        c.setCellProperty("NUM_SCALE", tempScale);
                    }
                }
                this.currentOrdinal = nextOrdinal;
                this.hasNext = nextOrdinal + 1 < this.axisSize;
            }
        }
        catch (JBapiException e) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_NEXT_CELL_ERROR, e);
        }
        return c;
    }

    private void setProperties(SNWODPCell cell) {
        if (this.properties != null) {
            cell.setProperties(this.properties.get(XQEIntegerPool.getInteger((int)((int)cell.getOrdinal()))));
        }
    }

    private IValue convertValue(SNWODPCell cell, JBapiTable table, String type, String currency, String cellUnit, int scale) {
        FormatService service;
        String sapFormatString;
        DoubleValue value;
        String currencyCode = null;
        String unitOfMeasure = null;
        try {
            if (type.equals("F")) {
                this.sapFormatType = 0;
                value = DataValueFactory.createDoubleValue();
                value.set(table.getFieldFloatByIndexX(1));
                scale *= -1;
                if (cellUnit.equals("%")) {
                    scale -= 2;
                }
                currencyCode = currency;
                unitOfMeasure = cellUnit;
            } else if (type.equals("I") || type.equals("b") || type.equals("s")) {
                this.sapFormatType = 0;
                value = DataValueFactory.createIntegerValue();
                ((IntegerValue)value).set(table.getFieldIntByIndex(1));
                scale *= -1;
                if (cellUnit.equals("%")) {
                    scale -= 2;
                }
                currencyCode = currency;
                unitOfMeasure = cellUnit;
            } else if (type.equals("T")) {
                this.sapFormatType = 2;
                value = DataValueFactory.createTimeValue();
                ((TimeValue)value).set((IValue)SNWODPUtility.DateUtils.convertSAPTSToTimestampValue(table.getFieldByIndex(1)));
            } else if (type.equals("D")) {
                try {
                    this.sapFormatType = 2;
                    value = DataValueFactory.createDateValue();
                    ((DateValue)value).set((IValue)SNWODPUtility.DateUtils.convertSAPDateToDateValue(table.getFieldByIndex(1)));
                }
                catch (IllegalArgumentException arg) {
                    this.sapFormatType = 0;
                    value = DataValueFactory.createDoubleValue();
                    value.setState(ValueState.ERROR);
                    SNWODPLog.getLogger("Exception").log(LogLevel.WARN, "Invalid date encountered returning error cell instead " + table.getFieldByIndex(1) + " Exception: " + arg);
                }
            } else if (type.equals("g") || type.equals("C") || type.equals("N")) {
                this.sapFormatType = 1;
                value = DataValueFactory.createStringValue();
                ((StringValue)value).set(table.getFieldByIndex(1));
            } else {
                if (SNWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
                    SNWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "CellIterator.convertValue - default (Double) type.");
                }
                this.sapFormatType = 0;
                value = DataValueFactory.createDoubleValue();
                value.setNull();
            }
        }
        catch (JBapiException e) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_CONVERT_CELL_VAL, e);
        }
        if (currency != null && !"".equals(currency)) {
            this.sapFormatType = 3;
        }
        if ((sapFormatString = cell.getFormatString()) != null && !sapFormatString.isEmpty() && !"\"*\"".equals(sapFormatString)) {
            sapFormatString = sapFormatString.replace("\"", "'");
        }
        if (null != (service = FormatService.getInstance())) {
            SNWODPFormatInfo info = new SNWODPFormatInfo(currencyCode, unitOfMeasure, scale, this.sapFormatType, sapFormatString);
            ((Value)value).setFormatId(service.registerSNWODPCellFormat((IFormatInfo)info, this.getFormatLocale()));
        }
        return value;
    }

    private int getAxisSize() {
        JBapiTable table = this.getCellDataTable();
        try {
            return table.getNumRows();
        }
        catch (JBapiException e) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_GET_AXIS_SIZE, e);
        }
    }

    public int getID() {
        return this.id;
    }

    private JBapiTable getPropertyTable() {
        return this.cellData.getData(1);
    }

    private JBapiTable getCellDataTable() {
        return this.cellData.getData(0);
    }

    public synchronized void releaseImpl() {
        if (SNWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
            SNWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "Releasing SNWODPCellIterator with ID: " + this.id);
        }
        if (this.isReleased) {
            SNWODPLog.getLogger("DataQuery").log(LogLevel.ERROR, "Attempt to Release previously released SNWODPCellIterator with ID: " + this.id);
            return;
        }
        this.isReleased = true;
        this.cellData.release();
        this.cellData = null;
        this.sapResultSet = null;
    }
}

