/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.snwodp;

import com.cognos.xqe.data.providers.olap.RestrictionType;

public final class SNWODPConstants {
    public static final String OPEN_DOT_CLOSE_SQUARE_BRACKET = "].[";
    public static final String DOT = ".";
    public static final String COMMA = ",";
    public static final String SPACE = " ";
    public static final String STRING_N = "N";
    public static final String STRING_A = "A";
    public static final String STRING_S = "S";
    public static final String STRING_E = "E";
    public static final String STRING_I = "I";
    public static final String STRING_X = "X";
    public static final String STRING_UNIT = "UNIT";
    public static final String PERCENT = "%";
    public static final String RFC_TRUE = "X";
    public static final String RFC_FALSE = " ";
    public static final String DATASET_ID = "DATASETID";
    public static final String SAP_BUSINESS_KEY = "SAP_BUSINESS_KEY";
    public static final String ALL_PROPS = "A";
    public static final String SELECTED_PROPS = "S";
    public static final String IO_CUBETYPE = "CUBETYPE";
    public static final String MDX_OPEN_SBRACE = "[";
    public static final String MDX_DOT_OPEN_SBRACE = ".[";
    public static final String MDX_KEY_IDENTIFIER = "2";
    public static final String MDX_CLOSE_SBRACE = "]";
    public static final String MDX_FWD_SLASH = "/";
    public static final String MDX_DOLLAR = "$";
    public static final String LETTER_A = "A";
    public static final String LETTER_I = "I";
    public static final String SEMI_COLON = ";";
    public static final String ASTERISK = "*";
    public static final String QUOTED_ASTERISK = "\"*\"";
    public static final String INCLUDE_CONSTRAINT = "I";
    public static final String MEASURES = "Measures";
    public static final String MEASURES_LEVEL = "MeasuresLevel";
    public static final String KEY_FIGURES = "Key Figures";
    public static final String KEY = "Key";
    public static final String EMPTY_STRING = "";
    public static final int SAP_MAX_TDS_RANGES = 16;
    public static final int SAP_MAX_TDS_CARD = 1000000;
    public static final int SAPBAPI_HRY_LDCHK = 9999999;
    public static final String BAPI_DIM_NOT_EXIST_ERROR_CODE = "012";
    public static final String BAPI_ACCESS_DENIED_MEMBER = "520";
    public static final String BAPI_SYS_FAILURE = "RFC_ERROR_SYSTEM_FAILURE";
    public static final String BAPI_GET_CUBE_ERROR_CODE = "201";
    public static final String BAPI_ACCESS_DENIED_ERROR_CODE = "887";
    public static final String BAPI_ABAP_SYSTEM_ERROR_CODE = "299";
    public static final String BAPI_INFOOBJ_ERROR_CODE = "037";
    public static final RestrictionType[] CATALOG_RESTRICTIONS = new RestrictionType[0];
    public static final RestrictionType[] CUBE_RESTRICTIONS = new RestrictionType[]{RestrictionType.CATALOG, RestrictionType.CUBE};
    public static final RestrictionType[] DIMENSION_RESTRICTIONS = new RestrictionType[]{RestrictionType.CUBE, RestrictionType.DIMENSION_UNIQUE_NAME};
    public static final RestrictionType[] HIERARCHY_RESTRICTIONS = new RestrictionType[]{RestrictionType.CUBE, RestrictionType.DIMENSION_UNIQUE_NAME, RestrictionType.HIERARCHY_UNIQUE_NAME};
    public static final RestrictionType[] LEVEL_RESTRICTIONS = new RestrictionType[]{RestrictionType.CUBE, RestrictionType.DIMENSION_UNIQUE_NAME, RestrictionType.HIERARCHY_UNIQUE_NAME, RestrictionType.LEVEL_UNIQUE_NAME};
    public static final RestrictionType[] MEMBER_RESTRICTIONS = new RestrictionType[]{RestrictionType.CUBE, RestrictionType.DIMENSION_UNIQUE_NAME, RestrictionType.HIERARCHY_UNIQUE_NAME, RestrictionType.LEVEL_UNIQUE_NAME, RestrictionType.LEVEL_NUMBER, RestrictionType.MEMBER_UNIQUE_NAME, RestrictionType.MEMBER_TYPE, RestrictionType.TREEOP};
    public static final RestrictionType[] MEASURE_RESTRICTIONS = new RestrictionType[]{RestrictionType.CUBE, RestrictionType.MEASURE_UNIQUE_NAME};
    public static final RestrictionType[] PROPERTY_RESTRICTIONS = new RestrictionType[]{RestrictionType.CUBE, RestrictionType.DIMENSION_UNIQUE_NAME, RestrictionType.HIERARCHY_UNIQUE_NAME, RestrictionType.LEVEL_UNIQUE_NAME, RestrictionType.MEMBER_UNIQUE_NAME, RestrictionType.PROPERTY, RestrictionType.PROPERTY_TYPE};
    public static final RestrictionType[] VARIABLE_RESTRICTIONS = new RestrictionType[]{RestrictionType.CUBE};

    public static final class BapiNames {
        public static final String GET_CATALOGS = "BAPI_MDPROVIDER_GET_CATALOGS";
        public static final String GET_CUBES = "BAPI_MDPROVIDER_GET_CUBES";
        public static final String GET_DIMENSIONS = "BAPI_MDPROVIDER_GET_DIMENSIONS";
        public static final String GET_HIERARCHIES = "BAPI_MDPROVIDER_GET_HIERARCHYS";
        public static final String GET_LEVELS = "BAPI_MDPROVIDER_GET_LEVELS";
        public static final String GET_MEASURES = "BAPI_MDPROVIDER_GET_MEASURES";
        public static final String GET_MEMBERS = "BAPI_MDPROVIDER_GET_MEMBERS";
        public static final String GET_PROPERTIES = "BAPI_MDPROVIDER_GET_PROPERTIES";
        public static final String GET_VARIABLES = "BAPI_MDPROVIDER_GET_VARIABLES";
        public static final String RESOLVE_NAMES = "BAPI_MDPROVIDER_RESOLVE_NAMES";
        public static final String REFRESH = "BAPI_MDPROVIDER_REFRESH";
        public static final String SET_KEY_DATE = "BAPI_MDPROVIDER_SET_KEY_DATE";
        public static final String GET_KEY_DATE = "BAPI_MDPROVIDER_GET_KEY_DATE";
        public static final String CREATE_OBJECT = "BAPI_MDDATASET_CREATE_OBJECT";
        public static final String CHECK_SYNTAX = "BAPI_MDDATASET_CHECK_SYNTAX";
        public static final String SELECT_DATA = "BAPI_MDDATASET_SELECT_DATA";
        public static final String GET_AXIS_INFO = "BAPI_MDDATASET_GET_AXIS_INFO";
        public static final String GET_AXIS_DATA = "BAPI_MDDATASET_GET_AXIS_DATA";
        public static final String GET_CELL_INFO = "BAPI_MDDATASET_GET_CELL_INFO";
        public static final String GET_CELL_DATA = "BAPI_MDDATASET_GET_CELL_DATA";
        public static final String DELETE_OBJECT = "BAPI_MDDATASET_DELETE_OBJECT";
        public static final String FIND_CELL = "BAPI_MDDATASET_FIND_CELL";
        public static final String FIND_TUPLE = "BAPI_MDDATASET_FIND_TUPLE";
        public static final String CUBE_GETDETAIL = "BAPI_CUBE_GETDETAIL";
        public static final String ODSO_GETDETAIL = "BAPI_ODSO_GETDETAIL";
        public static final String ISET_GETDETAIL = "BAPI_ISET_GETDETAIL";
        public static final String IOBJ_GETDETAIL = "BAPI_IOBJ_GETDETAIL";
        public static final String HIER_TD_INFO = "RSNDI_SHIE_CATALOG_GET";
        public static final String HIER_TD_STRUCT = "RSNDI_SHIE_STRUCTURE_GET3";
        public static final String GET_LANGS = "RS_UNI_INSTALLED_LANGU_GET";
        public static final String RSZ_X_VALUES_GET = "RSZ_X_VALUES_GET";
        public static final String USER_CACHE_CLEAR = "RSCR_API_USER_CACHE_CLEAR";
        public static final String RSOB_CREATE_OBJECT = "RSR_MDX_CREATE_OBJECT";
        public static final String RSOB_GET_AXIS_INFO = "RSR_MDX_GET_AXIS_INFO";
        public static final String RSOB_GET_AXIS_DATA = "RSR_MDX_GET_AXIS_DATA";
        public static final String RSOB_GET_CELL_DATA = "RSR_MDX_GET_CELL_DATA";
        public static final String TLS_RUN_ABAP = "RFC_ABAP_INSTALL_AND_RUN";
        public static final String USER_GET_DETAILS = "BAPI_USER_GET_DETAIL";
    }

    public class BapiLogLevel {
        public static final int NONE = 0;
        public static final int FATAL = 1;
        public static final int ERROR = 2;
        public static final int WARN = 3;
        public static final int INFO = 4;
        public static final int DEBUG = 5;
        public static final int ALL = 6;
    }

    public static final class ABAPTypes {
        public static final String INT1 = "b";
        public static final String INT2 = "s";
        public static final String INT = "I";
        public static final String CHAR = "C";
        public static final String NUM_CHAR = "N";
        public static final String STRING = "g";
        public static final String BCDECIMAL = "P";
        public static final String DATE = "D";
        public static final String TIME = "T";
        public static final String FLOAT = "F";
        public static final String BYTE = "X";
        public static final String XSTRING = "y";
        public static final String TABLE = "h";
        public static final String STRUCTURE = "u";
    }

    public static final class BapiTypes {
        public static final int BITMASK_FF = 255;
        public static final int UNDEF = -1;
        public static final int EMPTY = 0;
        public static final int NULL = 1;
        public static final int INT1 = 2;
        public static final int INT2 = 3;
        public static final int INT4 = 4;
        public static final int QUAN = 5;
        public static final int UNIT = 6;
        public static final int CURR = 7;
        public static final int DEC = 8;
        public static final int FLTP = 9;
        public static final int STRG = 10;
        public static final int ACCP = 11;
        public static final int CHAR = 12;
        public static final int CLNT = 13;
        public static final int CUKY = 14;
        public static final int DATS = 15;
        public static final int LANG = 16;
        public static final int LCHR = 17;
        public static final int LRAW = 18;
        public static final int NUMC = 19;
        public static final int PREC = 20;
        public static final int TIMS = 21;
        public static final int RAW = 22;
        public static final int RSTR = 23;
        public static final String STR_UNDEFINED = "UNDEFINED";
        public static final String STR_EMPTY = "EMPTY";
        public static final String STR_NULL = "NULL";
        public static final String STR_INT1 = "INT1";
        public static final String STR_INT2 = "INT2";
        public static final String STR_INT4 = "INT4";
        public static final String STR_QUAN = "QUAN";
        public static final String STR_UNIT = "UNIT";
        public static final String STR_CURR = "CURR";
        public static final String STR_DEC = "DEC";
        public static final String STR_FLTP = "FLTP";
        public static final String STR_STRG = "STRG";
        public static final String STR_ACCP = "ACCP";
        public static final String STR_CHAR = "CHAR";
        public static final String STR_CLNT = "CLNT";
        public static final String STR_CUKY = "CUKY";
        public static final String STR_DATS = "DATS";
        public static final String STR_LANG = "LANG";
        public static final String STR_LCHR = "LCHR";
        public static final String STR_LRAW = "LRAW";
        public static final String STR_NUMC = "NUMC";
        public static final String STR_PREC = "PREC";
        public static final String STR_TIMS = "TIMS";
        public static final String STR_RAW = "RAW";
        public static final String STR_RSTR = "RSTR";

        public static String getTypeName(int typeCode) {
            String result = SNWODPConstants.EMPTY_STRING;
            switch (typeCode &= 0xFF) {
                case -1: {
                    result = STR_UNDEFINED;
                    break;
                }
                case 0: {
                    result = STR_EMPTY;
                    break;
                }
                case 1: {
                    result = STR_NULL;
                    break;
                }
                case 2: {
                    result = STR_INT1;
                    break;
                }
                case 3: {
                    result = STR_INT2;
                    break;
                }
                case 4: {
                    result = STR_INT4;
                    break;
                }
                case 5: {
                    result = STR_QUAN;
                    break;
                }
                case 6: {
                    result = "UNIT";
                    break;
                }
                case 7: {
                    result = STR_CURR;
                    break;
                }
                case 8: {
                    result = STR_DEC;
                    break;
                }
                case 9: {
                    result = STR_FLTP;
                    break;
                }
                case 10: {
                    result = STR_STRG;
                    break;
                }
                case 11: {
                    result = STR_ACCP;
                    break;
                }
                case 12: {
                    result = STR_CHAR;
                    break;
                }
                case 13: {
                    result = STR_CLNT;
                    break;
                }
                case 14: {
                    result = STR_CUKY;
                    break;
                }
                case 15: {
                    result = STR_DATS;
                    break;
                }
                case 16: {
                    result = STR_LANG;
                    break;
                }
                case 17: {
                    result = STR_LCHR;
                    break;
                }
                case 18: {
                    result = STR_LRAW;
                    break;
                }
                case 19: {
                    result = STR_NUMC;
                    break;
                }
                case 20: {
                    result = STR_PREC;
                    break;
                }
                case 21: {
                    result = STR_TIMS;
                    break;
                }
                case 22: {
                    result = STR_RAW;
                    break;
                }
                case 23: {
                    result = STR_RSTR;
                    break;
                }
                default: {
                    result = "Unknown Type Code";
                }
            }
            return result;
        }
    }

    public static final class BapiTables {
        public static final String SELECTED_PROPERTIES = "SELECTED_PROPERTIES";
        public static final String COMMAND_TEXT = "COMMAND_TEXT";
        public static final String OPTIONAL_PROPERTIES = "OPTIONAL_PROPERTIES";
        public static final String AXIS_INFO = "AXIS_INFO";
        public static final String AXIS_DIMENSIONS = "AXIS_DIMENSIONS";
        public static final String AXIS_LEVELS = "AXIS_LEVELS";
        public static final String DIM_PRPTYS = "DIM_PRPTYS";
        public static final String FLTCOL_INFO = "FLTCOLINFO";
        public static final String MNDTRY_PRPTYS = "MNDTRY_PRPTYS";
        public static final String OPTION_PRPTYS_KEYS = "OPTION_PRPTYS_KEYS";
        public static final String OPTION_PRPTYS_VALS = "OPTION_PRPTYS_VALS";
        public static final String CELL_DATA = "CELL_DATA";
        public static final String CELL_PROPS = "CELL_PROPS";
        public static final String CATALOGS = "CATALOGS";
        public static final String CUBES = "CUBES";
        public static final String DIMENSIONS = "DIMENSIONS";
        public static final String MEASURES = "MEASURES";
        public static final String MEMBERS = "MEMBERS";
        public static final String AGGREXCEPT = "AGGR_EXCEPTIONAL";
        public static final String VARIABLES = "VARIABLES";
        public static final String HIERARCHIES = "HIERARCHIES";
        public static final String LEVELS = "LEVELS";
        public static final String PROPERTIES = "PROPERTIES";
        public static final String RESTRICTIONS = "RESTRICTIONS";
        public static final String INFOOBJECTS = "INFOOBJECTS";
        public static final String DIM_INFOOBJECTS = "DIMENSIONINFOOBJECTS";
        public static final String FIELDOBJECTS = "FIELDOBJECTS";
        public static final String TABLEOBJECTS = "TABLEOBJECTS";
        public static final String HIER_DIR = "E_T_HIEDIR";
        public static final String LOCALES = "E_T_LANGU";
        public static final String PARAMS = "I_T_PARAMS";
        public static final String VALUES = "E_T_VALUES";
        public static final String HIERSTRUC = "E_T_HIERSTRUC";
        public static final String WRITES = "WRITES";
        public static final String PROGRAM = "PROGRAM";
        public static final String PROFILES = "PROFILES";
    }

    public static final class BapiParams {
        public static final String KEY_DATE = "KEY_DATE";
        public static final String ZERO_KEY_DATE = "00000000";
        public static final String MIN_KEY_DATE = "10000101";
        public static final String MAX_KEY_DATE = "99991231";
        public static final String CATALOG_NAM = "CAT_NAM";
        public static final String CUBE_NAM = "CUBE_NAM";
        public static final String CUBE_TYPE = "CUBE_TYPE";
        public static final String CREATED_DATE = "CREATED_ON";
        public static final String LAST_SCHEMA_UPD = "LST_SCHEMA_UPD";
        public static final String LAST_DATA_UPD = "LST_DATA_UPD";
        public static final String DIM_NAM = "DIM_NAM";
        public static final String DIM_UNAM = "DIM_UNAM";
        public static final String DIM_TYPE = "DIM_TYPE";
        public static final String DIM_KEY = "DIM_KEY";
        public static final String DIM_ORDINAL = "DIM_ORDINAL";
        public static final String DIM_CAPTION = "DIM_CAP";
        public static final String DIM_CARDINALITY = "DIM_CARDINALITY";
        public static final String TYPE = "TYPE";
        public static final String MSG = "MESSAGE";
        public static final String DFLT_HRY = "DFLT_HRY";
        public static final String INFOCUBE = "INFOCUBE";
        public static final String OBJVERS = "OBJVERS";
        public static final String VERSION = "VERSION";
        public static final String DETAILS = "DETAILS";
        public static final String INFOOBJECT = "INFOOBJECT";
        public static final String IO_CUBETYPE = "CUBETYPE";
        public static final String IS_NAV_ATTR = "ATRNAVFL";
        public static final String ODSOBJECT = "ODSOBJECT";
        public static final String INFOSET = "INFOSET";
        public static final String IOBJTP = "IOBJTP";
        public static final String INTIOBJNM = "INTIOBJNM";
        public static final String TALIAS = "TALIAS";
        public static final String MES_NAM = "MES_NAM";
        public static final String MES_UNAM = "MES_UNAM";
        public static final String MES_CAP = "MES_CAP";
        public static final String MES_UNITS = "MES_UNITS";
        public static final String MES_AGGREGATOR = "MES_AGGREGATOR";
        public static final String AGGR_EXCEPTIONAL = "MES_AGGR_EXCEPTIONAL";
        public static final String MES_AGGR_REF_DIM = "MES_AGGR_REF_DIM";
        public static final String DFLT_MEM = "DFLT_MEM";
        public static final String ALL_MEM = "ALL_MEM";
        public static final String ONLY_STRUCTS = "ONLY_STRUCTURES";
        public static final String HRY_NAM = "HRY_NAM";
        public static final String HRY_UNAM = "HRY_UNAM";
        public static final String HRY_CAPTION = "HRY_CAP";
        public static final String HRY_UID = "HRY_UID";
        public static final String HRY_CARDINALITY = "HRY_CARDINALITY";
        public static final String LVL_NAM = "LVL_NAM";
        public static final String LVL_UNAM = "LVL_UNAM";
        public static final String LVL_TYPE = "LVL_TYPE";
        public static final String LVL_NUM = "LVL_NUMBER";
        public static final String LVL_CARDINALITY = "LVL_CARDINALITY";
        public static final String LVL_CAPTION = "LVL_CAP";
        public static final String MEM_NAM = "MEM_NAM";
        public static final String MEM_UNAM = "MEM_UNAM";
        public static final String MEM_CAPTION = "MEM_CAP";
        public static final String MEM_ORDINAL = "MEM_ORDINAL";
        public static final String MEM_TYPE = "MEM_TYPE";
        public static final String MEM_CHILDREN = "CHILDREN";
        public static final String PARENT_UNAM = "PARENT_UNAM";
        public static final String PARENT_LEVEL = "PARENT_LVL";
        public static final String TREEOP = "TREEOP";
        public static final String START_ROW = "START_ROW";
        public static final String END_ROW = "END_ROW";
        public static final String ALL_PROPS = "ALL_PROPERTIES";
        public static final String DESC = "DSCRPTN";
        public static final String PRPTY_NAM = "PRPTY_NAM";
        public static final String PRPTY_TYPE = "PRPTY_TYPE";
        public static final String PRPTY_VAL = "PRPTY_VAL";
        public static final String PRPTY_VALUE = "PRPTY_VALUE";
        public static final String PRPTY_KEY = "PRPTY_KEY";
        public static final String PRPTY_CAP = "PRPTY_CAP";
        public static final String OPTION_PRPTYS_KEYS = "OPTION_PRPTYS_KEYS";
        public static final String OPTION_PRPTYS_VALS = "OPTION_PRPTYS_VALS";
        public static final String TUPLE_ORDINAL = "TUPLE_ORDINAL";
        public static final String AXIS = "AXIS";
        public static final String CELL = "CELL";
        public static final String START_TUPLE = "START_TUPLE";
        public static final String END_TUPLE = "END_TUPLE";
        public static final String START_CELL = "START_CELL";
        public static final String END_CELL = "END_CELL";
        public static final String START_ORDINAL = "START_ORDINAL";
        public static final String CELL_ORDINAL = "CELL_ORDINAL";
        public static final String CELL_VALUE = "VALUE";
        public static final String CELL_FORMATTED_VALUE = "FORMATTED_VALUE";
        public static final String CELL_CURRENCY = "CURRENCY";
        public static final String CELL_VALUE_TYPE = "VALUE_TYPE";
        public static final String CELL_UNIT = "UNIT";
        public static final String NUM_SCALE = "NUM_SCALE";
        public static final String NUM_PREC = "NUM_PREC";
        public static final String CELL_STATUS = "CELL_STATUS";
        public static final String CELL_BACK_COLOR = "BACK_COLOR";
        public static final String CELL_PRPTY_NAM = "PRPTY_NAM";
        public static final String CELL_PRPTY_VALUE = "PRPTY_VALUE";
        public static final String CELL_FORMAT_STRING = "FORMAT_STRING";
        public static final String CELL_FORMAT_VALUE = "FORMAT_VALUE";
        public static final String CELL_LANGUAGE = "LANGUAGE";
        public static final String TUPLE = "TUPLE";
        public static final String MEMBER_NAME = "[MEMBER_NAME]";
        public static final String MDX_PARENT_NAME = "[MEMBER_NAME]";
        public static final String MDX_PARENT_UNIQUE_NAME = "[PARENT_UNIQUE_NAME]";
        public static final String MDX_PARENT_LEVEL = "[PARENT_LEVEL]";
        public static final String MDX_DESCRIPTION = "[DESCRIPTION]";
        public static final String MDX_UNIQUE_NAME = "[MEMBER_UNIQUE_NAME]";
        public static final String DATATP = "DATATP";
        public static final String TXTTIMFL = "TXTTIMFL";
        public static final String TXTTAB = "TXTTAB";
        public static final String DIMENSION = "DIMENSION";
        public static final String TEXTLONG = "TEXTLONG";
        public static final String HIEID = "HIEID";
        public static final String HIENM = "HIENM";
        public static final String DATETO = "DATETO";
        public static final String DATEFROM = "DATEFROM";
        public static final String I_OBJVERS = "I_OBJVERS";
        public static final String I_IOBJNM = "I_IOBJNM";
        public static final String I_LANGU = "I_LANGU";
        public static final String IOBJNM = "IOBJNM";
        public static final String I_S_HIEKEY = "I_S_HIEKEY";
        public static final String I_NO_NODENM_TABLE = "I_NO_NODENM_TABLE";
        public static final String I_S_HIESEL = "I_S_HIESEL";
        public static final String I_S_SUBTREESEL = "I_S_SUBTREESEL";
        public static final String I_T_NODENAME = "I_T_NODENAME";
        public static final String VAR_NAM = "VAR_NAM";
        public static final String VAR_CAP = "VAR_CAP";
        public static final String VAR_UID = "VAR_UID";
        public static final String VAR_DFLT_LOW = "DFLT_LOW";
        public static final String VAR_DFLT_HIGH = "DFLT_HIGH";
        public static final String VAR_DFLT_LOW_CAP = "DFLT_LOW_CAP";
        public static final String VAR_DFLT_HIGH_CAP = "DFLT_HIGH_CAP";
        public static final String VAR_REF_DIM = "REF_DIM";
        public static final String VAR_REF_HRY = "REF_HRY";
        public static final String VAR_TYPE = "VAR_TYPE";
        public static final String DATA_TYPE = "DATA_TYPE";
        public static final String VAR_SELC_TYPE = "VAR_SELC_TYPE";
        public static final String VAR_ENTRY_TYPE = "VAR_ENTRY_TYPE";
        public static final String LA_ISO = "LAISO";
        public static final String NUMBER = "NUMBER";
        public static final String MODE = "MODE";
        public static final String PROGRAMNAME = "PROGRAMNAME";
        public static final String ERRORMESSAGE = "ERRORMESSAGE";
        public static final String LINE = "LINE";
        public static final String USERNAME = "USERNAME";
        public static final String BAPIPROF = "BAPIPROF";
        public static final String BAPIAKTPS = "BAPIAKTPS";
        public static final String BAPITYPE = "BAPITYPE";
        public static final String SIGN = "SIGN";
        public static final String OPTION = "OPTION";
        public static final String LOW = "LOW";
        public static final String HIGH = "HIGH";
        public static final int ERROR_GROUP = 101;
    }

    public static final class TreeOps {
        public static final int CHILDREN = 1;
        public static final int SIBLINGS = 2;
        public static final int PARENT = 4;
        public static final int SELF = 8;
        public static final int DESCENDANTS = 16;
        public static final int ANCESTORS = 32;
    }

    public final class CubeTypes {
        public static final String UNKNOWN = "Unknown Cube Type";
        public static final String AGGREGATE = "Aggregate Cube";
        public static final String BASIC = "Basic Cube";
        public static final String REMOTE = "Remote Cube";
        public static final String MULTI = "Multi-Provider";
        public static final String VIRTUAL = "Virtual Cube";
        public static final String ODS = "Operational Data Store Item";
        public static final String ISET = "Infoset";
        public static final String INFOOBJECT = "Infoobject";
    }

    public final class CellTables {
        public static final int CELL_DATA = 0;
        public static final int CELL_PROPS = 1;
    }

    public final class AxisDataTables {
        public static final int OPTION_PRPTYS_VALS = 0;
        public static final int OPTION_PRPTYS_KEYS = 1;
        public static final String STR_OPTION_PRPTYS_KEYS = "OPTION_PRPTYS_KEYS";
        public static final String STR_OPTION_PRPTYS_VALS = "OPTION_PRPTYS_VALS";
        public static final int MNDTRY_PRPTYS = 2;
    }

    public final class AxisInfoTables {
        public static final int AXIS_INFO = 0;
        public static final int AXIS_DIMENSIONS = 1;
        public static final int AXIS_LEVELS = 2;
        public static final int DIM_PRPTYS = 3;
        public static final int FLTCOLINFO = 4;
    }

    public static final class AxisDimensionFields {
        public static final int AXIS = 0;
        public static final int DIM = 1;
        public static final int KEY = 2;
    }

    public static final class AxisInfoFields {
        public static final int NUM = 0;
        public static final int DIMS = 1;
        public static final int COORD = 2;
    }

    public static final class BapiIndex {
        public static final int PRPTY_NM_IDX = 0;
        public static final int LINE_IDX = 0;
        public static final int OPT_PRP_MEM_ORD_IDX = 0;
        public static final int OPT_PRP_NM_IDX = 1;
        public static final int OPT_PRP_VAL_IDX = 2;
        public static final int AXIS_IDX = 0;
        public static final int DIMS_IDX = 1;
        public static final int COORD_IDX = 2;
        public static final int AXIS_DIM_UNAM_IDX = 1;
        public static final int AXIS_DIM_KEY_IDX = 2;
        public static final int AXIS_DIM_PRP_CNT_IDX = 3;
        public static final int I_AXIS_IDX = 0;
        public static final int AXIS_LVL_DIM_KEY_IDX = 1;
        public static final int LVL_KEY_IDX = 2;
        public static final int DIM_PRP_LVL_UNAM_IDX = 3;
        public static final int DIM_PRP_LVL_KEY_IDX = 0;
        public static final int DIM_PRP_PRP_NM_IDX = 1;
        public static final int DATA_TPYE_IDX = 2;
        public static final int CHR_MAX_LEN_IDX = 3;
        public static final int COL_ORD_IDX = 0;
        public static final int FLTCOL_DATA_TYPE_IDX = 1;
        public static final int FLTCOL_CHR_MAX_LEN_IDX = 2;
        public static final int TPL_ORD_IDX = 0;
        public static final int MND_PRP_DIM_KEY_IDX = 1;
        public static final int MND_PRP_MEM_UNAM_IDX = 2;
        public static final int MND_PRP_MEM_CAP_IDX = 3;
        public static final int MND_PRP_LVL_UNAM_IDX = 4;
        public static final int MND_PRP_LVL_NUM_IDX = 5;
        public static final int CHLDRN_IDX = 6;
        public static final int DRLD_DOWN_IDX = 7;
        public static final int SAME_PARENT_IDX = 8;
        public static final int OPT_PRP_KEY_DIM_KEY_IDX = 0;
        public static final int OPT_PRP_KEY_PRP_NAM_IDX = 1;
        public static final int OPT_PRP_KEY_PRP_KEY_IDX = 2;
        public static final int OPT_PRP_NAM_TPL_ORD_IDX = 0;
        public static final int OPT_PRP_NAM_PRP_KEY_IDX = 1;
        public static final int OPT_PRP_NAM_PRP_VAL_IDX = 2;
        public static final int CELL_ORD_IDX = 0;
        public static final int VAL_IDX = 1;
        public static final int FMTD_VAL_IDX = 2;
        public static final int VAL_TYPE_IDX = 3;
        public static final int CRNCY_IDX = 4;
        public static final int UNIT_IDX = 5;
        public static final int MKWZ_IDX = 6;
        public static final int NUM_SCALE_IDX = 7;
        public static final int NUM_PREC_IDX = 8;
        public static final int CELL_STAT_IDX = 9;
        public static final int BACK_COL_IDX = 10;
        public static final int CELL_PRP_PRP_NAM_IDX = 0;
        public static final int CELL_PRP_CELL_ORD_IDX = 1;
        public static final int CELL_PRP_PRP_VAL_IDX = 2;
        public static final int CAT_NAM_IDX = 0;
        public static final int CUBE_NAM_IDX = 1;
        public static final int CUBE_TYP_IDX = 2;
        public static final int CUBE_UID_IDX = 3;
        public static final int CREATED_ON_IDX = 4;
        public static final int LST_SCHEMA_UPD_IDX = 5;
        public static final int SCHEMA_UPD_BY_IDX = 6;
        public static final int LST_DATA_UPD_IDX = 7;
        public static final int DATA_UPD_BY_IDX = 8;
        public static final int CB_DSCRPTN_IDX = 9;
        public static final int DIM_NAM_IDX = 2;
        public static final int DIM_DIM_UNAM_IDX = 3;
        public static final int DIM_UID_IDX = 4;
        public static final int DIM_CAP_IDX = 5;
        public static final int DIM_ORD_IDX = 6;
        public static final int DIM_TYPE_IDX = 7;
        public static final int DIM_CARD_IDX = 8;
        public static final int DFLT_HRY_IDX = 9;
        public static final int DIM_DSCRPTN_IDX = 10;
        public static final int MSR_NAM_IDX = 2;
        public static final int MSR_UNAM_IDX = 3;
        public static final int MSR_CAP_IDX = 4;
        public static final int MSR_UID_IDX = 5;
        public static final int MSR_AGGR_IDX = 6;
        public static final int MSR_DATA_TYPE_IDX = 7;
        public static final int MSR_NUM_PREC_IDX = 8;
        public static final int MSR_NUM_SCALE_IDX = 9;
        public static final int MSR_UNITS_IDX = 10;
        public static final int MSR_DSCRPTN_IDX = 11;
        public static final int MEM_LVL_NUM_IDX = 0;
        public static final int MEM_NAM_IDX = 1;
        public static final int MEM_UNAM_IDX = 2;
        public static final int MEM_TYPE_IDX = 3;
        public static final int MEM_UID_IDX = 4;
        public static final int MEM_CAP_IDX = 5;
        public static final int MEM_ORD_IDX = 6;
        public static final int CHILDREN_IDX = 7;
        public static final int PARENT_LVL_IDX = 8;
        public static final int PARENT_UNAM_IDX = 9;
        public static final int MEM_DSCRPTN_IDX = 10;
        public static final int AGGR_MES_UNAM_IDX = 2;
        public static final int AGGR_IDX = 3;
        public static final int AGGR_EXCP_IDX = 4;
        public static final int AGGR_REF_DIM_IDX = 5;
        public static final int VAR_NAM_IDX = 2;
        public static final int VAR_CAP_IDX = 3;
        public static final int VAR_UID_IDX = 4;
        public static final int VAR_ORD_IDX = 5;
        public static final int VAR_TYPE_IDX = 6;
        public static final int VAR_DATA_TYPE_IDX = 7;
        public static final int VAR_CHR_MAX_LEN_IDX = 8;
        public static final int PROC_TYPE_IDX = 9;
        public static final int SEL_TYPE_IDX = 10;
        public static final int ENT_TYPE_IDX = 11;
        public static final int VAR_REF_DIM_IDX = 12;
        public static final int REF_HRY_IDX = 13;
        public static final int DFLT_LO_IDX = 14;
        public static final int DFLT_HI_IDX = 15;
        public static final int DFLT_LO_CAP_IDX = 16;
        public static final int DFLT_HI_CAP_IDX = 17;
        public static final int VAR_DSCRPTN_IDX = 18;
        public static final int DIM_UNAM_IDX = 2;
        public static final int HRY_NAM_IDX = 3;
        public static final int HRY_HRY_UNAM_IDX = 4;
        public static final int HRY_UID_IDX = 5;
        public static final int HRY_CAP_IDX = 6;
        public static final int HRY_DIM_TYPE_IDX = 7;
        public static final int HRY_CARD_IDX = 8;
        public static final int DFLT_MEM_IDX = 9;
        public static final int ALL_MEM_IDX = 10;
        public static final int HRY_DSCRPTN_IDX = 11;
        public static final int HRY_UNAM_IDX = 3;
        public static final int LVL_NAM_IDX = 4;
        public static final int LVL_UNAM_IDX = 5;
        public static final int LVL_UID_IDX = 6;
        public static final int LVL_CAP_IDX = 7;
        public static final int LVL_NUM_IDX = 8;
        public static final int LVL_CARD_IDX = 9;
        public static final int LVL_TYPE_IDX = 10;
        public static final int LVL_DSCRPTN_IDX = 11;
        public static final int PRP_LVL_UNAM_IDX = 4;
        public static final int PRP_MEM_UNAM_IDX = 5;
        public static final int PRP_TYPE_IDX = 6;
        public static final int PRP_NAM_IDX = 7;
        public static final int PRP_CAP_IDX = 8;
        public static final int PRP_DATA_TYPE_IDX = 9;
        public static final int PRP_CHR_MAX_LEN_IDX = 10;
        public static final int PRP_CHR_OCT_LEN_IDX = 11;
        public static final int PRP_NUM_PREC_IDX = 12;
        public static final int PRP_NUM_SCALE_IDX = 13;
        public static final int PRP_DSCRPTN_IDX = 14;
        public static final int RSTRCTN_PRP_NAM_IDX = 0;
        public static final int SIGN_IDX = 0;
        public static final int OPTION_IDX = 0;
        public static final int LO_IDX = 3;
        public static final int HI_IDX = 4;
        public static final int INFOCUBE_IDX = 0;
        public static final int OBJVERS_IDX = 1;
        public static final int POSIT_IDX = 2;
        public static final int INFOOBJECT_IDX = 3;
        public static final int IOBJTP_IDX = 4;
        public static final int ATRNAVFL_IDX = 5;
        public static final int DIMIO_DIM_IDX = 2;
        public static final int DIMIO_POSIT_IDX = 3;
        public static final int DIMIO_INFOOBJECT_IDX = 4;
        public static final int DIM_DIM_IDX = 2;
        public static final int DIM_TXT_LNG_IDX = 3;
        public static final int DIM_IOBJ_TYP_IDX = 4;
        public static final int LANGU_IDX = 0;
        public static final int HIEID_IDX = 1;
        public static final int ETHD_OBJVERS_IDX = 2;
        public static final int TXTSH_IDX = 3;
        public static final int TXTMD_IDX = 4;
        public static final int TXTLG_IDX = 5;
        public static final int CHANM_IDX = 0;
        public static final int DATE_IDX = 1;
        public static final int READ_ATR_IDX = 2;
        public static final int ONLY_AUTH_IDX = 3;
        public static final int ONLY_FACTS_IDX = 4;
        public static final int ONLY_IC_IDX = 5;
        public static final int ITP_INFOCUBE_IDX = 6;
        public static final int HANDLE_IDX = 7;
        public static final int CONTEXT_IDX = 8;
        public static final int CHAVL_IDX = 0;
        public static final int CHAVL_EXT_IDX = 1;
        public static final int CHAVL_NC_IDX = 2;
        public static final int TEXT_IDX = 3;
        public static final int ICONID_IDX = 4;
        public static final int CHAVL_EXT_NC_IDX = 5;
        public static final int NODEID_IDX = 6;
        public static final int E_T_HS_HIEID_IDX = 0;
        public static final int E_T_HS_OBJVERS_IDX = 1;
        public static final int E_T_HS_NODEID_IDX = 2;
        public static final int E_T_HS_IOBJNM_IDX = 3;
        public static final int NODENAME_IDX = 4;
        public static final int TLVL_IDX = 5;
        public static final int LINK_IDX = 6;
        public static final int PARENTID_IDX = 7;
        public static final int CHILDID_IDX = 8;
        public static final int NEXTID_IDX = 9;
        public static final int DATEFROM_IDX = 10;
        public static final int DATETO_IDX = 11;
        public static final int INTERVL_IDX = 12;
        public static final int ZEILE_IDX = 0;
        public static final int BAPIPROF_IDX = 0;
        public static final int BAPIPTXT_IDX = 1;
        public static final int BAPITYPE_IDX = 2;
        public static final int BAPIAKTPS_IDX = 3;
    }

    public static final class SAPCubeTypes {
        public static final String AGGREGATE = "A";
        public static final String BASIC = "B";
        public static final String REMOTE = "R";
        public static final String MULTIPROVIDER = "M";
        public static final String VIRTUAL = "V";
    }

    public static final class DimensionTypes {
        public static final int KEY_FIGURE_STRUCT_CD = 0;
        public static final String KEY_FIGURE_STRUCT_STR = "0";
        public static final int TIME_CD = 1;
        public static final String TIME_STR = "1";
        public static final int MEASURE_CD = 2;
        public static final String MEASURE_STR = "2";
        public static final int REGULAR_CD = 3;
        public static final String REGULAR_STR = "3";
        public static final int CHARACTER_STRUCT = 4;
        public static final String CHARACTER_STRUCT_STR = "4";
        public static final String SAPTIME_STR = "SAPTime";
        public static final String DATE = "DAT";
        public static final String TIME = "TIM";
        public static final String NUM = "NUM";
        public static final String CHAR = "CHA";
    }

    public static final class VariableTypes {
        public static final int MEMBER = 1;
        public static final int NUMERIC = 2;
        public static final int HIERARCHY = 3;
        public static final int SELECTION_TYPE_VALUE = 1;
        public static final int SELECTION_TYPE_INTERVAL = 2;
        public static final int SELECTION_TYPE_COMPLEX = 3;
        public static final int SELECTION_TYPE_MULTI_SINGLES = 4;
        public static final int ENTRY_TYPE_OPTIONAL = 0;
        public static final int ENTRY_TYPE_MANDATORY = 1;
        public static final int ENTRY_TYPE_MANDATORY_NOT_DEFAULT = 2;
    }

    public static final class AggregateTypes {
        public static final int UNKNOWN = 0;
        public static final int SUM = 1;
        public static final int COUNT = 2;
        public static final int MIN = 3;
        public static final int MAX = 4;
        public static final int AVG = 5;
        public static final int VAR = 6;
        public static final int STDDEV = 7;
        public static final int AVG_NON_ZERO = 8;
        public static final int AVG_CALENDAR_DAYS = 9;
        public static final int AVG_PERIOD = 10;
        public static final int COUNT_NON_ZERO = 11;
        public static final int FIRST = 12;
        public static final int LAST = 13;
        public static final int NOP = 14;
        public static final int CALC = 127;
    }

    public static final class ValueFormatTypes {
        public static final int NUMERIC = 0;
        public static final int STRING = 1;
        public static final int DATE = 2;
        public static final int CURRENCY = 3;
        public static final int PERCENT = 4;
        public static final int UNKNOWN = 5;
    }

    public static final class CellValueStatus {
        public static final String EMPTY = "E";
        public static final String NULL = "N";
    }
}

