/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.snwodp;

import com.cognos.xqe.conn.bapi.JBapiConnect;
import com.cognos.xqe.conn.bapi.JBapiException;
import com.cognos.xqe.conn.bapi.JBapiFunction;
import com.cognos.xqe.conn.bapi.JBapiTable;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPConfig;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPConnection;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPException;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPFunctionHandler;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPLog;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPMessageKeys;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPSAPData;
import com.cognos.xqe.trace.LogLevel;

public class SNWODPDataHandler
extends SNWODPFunctionHandler {
    private static final int MAX_MDX_LINE_LEN = 75;
    private static final String CONSTRUCTOR_MSG = "Constructing SNWODPDataHandler for BAPI:";
    private Object dataSetID = null;

    public SNWODPDataHandler(SNWODPConnection connection, JBapiConnect client, String functionName) throws SNWODPException, LogonFailureException {
        super(connection, functionName);
        if (SNWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
            SNWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, CONSTRUCTOR_MSG + functionName);
        }
    }

    public SNWODPDataHandler(SNWODPConnection connection, JBapiFunction function) throws SNWODPException, LogonFailureException {
        super(connection, function);
        if (SNWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
            SNWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, CONSTRUCTOR_MSG + function.getFunctionName());
        }
    }

    public void setDataSetID(Object dataID) throws SNWODPException {
        this.checkForCancel();
        try {
            this.setImportParameter("DATASETID", dataID);
        }
        catch (JBapiException e) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_SET_DATASET_ID, e);
        }
        this.dataSetID = dataID;
    }

    public void setAxisDataParams(Object dataID, int axis, int iStartTuple, int iEndTuple) throws SNWODPException {
        this.setDataSetID(dataID);
        this.setImportParameter("AXIS", axis);
        this.setImportParameter("START_TUPLE", iStartTuple);
        this.setImportParameter("END_TUPLE", iEndTuple);
    }

    public void setCellDataParams(Object dataID, int iStartCell, int iEndCell) throws SNWODPException {
        this.setDataSetID(dataID);
        this.setImportParameter("START_CELL", iStartCell);
        this.setImportParameter("END_CELL", iEndCell);
    }

    public void clearAxisInfoTables() throws SNWODPException {
        this.clearTable("AXIS_INFO");
        this.clearTable("AXIS_DIMENSIONS");
        this.clearTable("AXIS_LEVELS");
        this.clearTable("DIM_PRPTYS");
        this.clearTable("FLTCOLINFO");
    }

    public void clearAxisDataTables() throws SNWODPException {
        this.clearTable("MNDTRY_PRPTYS");
        this.clearTable("OPTION_PRPTYS_KEYS");
        this.clearTable("OPTION_PRPTYS_VALS");
    }

    public void clearCellTables() throws SNWODPException {
        this.clearTable("CELL_DATA");
        this.clearTable("CELL_PROPS");
    }

    public void extractDataSetID() throws SNWODPException {
        this.checkForCancel();
        try {
            this.dataSetID = this.mFunction.getParam("DATASETID");
        }
        catch (JBapiException e) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_GET_DATASET_ID_FAILED, e);
        }
    }

    public Object getDataSetID() {
        return this.dataSetID;
    }

    public void createObject(String sMDX) throws SNWODPException {
        JBapiTable mdxTab = null;
        String mdxPart = null;
        int nStart = 0;
        int nEnd = 75;
        int nLast = sMDX.length();
        if (SNWODPConfig.instance().getServerCacheReset() == 2) {
            this.clearSAPUserCache();
        }
        if ((mdxTab = this.getTable("COMMAND_TEXT")) == null) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_TABLE_NOT_FOUND, "COMMAND_TEXT");
        }
        try {
            mdxTab.clearContent();
            while (nStart < nLast) {
                this.checkForCancel();
                mdxTab.appendRow();
                mdxPart = sMDX.substring(nStart, nEnd);
                if (mdxPart.length() > 0) {
                    mdxTab.setFieldByIndex(0, mdxPart);
                }
                nStart = nEnd;
                if ((nEnd += 75) <= nLast) continue;
                nEnd = nLast;
            }
        }
        catch (JBapiException e) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_SET_MDX_TEXT, e);
        }
        finally {
            mdxTab.release();
        }
    }

    public SNWODPSAPData getAxisTables(SNWODPSAPData sapData) throws SNWODPException {
        this.checkForCancel();
        sapData.setData(0, this.getTable("AXIS_INFO"));
        sapData.setData(1, this.getTable("AXIS_DIMENSIONS"));
        sapData.setData(2, this.getTable("AXIS_LEVELS"));
        sapData.setData(3, this.getTable("DIM_PRPTYS"));
        sapData.setData(4, this.getTable("FLTCOLINFO"));
        return sapData;
    }

    public SNWODPSAPData getCellTables(SNWODPSAPData sapData) throws SNWODPException {
        this.checkForCancel();
        sapData.setData(0, this.getTable("CELL_DATA"));
        sapData.setData(1, this.getTable("CELL_PROPS"));
        return sapData;
    }

    public SNWODPSAPData getAxisDataTables(SNWODPSAPData sapData) throws SNWODPException {
        this.checkForCancel();
        sapData.setData(2, this.getTable("MNDTRY_PRPTYS"));
        sapData.setData(1, this.getTable("OPTION_PRPTYS_KEYS"));
        sapData.setData(0, this.getTable("OPTION_PRPTYS_VALS"));
        return sapData;
    }
}

