/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.snwodp;

import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.model.ICombinedSignon;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.model.IDelegatedCredentialSignon;
import com.cognos.xqe.data.model.ITicketSignon;
import com.cognos.xqe.data.model.IUsernamePasswordSignon;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.ConnectionTestQueryArguments;
import com.cognos.xqe.data.providers.QueryArguments;
import com.cognos.xqe.data.providers.connection.ConnectionFactoryStatisticsDecorator;
import com.cognos.xqe.data.providers.connection.ConnectionFactoryTimeoutDecorator;
import com.cognos.xqe.data.providers.connection.ConnectionStringParser;
import com.cognos.xqe.data.providers.connection.parameters.DataSourceParameter;
import com.cognos.xqe.data.providers.connection.parameters.JAASSubjectParameter;
import com.cognos.xqe.data.providers.connection.parameters.PasswordParameter;
import com.cognos.xqe.data.providers.connection.parameters.ProviderTypeParameter;
import com.cognos.xqe.data.providers.connection.parameters.UserIDParameter;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.MDXQueryArguments;
import com.cognos.xqe.data.providers.olap.MetadataQueryArguments;
import com.cognos.xqe.data.providers.olap.OLAPDataProviderBase;
import com.cognos.xqe.data.providers.olap.TracingOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.snwodp.ClientParameter;
import com.cognos.xqe.data.providers.olap.snwodp.CodePageParameter;
import com.cognos.xqe.data.providers.olap.snwodp.LogonGroupParameter;
import com.cognos.xqe.data.providers.olap.snwodp.RouteParameter;
import com.cognos.xqe.data.providers.olap.snwodp.RunLocaleParameter;
import com.cognos.xqe.data.providers.olap.snwodp.SAPServerParameter;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPConnection;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPConnectionSelector;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPException;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPGlobal;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPLog;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPMDXHandler;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPMetadataProvider;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPResultSet;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPSSOCache;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPUtility;
import com.cognos.xqe.data.providers.olap.snwodp.SSOTicketParameter;
import com.cognos.xqe.data.providers.olap.snwodp.ServerTypeParameter;
import com.cognos.xqe.data.providers.olap.snwodp.SystemIDParameter;
import com.cognos.xqe.data.providers.olap.snwodp.SystemNumberParameter;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionFactory;
import com.cognos.xqe.pool.connection.IConnectionParameter;
import com.cognos.xqe.pool.connection.IConnectionSelector;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.sapbw.LOLAPSAPCube;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.LocaleConverter;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

public class SNWODPDataProvider
extends OLAPDataProviderBase {
    final SNWODPConnectionFactory mSNWODPConnectionFactory;
    final IConnectionFactory mConnectionFactory;
    final SNWODPGlobal mGlobal = SNWODPGlobal.getInstance();

    public SNWODPDataProvider(String instanceName, Properties properties) {
        super(instanceName, properties, (IConnectionSelector)new SNWODPConnectionSelector());
        SNWODPGlobal.writeBAPILog(4, "SNWODPDataProvider", "Initialize SAP Provider - Run 1");
        this.mSNWODPConnectionFactory = new SNWODPConnectionFactory();
        this.mConnectionFactory = ConnectionFactoryTimeoutDecorator.decorateIfNecessary((IConnectionFactory)new ConnectionFactoryStatisticsDecorator((IConnectionFactory)this.mSNWODPConnectionFactory, instanceName), (Properties)this.getProperties());
        if (SNWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
            SNWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "Constructing SNWODPDataProvider");
        }
    }

    public IConnectionFactory getConnectionFactory() {
        return this.mConnectionFactory;
    }

    public IPooledConnection borrowConnection(ConnectionParameters connectionParameters, IExecutionEnvironment executionEnvironment) {
        return executionEnvironment.getConnectionPool().borrowConnection(this.getProviderInstanceName(), connectionParameters, this.selector, this.mConnectionFactory);
    }

    public ICubeResultSet query(XDataContext xDataContext, MDXQueryArguments theQueryArgument) throws SNWODPException, LogonFailureException {
        SNWODPMDXHandler mdxHandler = null;
        try {
            if (SNWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
                SNWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "SNWODPDataProvider.query called");
            }
            ExecutionEnvironment environment = (ExecutionEnvironment)xDataContext.getEnvironment();
            Integer nodeId = xDataContext.getNodeId();
            MetricsService.startCollectingMetric((RequestEnvironment)((RequestEnvironment)environment.getRequestEnvironment()), (String)"executeMDXPopulateHResult");
            MDXQuery mdxQuery = theQueryArgument.getMDXQuery();
            String mdxString = mdxQuery.getMDX();
            ICube cube = mdxQuery.getReferencedCube();
            String effectiveDate = cube instanceof LOLAPSAPCube ? ((LOLAPSAPCube)cube).getKeyDate() : theQueryArgument.getKeyDate();
            effectiveDate = effectiveDate != null ? SNWODPUtility.DateUtils.convertDateToSAPDateFormat(effectiveDate) : SNWODPUtility.DateUtils.getLocalDateInSAPFormat();
            ConnectionParameters parameters = this.createConnectionParameters((IExecutionEnvironment)environment, theQueryArgument);
            IPooledConnection pooledConnection = this.borrowConnection(parameters, (IExecutionEnvironment)environment);
            ((SNWODPConnection)((Object)pooledConnection.getConnection())).setActiveDataQuery(true);
            mdxHandler = new SNWODPMDXHandler(pooledConnection, theQueryArgument, mdxString, nodeId, environment.getCancelManager());
            SNWODPResultSet ret = mdxHandler.executeMDX(this, xDataContext, effectiveDate);
            MetricsService.endCollectingMetric((RequestEnvironment)((RequestEnvironment)environment.getRequestEnvironment()), (String)"executeMDXPopulateHResult");
            return ret;
        }
        catch (SNWODPException se) {
            if (mdxHandler != null) {
                mdxHandler.release();
            }
            throw se;
        }
        catch (LogonFailureException e) {
            if (mdxHandler != null) {
                mdxHandler.release();
            }
            throw e;
        }
        catch (RuntimeException rte) {
            if (mdxHandler != null) {
                mdxHandler.release();
            }
            throw rte;
        }
    }

    public ConnectionParameters createConnectionParameters(IExecutionEnvironment env, MDXQueryArguments queryArgs) {
        return this.createConnectionParams(env, (QueryArguments)queryArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<XQEMessage> testConnection(ConnectionTestQueryArguments theQueryArguments) {
        List<XQEMessage> connectionDetails = null;
        SNWODPConnection connection = null;
        try {
            connection = (SNWODPConnection)((Object)this.mSNWODPConnectionFactory.createConnection(this.createConnectionParams(theQueryArguments.getExecutionEnvironment(), (QueryArguments)theQueryArguments)));
            connectionDetails = connection.getConnectionDetails();
        }
        catch (Throwable throwable) {
            this.mSNWODPConnectionFactory.destroyConnection(connection);
            throw throwable;
        }
        this.mSNWODPConnectionFactory.destroyConnection(connection);
        return connectionDetails;
    }

    protected ConnectionParameters createConnectionParams(IExecutionEnvironment executionEnvironment, QueryArguments theQueryArguments) {
        if (SNWODPLog.isOn("Function", LogLevel.TRACE).booleanValue()) {
            SNWODPLog.getLogger("Function").log(LogLevel.TRACE, "SNWODPDataProvider.createConnectionParams called");
        }
        IDataSource dataSource = theQueryArguments.getDataSource();
        IDataSourceConnection connection = dataSource.getDataSourceConnection();
        String connectionString = connection.getConnectionString(null);
        final ConnectionParameters parameters = new ConnectionParameters();
        ConnectionStringParser.parse((String)connectionString, (ConnectionStringParser.TokenHandler)new ConnectionStringParser.TokenHandler(){

            public void onKeyValueToken(String key, String value) {
                if (key.equalsIgnoreCase("serverType")) {
                    parameters.put((IConnectionParameter)new ServerTypeParameter(value));
                } else if (key.equalsIgnoreCase("server") || key.equalsIgnoreCase("Data Source")) {
                    parameters.put((IConnectionParameter)new SAPServerParameter(value));
                } else if (key.equalsIgnoreCase("sysid")) {
                    parameters.put((IConnectionParameter)new SystemIDParameter(value));
                } else if (key.equalsIgnoreCase("sysnr")) {
                    parameters.put((IConnectionParameter)new SystemNumberParameter(value));
                } else if (key.equalsIgnoreCase("logonGroup")) {
                    parameters.put((IConnectionParameter)new LogonGroupParameter(value));
                } else if (key.equalsIgnoreCase("client")) {
                    parameters.put((IConnectionParameter)new ClientParameter(value));
                } else if (key.equalsIgnoreCase("codePage")) {
                    parameters.put((IConnectionParameter)new CodePageParameter(value));
                } else if (key.equalsIgnoreCase("routerString")) {
                    parameters.put((IConnectionParameter)new RouteParameter(value));
                }
            }

            public void onSimpleToken(String value) {
            }
        });
        parameters.put((IConnectionParameter)new DataSourceParameter(dataSource));
        parameters.put((IConnectionParameter)new ProviderTypeParameter(dataSource.getType()));
        if (theQueryArguments instanceof MetadataQueryArguments) {
            parameters.put((IConnectionParameter)new RunLocaleParameter(LocaleConverter.toString((Locale)theQueryArguments.getDesignLocale())));
        } else {
            parameters.put((IConnectionParameter)new RunLocaleParameter(LocaleConverter.toString((Locale)theQueryArguments.getRunLocale())));
        }
        IDataSourceConnectionSignon signon = connection.getSignon();
        RequestEnvironment reqEnv = (RequestEnvironment)executionEnvironment.getRequestEnvironment();
        if (null != signon && signon.getType() == IDataSourceConnectionSignon.SignonType.USERNAME_PASSWORD) {
            IUsernamePasswordSignon userPwdSignon = (IUsernamePasswordSignon)signon;
            parameters.put((IConnectionParameter)new UserIDParameter(userPwdSignon.getUserName()));
            parameters.put((IConnectionParameter)new PasswordParameter(userPwdSignon.getPassword()));
        } else if (null != signon && signon.getType() == IDataSourceConnectionSignon.SignonType.COMBINED) {
            IDataSourceConnectionSignon[] signons;
            parameters.put((IConnectionParameter)new UserIDParameter(((ICombinedSignon)signon).getUserID()));
            for (IDataSourceConnectionSignon currentSignon : signons = ((ICombinedSignon)signon).getSignons()) {
                String ticket;
                if (null == currentSignon || currentSignon.getType() != IDataSourceConnectionSignon.SignonType.TICKET || null == (ticket = ((ITicketSignon)currentSignon).getTicket()) || ticket.length() <= 0) continue;
                parameters.put((IConnectionParameter)new SSOTicketParameter(ticket));
            }
        } else if (null != signon && signon.getType() == IDataSourceConnectionSignon.SignonType.TICKET) {
            String ticket = ((ITicketSignon)signon).getTicket();
            if (null != ticket && ticket.length() > 0) {
                parameters.put((IConnectionParameter)new SSOTicketParameter(ticket));
            }
        } else if (null != signon && signon.getType() == IDataSourceConnectionSignon.SignonType.JAASSUBJECT) {
            IDelegatedCredentialSignon jaasSignon = (IDelegatedCredentialSignon)signon;
            parameters.put((IConnectionParameter)new JAASSubjectParameter(jaasSignon.getDelegatedCredential().getSubject()));
        } else {
            String ticket = reqEnv.getSAPLogonTicket();
            if (ticket != null && ticket.length() > 0) {
                parameters.put((IConnectionParameter)new SSOTicketParameter(ticket));
                if (null != signon && signon.getType() == IDataSourceConnectionSignon.SignonType.USERNAME_PASSWORD) {
                    IUsernamePasswordSignon userPwdSignon = (IUsernamePasswordSignon)signon;
                    parameters.put((IConnectionParameter)new UserIDParameter(userPwdSignon.getUserName()));
                }
            }
        }
        return parameters;
    }

    public IOLAPMetadataProvider getMetadataProvider(MetadataQueryArguments theQueryArguments) throws LogonFailureException, SNWODPException {
        if (SNWODPLog.isOn("Metadata", LogLevel.TRACE).booleanValue()) {
            SNWODPLog.getLogger("Metadata").log(LogLevel.TRACE, "SNWODPDataProvider.getMetadataProvider called");
        }
        ConnectionParameters parameters = this.createConnectionParams(theQueryArguments.getExecutionEnvironment(), (QueryArguments)theQueryArguments);
        IExecutionEnvironment executionEnvironment = theQueryArguments.getExecutionEnvironment();
        Locale locale = executionEnvironment.getRequestEnvironment().getRunLocale();
        SNWODPMetadataProvider provider = new SNWODPMetadataProvider(this, parameters, locale);
        provider = new TracingOLAPMetadataProvider((IOLAPMetadataProvider)provider, "SNWODP");
        return provider;
    }

    public void releaseImpl() {
        SNWODPSSOCache.releaseInstance();
        if (SNWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
            SNWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "releasing SNWODPDataProvider");
        }
        this.mGlobal.releaseBAPINW();
    }

    private class SNWODPConnectionFactory
    implements IConnectionFactory {
        private SNWODPConnectionFactory() {
        }

        public Object createConnection(ConnectionParameters connectionParameters) {
            SNWODPConnection connection = null;
            try {
                if (SNWODPLog.isOn("Connection", LogLevel.TRACE).booleanValue()) {
                    SNWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SNWODPDataProvider.createConnection: attempting to create a connection.");
                }
                connection = new SNWODPConnection((IOLAPDataProvider)SNWODPDataProvider.this, connectionParameters);
            }
            catch (LogonFailureException e) {
                DataSourceParameter param = (DataSourceParameter)connectionParameters.get(DataSourceParameter.class);
                if (param != null) {
                    IDataSource ds = param.getDataSource();
                    IDataSourceConnection dsConnection = ds.getDataSourceConnection();
                    dsConnection.invalidateResolvedSignon();
                    if (e.getDataSource() == null) {
                        e.setDataSource(ds);
                    }
                }
                throw e;
            }
            finally {
                if (null == connection) {
                    if (SNWODPLog.isOn("Connection", LogLevel.TRACE).booleanValue()) {
                        SNWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SNWODPDataProvider.createConnection: FAILED");
                    }
                } else {
                    List<XQEMessage> blackList;
                    if (SNWODPLog.isOn("Connection", LogLevel.TRACE).booleanValue()) {
                        SNWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SNWODPDataProvider.createConnection: OK SAPKernelVersion: " + connection.getSAPKernelVersion() + " SAPSystemVersion: " + connection.getSAPSystemVersion());
                    }
                    if (!(blackList = connection.getConnectionBlackListDetails()).isEmpty()) {
                        this.destroyConnection(connection);
                        connection = null;
                        XQEMessage message = blackList.get(0);
                        if (XQEMessageKeys.DS_DriverBlacklistedTestConnectionUI == message.getMessageKey()) {
                            if (SNWODPLog.isOn("Connection", LogLevel.ERROR).booleanValue()) {
                                SNWODPLog.getLogger("Connection").log(LogLevel.ERROR, "SNWODPDataProvider.createConnection: The driver version " + message.getParams()[0] + " is black listed.");
                            }
                            throw new XQERuntimeException(XQEMessageKeys.DS_DriverBlacklistedTestConnectionUI, message.getParams()[0], message.getParams()[1]);
                        }
                        if (XQEMessageKeys.DS_ServerBlacklistedTestConnectionUI2 == message.getMessageKey()) {
                            if (SNWODPLog.isOn("Connection", LogLevel.ERROR).booleanValue()) {
                                SNWODPLog.getLogger("Connection").log(LogLevel.ERROR, "SNWODPDataProvider.createConnection: The server version " + message.getParams()[1] + "  is black listed.");
                            }
                            throw new XQERuntimeException(XQEMessageKeys.DS_ServerBlacklistedTestConnectionUI2, message.getParams()[0], message.getParams()[1]);
                        }
                        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL);
                    }
                }
            }
            return connection;
        }

        public void destroyConnection(IPooledConnection pooledConnection) {
            this.destroyConnection((SNWODPConnection)((Object)pooledConnection.getConnection()));
        }

        private void destroyConnection(SNWODPConnection connection) {
            if (null == connection) {
                if (SNWODPLog.isOn("Connection", LogLevel.TRACE).booleanValue()) {
                    SNWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SNWODPDataProvider.destroyConnection: There is no connection to destroy.");
                }
            } else {
                try {
                    if (SNWODPLog.isOn("Connection", LogLevel.TRACE).booleanValue()) {
                        SNWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SNWODPDataProvider.destroyConnection: OK");
                    }
                    connection.disconnect();
                }
                catch (SNWODPException e) {
                    SNWODPLog.getLogger("Exception").log(LogLevel.ERROR, "Error Destroying Connection: ", (Throwable)((Object)e));
                }
            }
        }
    }
}

