/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.snwodp;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.conn.bapi.JBapiException;
import com.cognos.xqe.conn.bapi.JBapiStructure;
import com.cognos.xqe.conn.bapi.JBapiTable;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPConnection;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPException;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPInfoObjDetails;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPLog;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPMetadataHandler;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPMetadataProvider;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPUtility;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.trace.LogLevel;
import java.util.TreeMap;

public final class SNWODPInfoObjectCache {
    private TreeMap<SNWODPInfoObjectKey, Object> cubeMD = new TreeMap();
    private static SNWODPInfoObjectCache theCache = null;
    private SNWODPMetadataProvider provider;
    private static final Object LOCK = new Object();
    private static final String STR_NOT_FOUND = "Not Found";
    private static final String BAPI_EXCP_CUBE_DETAIL = "BAPI Exception while executing getCubeDetails: ";
    private static final String SNWODP_EXCP_CUBE_DETAIL = "Exception while executing getCubeDetails: ";
    private static final String LOGON_EXCP_CUBE_DETAIL = "Logon Failure while executing getCubeDetails: ";
    private static final String BAPI_EXCP_ODSO_DETAIL = "BAPI Exception while executing getODSObjectDetails: ";
    private static final String SNWODP_EXCP_ODSO_DETAIL = "Exception while executing getODSObjectDetails: ";
    private static final String LOGON_EXCP_ODSO_DETAIL = "Logon Failure while executing getODSObjectDetails: ";
    private static final String BAPI_EXCP_ISET_DETAIL = "BAPI Exception while executing getInfoSetDetails: ";
    private static final String SNWODP_EXCP_ISET_DETAIL = "Exception while executing getInfoSetDetails: ";
    private static final String LOGON_EXCP_ISET_DETAIL = "Logon Failure while executing getInfoSetDetails: ";
    public static final String DATA_PACKET_ATTRIBUTE = "DPA";
    private static final String BAPI_EXCP_IOBJ_DETAIL = "BAPI Exception while executing getIOBJDetails: ";
    private static final String SNWODP_EXCP_IOBJ_DETAIL = "Exception while executing getIOBJDetails: ";
    private static final String LOGON_EXCP_IOBJ_DETAIL = "Logon Failure while executing getIOBJDetails: ";
    public static final String ATTRIBUTES = "ATTRIBUTES";
    public static final String ATTRINM = "ATTRINM";
    private static final String BAPI_IOBJ_GETDETAIL = "BAPI_IOBJ_GETDETAIL";
    private static final String BAPI_ISET_GETDETAIL = "BAPI_ISET_GETDETAIL";
    private static final String BAPI_ODSO_GETDETAIL = "BAPI_ODSO_GETDETAIL";
    private static final String BAPI_CUBE_GETDETAIL = "BAPI_CUBE_GETDETAIL";

    private SNWODPInfoObjectCache(SNWODPMetadataProvider mdProvider) {
        this.provider = mdProvider;
        SNWODPLog.getLogger("Metadata").log(LogLevel.TRACE, "Initializing SNWODPInfoObjectCache");
    }

    public static SNWODPInfoObjectCache getInstance(SNWODPMetadataProvider mdProvider) {
        if (null == theCache) {
            theCache = new SNWODPInfoObjectCache(mdProvider);
        }
        return theCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SNWODPInfoObjDetails getDimensionDetails(SNWODPConnection connection, String systemKey, String cubeName, String dimName, ExecutionEnvironment executionEnvironment) {
        if (!this.getCubeType(connection, systemKey, cubeName = SNWODPUtility.SNWODPNameUtils.extractCubeName(cubeName), executionEnvironment).equals("Infoset")) {
            dimName = SNWODPUtility.SNWODPNameUtils.extractIObjFromNavAttrName(dimName);
        }
        String language = ((RequestEnvironment)executionEnvironment.getRequestEnvironment()).getRunLocale().getLanguage().toUpperCase();
        SNWODPInfoObjectKey srchKey = new SNWODPInfoObjectKey(systemKey, cubeName, language);
        Object object = LOCK;
        synchronized (object) {
            Object o = this.cubeMD.get(srchKey);
            if (null == o && this.loadCubeAndDimMetadata(connection, srchKey, executionEnvironment)) {
                o = this.cubeMD.get(srchKey);
            }
            if (o != null && o instanceof SNWODPInfoObjectItem) {
                SNWODPInfoObjDetails infoObjDetail;
                TreeMap<String, SNWODPInfoObjDetails> map = ((SNWODPInfoObjectItem)o).getInfoObjectMap();
                if (map == null) {
                    map = new TreeMap();
                }
                if ((infoObjDetail = map.get(dimName)) == null) {
                    this.loadDimensionMetadata(connection, srchKey, dimName, map, executionEnvironment);
                    infoObjDetail = map.get(dimName);
                }
                if (infoObjDetail != null) {
                    ((SNWODPInfoObjectItem)o).setInfoObjectMap(map);
                    return infoObjDetail;
                }
                SNWODPLog.getLogger("Metadata").log(LogLevel.TRACE, "Could not find Dimension Data: " + dimName + " from Cached Cube: " + cubeName);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCubeType(SNWODPConnection connection, String systemKey, String cubeName, ExecutionEnvironment executionEnvironment) {
        String language = ((RequestEnvironment)executionEnvironment.getRequestEnvironment()).getRunLocale().getLanguage().toUpperCase();
        SNWODPInfoObjectKey srchKey = new SNWODPInfoObjectKey(systemKey, cubeName, language);
        Object object = LOCK;
        synchronized (object) {
            Object o = this.cubeMD.get(srchKey);
            if (null == o) {
                String type = this.loadCubeType(connection, srchKey, executionEnvironment);
                if (type.equals("Unknown Cube Type")) {
                    this.cubeMD.put(srchKey, STR_NOT_FOUND);
                } else {
                    this.cubeMD.put(srchKey, new SNWODPInfoObjectItem(type, null));
                }
                return type;
            }
            if (o instanceof SNWODPInfoObjectItem) {
                return ((SNWODPInfoObjectItem)o).getCubeType();
            }
        }
        return "Unknown Cube Type";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadCubeType(SNWODPConnection connection, SNWODPInfoObjectKey srchKey, ExecutionEnvironment executionEnvironment) {
        SNWODPMetadataHandler fnh = null;
        JBapiTable infoObj = null;
        JBapiTable odso = null;
        JBapiTable fObj = null;
        JBapiTable attrib = null;
        JBapiStructure details = null;
        try {
            fnh = new SNWODPMetadataHandler(this.provider, connection, BAPI_CUBE_GETDETAIL);
            this.provider.addCancelListener(fnh, executionEnvironment);
            fnh.setImportParameter("INFOCUBE", srchKey.getName());
            fnh.setImportParameter("OBJVERS", "A");
            fnh.executeFunctionNoCheck();
            infoObj = fnh.getTable("INFOOBJECTS");
            if (infoObj.getNumRows() > 0) {
                details = fnh.getExportStructure("DETAILS");
                String sapType = details.getField("CUBETYPE");
                if (sapType.equals("A")) {
                    String string = "Aggregate Cube";
                    return string;
                }
                if (sapType.equals("B")) {
                    String string = "Basic Cube";
                    return string;
                }
                if (sapType.equals("R")) {
                    String string = "Remote Cube";
                    return string;
                }
                if (sapType.equals("M")) {
                    String string = "Multi-Provider";
                    return string;
                }
                if (sapType.equals("V")) {
                    String string = "Virtual Cube";
                    return string;
                }
                String string = "Unknown Cube Type";
                return string;
            }
        }
        catch (JBapiException be) {
            SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, BAPI_EXCP_CUBE_DETAIL, (Throwable)be);
            String string = "Unknown Cube Type";
            return string;
        }
        catch (SNWODPException e) {
            SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, SNWODP_EXCP_CUBE_DETAIL, (Throwable)((Object)e));
            String string = "Unknown Cube Type";
            return string;
        }
        catch (LogonFailureException lfe) {
            SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, LOGON_EXCP_CUBE_DETAIL, (Throwable)lfe);
            String string = "Unknown Cube Type";
            return string;
        }
        finally {
            if (details != null) {
                details.release();
            }
            if (infoObj != null) {
                infoObj.release();
            }
            if (fnh != null) {
                this.provider.removeCancelListener(fnh, executionEnvironment);
                fnh.release();
                fnh = null;
            }
        }
        try {
            fnh = new SNWODPMetadataHandler(this.provider, connection, BAPI_ODSO_GETDETAIL);
            this.provider.addCancelListener(fnh, executionEnvironment);
            fnh.setImportParameter("ODSOBJECT", srchKey.getName());
            fnh.setImportParameter("OBJVERS", "A");
            fnh.executeFunctionNoCheck();
            odso = fnh.getTable("INFOOBJECTS");
            if (odso.getNumRows() > 0) {
                String lfe = "Operational Data Store Item";
                return lfe;
            }
        }
        catch (JBapiException be) {
            SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, BAPI_EXCP_ODSO_DETAIL, (Throwable)be);
            String string = "Unknown Cube Type";
            return string;
        }
        catch (SNWODPException e) {
            SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, SNWODP_EXCP_ODSO_DETAIL, (Throwable)((Object)e));
            String string = "Unknown Cube Type";
            return string;
        }
        catch (LogonFailureException lfe) {
            SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, LOGON_EXCP_ODSO_DETAIL, (Throwable)lfe);
            String string = "Unknown Cube Type";
            return string;
        }
        finally {
            if (odso != null) {
                odso.release();
            }
            if (fnh != null) {
                this.provider.removeCancelListener(fnh, executionEnvironment);
                fnh.release();
                fnh = null;
            }
        }
        try {
            fnh = new SNWODPMetadataHandler(this.provider, connection, BAPI_ISET_GETDETAIL);
            this.provider.addCancelListener(fnh, executionEnvironment);
            fnh.setImportParameter("INFOSET", srchKey.getName());
            fnh.setImportParameter("OBJVERS", "A");
            fnh.executeFunctionNoCheck();
            fObj = fnh.getTable("FIELDOBJECTS");
            if (fObj.getNumRows() > 0) {
                String lfe = "Infoset";
                return lfe;
            }
        }
        catch (JBapiException be) {
            SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, BAPI_EXCP_ISET_DETAIL, (Throwable)be);
            String string = "Unknown Cube Type";
            return string;
        }
        catch (SNWODPException e) {
            SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, SNWODP_EXCP_ISET_DETAIL, (Throwable)((Object)e));
            String string = "Unknown Cube Type";
            return string;
        }
        catch (LogonFailureException lfe) {
            SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, LOGON_EXCP_ISET_DETAIL, (Throwable)lfe);
            String string = "Unknown Cube Type";
            return string;
        }
        finally {
            if (fObj != null) {
                fObj.release();
            }
            if (fnh != null) {
                this.provider.removeCancelListener(fnh, executionEnvironment);
                fnh.release();
                fnh = null;
            }
        }
        try {
            fnh = new SNWODPMetadataHandler(this.provider, connection, BAPI_IOBJ_GETDETAIL);
            this.provider.addCancelListener(fnh, executionEnvironment);
            fnh.setImportParameter("INFOOBJECT", srchKey.getName());
            fnh.setImportParameter("VERSION", "A");
            fnh.executeFunctionNoCheck();
            attrib = fnh.getTable(ATTRIBUTES);
            if (attrib.getNumRows() > 0) {
                String lfe = "Infoobject";
                return lfe;
            }
        }
        catch (JBapiException be) {
            SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, BAPI_EXCP_IOBJ_DETAIL, (Throwable)be);
            String string = "Unknown Cube Type";
            return string;
        }
        catch (SNWODPException e) {
            SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, SNWODP_EXCP_IOBJ_DETAIL, (Throwable)((Object)e));
            String string = "Unknown Cube Type";
            return string;
        }
        catch (LogonFailureException lfe) {
            SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, LOGON_EXCP_IOBJ_DETAIL, (Throwable)lfe);
            String string = "Unknown Cube Type";
            return string;
        }
        finally {
            if (attrib != null) {
                attrib.release();
            }
            if (fnh != null) {
                this.provider.removeCancelListener(fnh, executionEnvironment);
                fnh.release();
            }
        }
        return "Unknown Cube Type";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadCubeAndDimMetadata(SNWODPConnection connection, SNWODPInfoObjectKey srchKey, ExecutionEnvironment executionEnvironment) {
        int rowCount;
        SNWODPInfoObjDetails data = null;
        SNWODPMetadataHandler fnh = null;
        JBapiTable infoObj = null;
        JBapiTable dio = null;
        JBapiTable dims = null;
        JBapiTable odso = null;
        JBapiTable iobj = null;
        JBapiTable fObj = null;
        JBapiTable tObj = null;
        JBapiStructure details = null;
        String cubeType = "Unknown Cube Type";
        TreeMap<String, SNWODPInfoObjDetails> map = new TreeMap<String, SNWODPInfoObjDetails>();
        boolean found = false;
        boolean abort = false;
        if (SNWODPLog.isOn("Metadata", LogLevel.TRACE).booleanValue()) {
            SNWODPLog.getLogger("Metadata").log(LogLevel.TRACE, "Loading cube and dimension metadata");
        }
        try {
            fnh = new SNWODPMetadataHandler(this.provider, connection, BAPI_CUBE_GETDETAIL);
            this.provider.addCancelListener(fnh, executionEnvironment);
            fnh.setImportParameter("INFOCUBE", srchKey.getName());
            fnh.setImportParameter("OBJVERS", "A");
            fnh.executeFunctionNoCheck();
            infoObj = fnh.getTable("INFOOBJECTS");
            dio = fnh.getTable("DIMENSIONINFOOBJECTS");
            dims = fnh.getTable("DIMENSIONS");
            rowCount = infoObj.getNumRows();
            for (int ioIdx = 0; ioIdx < rowCount; ++ioIdx) {
                String ioName = "";
                String dimName = "";
                String dimText = "";
                data = new SNWODPInfoObjDetails();
                infoObj.moveTo(ioIdx);
                ioName = infoObj.getFieldByIndex(3);
                if (infoObj.getFieldByIndex(5).equals("X")) {
                    ioName = SNWODPUtility.SNWODPNameUtils.extractIObjFromNavAttrName(ioName);
                }
                int rowCount2 = dio.getNumRows();
                for (int dioIdx = 0; dioIdx < rowCount2; ++dioIdx) {
                    dio.moveTo(dioIdx);
                    String dioName = dio.getFieldByIndex(4);
                    if (!ioName.equals(dioName) && !ioName.equals(SNWODPUtility.SNWODPNameUtils.extractIObjFromNavAttrName(dioName))) continue;
                    dimName = dio.getFieldByIndex(2);
                    break;
                }
                data.setName(ioName);
                if (!dimName.equals("")) {
                    rowCount2 = dims.getNumRows();
                    for (int dIdx = 0; dIdx < rowCount2; ++dIdx) {
                        dims.moveTo(dIdx);
                        if (!dimName.equals(dims.getFieldByIndex(2))) continue;
                        dimText = dims.getFieldByIndex(3);
                        data.setOlapType(dims.getFieldByIndex(4));
                        break;
                    }
                }
                data.setDimGroup(dimName);
                data.setDimGroupDescription(dimText);
                found = true;
                if (this.setInfoObjectDetails(map, data, connection, executionEnvironment)) continue;
                abort = true;
                break;
            }
            SNWODPInfoObjectItem item = null;
            if (found) {
                details = fnh.getExportStructure("DETAILS");
                String sapType = details.getField("CUBETYPE");
                if (sapType.equals("A")) {
                    cubeType = "Aggregate Cube";
                } else if (sapType.equals("B")) {
                    cubeType = "Basic Cube";
                } else if (sapType.equals("R")) {
                    cubeType = "Remote Cube";
                } else if (sapType.equals("M")) {
                    cubeType = "Multi-Provider";
                } else if (sapType.equals("V")) {
                    cubeType = "Virtual Cube";
                }
                item = abort ? new SNWODPInfoObjectItem(cubeType, new TreeMap<String, SNWODPInfoObjDetails>()) : new SNWODPInfoObjectItem(cubeType, map);
                this.cubeMD.put(srchKey, item);
                boolean dimName = true;
                return dimName;
            }
        }
        catch (JBapiException be) {
            SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, BAPI_EXCP_CUBE_DETAIL, (Throwable)be);
        }
        catch (SNWODPException e) {
            SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, SNWODP_EXCP_CUBE_DETAIL, (Throwable)((Object)e));
        }
        catch (LogonFailureException lfe) {
            SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, LOGON_EXCP_CUBE_DETAIL, (Throwable)lfe);
        }
        finally {
            if (infoObj != null) {
                infoObj.release();
            }
            if (dio != null) {
                dio.release();
            }
            if (dims != null) {
                dims.release();
            }
            if (details != null) {
                details.release();
            }
            if (fnh != null) {
                this.provider.removeCancelListener(fnh, executionEnvironment);
                fnh.release();
            }
        }
        try {
            found = false;
            fnh = new SNWODPMetadataHandler(this.provider, connection, BAPI_ODSO_GETDETAIL);
            this.provider.addCancelListener(fnh, executionEnvironment);
            fnh.setImportParameter("ODSOBJECT", srchKey.getName());
            fnh.setImportParameter("OBJVERS", "A");
            fnh.executeFunctionNoCheck();
            odso = fnh.getTable("INFOOBJECTS");
            rowCount = odso.getNumRows();
            for (int odsIdx = 0; odsIdx < rowCount; ++odsIdx) {
                odso.moveTo(odsIdx);
                data = new SNWODPInfoObjDetails();
                data.setName(odso.getField("INFOOBJECT"));
                found = true;
                if (this.setInfoObjectDetails(map, data, connection, executionEnvironment)) continue;
                abort = true;
                break;
            }
            if (found) {
                SNWODPInfoObjectItem item = null;
                item = abort ? new SNWODPInfoObjectItem("Operational Data Store Item", new TreeMap<String, SNWODPInfoObjDetails>()) : new SNWODPInfoObjectItem("Operational Data Store Item", map);
                this.cubeMD.put(srchKey, item);
                boolean sapType = true;
                return sapType;
            }
        }
        catch (JBapiException be) {
            SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, BAPI_EXCP_ODSO_DETAIL, (Throwable)be);
        }
        catch (SNWODPException e) {
            SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, SNWODP_EXCP_ODSO_DETAIL, (Throwable)((Object)e));
        }
        catch (LogonFailureException lfe) {
            SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, LOGON_EXCP_ODSO_DETAIL, (Throwable)lfe);
        }
        finally {
            if (odso != null) {
                odso.release();
            }
            if (fnh != null) {
                this.provider.removeCancelListener(fnh, executionEnvironment);
                fnh.release();
            }
        }
        try {
            found = false;
            fnh = new SNWODPMetadataHandler(this.provider, connection, BAPI_ISET_GETDETAIL);
            this.provider.addCancelListener(fnh, executionEnvironment);
            fnh.setImportParameter("INFOSET", srchKey.getName());
            fnh.setImportParameter("OBJVERS", "A");
            fnh.executeFunctionNoCheck();
            fObj = fnh.getTable("FIELDOBJECTS");
            tObj = fnh.getTable("TABLEOBJECTS");
            String talias = "";
            int rowCount2 = fObj.getNumRows();
            for (int fIdx = 0; fIdx < rowCount2; ++fIdx) {
                fObj.moveTo(fIdx);
                data = new SNWODPInfoObjDetails();
                data.setName(fObj.getField("INTIOBJNM"));
                talias = fObj.getField("TALIAS");
                int rowCount22 = tObj.getNumRows();
                for (int tIdx = 0; tIdx < rowCount22; ++tIdx) {
                    tObj.moveTo(tIdx);
                    if (!talias.equals(tObj.getField("TALIAS"))) continue;
                    data.setDimGroup(tObj.getField("TEXTLONG"));
                }
                found = true;
                if (this.setInfoObjectDetails(map, data, connection, executionEnvironment)) continue;
                abort = true;
                break;
            }
            if (found) {
                SNWODPInfoObjectItem item = null;
                item = abort ? new SNWODPInfoObjectItem("Infoset", new TreeMap<String, SNWODPInfoObjDetails>()) : new SNWODPInfoObjectItem("Infoset", map);
                this.cubeMD.put(srchKey, item);
                boolean bl = true;
                return bl;
            }
            this.cubeMD.put(srchKey, STR_NOT_FOUND);
            boolean bl = false;
            return bl;
        }
        catch (JBapiException be) {
            SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, BAPI_EXCP_ISET_DETAIL, (Throwable)be);
        }
        catch (SNWODPException e) {
            SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, SNWODP_EXCP_ISET_DETAIL, (Throwable)((Object)e));
        }
        catch (LogonFailureException lfe) {
            SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, LOGON_EXCP_ISET_DETAIL, (Throwable)lfe);
        }
        finally {
            if (fObj != null) {
                fObj.release();
            }
            if (tObj != null) {
                tObj.release();
            }
            if (fnh != null) {
                this.provider.removeCancelListener(fnh, executionEnvironment);
                fnh.release();
            }
        }
        try {
            found = false;
            fnh = new SNWODPMetadataHandler(this.provider, connection, BAPI_IOBJ_GETDETAIL);
            this.provider.addCancelListener(fnh, executionEnvironment);
            fnh.setImportParameter("INFOOBJECT", srchKey.getName());
            fnh.setImportParameter("VERSION", "A");
            fnh.executeFunctionNoCheck();
            iobj = fnh.getTable(ATTRIBUTES);
            int rowCount3 = iobj.getNumRows();
            for (int iobjIdx = 0; iobjIdx < rowCount3; ++iobjIdx) {
                iobj.moveTo(iobjIdx);
                data = new SNWODPInfoObjDetails();
                data.setName(iobj.getField(ATTRINM));
                found = true;
                if (!this.setInfoObjectDetails(map, data, connection, executionEnvironment)) {
                    abort = true;
                    break;
                }
                map.put(data.getName(), data);
            }
            if (found) {
                SNWODPInfoObjectItem item = null;
                item = abort ? new SNWODPInfoObjectItem("Unknown Cube Type", new TreeMap<String, SNWODPInfoObjDetails>()) : new SNWODPInfoObjectItem("Unknown Cube Type", map);
                this.cubeMD.put(srchKey, item);
                boolean bl = true;
                return bl;
            }
            this.cubeMD.put(srchKey, STR_NOT_FOUND);
            boolean bl = false;
            return bl;
        }
        catch (JBapiException be) {
            found = false;
            this.cubeMD.put(srchKey, STR_NOT_FOUND);
            SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, BAPI_EXCP_IOBJ_DETAIL, (Throwable)be);
        }
        catch (SNWODPException e) {
            found = false;
            this.cubeMD.put(srchKey, STR_NOT_FOUND);
            SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, SNWODP_EXCP_IOBJ_DETAIL, (Throwable)((Object)e));
        }
        catch (LogonFailureException lfe) {
            found = false;
            this.cubeMD.put(srchKey, STR_NOT_FOUND);
            SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, LOGON_EXCP_IOBJ_DETAIL, (Throwable)lfe);
        }
        finally {
            if (iobj != null) {
                iobj.release();
            }
            if (fnh != null) {
                this.provider.removeCancelListener(fnh, executionEnvironment);
                fnh.release();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeMap<String, SNWODPInfoObjDetails> loadDimensionMetadata(SNWODPConnection connection, SNWODPInfoObjectKey srchKey, String objName, TreeMap<String, SNWODPInfoObjDetails> map, ExecutionEnvironment executionEnvironment) {
        int rowCount;
        SNWODPInfoObjDetails data = null;
        SNWODPMetadataHandler fnh = null;
        JBapiTable infoObj = null;
        JBapiTable dio = null;
        JBapiTable dims = null;
        JBapiTable odso = null;
        JBapiTable iobj = null;
        JBapiTable fObj = null;
        JBapiTable tObj = null;
        if (SNWODPLog.isOn("Metadata", LogLevel.TRACE).booleanValue()) {
            SNWODPLog.getLogger("Metadata").log(LogLevel.TRACE, "Loading dimension metadata");
        }
        boolean found = false;
        boolean abort = false;
        try {
            fnh = new SNWODPMetadataHandler(this.provider, connection, BAPI_CUBE_GETDETAIL);
            this.provider.addCancelListener(fnh, executionEnvironment);
            fnh.setImportParameter("INFOCUBE", srchKey.getName());
            fnh.setImportParameter("OBJVERS", "A");
            fnh.executeFunctionNoCheck();
            infoObj = fnh.getTable("INFOOBJECTS");
            dio = fnh.getTable("DIMENSIONINFOOBJECTS");
            dims = fnh.getTable("DIMENSIONS");
            rowCount = infoObj.getNumRows();
            for (int ioIdx = 0; ioIdx < rowCount; ++ioIdx) {
                String ioName = "";
                String dimName = "";
                String dimText = "";
                data = new SNWODPInfoObjDetails();
                infoObj.moveTo(ioIdx);
                ioName = infoObj.getFieldByIndex(3);
                if (infoObj.getFieldByIndex(5).equals("X")) {
                    ioName = SNWODPUtility.SNWODPNameUtils.extractIObjFromNavAttrName(ioName);
                }
                if (!ioName.equals(objName)) continue;
                int rowCount2 = dio.getNumRows();
                for (int dioIdx = 0; dioIdx < rowCount2; ++dioIdx) {
                    dio.moveTo(dioIdx);
                    String dioName = dio.getFieldByIndex(4);
                    if (!ioName.equals(dioName) && !ioName.equals(SNWODPUtility.SNWODPNameUtils.extractIObjFromNavAttrName(dioName))) continue;
                    dimName = dio.getFieldByIndex(2);
                    break;
                }
                data.setName(ioName);
                if (!dimName.equals("")) {
                    rowCount2 = dims.getNumRows();
                    for (int dIdx = 0; dIdx < rowCount2; ++dIdx) {
                        dims.moveTo(dIdx);
                        if (!dimName.equals(dims.getFieldByIndex(2))) continue;
                        dimText = dims.getFieldByIndex(3);
                        data.setOlapType(dims.getFieldByIndex(4));
                        break;
                    }
                }
                data.setDimGroup(dimName);
                data.setDimGroupDescription(dimText);
                if (this.setInfoObjectDetails(map, data, connection, executionEnvironment)) {
                    found = true;
                } else {
                    abort = true;
                }
                break;
            }
        }
        catch (JBapiException be) {
            found = false;
            SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, BAPI_EXCP_CUBE_DETAIL, (Throwable)be);
        }
        catch (SNWODPException e) {
            found = false;
            SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, SNWODP_EXCP_CUBE_DETAIL, (Throwable)((Object)e));
        }
        catch (LogonFailureException lfe) {
            found = false;
            SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, LOGON_EXCP_CUBE_DETAIL, (Throwable)lfe);
        }
        finally {
            if (infoObj != null) {
                infoObj.release();
            }
            if (dio != null) {
                dio.release();
            }
            if (dims != null) {
                dims.release();
            }
            if (fnh != null) {
                this.provider.removeCancelListener(fnh, executionEnvironment);
                fnh.release();
            }
        }
        if (!found && !abort) {
            try {
                fnh = new SNWODPMetadataHandler(this.provider, connection, BAPI_ODSO_GETDETAIL);
                this.provider.addCancelListener(fnh, executionEnvironment);
                fnh.setImportParameter("ODSOBJECT", srchKey.getName());
                fnh.setImportParameter("OBJVERS", "A");
                fnh.executeFunctionNoCheck();
                odso = fnh.getTable("INFOOBJECTS");
                rowCount = odso.getNumRows();
                for (int odsIdx = 0; odsIdx < rowCount; ++odsIdx) {
                    odso.moveTo(odsIdx);
                    data = new SNWODPInfoObjDetails();
                    data.setName(odso.getField("INFOOBJECT"));
                    if (!this.setInfoObjectDetails(map, data, connection, executionEnvironment)) {
                        abort = true;
                        break;
                    }
                    found = true;
                }
            }
            catch (JBapiException be) {
                found = false;
                SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, BAPI_EXCP_ODSO_DETAIL, (Throwable)be);
            }
            catch (SNWODPException e) {
                found = false;
                SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, SNWODP_EXCP_ODSO_DETAIL, (Throwable)((Object)e));
            }
            catch (LogonFailureException lfe) {
                found = false;
                SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, LOGON_EXCP_ODSO_DETAIL, (Throwable)lfe);
            }
            finally {
                if (odso != null) {
                    odso.release();
                }
                if (fnh != null) {
                    this.provider.removeCancelListener(fnh, executionEnvironment);
                    fnh.release();
                }
            }
        }
        if (!found && !abort) {
            try {
                fnh = new SNWODPMetadataHandler(this.provider, connection, BAPI_ISET_GETDETAIL);
                this.provider.addCancelListener(fnh, executionEnvironment);
                fnh.setImportParameter("INFOSET", srchKey.getName());
                fnh.setImportParameter("OBJVERS", "A");
                fnh.executeFunctionNoCheck();
                fObj = fnh.getTable("FIELDOBJECTS");
                tObj = fnh.getTable("TABLEOBJECTS");
                String talias = "";
                int rowCount2 = fObj.getNumRows();
                for (int fIdx = 0; fIdx < rowCount2; ++fIdx) {
                    fObj.moveTo(fIdx);
                    data = new SNWODPInfoObjDetails();
                    data.setName(fObj.getField("INTIOBJNM"));
                    talias = fObj.getField("TALIAS");
                    int rowCount22 = tObj.getNumRows();
                    for (int tIdx = 0; tIdx < rowCount22; ++tIdx) {
                        tObj.moveTo(tIdx);
                        if (!talias.equals(tObj.getField("TALIAS"))) continue;
                        data.setDimGroup(tObj.getField("TEXTLONG"));
                    }
                    if (!this.setInfoObjectDetails(map, data, connection, executionEnvironment)) {
                        abort = true;
                        break;
                    }
                    found = true;
                }
            }
            catch (JBapiException be) {
                found = false;
                SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, BAPI_EXCP_ISET_DETAIL, (Throwable)be);
            }
            catch (SNWODPException e) {
                found = false;
                SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, SNWODP_EXCP_ISET_DETAIL, (Throwable)((Object)e));
            }
            catch (LogonFailureException lfe) {
                found = false;
                SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, LOGON_EXCP_ISET_DETAIL, (Throwable)lfe);
            }
            finally {
                if (fObj != null) {
                    fObj.release();
                }
                if (tObj != null) {
                    tObj.release();
                }
                if (fnh != null) {
                    this.provider.removeCancelListener(fnh, executionEnvironment);
                    fnh.release();
                }
            }
        }
        if (!found && !abort) {
            try {
                fnh = new SNWODPMetadataHandler(this.provider, connection, BAPI_IOBJ_GETDETAIL);
                this.provider.addCancelListener(fnh, executionEnvironment);
                fnh.setImportParameter("INFOOBJECT", srchKey.getName());
                fnh.setImportParameter("VERSION", "A");
                fnh.executeFunctionNoCheck();
                iobj = fnh.getTable(ATTRIBUTES);
                int rowCount3 = iobj.getNumRows();
                for (int iobjIdx = 0; iobjIdx < rowCount3; ++iobjIdx) {
                    iobj.moveTo(iobjIdx);
                    data = new SNWODPInfoObjDetails();
                    data.setName(iobj.getField(ATTRINM));
                    if (!this.setInfoObjectDetails(map, data, connection, executionEnvironment)) {
                        abort = true;
                        break;
                    }
                    found = true;
                }
            }
            catch (JBapiException be) {
                found = false;
                SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, BAPI_EXCP_IOBJ_DETAIL, (Throwable)be);
            }
            catch (SNWODPException e) {
                found = false;
                SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, SNWODP_EXCP_IOBJ_DETAIL, (Throwable)((Object)e));
            }
            catch (LogonFailureException lfe) {
                found = false;
                SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, LOGON_EXCP_IOBJ_DETAIL, (Throwable)lfe);
            }
            finally {
                if (iobj != null) {
                    iobj.release();
                }
                if (fnh != null) {
                    this.provider.removeCancelListener(fnh, executionEnvironment);
                    fnh.release();
                }
            }
        }
        if (abort) {
            return new TreeMap<String, SNWODPInfoObjDetails>();
        }
        if (found) {
            return map;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setInfoObjectDetails(TreeMap<String, SNWODPInfoObjDetails> map, SNWODPInfoObjDetails infoObj, SNWODPConnection connection, ExecutionEnvironment executionEnvironment) {
        if (infoObj.getOlapType().equals(DATA_PACKET_ATTRIBUTE)) {
            return true;
        }
        infoObj.setIsDateType();
        SNWODPMetadataHandler fnh = null;
        JBapiStructure struct = null;
        try {
            fnh = new SNWODPMetadataHandler(this.provider, connection, BAPI_IOBJ_GETDETAIL);
            this.provider.addCancelListener(fnh, executionEnvironment);
            fnh.setImportParameter("INFOOBJECT", infoObj.getName());
            fnh.setImportParameter("VERSION", "A");
            fnh.executeFunction();
            struct = fnh.getExportStructure("DETAILS");
            String abapType = struct.getField("DATATP");
            infoObj.setAbapType(abapType);
            infoObj.setHasTimeDepText("1".equals(struct.getField("TXTTIMFL")));
            infoObj.setTextTable(struct.getField("TXTTAB"));
            String olapType = infoObj.getOlapType();
            if (olapType == null || olapType.length() == 0) {
                olapType = struct.getField("TYPE");
                infoObj.setOlapType(olapType);
            }
        }
        catch (JBapiException be) {
            SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, "BAPI Exception while executing getInfoObjectDetails: " + be.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (SNWODPException e) {
            SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, "Exception while executing getInfoObjectDetails: ", (Throwable)((Object)e));
            boolean bl = false;
            return bl;
        }
        catch (LogonFailureException lfe) {
            SNWODPLog.getLogger("Metadata").log(LogLevel.ERROR, "Logon Failure while executing getInfoObjectDetails: ", (Throwable)lfe);
            boolean bl = false;
            return bl;
        }
        finally {
            if (struct != null) {
                struct.release();
            }
            if (fnh != null) {
                this.provider.removeCancelListener(fnh, executionEnvironment);
                fnh.release();
            }
        }
        map.put(infoObj.getName(), infoObj);
        return true;
    }

    public final class SNWODPInfoObjectItem {
        private final String cubeType;
        private TreeMap<String, SNWODPInfoObjDetails> ioMap = null;

        public SNWODPInfoObjectItem(String type, TreeMap<String, SNWODPInfoObjDetails> map) {
            this.cubeType = type;
            this.ioMap = map;
        }

        public TreeMap<String, SNWODPInfoObjDetails> getInfoObjectMap() {
            return this.ioMap;
        }

        public void setInfoObjectMap(TreeMap<String, SNWODPInfoObjDetails> map) {
            this.ioMap = map;
        }

        public String getCubeType() {
            return this.cubeType;
        }
    }

    public final class SNWODPInfoObjectKey
    implements Comparable<SNWODPInfoObjectKey> {
        private String sysKey;
        private String cube;
        private String language;

        public SNWODPInfoObjectKey(String sys, String c, String lang) {
            this.sysKey = sys;
            this.cube = c;
            this.language = lang;
        }

        @Override
        public int compareTo(SNWODPInfoObjectKey other) {
            int ret = this.sysKey.compareTo(other.sysKey);
            if (ret == 0 && (ret = this.cube.compareTo(other.cube)) == 0) {
                ret = this.language.compareTo(other.language);
            }
            return ret;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.cube == null ? 0 : this.cube.hashCode());
            result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
            result = 31 * result + (this.sysKey == null ? 0 : this.sysKey.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SNWODPInfoObjectKey other = (SNWODPInfoObjectKey)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.cube == null ? other.cube != null : !this.cube.equals(other.cube)) {
                return false;
            }
            if (this.language == null ? other.language != null : !this.language.equals(other.language)) {
                return false;
            }
            return !(this.sysKey == null ? other.sysKey != null : !this.sysKey.equals(other.sysKey));
        }

        public String getName() {
            return this.cube;
        }

        private SNWODPInfoObjectCache getOuterType() {
            return SNWODPInfoObjectCache.this;
        }
    }
}

