/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.snwodp;

import com.cognos.xqe.bibushandler.CancelManager;
import com.cognos.xqe.bibushandler.CancelRequestSourceEnum;
import com.cognos.xqe.bibushandler.CancelUnsuccessfulException;
import com.cognos.xqe.bibushandler.ICancelable;
import com.cognos.xqe.conn.bapi.JBapiException;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.olap.MDXQueryArguments;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPConfig;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPConnection;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPDataHandler;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPDataProvider;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPException;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPFunctionHandler;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPGlobal;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPLog;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPMessageKeys;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPResultSet;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPSAPData;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPUtility;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.LogLevel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SNWODPMDXHandler
implements ICancelable {
    private final IPooledConnection mPooledConnection;
    private final MDXQueryArguments mQueryArgs;
    private final String mdx;
    private SNWODPConnection connection = null;
    private Integer nodeId = 0;
    private boolean canceled = false;
    private CancelManager cancelManager;
    private SNWODPDataHandler getAxisInfoFunction = null;
    private List<SNWODPDataHandler> getAxisDataFunction = new ArrayList<SNWODPDataHandler>();
    private SNWODPDataHandler getCellDataFunction = null;

    public SNWODPMDXHandler(IPooledConnection pooledConnection, MDXQueryArguments queryArgs, String sapMDX, Integer ndID, CancelManager cancelMgr) throws SNWODPException, LogonFailureException {
        this.mdx = sapMDX;
        this.nodeId = ndID;
        this.mPooledConnection = pooledConnection;
        this.mQueryArgs = queryArgs;
        this.cancelManager = cancelMgr;
        this.cancelManager.addCancelHandler((ICancelable)this);
        this.connection = (SNWODPConnection)((Object)this.mPooledConnection.getConnection());
        if (SNWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
            SNWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "Constructing SNWODPMDXHandler");
        }
    }

    public synchronized void addCancelListener(ICancelable listener) {
        this.cancelManager.addCancelHandler(listener);
    }

    public synchronized void removeCancelListener(ICancelable listener) {
        this.cancelManager.removeCancelHandler(listener);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void cancel() throws CancelUnsuccessfulException {
        if (!this.canceled) {
            this.canceled = true;
            SNWODPGlobal.writeBAPILog(4, "SNWODPMDXHandler", "Cancel request received!");
        }
    }

    public synchronized void cancel(CancelRequestSourceEnum cancelSource) throws CancelUnsuccessfulException {
        throw new CancelUnsuccessfulException();
    }

    public SNWODPResultSet executeMDX(SNWODPDataProvider provider, XDataContext xDataContext, String effectiveDate) throws SNWODPException {
        if (this.mdx.equals("")) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_EMPTY_MDX);
        }
        SNWODPSAPData axisData = null;
        try {
            SNWODPGlobal.writeBAPILog(4, "executeMDX", this.mdx);
            if (SNWODPLog.isOn("DataQuery", LogLevel.INFO).booleanValue()) {
                SNWODPLog.getLogger("DataQuery").log(LogLevel.INFO, "MDX Trace: " + StringUtils.replace((String)this.mdx, (String)"\n", (String)""));
            }
            this.resolveEffectiveDate(effectiveDate);
            this.executeCreateObjectFunction();
            this.executeCheckSyntaxFunction();
            this.executeSelectDataFunction();
            axisData = this.executeGetAxisInfoFunction();
        }
        catch (JBapiException be) {
            if (SNWODPLog.isOn("MDXEngine", LogLevel.ERROR).booleanValue()) {
                SNWODPLog.getLogger("MDXEngine").log(LogLevel.ERROR, "ERR_EXECUTE_MDX_FAILED");
            }
            throw be;
        }
        return new SNWODPResultSet(provider, xDataContext, this.mQueryArgs, this, axisData);
    }

    public void checkDataSetID() throws SNWODPException {
        if (this.connection.getDataSetID() == null) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_INVALID_DATASETID);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeCreateObjectFunction() throws SNWODPException {
        if (this.connection.getDataSetID() != null) {
            this.executeDeleteObjectFunction();
            this.connection.setDataSetID(null);
        }
        SNWODPFunctionHandler dataHandler = null;
        try {
            dataHandler = SNWODPConfig.instance().getUseRSOB() ? new SNWODPDataHandler(this.connection, this.connection.getConnect(), "RSR_MDX_CREATE_OBJECT") : new SNWODPDataHandler(this.connection, this.connection.getConnect(), "BAPI_MDDATASET_CREATE_OBJECT");
            this.addCancelListener(dataHandler);
            ((SNWODPDataHandler)dataHandler).createObject(this.mdx);
            dataHandler.executeFunction();
            ((SNWODPDataHandler)dataHandler).extractDataSetID();
            this.connection.setDataSetID(((SNWODPDataHandler)dataHandler).getDataSetID());
            if (dataHandler == null) return;
            this.removeCancelListener(dataHandler);
        }
        catch (JBapiException be) {
            try {
                throw new SNWODPException(SNWODPMessageKeys.ERR_CREATE_OBJECT_FAILED, be);
                catch (SNWODPException e) {
                    throw new SNWODPException(SNWODPMessageKeys.ERR_CREATE_OBJECT_FAILED, (Throwable)((Object)e));
                }
            }
            catch (Throwable throwable) {
                if (dataHandler == null) throw throwable;
                this.removeCancelListener(dataHandler);
                dataHandler.release();
                throw throwable;
            }
        }
        dataHandler.release();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeCheckSyntaxFunction() throws SNWODPException {
        SNWODPFunctionHandler dataHandler = null;
        try {
            this.checkDataSetID();
            dataHandler = new SNWODPDataHandler(this.connection, this.connection.getConnect(), "BAPI_MDDATASET_CHECK_SYNTAX");
            this.addCancelListener(dataHandler);
            ((SNWODPDataHandler)dataHandler).setDataSetID(this.connection.getDataSetID());
            dataHandler.executeFunction();
            if (dataHandler == null) return;
            this.removeCancelListener(dataHandler);
        }
        catch (JBapiException be) {
            try {
                throw new SNWODPException(SNWODPMessageKeys.ERR_CHECK_SYNTAX_FAILED, be);
                catch (SNWODPException e) {
                    throw new SNWODPException(SNWODPMessageKeys.ERR_CHECK_SYNTAX_FAILED, (Throwable)((Object)e));
                }
            }
            catch (Throwable throwable) {
                if (dataHandler == null) throw throwable;
                this.removeCancelListener(dataHandler);
                dataHandler.release();
                throw throwable;
            }
        }
        dataHandler.release();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeSelectDataFunction() throws SNWODPException {
        SNWODPFunctionHandler dataHandler = null;
        try {
            this.checkDataSetID();
            dataHandler = new SNWODPDataHandler(this.connection, this.connection.getConnect(), "BAPI_MDDATASET_SELECT_DATA");
            this.addCancelListener(dataHandler);
            ((SNWODPDataHandler)dataHandler).setDataSetID(this.connection.getDataSetID());
            dataHandler.executeFunction();
            if (dataHandler == null) return;
            this.removeCancelListener(dataHandler);
        }
        catch (JBapiException be) {
            try {
                throw new SNWODPException(SNWODPMessageKeys.ERR_EXECUTE_MDX_FAILED, be);
                catch (SNWODPException e) {
                    throw new SNWODPException(SNWODPMessageKeys.ERR_EXECUTE_MDX_FAILED, (Throwable)((Object)e));
                }
            }
            catch (Throwable throwable) {
                if (dataHandler == null) throw throwable;
                this.removeCancelListener(dataHandler);
                dataHandler.release();
                throw throwable;
            }
        }
        dataHandler.release();
    }

    public SNWODPSAPData executeGetAxisInfoFunction() throws SNWODPException {
        try {
            this.checkDataSetID();
            this.getAxisInfoFunction = SNWODPConfig.instance().getUseRSOB() ? new SNWODPDataHandler(this.connection, this.connection.getConnect(), "RSR_MDX_GET_AXIS_INFO") : new SNWODPDataHandler(this.connection, this.connection.getConnect(), "BAPI_MDDATASET_GET_AXIS_INFO");
            this.addCancelListener(this.getAxisInfoFunction);
            this.getAxisInfoFunction.setDataSetID(this.connection.getDataSetID());
            this.getAxisInfoFunction.executeFunction();
            SNWODPSAPData axisInfo = new SNWODPSAPData();
            SNWODPSAPData sNWODPSAPData = this.getAxisInfoFunction.getAxisTables(axisInfo);
            return sNWODPSAPData;
        }
        catch (JBapiException se) {
            if ("804".equals(se.getErrorKey()) || "813".equals(se.getErrorKey())) {
                throw new SNWODPException(SNWODPMessageKeys.ERR_ACCESS_DENIED, this.mQueryArgs.getCube().getCaption());
            }
            throw new SNWODPException(SNWODPMessageKeys.ERR_GET_AXIS_INFO_FAILED, se);
        }
        catch (SNWODPException e) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_GET_AXIS_INFO_FAILED, (Throwable)((Object)e));
        }
        finally {
            if (this.getAxisInfoFunction != null) {
                this.removeCancelListener(this.getAxisInfoFunction);
            }
        }
    }

    public void executeDeleteObjectFunction() throws SNWODPException {
        SNWODPFunctionHandler dataHandler = null;
        try {
            this.checkDataSetID();
            dataHandler = new SNWODPDataHandler(this.connection, this.connection.getConnect(), "BAPI_MDDATASET_DELETE_OBJECT");
            ((SNWODPDataHandler)dataHandler).setDataSetID(this.connection.getDataSetID());
            dataHandler.executeFunction();
        }
        catch (JBapiException be) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_DELETE_OBJECT_FAILED, be);
        }
        catch (SNWODPException e) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_DELETE_OBJECT_FAILED, (Throwable)((Object)e));
        }
        finally {
            if (dataHandler != null) {
                dataHandler.release();
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SNWODPSAPData executeGetAxisDataFunction(int axis, int iStartTuple, int iEndTuple) throws SNWODPException {
        SNWODPDataHandler dataHandler = null;
        try {
            this.checkDataSetID();
            dataHandler = SNWODPConfig.instance().getUseRSOB() ? new SNWODPDataHandler(this.connection, this.connection.getConnect(), "RSR_MDX_GET_AXIS_DATA") : new SNWODPDataHandler(this.connection, this.connection.getConnect(), "BAPI_MDDATASET_GET_AXIS_DATA");
            this.getAxisDataFunction.add(dataHandler);
            this.addCancelListener(dataHandler);
            dataHandler.setAxisDataParams(this.connection.getDataSetID(), axis, iStartTuple, iEndTuple);
            dataHandler.executeFunction();
            SNWODPSAPData axisData = new SNWODPSAPData();
            SNWODPSAPData sNWODPSAPData = dataHandler.getAxisDataTables(axisData);
            if (dataHandler != null) {
                this.removeCancelListener(dataHandler);
            }
            return sNWODPSAPData;
        }
        catch (JBapiException be) {
            try {
                throw new SNWODPException(SNWODPMessageKeys.ERR_GET_AXIS_DATA_FAILED, be);
                catch (SNWODPException e) {
                    throw new SNWODPException(SNWODPMessageKeys.ERR_GET_AXIS_DATA_FAILED, (Throwable)((Object)e));
                }
            }
            catch (Throwable throwable) {
                if (dataHandler != null) {
                    this.removeCancelListener(dataHandler);
                }
                throw throwable;
            }
        }
    }

    public SNWODPSAPData executeGetCellDataFunction(int iStartCell, int iEndCell) throws SNWODPException {
        try {
            this.checkDataSetID();
            this.getCellDataFunction = SNWODPConfig.instance().getUseRSOB() ? new SNWODPDataHandler(this.connection, this.connection.getConnect(), "RSR_MDX_GET_CELL_DATA") : new SNWODPDataHandler(this.connection, this.connection.getConnect(), "BAPI_MDDATASET_GET_CELL_DATA");
            this.addCancelListener(this.getCellDataFunction);
            this.getCellDataFunction.setCellDataParams(this.connection.getDataSetID(), iStartCell, iEndCell);
            this.getCellDataFunction.executeFunction();
            SNWODPSAPData cellData = new SNWODPSAPData();
            SNWODPSAPData sNWODPSAPData = this.getCellDataFunction.getCellTables(cellData);
            return sNWODPSAPData;
        }
        catch (JBapiException be) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_GET_CELL_DATA_FAILED, be);
        }
        catch (SNWODPException e) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_GET_CELL_DATA_FAILED, (Throwable)((Object)e));
        }
        finally {
            if (this.getCellDataFunction != null) {
                this.removeCancelListener(this.getCellDataFunction);
            }
        }
    }

    public void executeSetKeyDateFunction(String keyDate) throws SNWODPException {
        SNWODPFunctionHandler dataHandler = null;
        try {
            dataHandler = new SNWODPDataHandler(this.connection, this.connection.getConnect(), "BAPI_MDPROVIDER_SET_KEY_DATE");
            dataHandler.setKeyDateParam(keyDate);
            dataHandler.executeFunction();
        }
        catch (JBapiException be) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_SET_KEY_DATE_FAILED, be);
        }
        catch (SNWODPException e) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_SET_KEY_DATE_FAILED, (Throwable)((Object)e));
        }
        finally {
            if (dataHandler != null) {
                dataHandler.release();
            }
        }
    }

    public String executeGetKeyDateFunction() throws SNWODPException {
        SNWODPFunctionHandler dataHandler = null;
        try {
            dataHandler = new SNWODPDataHandler(this.connection, this.connection.getConnect(), "BAPI_MDPROVIDER_GET_KEY_DATE");
            dataHandler.executeFunction();
            String string = (String)dataHandler.getExportParameter("KEY_DATE");
            return string;
        }
        catch (JBapiException be) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_SET_KEY_DATE_FAILED, be);
        }
        catch (SNWODPException e) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_SET_KEY_DATE_FAILED, (Throwable)((Object)e));
        }
        finally {
            if (dataHandler != null) {
                dataHandler.release();
            }
        }
    }

    public void resolveEffectiveDate(String effectiveDate) throws SNWODPException {
        String cDate = this.connection.getEffectiveDate();
        String currentDate = SNWODPUtility.DateUtils.getLocalDateInSAPFormat();
        String date = effectiveDate != null ? SNWODPUtility.DateUtils.convertDateToSAPDateFormat(effectiveDate) : currentDate;
        if (cDate == null) {
            cDate = this.executeGetKeyDateFunction();
            this.connection.setEffectiveDate(cDate);
        }
        if (date.compareTo(cDate) != 0 && (effectiveDate == null || date.compareTo(currentDate) != 0)) {
            this.connection.setEffectiveDate(effectiveDate);
            this.executeSetKeyDateFunction(effectiveDate);
        }
    }

    public String getKeyDate() {
        return this.connection.getEffectiveDate();
    }

    public Integer getNodeID() {
        return this.nodeId;
    }

    public void release() {
        if (this.getAxisInfoFunction != null) {
            this.getAxisInfoFunction.release();
        }
        if (this.getCellDataFunction != null) {
            this.getCellDataFunction.release();
        }
        for (SNWODPDataHandler dh : this.getAxisDataFunction) {
            dh.release();
        }
        if (this.connection != null) {
            this.connection.setActiveDataQuery(false);
            this.cancelManager.removeCancelHandler((ICancelable)this);
            if (!this.connection.getConnect().isValid(false)) {
                if (SNWODPLog.isOn("Connection", LogLevel.WARN).booleanValue()) {
                    SNWODPLog.getLogger("Connection").log(LogLevel.WARN, "SNWODPMDXHandler: invalidating connection");
                }
                this.mPooledConnection.setNotReusable();
            }
            this.connection = null;
            this.mPooledConnection.returnConnection();
        }
        if (SNWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
            SNWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "releasing SNWODPMDXHandler");
        }
    }
}

