/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.snwodp;

import com.cognos.xqe.ast.maExp.MABlockConstraint;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.transformation.ma.provider.MASearchCriteria;
import com.cognos.xqe.util.LocalizedString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class SNWODPMemberSearch {
    private final MASearchCriteria.SearchCondition searchCondition;
    private final List<String> searchValues;
    private final MABlockConstraint.Operation searchOperation;
    private final boolean searchCaseInsensitive;
    private final boolean containsSelf;

    SNWODPMemberSearch(MASearchCriteria theSearchCriteria, boolean containSelf) {
        this.searchCondition = theSearchCriteria.getSearchCondition();
        this.searchValues = theSearchCriteria.getSearchValues();
        this.searchOperation = theSearchCriteria.getOperator();
        this.searchCaseInsensitive = theSearchCriteria.getCaseInsensitive();
        this.containsSelf = containSelf;
    }

    public List<MemberRecord> foundMembers(List<MemberRecord> members, MASearchCriteria searchCriteria) {
        Vector<MemberRecord> searchResult = new Vector<MemberRecord>();
        Iterator<MemberRecord> iter = members.iterator();
        if (this.containsSelf && iter.hasNext()) {
            searchResult.add(iter.next());
        }
        String propertyMUN = searchCriteria.getPropertyUniqueName();
        boolean isDynamicProperty = searchCriteria.isDynamicProperty();
        while (iter.hasNext()) {
            String propertyValue;
            MemberRecord member = iter.next();
            if (isDynamicProperty) {
                propertyValue = member.getDynamicFieldAsString(propertyMUN);
            } else {
                if (propertyMUN == null) {
                    throw new XQERuntimeException(XQEMessageKeys.MD_InvalidMemberPropertyName, "NULL property name found.");
                }
                propertyValue = this.getPropertyValue(member, propertyMUN);
            }
            if (!this.isMemberFound(propertyValue)) continue;
            searchResult.add(member);
        }
        ArrayList<MemberRecord> result = new ArrayList<MemberRecord>(searchResult.size());
        result.addAll(searchResult);
        return result;
    }

    private String getPropertyValue(MemberRecord record, String pUniqueName) {
        String propertyValue = null;
        if (pUniqueName.equals("MEMBER_CAPTION")) {
            LocalizedString localizedCaption = record.getCaption();
            String defaultLocale = localizedCaption.getDefaultLocale();
            propertyValue = localizedCaption.toString(defaultLocale);
        } else if (pUniqueName.equals("MEMBER_UNIQUE_NAME")) {
            propertyValue = record.getUniqueName();
        } else if (pUniqueName.equals("MEMBER_NAME")) {
            propertyValue = record.getName();
        } else if (pUniqueName.equals("DIMENSION_UNIQUE_NAME")) {
            propertyValue = record.getDimensionUniqueName();
        } else if (pUniqueName.equals("HIERARCHY_UNIQUE_NAME")) {
            propertyValue = record.getHierarchyUniqueName();
        } else if (pUniqueName.equals("LEVEL_UNIQUE_NAME")) {
            propertyValue = record.getLevelUniqueName();
        } else if (pUniqueName.equals("LEVEL_NUMBER")) {
            propertyValue = String.valueOf(record.getLevelNumber());
        } else if (pUniqueName.equals("PARENT_UNIQUE_NAME")) {
            propertyValue = record.getParentUniqueName();
        } else if (pUniqueName.equals("PARENT_LEVEL")) {
            propertyValue = String.valueOf(record.getParentLevelNumber());
        }
        return propertyValue;
    }

    public boolean isMemberFound(String propertyValue) {
        boolean patternFound = false;
        Iterator<String> iterator = this.searchValues.iterator();
        while (iterator.hasNext()) {
            String value;
            String pattern = value = iterator.next();
            if (this.searchCaseInsensitive && this.searchOperation == MABlockConstraint.Operation.AND) {
                if (propertyValue != null) {
                    propertyValue = propertyValue.toUpperCase();
                }
                pattern = pattern.toUpperCase();
            }
            if (propertyValue == null) {
                return this.searchCondition == MASearchCriteria.SearchCondition.NOTEQUAL;
            }
            patternFound = false;
            if (this.searchCondition == MASearchCriteria.SearchCondition.EQUALS) {
                if (propertyValue.equals(pattern)) {
                    patternFound = true;
                }
            } else if (this.searchCondition == MASearchCriteria.SearchCondition.NOTEQUAL) {
                if (!propertyValue.equals(pattern)) {
                    patternFound = true;
                }
            } else if (this.searchCondition == MASearchCriteria.SearchCondition.STARTS_WITH) {
                if (propertyValue.startsWith(pattern)) {
                    patternFound = true;
                }
            } else if (this.searchCondition == MASearchCriteria.SearchCondition.ENDS_WITH) {
                if (propertyValue.endsWith(pattern)) {
                    patternFound = true;
                }
            } else if (this.searchCondition == MASearchCriteria.SearchCondition.CONTAINS && propertyValue.contains(pattern)) {
                patternFound = true;
            }
            if (patternFound && this.searchOperation == MABlockConstraint.Operation.OR) {
                return true;
            }
            if (!patternFound && this.searchOperation == MABlockConstraint.Operation.AND) {
                return false;
            }
            if (this.searchOperation != MABlockConstraint.Operation.NOT_DEFINED) continue;
            return patternFound;
        }
        return patternFound;
    }
}

