/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.snwodp;

import com.cognos.xqe.conn.bapi.JBapiException;
import com.cognos.xqe.conn.bapi.JBapiStructure;
import com.cognos.xqe.conn.bapi.JBapiTable;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.olap.snwodp.SAPNWGenerateRestriction;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPConfig;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPConnection;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPConstants;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPDimensionProperties;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPException;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPFunctionHandler;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPInfoObjDetails;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPInfoObjectCache;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPLog;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPMessageKeys;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPMetadataProvider;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPTDStructures;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPUtility;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.TimestampValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.metadata.PPDSCodeTypeEnum;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.metadata.RollupTypeEnum;
import com.cognos.xqe.metadata.TreeOperatorEnum;
import com.cognos.xqe.metadata.VariableEntryTypeEnum;
import com.cognos.xqe.metadata.VariableSelectionTypeEnum;
import com.cognos.xqe.metadata.VariableTypeEnum;
import com.cognos.xqe.metadata.record.CatalogRecord;
import com.cognos.xqe.metadata.record.CubeRecord;
import com.cognos.xqe.metadata.record.DimensionRecord;
import com.cognos.xqe.metadata.record.HierarchyRecord;
import com.cognos.xqe.metadata.record.LevelRecord;
import com.cognos.xqe.metadata.record.MeasureRecord;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.metadata.record.PropertyRecord;
import com.cognos.xqe.metadata.record.RecordType;
import com.cognos.xqe.metadata.record.VariableRecord;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocalizedString;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import com.cognos.xqe.util.pool.XQELongPool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class SNWODPMetadataHandler
extends SNWODPFunctionHandler {
    private static final int ZERO = 0;
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final int THREE = 3;
    private static final int FOUR = 4;
    private static final int FIVE = 5;
    private static final String BAPI_MDPROVIDER_GET_DIMENSIONS = "BAPI_MDPROVIDER_GET_DIMENSIONS";
    private static final String BAPI_MDPROVIDER_GET_HIERARCHYS = "BAPI_MDPROVIDER_GET_HIERARCHYS";
    private static final String BAPI_MDPROVIDER_GET_MEMBERS = "BAPI_MDPROVIDER_GET_MEMBERS";
    private SNWODPMetadataProvider provider = null;
    private static final String LETTER_V = " v";
    private static final String MEASURES_DUN = "[Measures]";

    public SNWODPMetadataHandler(SNWODPMetadataProvider mdProvider, SNWODPConnection connection, String functionName) throws SNWODPException, LogonFailureException {
        super(connection, functionName);
        this.provider = mdProvider;
        if (SNWODPLog.isOn("Metadata", LogLevel.TRACE).booleanValue()) {
            SNWODPLog.getLogger("Metadata").log(LogLevel.TRACE, "Constructing SNWODPMetadataHandler");
        }
    }

    public void setKeyDate(String keyDate) throws SNWODPException {
        try {
            if (keyDate.contains("-")) {
                keyDate = SNWODPUtility.DateUtils.convertDateToSAPDateFormat(keyDate);
            }
            this.setKeyDateParam(keyDate);
            this.executeFunction();
        }
        catch (JBapiException be) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_SET_KEY_DATE_FAILED, be);
        }
        finally {
            this.release();
        }
    }

    public String getKeyDate() throws SNWODPException {
        try {
            this.executeFunction();
            String string = (String)this.getExportParameter("KEY_DATE");
            return string;
        }
        catch (JBapiException be) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_GET_KEY_DATE_FAILED, be);
        }
        finally {
            this.release();
        }
    }

    public List<String> getLocales(IRestrictions restrictions) throws SNWODPException {
        ArrayList<String> result = null;
        JBapiTable localeTable = null;
        try {
            this.executeFunctionNoCheck();
            localeTable = this.getTable("E_T_LANGU");
            if (SNWODPLog.isOn("Metadata", LogLevel.INFO).booleanValue()) {
                SNWODPLog.getLogger("Metadata").log(LogLevel.INFO, localeTable.traceToString(SNWODPConfig.instance().getMaxTableDumpRows()));
            }
            int rowCount = localeTable.getNumRows();
            result = new ArrayList<String>(rowCount);
            for (int row = 0; row < rowCount; ++row) {
                this.checkForCancel();
                localeTable.moveTo(row);
                String value = localeTable.getField("LAISO");
                result.add(value);
            }
        }
        catch (JBapiException be) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_GET_LOCALES, be);
        }
        finally {
            if (localeTable != null) {
                localeTable.release();
            }
            this.release();
        }
        return result;
    }

    public List<CatalogRecord> getCatalogs(IRestrictions restrictions) throws SNWODPException {
        String catalogNameRestriction = (String)restrictions.getValueOf(RestrictionType.CATALOG, null);
        ArrayList<CatalogRecord> result = null;
        JBapiTable catalogTable = null;
        int from = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
        int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)0x7FFFFFFE);
        try {
            int rowCount;
            this.setImportParams(restrictions, SNWODPConstants.CATALOG_RESTRICTIONS);
            this.executeFunction();
            catalogTable = this.getTable("CATALOGS");
            if (SNWODPLog.isOn("Metadata", LogLevel.INFO).booleanValue()) {
                SNWODPLog.getLogger("Metadata").log(LogLevel.INFO, catalogTable.traceToString(SNWODPConfig.instance().getMaxTableDumpRows()));
            }
            if ((rowCount = catalogTable.getNumRows()) < from) {
                if (SNWODPLog.isOn("Metadata", LogLevel.WARN).booleanValue()) {
                    SNWODPLog.getLogger("Metadata").log(LogLevel.WARN, "SNWODPMetadataHandler.getCatalogs: request starts after end of table");
                }
                List<CatalogRecord> list = Collections.emptyList();
                return list;
            }
            size = from == 0 && size == 0 ? rowCount : (size == 0 ? 0x7FFFFFFE : from + size);
            int resultEnd = Math.min(size, rowCount);
            result = new ArrayList<CatalogRecord>(resultEnd - from);
            for (int row = from; row < resultEnd; ++row) {
                this.checkForCancel();
                catalogTable.moveTo(row);
                CatalogRecord catalog = new CatalogRecord();
                String name = catalogTable.getFieldByIndex(0);
                catalog.setName(name);
                catalog.setUniqueName(name);
                catalog.setCaption((ILocalizedString)new LocalizedString(this.provider.getRunLocale(), name));
                catalog.setUniqueId(RecordType.CATALOG, name);
                catalog.setDescription("");
                if (null != catalogNameRestriction) {
                    if (!catalog.getName().equals(catalogNameRestriction)) continue;
                    result.add(catalog);
                    break;
                }
                result.add(catalog);
            }
        }
        catch (JBapiException be) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_GET_CATALOGS, be);
        }
        finally {
            if (catalogTable != null) {
                catalogTable.release();
            }
            this.release();
        }
        return result;
    }

    public List<CubeRecord> getCubes(IRestrictions restrictions, ExecutionEnvironment executionEnvironment) throws SNWODPException {
        ArrayList<CubeRecord> result = null;
        JBapiTable cubeTable = null;
        int rowCount = 0;
        int from = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
        int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)0x7FFFFFFE);
        SNWODPUtility.SNWODPNameUtils.checkCatalogName(restrictions);
        try {
            this.setImportParams(restrictions, SNWODPConstants.CUBE_RESTRICTIONS);
            try {
                this.executeFunction();
            }
            catch (JBapiException be) {
                if (be.getErrorKey().equals("201")) {
                    cubeTable = this.getTable("CUBES");
                    rowCount = cubeTable.getNumRows();
                    if (rowCount <= 0) {
                        throw be;
                    }
                }
                throw be;
            }
            if (cubeTable == null) {
                cubeTable = this.getTable("CUBES");
                rowCount = cubeTable.getNumRows();
            }
            if (SNWODPLog.isOn("Metadata", LogLevel.INFO).booleanValue()) {
                SNWODPLog.getLogger("Metadata").log(LogLevel.INFO, cubeTable.traceToString(SNWODPConfig.instance().getMaxTableDumpRows()));
            }
            if (rowCount < from) {
                if (SNWODPLog.isOn("Metadata", LogLevel.WARN).booleanValue()) {
                    SNWODPLog.getLogger("Metadata").log(LogLevel.WARN, "SNWODPMetadataHandler.getCubes: request starts after end of table");
                }
                List<CubeRecord> be = Collections.emptyList();
                return be;
            }
            size = from == 0 && size == 0 ? rowCount : (size == 0 ? 0x7FFFFFFE : from + size);
            int resultEnd = Math.min(size, rowCount);
            result = new ArrayList<CubeRecord>(resultEnd - from);
            SNWODPInfoObjectCache iObjCache = SNWODPInfoObjectCache.getInstance(this.provider);
            for (int row = from; row < resultEnd; ++row) {
                this.checkForCancel();
                cubeTable.moveTo(row);
                CubeRecord cube = new CubeRecord();
                String cubeUName = cubeTable.getFieldByIndex(1);
                cube.setName(cubeUName);
                cube.setUniqueName(cubeUName);
                cube.setCaption((ILocalizedString)new LocalizedString(this.provider.getRunLocale(), cubeUName));
                cube.setDescription(cubeTable.getFieldByIndex(9));
                cube.setUniqueId(RecordType.CUBE, cube.getUniqueName());
                cube.setCatalogName(cubeTable.getFieldByIndex(0));
                String sapTime = cubeTable.getFieldByIndex(7);
                TimestampValue tVal = SNWODPUtility.DateUtils.convertSAPTimestampToTimestampValue(sapTime);
                cube.setDataUpdateDate((DateTimeValue)tVal);
                sapTime = cubeTable.getFieldByIndex(5);
                tVal = SNWODPUtility.DateUtils.convertSAPTimestampToTimestampValue(sapTime);
                cube.setSchemaUpdateDate((DateTimeValue)tVal);
                sapTime = cubeTable.getFieldByIndex(4);
                tVal = SNWODPUtility.DateUtils.convertSAPTimestampToTimestampValue(sapTime);
                cube.setCreatedDate((DateTimeValue)tVal);
                String type = iObjCache.getCubeType(this.connection, this.connection.getSystemKey(), SNWODPUtility.SNWODPNameUtils.extractCubeName(cubeUName), executionEnvironment);
                cube.setDynamicFieldAsString("CUBETYPE", type);
                cube.setSchemaName("");
                result.add(cube);
            }
        }
        catch (JBapiException be) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_GET_CUBES, be);
        }
        finally {
            if (cubeTable != null) {
                cubeTable.release();
            }
            this.release();
        }
        return result;
    }

    public List<DimensionRecord> getDimensions(IRestrictions restrictions, ExecutionEnvironment executionEnvironment) throws SNWODPException {
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE, null);
        ArrayList<DimensionRecord> result = null;
        JBapiTable dimTable = null;
        int from = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
        int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)0x7FFFFFFE);
        try {
            int rowCount;
            this.setImportParams(restrictions, SNWODPConstants.DIMENSION_RESTRICTIONS);
            Boolean onlyStructs = (Boolean)restrictions.getValueOf(RestrictionType.ONLY_STRUCTURES, (Object)Boolean.FALSE);
            if (onlyStructs.booleanValue() && this.hasKeyFigureStructures(cubeName, executionEnvironment)) {
                this.setImportParameter("ONLY_STRUCTURES", "X");
            } else {
                this.setImportParameter("ONLY_STRUCTURES", " ");
            }
            this.executeFunction();
            dimTable = this.getTable("DIMENSIONS");
            if (SNWODPLog.isOn("Metadata", LogLevel.INFO).booleanValue()) {
                SNWODPLog.getLogger("Metadata").log(LogLevel.INFO, dimTable.traceToString(SNWODPConfig.instance().getMaxTableDumpRows()));
            }
            if ((rowCount = dimTable.getNumRows()) < from) {
                if (SNWODPLog.isOn("Metadata", LogLevel.WARN).booleanValue()) {
                    SNWODPLog.getLogger("Metadata").log(LogLevel.WARN, "SNWODPMetadataHandler.getDimensions: request starts after end of table");
                }
                List<DimensionRecord> list = Collections.emptyList();
                return list;
            }
            size = from == 0 && size == 0 ? rowCount : (size == 0 ? 0x7FFFFFFE : from + size);
            int resultEnd = Math.min(size, rowCount);
            result = new ArrayList<DimensionRecord>(resultEnd - from);
            SNWODPInfoObjectCache iObjCache = SNWODPInfoObjectCache.getInstance(this.provider);
            for (int row = from; row < resultEnd; ++row) {
                this.checkForCancel();
                dimTable.moveTo(row);
                String uName = dimTable.getFieldByIndex(3);
                String dName = SNWODPUtility.SNWODPNameUtils.removeBrackets(uName);
                String type = dimTable.getFieldByIndex(7);
                SNWODPInfoObjDetails details = iObjCache.getDimensionDetails(this.connection, this.connection.getSystemKey(), cubeName, dName, executionEnvironment);
                DimensionRecord dimension = new DimensionRecord();
                if (null != details) {
                    type = this.determineType(type, details);
                    this.setDimensionType(type, dimension);
                    dimension.setDimensionGroupName(details.getDimGroup());
                    dimension.setDimensionGroupDescription(details.getDimGroupDescription());
                    if (details.hasTimeDepText()) {
                        dimension.setDimensionHasTDText(Boolean.TRUE);
                        dimension.setDimensionTextTableName(details.getTextTable());
                    } else {
                        dimension.setDimensionHasTDText(Boolean.FALSE);
                        dimension.setDimensionTextTableName("");
                    }
                } else {
                    this.setDimensionType(type, dimension);
                    dimension.setDimensionGroupName("");
                    dimension.setDimensionGroupDescription("");
                    dimension.setDimensionTextTableName("");
                    dimension.setDimensionHasTDText(Boolean.FALSE);
                }
                if (dimension.getType() == DimensionTypeEnum.ACCOUNT || dimension.getType() == DimensionTypeEnum.SCENARIO) {
                    dimension.setMembersRollup(false);
                }
                dimension.setName(dimTable.getFieldByIndex(2));
                dimension.setUniqueName(uName);
                dimension.setDescription(dimTable.getFieldByIndex(10));
                dimension.setUniqueId(RecordType.DIMENSION, uName);
                dimension.setCatalogName(dimTable.getFieldByIndex(0));
                dimension.setCubeName(dimTable.getFieldByIndex(1));
                dimension.setCaption((ILocalizedString)new LocalizedString(this.provider.getRunLocale(), dimTable.getFieldByIndex(5)));
                dimension.setDefaultHierarchyUniqueName(dimTable.getFieldByIndex(9));
                dimension.setCardinality(dimTable.getFieldIntByIndex(8));
                dimension.setRank(dimTable.getFieldIntByIndex(6));
                dimension.setSchemaName("");
                result.add(dimension);
            }
        }
        catch (JBapiException be) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_GET_DIMS, be);
        }
        finally {
            if (dimTable != null) {
                dimTable.release();
            }
            this.release();
        }
        return result;
    }

    private String determineType(String type, SNWODPInfoObjDetails details) {
        String olapType = details.getOlapType();
        String abapType = details.getAbapType();
        if ("CHA".equals(olapType)) {
            if (details.isDateType()) {
                olapType = "DAT";
            } else if ("TIMS".equals(abapType)) {
                olapType = "TIM";
            }
        }
        if ("TIM".equals(olapType) && "DATS".equals(abapType)) {
            olapType = "DAT";
        }
        if ("1".equals(type)) {
            if ("DAT".equals(olapType)) {
                type = "SAPTime";
            }
        } else if ("TIM".equals(olapType)) {
            type = "1";
        } else if ("DAT".equals(olapType)) {
            type = "SAPTime";
        }
        return type;
    }

    private void setDimensionType(String sapType, DimensionRecord d) {
        if (sapType.equals("0")) {
            d.setType(DimensionTypeEnum.MEASURE);
            d.setIsStructure(Boolean.TRUE);
        } else if (sapType.equals("1")) {
            d.setType(DimensionTypeEnum.TIME);
            d.setIsStructure(Boolean.FALSE);
        } else if (sapType.equals("SAPTime")) {
            d.setType(DimensionTypeEnum.SAPTIME);
            d.setIsStructure(Boolean.FALSE);
        } else if (sapType.equals("2")) {
            d.setType(DimensionTypeEnum.MEASURE);
            d.setIsStructure(Boolean.FALSE);
        } else if (sapType.equals("3")) {
            d.setType(DimensionTypeEnum.REGULAR);
            d.setIsStructure(Boolean.FALSE);
        } else if (sapType.equals("4")) {
            d.setType(DimensionTypeEnum.REGULAR);
            d.setIsStructure(Boolean.TRUE);
        }
    }

    private boolean hasKeyFigureStructures(String cubeName, ExecutionEnvironment executionEnvironment) throws SNWODPException {
        SNWODPMetadataHandler mdh = null;
        JBapiTable tab = null;
        try {
            mdh = new SNWODPMetadataHandler(this.provider, this.connection, BAPI_MDPROVIDER_GET_DIMENSIONS);
            this.provider.addCancelListener(mdh, executionEnvironment);
            mdh.setImportParameter("CUBE_NAM", cubeName);
            mdh.executeFunctionNoCheck();
            tab = mdh.getTable("DIMENSIONS");
            if (SNWODPLog.isOn("Metadata", LogLevel.INFO).booleanValue()) {
                SNWODPLog.getLogger("Metadata").log(LogLevel.INFO, tab.traceToString(SNWODPConfig.instance().getMaxTableDumpRows()));
            }
            int rowCount = tab.getNumRows();
            for (int i = 0; i < rowCount; ++i) {
                this.checkForCancel();
                tab.moveTo(i);
                if (!tab.getFieldByIndex(7).equals("0")) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (JBapiException e) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_GET_DIM_TYPE_FAILED, e);
        }
        finally {
            if (tab != null) {
                tab.release();
            }
            if (mdh != null) {
                this.provider.removeCancelListener(mdh, executionEnvironment);
                mdh.release();
            }
        }
    }

    public List<HierarchyRecord> getHierarchy(IRestrictions restrictions, ExecutionEnvironment executionEnvironment) throws SNWODPException {
        String hierUName = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME, null);
        String variable = (String)restrictions.getValueOf(RestrictionType.VARIABLE, null);
        boolean isHierarchyVariableRequest = false;
        if (variable != null && (hierUName == null || hierUName.length() == 0)) {
            isHierarchyVariableRequest = true;
        }
        return this.getHierarchy(restrictions, isHierarchyVariableRequest, executionEnvironment);
    }

    public List<HierarchyRecord> getHierarchy(IRestrictions restrictions, boolean isHierarchyVariableRequest, ExecutionEnvironment executionEnvironment) throws SNWODPException {
        String dimName = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME, null);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE, null);
        String hierUName = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME, null);
        ArrayList<HierarchyRecord> result = null;
        HashMap<String, SNWODPTDStructures.HierarchyObject> hierListTemp = new HashMap<String, SNWODPTDStructures.HierarchyObject>();
        ArrayList<SNWODPTDStructures.StructInfo> hierNodeList = null;
        ArrayList<SNWODPTDStructures.HierarchyObject> hierList = null;
        boolean isHierUNameSpecified = false;
        SNWODPTDStructures tdStructures = new SNWODPTDStructures();
        JBapiTable hirTable = null;
        Object tdStruct = null;
        int hirCard = 0;
        int from = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
        int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)0x7FFFFFFE);
        isHierUNameSpecified = hierUName != null && hierUName.length() != 0;
        try {
            int rowCount;
            this.setImportParams(restrictions, SNWODPConstants.HIERARCHY_RESTRICTIONS);
            this.setImportParameter("HRY_NAM", "");
            this.executeFunction();
            hirTable = this.getTable("HIERARCHIES");
            if (SNWODPLog.isOn("Metadata", LogLevel.INFO).booleanValue()) {
                SNWODPLog.getLogger("Metadata").log(LogLevel.INFO, hirTable.traceToString(SNWODPConfig.instance().getMaxTableDumpRows()));
            }
            if ((rowCount = hirTable.getNumRows()) < from) {
                if (SNWODPLog.isOn("Metadata", LogLevel.WARN).booleanValue()) {
                    SNWODPLog.getLogger("Metadata").log(LogLevel.WARN, "SNWODPMetadataHandler.getHierarchies: request starts after end of table");
                }
                List<HierarchyRecord> list = Collections.emptyList();
                return list;
            }
            size = from == 0 && size == 0 ? rowCount : (size == 0 ? 0x7FFFFFFE : from + size);
            int resultEnd = Math.min(size, rowCount);
            result = new ArrayList<HierarchyRecord>(resultEnd - from);
            hierList = new ArrayList<SNWODPTDStructures.HierarchyObject>();
            List<Object> hierTDList = new ArrayList();
            HierarchyRecord hierarchy = null;
            if (isHierUNameSpecified) {
                for (int row = from; row < resultEnd; ++row) {
                    this.checkForCancel();
                    hirTable.moveTo(row);
                    hierarchy = this.createHierarchyRecord(hirTable);
                    result.add(hierarchy);
                }
            } else {
                int row;
                HashMap<String, String> versions = new HashMap<String, String>();
                hierTDList = this.getTimeDependentHierarchies(SNWODPUtility.SNWODPNameUtils.removeBrackets(dimName), versions, executionEnvironment);
                for (int row2 = 0; row2 < rowCount; ++row2) {
                    int maxTDSRanges;
                    SNWODPTDStructures.HierarchyObject tempHierarchy;
                    this.checkForCancel();
                    hirTable.moveTo(row2);
                    String hierID = hirTable.getFieldByIndex(5);
                    hierID = hierID.trim();
                    hirCard = hirTable.getFieldIntByIndex(8);
                    String caption = hirTable.getFieldByIndex(6);
                    if (versions.size() == 0 || hierID.length() == 0) {
                        hierarchy = this.createHierarchyRecord(hirTable);
                        SNWODPTDStructures sNWODPTDStructures = tdStructures;
                        sNWODPTDStructures.getClass();
                        tempHierarchy = sNWODPTDStructures.new SNWODPTDStructures.HierarchyObject(hierarchy, hierID, SNWODPTDStructures.HierarchyTDType.HRY_NTDEP);
                        hierList.add(tempHierarchy);
                        continue;
                    }
                    String version = (String)versions.get(hierID);
                    if (version != null && !version.equals("")) {
                        caption = caption + LETTER_V + version.trim();
                        caption = caption.trim();
                    }
                    if (hierNodeList != null) {
                        hierNodeList.clear();
                    }
                    if (hirCard < 0) {
                        hirCard = 9999999;
                    }
                    if (((maxTDSRanges = SNWODPConfig.instance().getMaxTDSRanges()) > 0 || hirCard < SNWODPConfig.instance().getMaxTDSCard()) && hierID != null && hierID.length() != 0) {
                        if (hierNodeList == null) {
                            hierNodeList = new ArrayList<SNWODPTDStructures.StructInfo>();
                        }
                        this.getTimeDependentStructures(hierID, hierNodeList, maxTDSRanges, executionEnvironment);
                    }
                    if (hierNodeList != null && !hierNodeList.isEmpty()) {
                        for (int row1 = 0; row1 < hierNodeList.size(); ++row1) {
                            this.checkForCancel();
                            hierarchy = this.createHierarchyRecord(hirTable);
                            hierarchy.setCaption((ILocalizedString)new LocalizedString(this.provider.getRunLocale(), caption));
                            SNWODPTDStructures.StructInfo structInfo = (SNWODPTDStructures.StructInfo)hierNodeList.get(row1);
                            hierarchy.setValidTo(SNWODPUtility.DateUtils.convertDateToXSDTimestamp(structInfo.getValidTo()));
                            hierarchy.setValidFrom(SNWODPUtility.DateUtils.convertDateToXSDTimestamp(structInfo.getValidFrom()));
                            SNWODPTDStructures sNWODPTDStructures = tdStructures;
                            sNWODPTDStructures.getClass();
                            tempHierarchy = sNWODPTDStructures.new SNWODPTDStructures.HierarchyObject(hierarchy, hierID, SNWODPTDStructures.HierarchyTDType.HRY_TDSTRUCT);
                            hierListTemp.put(hierID, tempHierarchy);
                            hierList.add(tempHierarchy);
                        }
                        if (hierNodeList == null) continue;
                        hierNodeList.clear();
                        continue;
                    }
                    hierarchy = this.createHierarchyRecord(hirTable);
                    hierarchy.setCaption(caption);
                    SNWODPTDStructures sNWODPTDStructures = tdStructures;
                    sNWODPTDStructures.getClass();
                    tempHierarchy = sNWODPTDStructures.new SNWODPTDStructures.HierarchyObject(hierarchy, hierID, SNWODPTDStructures.HierarchyTDType.HRY_NTDEP);
                    hierList.add(tempHierarchy);
                }
                if (hirTable != null) {
                    hirTable.release();
                    hirTable = null;
                }
                rowCount = hierTDList.size();
                ArrayList<HierarchyRecord> hierRecord = new ArrayList<HierarchyRecord>();
                for (int row3 = 0; row3 < rowCount; ++row3) {
                    this.checkForCancel();
                    SNWODPTDStructures.HierarchyObject hierObj = (SNWODPTDStructures.HierarchyObject)hierTDList.get(row3);
                    SNWODPTDStructures.HierarchyTDType type = hierObj.getType();
                    if (!type.equals((Object)SNWODPTDStructures.HierarchyTDType.HRY_TDEP)) continue;
                    hierRecord.addAll(this.checkTDHierarchy(hierObj, cubeName, dimName, executionEnvironment));
                }
                ArrayList<Integer> flagList = new ArrayList<Integer>(hierRecord.size());
                for (row = 0; row < hierRecord.size(); ++row) {
                    flagList.add(row, XQEIntegerPool.getInteger((int)0));
                }
                for (row = 0; row < hierList.size(); ++row) {
                    this.checkForCancel();
                    SNWODPTDStructures.HierarchyObject hierObj = (SNWODPTDStructures.HierarchyObject)hierList.get(row);
                    hierarchy = hierObj.getHierarchy();
                    hierUName = hierarchy.getUniqueName();
                    boolean isTime = false;
                    for (int row2 = 0; row2 < hierRecord.size(); ++row2) {
                        HierarchyRecord hierTD = (HierarchyRecord)hierRecord.get(row2);
                        String hierUN = hierTD.getUniqueName();
                        if (!hierUN.equals(hierUName)) continue;
                        result.add(hierTD);
                        flagList.add(row2, XQEIntegerPool.getInteger((int)1));
                        isTime = true;
                    }
                    if (isTime) continue;
                    result.add(hierarchy);
                }
                for (row = 0; row < hierRecord.size(); ++row) {
                    this.checkForCancel();
                    Integer flag = (Integer)flagList.get(row);
                    if (flag != 0) continue;
                    HierarchyRecord hierTD = (HierarchyRecord)hierRecord.get(row);
                    result.add(hierTD);
                }
            }
        }
        catch (JBapiException be) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_GET_HIERS, be);
        }
        finally {
            if (hirTable != null) {
                hirTable.release();
            }
            if (tdStruct != null) {
                tdStruct.release();
            }
            this.release();
        }
        return result;
    }

    private HierarchyRecord createHierarchyRecord(JBapiTable hirTable) {
        HierarchyRecord hierarchy = new HierarchyRecord();
        String caption = hirTable.getFieldByIndex(6);
        hierarchy.setUniqueName(hirTable.getFieldByIndex(4));
        hierarchy.setDescription(hirTable.getFieldByIndex(11));
        hierarchy.setUniqueId(RecordType.HIERARCHY, hierarchy.getUniqueName());
        hierarchy.setCatalogName(hirTable.getFieldByIndex(0));
        hierarchy.setCubeName(hirTable.getFieldByIndex(1));
        hierarchy.setDimensionUniqueName(hirTable.getFieldByIndex(2));
        hierarchy.setDefaultMemberUniqueName(hirTable.getFieldByIndex(9));
        hierarchy.setCardinality(hirTable.getFieldIntByIndex(8));
        hierarchy.setBalanced(hierarchy.getUniqueName().equals(hierarchy.getDimensionUniqueName()));
        hierarchy.setRagged(!hierarchy.isBalanced());
        hierarchy.setParentChild(false);
        hierarchy.setName(caption);
        hierarchy.setCaption((ILocalizedString)new LocalizedString(this.provider.getRunLocale(), caption));
        hierarchy.setHighestRollupMemberUniqueName(hirTable.getFieldByIndex(10));
        hierarchy.setSchemaName("");
        hierarchy.setDisplayPath("");
        return hierarchy;
    }

    private List<SNWODPTDStructures.HierarchyObject> getTimeDependentHierarchies(String dim, Map<String, String> versions, ExecutionEnvironment executionEnvironment) throws SNWODPException {
        SNWODPMetadataHandler mdh = null;
        JBapiTable tdHierarchies = null;
        try {
            mdh = new SNWODPMetadataHandler(this.provider, this.connection, "RSNDI_SHIE_CATALOG_GET");
            this.provider.addCancelListener(mdh, executionEnvironment);
            mdh.setImportParameter("I_OBJVERS", "A");
            mdh.setImportParameter("I_IOBJNM", dim);
            mdh.setImportParameter("I_LANGU", "E");
            mdh.executeFunctionNoCheck();
            tdHierarchies = mdh.getTable("E_T_HIEDIR");
            if (SNWODPLog.isOn("Metadata", LogLevel.INFO).booleanValue()) {
                SNWODPLog.getLogger("Metadata").log(LogLevel.INFO, tdHierarchies.traceToString(SNWODPConfig.instance().getMaxTableDumpRows()));
            }
            List<SNWODPTDStructures.HierarchyObject> list = this.findSAPDimensionHierarchies(dim, tdHierarchies, versions);
            return list;
        }
        catch (JBapiException e) {
            if (tdHierarchies != null) {
                tdHierarchies.release();
            }
            throw new SNWODPException(SNWODPMessageKeys.ERR_GET_HIER_TD_INFO_FAILED, e, dim);
        }
        finally {
            if (mdh != null) {
                this.provider.removeCancelListener(mdh, executionEnvironment);
                if (tdHierarchies != null) {
                    tdHierarchies.release();
                }
                mdh.release();
            }
        }
    }

    private void getTimeDependentStructures(String hirID, List<SNWODPTDStructures.StructInfo> hierNodeList, int maxRange, ExecutionEnvironment executionEnvironment) throws SNWODPException {
        SNWODPMetadataHandler mdh = null;
        JBapiTable hierarchyStructure = null;
        JBapiStructure struct = null;
        try {
            mdh = new SNWODPMetadataHandler(this.provider, this.connection, "RSNDI_SHIE_STRUCTURE_GET3");
            this.provider.addCancelListener(mdh, executionEnvironment);
            mdh.setImportParameter("I_NO_NODENM_TABLE", "X");
            struct = mdh.getImportStructure("I_S_HIEKEY");
            struct.setField("OBJVERS", "A");
            struct.setField("HIEID", hirID);
            mdh.executeFunctionNoCheck();
            hierarchyStructure = mdh.getTable("E_T_HIERSTRUC");
            boolean found = false;
            int nodeCount = hierarchyStructure.getNumRows();
            for (int row3 = 0; row3 < nodeCount; ++row3) {
                hierarchyStructure.moveTo(row3);
                String nodeDateFrom = hierarchyStructure.getFieldByIndex(10);
                String nodeDateTo = hierarchyStructure.getFieldByIndex(11);
                if (nodeDateTo != null && nodeDateFrom != null && (!nodeDateFrom.equals("10000101") && !nodeDateFrom.equals("00000000") || !nodeDateTo.equals("99991231") && !nodeDateTo.equals("00000000"))) {
                    SNWODPTDStructures.StructInfo structInfo;
                    found = false;
                    for (int row1 = 0; row1 < hierNodeList.size(); ++row1) {
                        structInfo = hierNodeList.get(row1);
                        if (!nodeDateTo.equals(structInfo.getValidTo()) || !nodeDateFrom.equals(structInfo.getValidFrom())) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        SNWODPTDStructures tdStructures;
                        SNWODPTDStructures sNWODPTDStructures = tdStructures = new SNWODPTDStructures();
                        sNWODPTDStructures.getClass();
                        structInfo = sNWODPTDStructures.new SNWODPTDStructures.StructInfo(nodeDateFrom, nodeDateTo);
                        hierNodeList.add(structInfo);
                    }
                }
                if (hierNodeList.size() < maxRange) continue;
                break;
            }
        }
        catch (JBapiException e) {
            if (hierarchyStructure != null) {
                hierarchyStructure.release();
            }
            throw new SNWODPException(SNWODPMessageKeys.ERR_GET_HIER_TD_STRUCT_FAILED, e, hirID);
        }
        finally {
            if (struct != null) {
                struct.release();
            }
            if (hierarchyStructure != null) {
                hierarchyStructure.release();
            }
            if (mdh != null) {
                this.provider.removeCancelListener(mdh, executionEnvironment);
                mdh.release();
            }
        }
    }

    private List<SNWODPTDStructures.HierarchyObject> findSAPDimensionHierarchies(String dimName, JBapiTable hierTDTable, Map<String, String> versions) {
        ArrayList<SNWODPTDStructures.HierarchyObject> hierList = new ArrayList<SNWODPTDStructures.HierarchyObject>();
        int rowCount = hierTDTable.getNumRows();
        SNWODPTDStructures tdStructures = new SNWODPTDStructures();
        for (int i = 0; i < rowCount; ++i) {
            this.checkForCancel();
            hierTDTable.moveTo(i);
            if (!hierTDTable.getField("IOBJNM").equals(dimName)) continue;
            String toDate = hierTDTable.getField("DATETO");
            String fromDate = hierTDTable.getField("DATEFROM");
            String hierID = hierTDTable.getField("HIEID");
            if (toDate != null && fromDate != null && (!fromDate.equals("10000101") && !fromDate.equals("00000000") || !toDate.equals("99991231") && !toDate.equals("00000000"))) {
                HierarchyRecord hierarchy = new HierarchyRecord();
                hierarchy.setValidTo(SNWODPUtility.DateUtils.convertDateToXSDTimestamp(toDate));
                hierarchy.setValidFrom(SNWODPUtility.DateUtils.convertDateToXSDTimestamp(fromDate));
                SNWODPTDStructures sNWODPTDStructures = tdStructures;
                sNWODPTDStructures.getClass();
                SNWODPTDStructures.HierarchyObject tempHierarchy = sNWODPTDStructures.new SNWODPTDStructures.HierarchyObject(hierarchy, hierID, SNWODPTDStructures.HierarchyTDType.HRY_TDEP);
                hierList.add(tempHierarchy);
            }
            versions.put(hierID, hierTDTable.getField("VERSION"));
        }
        return hierList;
    }

    public List<LevelRecord> getLevels(IRestrictions restrictions) throws SNWODPException {
        JBapiTable levelTable = null;
        ArrayList<LevelRecord> result = null;
        int from = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
        int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)0x7FFFFFFE);
        try {
            int rowCount;
            this.setImportParams(restrictions, SNWODPConstants.LEVEL_RESTRICTIONS);
            this.executeFunction();
            levelTable = this.getTable("LEVELS");
            if (SNWODPLog.isOn("Metadata", LogLevel.INFO).booleanValue()) {
                SNWODPLog.getLogger("Metadata").log(LogLevel.INFO, levelTable.traceToString(SNWODPConfig.instance().getMaxTableDumpRows()));
            }
            if ((rowCount = levelTable.getNumRows()) < from) {
                if (SNWODPLog.isOn("Metadata", LogLevel.WARN).booleanValue()) {
                    SNWODPLog.getLogger("Metadata").log(LogLevel.WARN, "SNWODPMetadataHandler.getLevels: request starts after end of table");
                }
                List<LevelRecord> list = Collections.emptyList();
                return list;
            }
            size = from == 0 && size == 0 ? rowCount : (size == 0 ? 0x7FFFFFFE : from + size);
            int resultEnd = Math.min(size, rowCount);
            result = new ArrayList<LevelRecord>(resultEnd - from);
            for (int row = from; row < resultEnd; ++row) {
                this.checkForCancel();
                levelTable.moveTo(row);
                LevelRecord level = new LevelRecord();
                String levelName = levelTable.getFieldByIndex(4);
                if (levelName.equals("Key Figures")) {
                    levelName = "MeasuresLevel";
                }
                level.setName(levelName);
                level.setUniqueName(levelTable.getFieldByIndex(5));
                level.setCaption((ILocalizedString)new LocalizedString(this.provider.getRunLocale(), levelTable.getFieldByIndex(7)));
                level.setDescription(levelTable.getFieldByIndex(11));
                level.setUniqueId(RecordType.LEVEL, level.getUniqueName());
                level.setCatalogName(levelTable.getFieldByIndex(0));
                level.setCubeName(levelTable.getFieldByIndex(1));
                level.setDimensionUniqueName(levelTable.getFieldByIndex(2));
                level.setHierarchyUniqueName(levelTable.getFieldByIndex(3));
                level.setCardinality(levelTable.getFieldIntByIndex(9));
                level.setLevelNumber(levelTable.getFieldIntByIndex(8));
                level.setUniqueMemberNames(true);
                level.setSchemaName("");
                result.add(level);
            }
        }
        catch (JBapiException be) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_GET_LEVELS, be);
        }
        finally {
            if (levelTable != null) {
                levelTable.release();
            }
            this.release();
        }
        return result;
    }

    public List<MeasureRecord> getMeasures(IRestrictions restrictions, ExecutionEnvironment executionEnvironment) throws SNWODPException {
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE, null);
        Boolean onlyStructs = (Boolean)restrictions.getValueOf(RestrictionType.ONLY_STRUCTURES, (Object)Boolean.FALSE);
        String resMUN = "";
        JBapiTable measureTable = null;
        ArrayList<MeasureRecord> result = null;
        JBapiTable aggregateTable = null;
        int from = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
        boolean skipSelf = false;
        int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)0x7FFFFFFE);
        try {
            int rowCount;
            EnumSet treeOps = (EnumSet)restrictions.getValueOf(RestrictionType.TREEOP, null);
            if (treeOps != null) {
                if (!treeOps.contains(TreeOperatorEnum.SELF) && !treeOps.contains(TreeOperatorEnum.SIBLINGS)) {
                    List<MeasureRecord> list = Collections.emptyList();
                    return list;
                }
                if (treeOps.contains(TreeOperatorEnum.SIBLINGS)) {
                    if (treeOps.size() == 1) {
                        skipSelf = true;
                        resMUN = (String)restrictions.getValueOf(RestrictionType.MEASURE_UNIQUE_NAME);
                    }
                    restrictions.remove(RestrictionType.MEASURE_UNIQUE_NAME);
                }
            }
            this.setImportParams(restrictions, SNWODPConstants.MEASURE_RESTRICTIONS);
            if (onlyStructs.booleanValue() && this.hasKeyFigureStructures(cubeName, executionEnvironment)) {
                this.setImportParameter("ONLY_STRUCTURES", "X");
            } else {
                this.setImportParameter("ONLY_STRUCTURES", " ");
            }
            this.executeFunction();
            measureTable = this.getTable("MEASURES");
            if (SNWODPLog.isOn("Metadata", LogLevel.INFO).booleanValue()) {
                SNWODPLog.getLogger("Metadata").log(LogLevel.INFO, measureTable.traceToString(SNWODPConfig.instance().getMaxTableDumpRows()));
            }
            if ((rowCount = measureTable.getNumRows()) < from) {
                if (SNWODPLog.isOn("Metadata", LogLevel.WARN).booleanValue()) {
                    SNWODPLog.getLogger("Metadata").log(LogLevel.WARN, "SNWODPMetadataHandler.getMeasures: request starts after end of table");
                }
                List<MeasureRecord> list = Collections.emptyList();
                return list;
            }
            size = from == 0 && size == 0 ? rowCount : (size == 0 ? 0x7FFFFFFE : from + size);
            int resultEnd = Math.min(size, rowCount);
            result = new ArrayList<MeasureRecord>(resultEnd - from);
            aggregateTable = this.getTable("AGGR_EXCEPTIONAL");
            int rowCount2 = aggregateTable.getNumRows();
            if (rowCount2 == 0 && SNWODPLog.isOn("Metadata", LogLevel.TRACE).booleanValue()) {
                SNWODPLog.getLogger("Metadata").log(LogLevel.TRACE, "SNWODPMetadataHandler.getMeasures: Exceptional Aggregation Table not found");
            }
            for (int row = from; row < resultEnd; ++row) {
                this.checkForCancel();
                measureTable.moveTo(row);
                String measureUniqueName = measureTable.getFieldByIndex(3);
                if (skipSelf && measureUniqueName.equals(resMUN)) continue;
                MeasureRecord measure = new MeasureRecord();
                measure.setName(measureTable.getFieldByIndex(2));
                measure.setUniqueName(measureUniqueName);
                measure.setDescription(measureTable.getFieldByIndex(11));
                measure.setUniqueId(RecordType.MEASURE, measure.getUniqueName());
                measure.setCatalogName(measureTable.getFieldByIndex(0));
                measure.setCubeName(measureTable.getFieldByIndex(1));
                measure.setCaption((ILocalizedString)new LocalizedString(this.provider.getRunLocale(), measureTable.getFieldByIndex(4)));
                measure.setUnits(measureTable.getFieldByIndex(10));
                String dataTypeSAP = measureTable.getFieldByIndex(7);
                measure.setDataType(SNWODPUtility.SAPNWTypeUtils.sapMeasureDataTypeToXQEDataType(dataTypeSAP));
                int aggregator = measureTable.getFieldIntByIndex(6);
                AggregateTypeEnum regAggType = SNWODPUtility.SAPNWTypeUtils.convertSAPAggregateType(aggregator);
                AggregateTypeEnum semiAggType = AggregateTypeEnum.NONE;
                for (int row2 = 0; row2 < rowCount2; ++row2) {
                    aggregateTable.moveTo(row2);
                    if (!measureUniqueName.equals(aggregateTable.getFieldByIndex(2))) continue;
                    if (regAggType == AggregateTypeEnum.UNKNOWN) {
                        int agg = aggregateTable.getFieldIntByIndex(3);
                        regAggType = SNWODPUtility.SAPNWTypeUtils.convertSAPAggregateType(agg);
                    }
                    int semiAgg = aggregateTable.getFieldIntByIndex(4);
                    String dimRef = aggregateTable.getFieldByIndex(5);
                    semiAggType = SNWODPUtility.SAPNWTypeUtils.convertSAPAggregateType(semiAgg);
                    measure.setTimestateAggregatorDimension(dimRef);
                    break;
                }
                measure.setRegularAggregate(regAggType);
                measure.setSemiAggregate(semiAggType);
                measure.setSchemaName("");
                measure.setDimensionUniqueName("");
                measure.setHierarchyUniqueName("");
                measure.setLevelUniqueName("");
                result.add(measure);
            }
        }
        catch (JBapiException be) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_GET_MEASURES, be);
        }
        finally {
            if (aggregateTable != null) {
                aggregateTable.release();
            }
            if (measureTable != null) {
                measureTable.release();
            }
            this.release();
        }
        return result;
    }

    public List<MemberRecord> getMembersFromPPDSCodes(IRestrictions restrictions, Collection<String> resPPDSCodes, ExecutionEnvironment executionEnvironment) throws SNWODPException {
        String resMUN = (String)restrictions.getValueOf(RestrictionType.MEMBER_UNIQUE_NAME);
        int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)Integer.MAX_VALUE);
        restrictions.remove(RestrictionType.FROM);
        restrictions.remove(RestrictionType.SIZE);
        ArrayList<MemberRecord> memberRecords = new ArrayList<MemberRecord>();
        for (String ppdsCode : resPPDSCodes) {
            this.checkForCancel();
            if (null != ppdsCode) {
                String ppdsCodeType = ppdsCode.substring(0, 1);
                String mun = ppdsCode.substring(1);
                if (SNWODPLog.isOn("Metadata", LogLevel.TRACE).booleanValue()) {
                    SNWODPLog.getLogger("Metadata").log(LogLevel.TRACE, "Getting Members for PPDS_CODE:" + ppdsCode);
                }
                if (ppdsCodeType.equals(PPDSCodeTypeEnum.DIMENSION.getPPDSCodePrefix())) {
                    restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, (Object)mun);
                    SNWODPMetadataHandler dimHandler = new SNWODPMetadataHandler(this.provider, this.connection, BAPI_MDPROVIDER_GET_DIMENSIONS);
                    this.provider.addCancelListener(dimHandler, executionEnvironment);
                    List<DimensionRecord> dimRecord = dimHandler.getDimensions(restrictions, executionEnvironment);
                    this.provider.removeCancelListener(dimHandler, executionEnvironment);
                    if (dimRecord.isEmpty()) {
                        throw new SNWODPException(SNWODPMessageKeys.ERR_CANNOT_FIND_DIMENSION, mun);
                    }
                    DimensionRecord dim = dimRecord.get(0);
                    String hierMun = dim.getDefaultHierarchyUniqueName();
                    restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, (Object)hierMun);
                    SNWODPMetadataHandler hierHandler = new SNWODPMetadataHandler(this.provider, this.connection, BAPI_MDPROVIDER_GET_HIERARCHYS);
                    this.provider.addCancelListener(hierHandler, executionEnvironment);
                    List<HierarchyRecord> hierRecord = hierHandler.getHierarchy(restrictions, executionEnvironment);
                    this.provider.removeCancelListener(hierHandler, executionEnvironment);
                    if (hierRecord.isEmpty()) {
                        throw new SNWODPException(SNWODPMessageKeys.ERR_CANNOT_FIND_HIERARCHY, hierMun);
                    }
                    HierarchyRecord hier = hierRecord.get(0);
                    String memUName = hier.getDefaultMemberUniqueName();
                    restrictions.add(RestrictionType.MEMBER_UNIQUE_NAME, (Object)memUName);
                    List<SAPNWGenerateRestriction> memberRestrictions = null;
                    SNWODPMetadataHandler memHandler = new SNWODPMetadataHandler(this.provider, this.connection, BAPI_MDPROVIDER_GET_MEMBERS);
                    this.provider.addCancelListener(memHandler, executionEnvironment);
                    List<MemberRecord> memRecord = memHandler.getMembers(restrictions, memberRestrictions, false, executionEnvironment);
                    this.provider.removeCancelListener(memHandler, executionEnvironment);
                    if (memRecord.isEmpty()) {
                        throw new SNWODPException(SNWODPMessageKeys.ERR_CANNOT_FIND_MEMBER, memUName);
                    }
                    if (size < memberRecords.size()) break;
                    memberRecords.add(memRecord.get(0));
                    continue;
                }
                if (ppdsCodeType.equals(PPDSCodeTypeEnum.MEMBER.getPPDSCodePrefix())) {
                    if (null != resMUN && !resMUN.equals(mun)) {
                        if (!SNWODPLog.isOn("Metadata", LogLevel.TRACE).booleanValue()) continue;
                        StringBuilder sBuf = new StringBuilder();
                        sBuf.append("PPDSCode restriction (");
                        sBuf.append(mun);
                        sBuf.append(")doesn't match MUN restriction (");
                        sBuf.append(resMUN);
                        sBuf.append(").");
                        SNWODPLog.getLogger("Metadata").log(LogLevel.TRACE, sBuf.toString());
                        continue;
                    }
                    restrictions.add(RestrictionType.MEMBER_UNIQUE_NAME, (Object)mun);
                    List<SAPNWGenerateRestriction> memberRestrictions = null;
                    SNWODPMetadataHandler memHandler = new SNWODPMetadataHandler(this.provider, this.connection, BAPI_MDPROVIDER_GET_MEMBERS);
                    this.provider.addCancelListener(memHandler, executionEnvironment);
                    List<MemberRecord> memRecord = memHandler.getMembers(restrictions, memberRestrictions, false, executionEnvironment);
                    this.provider.removeCancelListener(memHandler, executionEnvironment);
                    if (memRecord.isEmpty()) {
                        throw new SNWODPException(SNWODPMessageKeys.ERR_CANNOT_FIND_MEMBER, mun);
                    }
                    if (size < memberRecords.size()) break;
                    memberRecords.add(memRecord.get(0));
                    continue;
                }
                if (!SNWODPLog.isOn("Metadata", LogLevel.WARN).booleanValue()) continue;
                SNWODPLog.getLogger("Metadata").log(LogLevel.WARN, "PPDSCode restriction was not a dimension unique name or member unique name:" + ppdsCode);
                continue;
            }
            if (!SNWODPLog.isOn("Metadata", LogLevel.WARN).booleanValue()) continue;
            SNWODPLog.getLogger("Metadata").log(LogLevel.WARN, "Empty PPDSCode restriction");
        }
        return memberRecords;
    }

    public List<MemberRecord> getMembers(IRestrictions restrictions, List<SAPNWGenerateRestriction> memberRestrictions, boolean isInfoQuery, ExecutionEnvironment executionEnvironment) throws SNWODPException {
        String catName = (String)restrictions.getValueOf(RestrictionType.CATALOG, null);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE, null);
        String dimName = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME, null);
        String hirName = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME, null);
        String levName = (String)restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME, null);
        String memUName = (String)restrictions.getValueOf(RestrictionType.MEMBER_UNIQUE_NAME, null);
        EnumSet treeOpSet = (EnumSet)restrictions.getValueOf(RestrictionType.TREEOP, null);
        ICube cube = (ICube)restrictions.getValueOf(RestrictionType.CUBE_OBJECT, null);
        if (treeOpSet != null && !treeOpSet.isEmpty()) {
            levName = null;
        }
        int from = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
        int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)0x7FFFFFFE);
        if (isInfoQuery) {
            restrictions.remove(RestrictionType.DIMENSION_UNIQUE_NAME);
        }
        if (memUName == null) {
            restrictions.remove(RestrictionType.TREEOP);
        }
        boolean containsSelf = false;
        if (treeOpSet != null) {
            containsSelf = treeOpSet.contains(TreeOperatorEnum.SELF);
        }
        List<MemberRecord> selfResult = null;
        if (treeOpSet != null && containsSelf && treeOpSet.size() > 1) {
            restrictions.replace(RestrictionType.TREEOP, EnumSet.of(TreeOperatorEnum.SELF));
            SNWODPMetadataHandler metadataHandler = new SNWODPMetadataHandler(this.provider, this.connection, BAPI_MDPROVIDER_GET_MEMBERS);
            this.provider.addCancelListener(metadataHandler, executionEnvironment);
            selfResult = metadataHandler.getMembers(restrictions, null, isInfoQuery, executionEnvironment);
            this.provider.removeCancelListener(metadataHandler, executionEnvironment);
            treeOpSet.remove(TreeOperatorEnum.SELF);
            restrictions.replace(RestrictionType.TREEOP, (Object)treeOpSet);
        }
        if (catName == null) {
            catName = "";
        }
        if (memUName != null && (dimName == null || hirName == null)) {
            int firstBlank = memUName.indexOf(" ");
            int firstBracket = memUName.indexOf("]");
            if (dimName == null) {
                dimName = firstBlank != -1 && firstBlank < firstBracket ? memUName.substring(0, firstBlank) + "]" : memUName.substring(0, firstBracket) + "]";
                restrictions.replace(RestrictionType.DIMENSION_UNIQUE_NAME, (Object)dimName);
            }
            if (hirName == null) {
                hirName = memUName.substring(0, firstBracket) + "]";
                restrictions.replace(RestrictionType.HIERARCHY_UNIQUE_NAME, (Object)hirName);
            }
        }
        int resultEnd = 0;
        resultEnd = size == 0 || size == 0x7FFFFFFE || size == Integer.MAX_VALUE ? 0 : (size == 1 ? from + 1 : size + from - 1);
        this.setImportParams(restrictions, SNWODPConstants.MEMBER_RESTRICTIONS);
        JBapiTable restrictionTable = null;
        JBapiTable selectedPropTable = null;
        JBapiTable memberTable = null;
        JBapiTable propTable = null;
        List<MemberRecord> result = null;
        try {
            SNWODPDimensionProperties dimensionProperties = new SNWODPDimensionProperties(restrictions);
            if (dimensionProperties.getAllProperies().equals("A")) {
                this.setImportParameter("ALL_PROPERTIES", "A");
            } else {
                this.setImportParameter("ALL_PROPERTIES", "S");
                TreeSet<String> properties = dimensionProperties.getPropertiesName();
                selectedPropTable = this.getTable("SELECTED_PROPERTIES");
                this.setSelectedPropTable(selectedPropTable, properties);
            }
            this.setImportParameter("START_ROW", String.valueOf(from));
            this.setImportParameter("END_ROW", String.valueOf(resultEnd));
            if (memberRestrictions != null && !memberRestrictions.isEmpty()) {
                restrictionTable = this.getTable("RESTRICTIONS");
                this.setRestrictionTable(restrictionTable, memberRestrictions);
            }
            SNWODPConfig config = SNWODPConfig.instance();
            Integer serverCacheReset = config.getServerCacheReset();
            if (config != null) {
                if (serverCacheReset.equals(1)) {
                    this.clearSAPMetadataCache();
                } else if (serverCacheReset.equals(2)) {
                    this.clearSAPUserCache();
                }
            }
            this.executeFunction();
            memberTable = this.getTable("MEMBERS");
            if (SNWODPLog.isOn("Metadata", LogLevel.INFO).booleanValue()) {
                SNWODPLog.getLogger("Metadata").log(LogLevel.INFO, memberTable.traceToString(SNWODPConfig.instance().getMaxTableDumpRows()));
            }
            int numberOfRows = memberTable.getNumRows();
            result = new ArrayList<MemberRecord>(numberOfRows);
            propTable = this.getTable("OPTIONAL_PROPERTIES");
            if (SNWODPLog.isOn("Metadata", LogLevel.INFO).booleanValue()) {
                SNWODPLog.getLogger("Metadata").log(LogLevel.INFO, propTable.traceToString(SNWODPConfig.instance().getMaxTableDumpRows()));
            }
            int propCount = propTable.getNumRows();
            int propRow = 0;
            for (int row = 0; row < numberOfRows; ++row) {
                this.checkForCancel();
                memberTable.moveTo(row);
                String uName = memberTable.getFieldByIndex(2);
                if (treeOpSet != null && !treeOpSet.contains(TreeOperatorEnum.SELF) && (treeOpSet.contains(TreeOperatorEnum.ANCESTORS) || treeOpSet.contains(TreeOperatorEnum.DESCENDANTS) || treeOpSet.contains(TreeOperatorEnum.SIBLINGS)) && uName.equals(memUName)) continue;
                MemberRecord member = new MemberRecord();
                member.setName(memberTable.getFieldByIndex(1));
                member.setUniqueName(uName);
                member.setCaption((ILocalizedString)new LocalizedString(this.provider.getRunLocale(), memberTable.getFieldByIndex(5).trim()));
                member.setDescription(memberTable.getFieldByIndex(10).trim());
                member.setUniqueId(RecordType.MEMBER, member.getUniqueName());
                member.setLevelNumber(memberTable.getFieldIntByIndex(0));
                member.setChildCardinality(memberTable.getFieldIntByIndex(7));
                member.setParentLevelNumber(memberTable.getFieldIntByIndex(8));
                member.setParentUniqueName(memberTable.getFieldByIndex(9));
                if (member.getLevelNumber() == 0) {
                    member.setParentLevelNumber(-1);
                    member.setParentCount(0);
                } else {
                    member.setParentCount(1);
                }
                member.setCatalogName(catName);
                member.setCubeName(cubeName);
                member.setDimensionUniqueName(dimName);
                member.setHierarchyUniqueName(hirName);
                member.setMemberOrdinal(memberTable.getFieldIntByIndex(6));
                if (levName != null) {
                    member.setLevelUniqueName(levName);
                }
                member.setRollupType(RollupTypeEnum.ROLLUP);
                int sapType = memberTable.getFieldIntByIndex(3);
                switch (sapType) {
                    case 0: 
                    case 1: 
                    case 2: {
                        member.setType(MemberTypeEnum.REGULAR);
                        break;
                    }
                    default: {
                        member.setType(MemberTypeEnum.UNKNOWN);
                    }
                }
                Long memOrdinal = XQELongPool.getLong((long)memberTable.getFieldLongByIndexX(6));
                for (int i = propRow; i < propCount; ++i) {
                    propTable.moveTo(i);
                    int compVal = Long.valueOf(propTable.getFieldByIndex(0)).compareTo(memOrdinal);
                    if (0 == compVal) {
                        boolean isAlreadyEnclosed;
                        StringBuilder sb = new StringBuilder(dimName);
                        sb.append(".");
                        String propName = propTable.getFieldByIndex(1);
                        boolean bl = isAlreadyEnclosed = propName.startsWith("[") && propName.endsWith("]");
                        if (!isAlreadyEnclosed) {
                            sb.append("[");
                        }
                        sb.append(propName);
                        if (!isAlreadyEnclosed) {
                            sb.append("]");
                        }
                        StringBuilder sb1 = new StringBuilder("2");
                        sb1.append(SNWODPUtility.SNWODPNameUtils.removeBrackets(dimName));
                        if (propName.equals(sb1.toString())) {
                            String sapBusinessKey;
                            member.setDynamicFieldAsString("SAP_BUSINESS_KEY", uName);
                            if (cube != null && cube.getDimension(dimName).isTimeDimension() && SNWODPUtility.DateUtils.isDateType(sapBusinessKey = SNWODPUtility.getSAPMemberUniqueNameKey(uName))) {
                                member.setDynamicFieldAsString("SAP_BUSINESS_KEY", sapBusinessKey);
                            }
                        }
                        member.setDynamicFieldAsString(sb.toString(), propTable.getFieldByIndex(2));
                        continue;
                    }
                    if (0 >= compVal) continue;
                    propRow = i;
                    break;
                }
                member = this.setCaptionForMembers(member, dimName);
                member.setSchemaName("");
                member.setDataMemberUniqueName(null);
                result.add(member);
            }
        }
        catch (JBapiException be) {
            if (be.getErrorKey().equals("012")) {
                throw be;
            }
            if (be.getErrorKey().equals("520")) {
                throw be;
            }
            if (be.getErrorKey().equals("037")) {
                throw be;
            }
            throw new SNWODPException(SNWODPMessageKeys.ERR_BAPI_GET_MEMBERS, be);
        }
        finally {
            if (memberTable != null) {
                memberTable.release();
            }
            if (propTable != null) {
                propTable.release();
            }
            if (selectedPropTable != null) {
                selectedPropTable.release();
            }
            if (restrictionTable != null) {
                restrictionTable.release();
            }
            this.release();
        }
        if (selfResult != null && !selfResult.isEmpty()) {
            selfResult.addAll(result);
            result = selfResult;
        }
        return result;
    }

    public List<PropertyRecord> getProperties(IRestrictions restrictions) throws SNWODPException {
        JBapiTable propertyTable = null;
        ArrayList<PropertyRecord> result = null;
        int from = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
        int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)0x7FFFFFFE);
        try {
            int rowCount;
            this.setImportParams(restrictions, SNWODPConstants.PROPERTY_RESTRICTIONS);
            this.executeFunction();
            propertyTable = this.getTable("PROPERTIES");
            if (SNWODPLog.isOn("Metadata", LogLevel.INFO).booleanValue()) {
                SNWODPLog.getLogger("Metadata").log(LogLevel.INFO, propertyTable.traceToString(SNWODPConfig.instance().getMaxTableDumpRows()));
            }
            if ((rowCount = propertyTable.getNumRows()) < from) {
                if (SNWODPLog.isOn("Metadata", LogLevel.WARN).booleanValue()) {
                    SNWODPLog.getLogger("Metadata").log(LogLevel.WARN, "SNWODPMetadataHandler.getProperties: request starts after end of table");
                }
                List<PropertyRecord> list = Collections.emptyList();
                return list;
            }
            size = from == 0 && size == 0 ? rowCount : (size == 0 ? 0x7FFFFFFE : from + size);
            int resultEnd = Math.min(size, rowCount);
            result = new ArrayList<PropertyRecord>(resultEnd - from);
            for (int row = from; row < resultEnd; ++row) {
                String cubeName;
                this.checkForCancel();
                propertyTable.moveTo(row);
                PropertyRecord property = new PropertyRecord();
                String dimUName = propertyTable.getFieldByIndex(2);
                String name = propertyTable.getFieldByIndex(7);
                String catalogName = propertyTable.getFieldByIndex(0);
                if (catalogName == null || catalogName.length() == 0) {
                    catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
                }
                if ((cubeName = propertyTable.getFieldByIndex(1)) == null || cubeName.length() == 0) {
                    cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
                }
                String caption = propertyTable.getFieldByIndex(8);
                StringBuffer uName = new StringBuffer(dimUName);
                uName.append(".");
                uName.append(name);
                property.setName(name);
                property.setUniqueName(uName.toString());
                property.setCaption((ILocalizedString)new LocalizedString(this.provider.getRunLocale(), caption));
                property.setDescription(propertyTable.getFieldByIndex(14));
                property.setUniqueId(RecordType.PROPERTY, uName.toString());
                property.setCatalogName(catalogName);
                property.setCubeName(cubeName);
                property.setDimensionUniqueName(dimUName);
                property.setHierarchyUniqueName(propertyTable.getFieldByIndex(3));
                property.setLevelUniqueName(propertyTable.getFieldByIndex(4));
                String scaleString = propertyTable.getFieldByIndex(13);
                String precisionString = propertyTable.getFieldByIndex(12);
                int scale = -1;
                int precision = -1;
                if (!scaleString.equals("")) {
                    scale = Integer.parseInt(scaleString);
                }
                if (!precisionString.equals("")) {
                    precision = Integer.parseInt(precisionString);
                }
                String dataTypeSAP = propertyTable.getFieldByIndex(9);
                property.setDataType(SNWODPUtility.SAPNWTypeUtils.sapPropertyDataTypeToXQEDataType(dataTypeSAP, precision, scale));
                String temp = "[" + name.substring(2);
                if (caption.equals("Key") && temp.equals(dimUName)) {
                    property.setRoleType(RoleTypeEnum.BUSINESS_KEY);
                    property.setDynamicFieldAsString("XQE_CUSTOM_PROPERTY_NAME", "SAP_BUSINESS_KEY");
                }
                property.setSchemaName("");
                result.add(property);
            }
        }
        catch (JBapiException be) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_GET_PROPERTIES, be);
        }
        finally {
            if (propertyTable != null) {
                propertyTable.release();
            }
            this.release();
        }
        return result;
    }

    public void setImportParams(IRestrictions restrictions, RestrictionType[] restrictionTypes) throws SNWODPException {
        for (int i = 0; i < restrictionTypes.length; ++i) {
            this.checkForCancel();
            RestrictionType type = restrictionTypes[i];
            String strVal = null;
            Integer intVal = null;
            EnumSet setVal = null;
            try {
                if (type.equals((Object)RestrictionType.CATALOG)) {
                    strVal = (String)restrictions.getValueOf(type, null);
                    if (strVal == null) continue;
                    this.setImportParameter("CAT_NAM", strVal);
                    continue;
                }
                if (type.equals((Object)RestrictionType.CUBE)) {
                    strVal = (String)restrictions.getValueOf(type, null);
                    if (strVal == null) continue;
                    strVal = SNWODPUtility.SNWODPNameUtils.removeBrackets(strVal);
                    this.setImportParameter("CUBE_NAM", strVal);
                    continue;
                }
                if (type.equals((Object)RestrictionType.DIMENSION_UNIQUE_NAME)) {
                    strVal = (String)restrictions.getValueOf(type, null);
                    if (strVal == null) continue;
                    this.setImportParameter("DIM_UNAM", strVal);
                    continue;
                }
                if (type.equals((Object)RestrictionType.HIERARCHY_UNIQUE_NAME)) {
                    strVal = (String)restrictions.getValueOf(type, null);
                    if (strVal == null) continue;
                    this.setImportParameter("HRY_UNAM", strVal);
                    continue;
                }
                if (type.equals((Object)RestrictionType.LEVEL_UNIQUE_NAME)) {
                    strVal = (String)restrictions.getValueOf(type, null);
                    if (strVal == null) continue;
                    this.setImportParameter("LVL_UNAM", strVal);
                    continue;
                }
                if (type.equals((Object)RestrictionType.LEVEL_NUMBER)) {
                    intVal = (Integer)restrictions.getValueOf(RestrictionType.LEVEL_NUMBER, null);
                    if (intVal == null) continue;
                    this.setImportParameter("LVL_NUMBER", intVal.toString());
                    continue;
                }
                if (type.equals((Object)RestrictionType.LEVEL_UNIQUE_NAME)) {
                    strVal = (String)restrictions.getValueOf(type, null);
                    if (strVal == null) continue;
                    this.setImportParameter("LVL_NAM", strVal);
                    continue;
                }
                if (type.equals((Object)RestrictionType.MEMBER_UNIQUE_NAME)) {
                    strVal = (String)restrictions.getValueOf(type, null);
                    if (strVal == null) continue;
                    this.setImportParameter("MEM_UNAM", strVal);
                    continue;
                }
                if (type.equals((Object)RestrictionType.MEMBER_CAPTION)) {
                    strVal = (String)restrictions.getValueOf(type, null);
                    if (strVal == null) continue;
                    this.setImportParameter("MEM_CAP", strVal);
                    continue;
                }
                if (type.equals((Object)RestrictionType.TREEOP)) {
                    setVal = (EnumSet)restrictions.getValueOf(RestrictionType.TREEOP, null);
                    if (setVal == null) continue;
                    int op = SNWODPUtility.convertTreeOperatorEnumSetToInt(setVal);
                    this.setImportParameter("TREEOP", XQEIntegerPool.getInteger((int)op).toString());
                    continue;
                }
                if (type.equals((Object)RestrictionType.MEASURE_UNIQUE_NAME)) {
                    strVal = (String)restrictions.getValueOf(type, null);
                    if (strVal == null) continue;
                    this.setImportParameter("MES_UNAM", strVal);
                    continue;
                }
                if (type.equals((Object)RestrictionType.PROPERTY)) {
                    strVal = (String)restrictions.getValueOf(type, null);
                    if (strVal == null) continue;
                    this.setImportParameter("PRPTY_NAM", strVal);
                    continue;
                }
                if (!type.equals((Object)RestrictionType.PROPERTY_TYPE) || (strVal = (String)restrictions.getValueOf(type, null)) == null) continue;
                this.setImportParameter("PRPTY_TYPE", strVal);
                continue;
            }
            catch (JBapiException e) {
                throw new SNWODPException(SNWODPMessageKeys.ERR_ADD_RESTRICTION, e, type.toString());
            }
        }
    }

    public List<VariableRecord> getVariables(IRestrictions restrictions, ExecutionEnvironment executionEnvironment) throws SNWODPException {
        JBapiTable varTable = null;
        ArrayList<VariableRecord> result = null;
        int from = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
        int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)0x7FFFFFFE);
        try {
            int rowCount;
            this.setImportParams(restrictions, SNWODPConstants.VARIABLE_RESTRICTIONS);
            this.executeFunction();
            varTable = this.getTable("VARIABLES");
            if (SNWODPLog.isOn("Metadata", LogLevel.INFO).booleanValue()) {
                SNWODPLog.getLogger("Metadata").log(LogLevel.INFO, varTable.traceToString(SNWODPConfig.instance().getMaxTableDumpRows()));
            }
            if ((rowCount = varTable.getNumRows()) < from) {
                if (SNWODPLog.isOn("Metadata", LogLevel.WARN).booleanValue()) {
                    SNWODPLog.getLogger("Metadata").log(LogLevel.WARN, "SNWODPMetadataHandler.getVariables: request starts after end of table");
                }
                List<VariableRecord> list = Collections.emptyList();
                return list;
            }
            size = from == 0 && size == 0 ? rowCount : (size == 0 || size == -1 ? 0x7FFFFFFE : from + size);
            int resultEnd = Math.min(size, rowCount);
            SNWODPInfoObjectCache iObjCache = SNWODPInfoObjectCache.getInstance(this.provider);
            result = new ArrayList<VariableRecord>(resultEnd - from);
            for (int row = from; row < resultEnd; ++row) {
                IDataType dataType;
                VariableTypeEnum varType;
                this.checkForCancel();
                varTable.moveTo(row);
                VariableRecord variable = new VariableRecord();
                variable.setKeyDate(false);
                String name = varTable.getFieldByIndex(2);
                variable.setName(name);
                variable.setUniqueName(name);
                variable.setCaption((ILocalizedString)new LocalizedString(this.provider.getRunLocale(), varTable.getFieldByIndex(3)));
                variable.setDescription(varTable.getFieldByIndex(18));
                variable.setCatalogName(varTable.getFieldByIndex(0));
                String cubeName = varTable.getFieldByIndex(1);
                variable.setCubeName(cubeName);
                String dimUName = varTable.getFieldByIndex(12);
                variable.setDimensionUniqueName(dimUName);
                String hirUName = varTable.getFieldByIndex(13);
                variable.setHierarchyUniqueName(hirUName);
                variable.setUniqueId(RecordType.VARIABLE, variable.getName());
                variable.setLowCaption(varTable.getFieldByIndex(16));
                variable.setHighCaption(varTable.getFieldByIndex(17));
                int val = varTable.getFieldIntByIndex(10);
                switch (val) {
                    case 2: {
                        variable.setSelectionType(VariableSelectionTypeEnum.INTERVAL);
                        break;
                    }
                    case 3: {
                        variable.setSelectionType(VariableSelectionTypeEnum.COMPLEX);
                        break;
                    }
                    case 4: {
                        variable.setSelectionType(VariableSelectionTypeEnum.MULTIVALUED);
                        break;
                    }
                    default: {
                        variable.setSelectionType(VariableSelectionTypeEnum.VALUE);
                    }
                }
                val = varTable.getFieldIntByIndex(6);
                switch (val) {
                    case 1: {
                        if (dimUName.equals(hirUName)) {
                            variable.setType(VariableTypeEnum.LEAF_MEMBER);
                            varType = VariableTypeEnum.LEAF_MEMBER;
                            break;
                        }
                        variable.setType(VariableTypeEnum.MEMBER);
                        varType = VariableTypeEnum.MEMBER;
                        break;
                    }
                    case 3: {
                        variable.setType(VariableTypeEnum.HIERARCHY);
                        varType = VariableTypeEnum.HIERARCHY;
                        break;
                    }
                    case 2: {
                        variable.setType(VariableTypeEnum.NUMERIC);
                        varType = VariableTypeEnum.NUMERIC;
                        break;
                    }
                    default: {
                        variable.setType(VariableTypeEnum.MEMBER);
                        varType = VariableTypeEnum.MEMBER;
                    }
                }
                val = varTable.getFieldIntByIndex(11);
                switch (val) {
                    case 1: 
                    case 2: {
                        variable.setEntryType(VariableEntryTypeEnum.MANDATORY);
                        break;
                    }
                    default: {
                        variable.setEntryType(VariableEntryTypeEnum.OPTIONAL);
                    }
                }
                StringValue value = null;
                String defaultLow = varTable.getFieldByIndex(14);
                String defaultHigh = varTable.getFieldByIndex(15);
                value = DataValueFactory.createStringValue();
                value.set(defaultLow.trim());
                variable.setDefaultLow((Value)value);
                value = DataValueFactory.createStringValue();
                value.set(defaultHigh.trim());
                variable.setDefaultHigh((Value)value);
                String dataTypeSAP = varTable.getFieldByIndex(7);
                String dName = SNWODPUtility.SNWODPNameUtils.removeBrackets(dimUName);
                boolean isDateType = false;
                SNWODPInfoObjDetails details = iObjCache.getDimensionDetails(this.connection, this.connection.getSystemKey(), cubeName, dName, executionEnvironment);
                if (details != null) {
                    isDateType = details.getIsDateType();
                }
                if ((dataType = SNWODPUtility.SAPNWTypeUtils.sapVariableDataTypeToXQEDataType(dataTypeSAP, isDateType)).getTypeName().equals("string") && (varType.equals((Object)VariableTypeEnum.LEAF_MEMBER) || varType.equals((Object)VariableTypeEnum.MEMBER))) {
                    dataType = DataTypeFactory.getMemberUniqueNameType();
                }
                variable.setDataType(dataType);
                variable.setSchemaName("");
                result.add(variable);
            }
        }
        catch (JBapiException be) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_GET_VARIABLES, be);
        }
        finally {
            if (varTable != null) {
                varTable.release();
            }
            this.release();
        }
        return result;
    }

    public String getDefaultMeasure(String cubeName, String catalogName, ExecutionEnvironment executionEnvironment) {
        String measureUniqeName = "";
        MetadataRestriction hirRestrictions = new MetadataRestriction();
        hirRestrictions.add(RestrictionType.CATALOG, (Object)catalogName);
        hirRestrictions.add(RestrictionType.CUBE, (Object)cubeName);
        hirRestrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, (Object)MEASURES_DUN);
        SNWODPMetadataHandler metadataHandler = null;
        try {
            metadataHandler = new SNWODPMetadataHandler(this.provider, this.connection, BAPI_MDPROVIDER_GET_HIERARCHYS);
            this.provider.addCancelListener(metadataHandler, executionEnvironment);
            List<HierarchyRecord> hirs = metadataHandler.getHierarchy((IRestrictions)hirRestrictions, executionEnvironment);
            if (!hirs.isEmpty()) {
                HierarchyRecord hir = hirs.get(0);
                measureUniqeName = hir.getDefaultMemberUniqueName();
            }
        }
        catch (JBapiException be) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_GET_DEFAULT_MEASURE, be);
        }
        finally {
            if (metadataHandler != null) {
                this.provider.removeCancelListener(metadataHandler, executionEnvironment);
                metadataHandler.release();
            }
        }
        return measureUniqeName;
    }

    public String getDefaultMeasureExternal(String cubeName, String catalogName, ExecutionEnvironment executionEnvironment) {
        String measureUniqeName = "";
        MetadataRestriction hirRestrictions = new MetadataRestriction();
        hirRestrictions.add(RestrictionType.CATALOG, (Object)catalogName);
        hirRestrictions.add(RestrictionType.CUBE, (Object)cubeName);
        hirRestrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, (Object)MEASURES_DUN);
        try {
            List<HierarchyRecord> hirs = this.getHierarchy((IRestrictions)hirRestrictions, executionEnvironment);
            if (!hirs.isEmpty()) {
                HierarchyRecord hir = hirs.get(0);
                measureUniqeName = hir.getDefaultMemberUniqueName();
            }
        }
        catch (JBapiException be) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_GET_DEFAULT_MEASURE, be);
        }
        return measureUniqeName;
    }

    private void setRestrictionTable(JBapiTable restrictionTable, List<SAPNWGenerateRestriction> memberRestrictions) throws SNWODPException {
        try {
            restrictionTable.clearContent();
            for (SAPNWGenerateRestriction res : memberRestrictions) {
                this.checkForCancel();
                if (SNWODPLog.isOn("Metadata", LogLevel.INFO).booleanValue()) {
                    SNWODPLog.getLogger("Metadata").log(LogLevel.INFO, res.printRestriction());
                }
                restrictionTable.appendRow();
                List<String> resRow = res.getSapRestriction();
                if (resRow.size() != 5) {
                    throw new SNWODPException(SNWODPMessageKeys.ERR_SEARCH_RESTRICTION);
                }
                int rowIndex = restrictionTable.getNumRows() - 1;
                restrictionTable.moveTo(rowIndex);
                restrictionTable.setField("PRPTY_NAM", resRow.get(0));
                restrictionTable.setField("SIGN", resRow.get(1));
                restrictionTable.setField("OPTION", resRow.get(2));
                restrictionTable.setField("LOW", resRow.get(3));
                restrictionTable.setField("HIGH", resRow.get(4));
            }
        }
        catch (JBapiException be) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_SET_RESTRICTIONS, be);
        }
    }

    private void setSelectedPropTable(JBapiTable selectedPropTable, TreeSet<String> properties) throws SNWODPException {
        try {
            selectedPropTable.clearContent();
            for (String prop : properties) {
                this.checkForCancel();
                if (SNWODPLog.isOn("Metadata", LogLevel.INFO).booleanValue()) {
                    SNWODPLog.getLogger("Metadata").log(LogLevel.INFO, prop);
                }
                selectedPropTable.appendRow();
                int rowIndex = selectedPropTable.getNumRows() - 1;
                selectedPropTable.moveTo(rowIndex);
                selectedPropTable.setField("PRPTY_NAM", prop);
            }
        }
        catch (JBapiException be) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_SET_SELECTED_TABLE, be);
        }
    }

    public List<LevelRecord> loadLevels(String cube, String dimUName, String hierUName, ExecutionEnvironment executionEnvironment) throws SNWODPException {
        MetadataRestriction lvlRestrictions = new MetadataRestriction();
        lvlRestrictions.add(RestrictionType.CUBE, (Object)cube);
        lvlRestrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, (Object)dimUName);
        lvlRestrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, (Object)hierUName);
        SNWODPMetadataHandler metadataHandler = null;
        try {
            metadataHandler = new SNWODPMetadataHandler(this.provider, this.connection, "BAPI_MDPROVIDER_GET_LEVELS");
            this.provider.addCancelListener(metadataHandler, executionEnvironment);
            List<LevelRecord> list = metadataHandler.getLevels((IRestrictions)lvlRestrictions);
            return list;
        }
        catch (JBapiException be) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_LOAD_HIER_LEVELS, be);
        }
        finally {
            if (metadataHandler != null) {
                this.provider.removeCancelListener(metadataHandler, executionEnvironment);
                metadataHandler.release();
            }
        }
    }

    public List<MemberRecord> fastGetMemberMetadata(IRestrictions restrictions, ExecutionEnvironment executionEnvironment) throws SNWODPException {
        String catName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String dimName = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        String hirName = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        ArrayList<MemberRecord> result = null;
        JBapiTable values = null;
        MemberRecord tempMember = null;
        SNWODPMetadataHandler mdh = new SNWODPMetadataHandler(this.provider, this.connection, "RSZ_X_VALUES_GET");
        try {
            values = this.fastGetMemberMetadata(dimName, cubeName, mdh, executionEnvironment);
            int numberOfRows = values.getNumRows();
            result = new ArrayList<MemberRecord>(numberOfRows);
            for (int row = 0; row < numberOfRows; ++row) {
                this.checkForCancel();
                values.moveTo(row);
                MemberRecord member = new MemberRecord();
                member.setCatalogName(catName);
                member.setCubeName(cubeName);
                member.setUniqueId(RecordType.MEMBER, member.getUniqueName());
                member.setDimensionUniqueName(dimName);
                member.setHierarchyUniqueName(hirName);
                String key = values.getFieldByIndex(0);
                String name = ".[" + key + "]";
                member.setName(dimName + name);
                member.setUniqueName(dimName + name);
                member.setCaption((ILocalizedString)new LocalizedString(this.provider.getRunLocale(), values.getFieldByIndex(3)));
                member.setLevelNumber(1);
                member.setChildCardinality(0);
                member.setRollupType(RollupTypeEnum.ROLLUP);
                if ("#".equals(key)) {
                    tempMember = member;
                    String memberUName = dimName + name;
                    restrictions.add(RestrictionType.MEMBER_UNIQUE_NAME, (Object)memberUName);
                    restrictions.replace(RestrictionType.LEVEL_NUMBER, (Object)1);
                    restrictions.replace(RestrictionType.TREEOP, EnumSet.of(TreeOperatorEnum.SELF));
                    restrictions.replace(RestrictionType.FROM, (Object)0);
                    restrictions.replace(RestrictionType.SIZE, (Object)0);
                    if (SNWODPLog.isOn("Metadata", LogLevel.INFO).booleanValue()) {
                        SNWODPLog.getLogger("Metadata").log(LogLevel.INFO, "SNWODPMetadataProvider.getMembers search restrictions: " + restrictions.toString());
                    }
                    List<MemberRecord> resultMember = this.getMembers(restrictions, null, false, executionEnvironment);
                    MemberRecord notAssignMember = resultMember.get(0);
                    String caption = notAssignMember.getCaption().toString();
                    tempMember.setCaption((ILocalizedString)new LocalizedString(this.provider.getRunLocale(), caption));
                    continue;
                }
                result.add(member);
            }
            if (tempMember != null) {
                result.add(tempMember);
            }
            ArrayList<MemberRecord> arrayList = result;
            return arrayList;
        }
        catch (JBapiException be) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_BAPI_FAST_GET_MEMBERS, be);
        }
        finally {
            this.provider.removeCancelListener(mdh, executionEnvironment);
            mdh.release();
            this.release();
        }
    }

    private JBapiTable fastGetMemberMetadata(String dimName, String cubeName, SNWODPMetadataHandler mdh, ExecutionEnvironment executionEnvironment) throws SNWODPException {
        JBapiTable params = null;
        JBapiTable values = null;
        try {
            String catalogName;
            this.provider.addCancelListener(mdh, executionEnvironment);
            params = mdh.getTable("I_T_PARAMS");
            params.appendRow();
            int rowIndex = 0;
            if (cubeName.substring(0, 1).equals("$")) {
                catalogName = cubeName.substring(1);
            } else {
                int index = cubeName.indexOf("/");
                catalogName = cubeName.substring(0, 1).equals("[") ? cubeName.substring(1, index) : cubeName.substring(0, index);
            }
            params.moveTo(rowIndex);
            params.setField("CHANM", SNWODPUtility.SNWODPNameUtils.removeBrackets(dimName));
            params.setField("READ_ALL_ATR", "");
            params.setField("ONLY_AUTH", "");
            params.setField("ONLY_FACTS", "");
            params.setField("ONLY_INFOCUBE", "X");
            params.setField("INFOCUBE", catalogName);
            params.setField("HANDLE", "");
            params.setField("CONTEXT", "");
            if (SNWODPLog.isOn("Metadata", LogLevel.INFO).booleanValue()) {
                SNWODPLog.getLogger("Metadata").log(LogLevel.INFO, params.traceToString(SNWODPConfig.instance().getMaxTableDumpRows()));
            }
            mdh.executeFunctionNoCheck();
            values = mdh.getTable("E_T_VALUES");
            if (SNWODPLog.isOn("Metadata", LogLevel.INFO).booleanValue()) {
                SNWODPLog.getLogger("Metadata").log(LogLevel.INFO, values.traceToString(SNWODPConfig.instance().getMaxTableDumpRows()));
            }
            JBapiTable jBapiTable = values;
            return jBapiTable;
        }
        catch (JBapiException e) {
            if (values != null) {
                values.release();
            }
            throw new SNWODPException(SNWODPMessageKeys.ERR_FAST_GET_MEMBERS, e);
        }
        finally {
            if (params != null) {
                params.release();
            }
        }
    }

    private List<HierarchyRecord> checkTDHierarchy(SNWODPTDStructures.HierarchyObject hierarchyObj, String cubeName, String dimUName, ExecutionEnvironment executionEnvironment) {
        HierarchyRecord hierarchy = hierarchyObj.getHierarchy();
        String sKeyDate = hierarchy.getValidTo();
        this.provider.setKeyDate(this.connection, sKeyDate, executionEnvironment);
        MetadataRestriction restrictions = new MetadataRestriction();
        restrictions.add(RestrictionType.CUBE, (Object)cubeName);
        restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, (Object)dimUName);
        ArrayList<HierarchyRecord> hierRecord = new ArrayList<HierarchyRecord>();
        SNWODPMetadataHandler metadataHandler = null;
        JBapiTable hirTable = null;
        try {
            metadataHandler = new SNWODPMetadataHandler(this.provider, this.connection, BAPI_MDPROVIDER_GET_HIERARCHYS);
            this.provider.addCancelListener(metadataHandler, executionEnvironment);
            metadataHandler.setImportParams((IRestrictions)restrictions, SNWODPConstants.HIERARCHY_RESTRICTIONS);
            metadataHandler.setImportParameter("HRY_NAM", "");
            metadataHandler.executeFunctionNoCheck();
            hirTable = metadataHandler.getTable("HIERARCHIES");
            boolean found = false;
            String hierUID = hierarchyObj.getHierarchyID();
            int rowCount = hirTable.getNumRows();
            for (int row = 0; row < rowCount; ++row) {
                this.checkForCancel();
                hirTable.moveTo(row);
                String hierID = hirTable.getFieldByIndex(5);
                if (!hierUID.equals(hierID.trim())) continue;
                HierarchyRecord tempHier = this.createHierarchyRecord(hirTable);
                tempHier.setValidTo(hierarchy.getValidTo());
                tempHier.setValidFrom(hierarchy.getValidFrom());
                hierRecord.add(tempHier);
                found = true;
                break;
            }
            if (!found) {
                hirTable.release();
                throw new SNWODPException(SNWODPMessageKeys.ERR_NO_RECORD_FOUND_FOR_UID, hierUID);
            }
        }
        catch (JBapiException be) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_GET_HIER_TD, be);
        }
        finally {
            if (hirTable != null) {
                hirTable.release();
            }
            if (metadataHandler != null) {
                this.provider.removeCancelListener(metadataHandler, executionEnvironment);
                metadataHandler.release();
            }
            this.release();
        }
        return hierRecord;
    }

    private MemberRecord setCaptionForMembers(MemberRecord member, String dimName) {
        String configPropertyName = SNWODPConfig.instance().getDisplayProperty();
        configPropertyName = configPropertyName.toUpperCase();
        SNWODPUtility.DisplayPropertiesForCaption displayProperty = SNWODPUtility.DisplayPropertiesForCaption.getDisplayProperty(configPropertyName);
        String prefix = displayProperty.getDimensionPrefix();
        if (configPropertyName.equals(SNWODPUtility.DisplayPropertiesForCaption.DESCRIPTION.getPropertyName())) {
            member.setCaption((ILocalizedString)new LocalizedString(this.provider.getRunLocale(), member.getDescription()));
            return member;
        }
        if (configPropertyName.equals(SNWODPUtility.DisplayPropertiesForCaption.CAPTION.getPropertyName())) {
            return member;
        }
        String dimProperyName = SNWODPUtility.SNWODPNameUtils.makeDimPropertyName(prefix, dimName);
        String propertyValue = member.getDynamicFieldAsString(dimProperyName);
        if (propertyValue != null && propertyValue.length() != 0) {
            member.setCaption((ILocalizedString)new LocalizedString(this.provider.getRunLocale(), propertyValue));
        }
        return member;
    }
}

