/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.snwodp;

import com.cognos.xqe.conn.bapi.JBapiTable;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPLog;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.HashMap;

public class SNWODPSAPData {
    private HashMap<Integer, JBapiTable> data = new HashMap();

    public int getRowCount(int tableID) {
        if (this.isValid(tableID)) {
            return this.data.get(XQEIntegerPool.getInteger((int)tableID)).getNumRows();
        }
        return -1;
    }

    private boolean isValid(int tableID) {
        return this.data.containsKey(XQEIntegerPool.getInteger((int)tableID));
    }

    public boolean tableExists(int tableId) {
        return this.isValid(tableId);
    }

    public boolean clear(int tableId) {
        JBapiTable tab = this.data.remove(XQEIntegerPool.getInteger((int)tableId));
        if (tab != null) {
            tab.release();
            return true;
        }
        return false;
    }

    public void setData(int tableID, JBapiTable table) {
        if (table != null) {
            this.data.put(XQEIntegerPool.getInteger((int)tableID), table);
            if (SNWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
                SNWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "Inserting Table with key: " + tableID);
            }
        }
    }

    public JBapiTable getData(int tableID) {
        return this.data.get(XQEIntegerPool.getInteger((int)tableID));
    }

    public void setRow(int tableId, int row) {
        JBapiTable table = this.data.get(XQEIntegerPool.getInteger((int)tableId));
        if (table != null) {
            table.moveTo(row);
        }
    }

    public void release() {
        if (SNWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
            SNWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "Releasing SAPData.");
        }
        if (this.data != null) {
            HashMap<Integer, JBapiTable> localMap = this.data;
            this.data = null;
            for (JBapiTable tab : localMap.values()) {
                tab.release();
            }
            localMap.clear();
        }
    }
}

