/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.snwodp;

import com.cognos.xqe.data.providers.olap.snwodp.SNWODPLog;
import com.cognos.xqe.trace.LogLevel;
import com.ibm.xml.crypto.util.Base64;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.auth.AuthChallengeException;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.InvalidCredentialsException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class SNWODPSPNEGOScheme
implements AuthScheme {
    private GSSContext ctxGSS = null;
    byte[] baToken = new byte[0];
    private static final String PREFIX = "SPNEGOScheme: ";
    private static final String FORWARD_SLASH = "/";
    private static final String SPNEGO_MECH_OID = "1.3.6.1.5.5.2";
    private static final String SPN_SERVICE_CLASS = "HTTP";
    private static final String SPNEGO_MECH_NAME = "Negotiate";
    private static final String SPNEGO_RESPONSE_PREFIX = "Negotiate ";
    private static final String RIGHT_BRACKET = ")";
    private static final int THIRTY = 30;

    private int getState() {
        if (this.ctxGSS == null) {
            return 0;
        }
        if (this.baToken == null) {
            return -1;
        }
        return 1;
    }

    protected void createGSSContext(String sTargetServiceHost) throws GSSException {
        SNWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SPNEGOScheme:  ENTER CreateGSSContext() for target host " + sTargetServiceHost);
        Oid spnegoMechOid = new Oid(SPNEGO_MECH_OID);
        GSSManager mgrGSS = GSSManager.getInstance();
        GSSName nameGSS = mgrGSS.createName("HTTP/" + sTargetServiceHost, null);
        this.ctxGSS = mgrGSS.createContext(nameGSS, spnegoMechOid, null, Integer.MAX_VALUE);
        this.ctxGSS.requestMutualAuth(true);
        this.ctxGSS.requestCredDeleg(true);
        SNWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SPNEGOScheme:  EXIT CreateGSSContext() - created GSSContext for MechName:" + nameGSS);
    }

    public SNWODPSPNEGOScheme() {
    }

    public SNWODPSPNEGOScheme(String sChallenge) {
        SNWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SPNEGOScheme:  ENTER SPNEGOScheme(" + sChallenge + RIGHT_BRACKET);
        this.processChallenge(sChallenge);
        SNWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SPNEGOScheme:  EXIT SPNEGOScheme(challenge)");
    }

    public void processChallenge(String sChallenge) {
        SNWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SPNEGOScheme:  ENTER processChallenge(" + sChallenge + RIGHT_BRACKET);
        if (sChallenge.startsWith(SPNEGO_MECH_NAME)) {
            if (sChallenge.startsWith(SPNEGO_RESPONSE_PREFIX)) {
                new Base64();
                this.baToken = Base64.decode((byte[])sChallenge.substring(SPNEGO_MECH_NAME.length() + 1).getBytes());
            } else {
                this.baToken = new byte[0];
            }
            SNWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SPNEGOScheme:  EXIT processChallenge(), token=" + this.baToken.toString());
        } else {
            SNWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SPNEGOScheme:  EXIT processChallenge() - No SPNEGO Challenge , ignoring");
        }
    }

    public boolean isComplete() {
        boolean bContinue = this.getState() > 1;
        SNWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SPNEGOScheme:  IsComplete: " + bContinue);
        return bContinue;
    }

    public String getSchemeName() {
        return SPNEGO_MECH_NAME;
    }

    public String getRealm() {
        return null;
    }

    @Deprecated
    public String getID() {
        SNWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SPNEGOScheme:  DEPECATED CALL - getID() - returning current Token: " + this.baToken.toString());
        return this.baToken.toString();
    }

    public String getParameter(String sParamName) {
        SNWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SPNEGOScheme:  getParameter(" + sParamName + ") - unsupported");
        if (sParamName == null) {
            throw new IllegalArgumentException("Parameter name may not be null");
        }
        return null;
    }

    public boolean isConnectionBased() {
        SNWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SPNEGOScheme:  isConnectionBased() - true");
        return true;
    }

    @Deprecated
    public String authenticate(Credentials crdCredentials, String sMethod, String sUri) throws AuthenticationException {
        throw new AuthenticationException("method not supported by SPNEGO scheme");
    }

    public String authenticate(Credentials crdCredentials, HttpMethod method) throws AuthenticationException {
        SNWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SPNEGOScheme:  ENTER Authenticate(creds, method) ");
        try {
            try {
                if (this.getState() == 0) {
                    this.createGSSContext(method.getURI().getHost());
                }
            }
            catch (URIException exURI) {
                SNWODPLog.getLogger("Connection").log(LogLevel.ERROR, "SPNEGOScheme:  EXIT Authenticate() - Failed URI Exception");
                this.baToken = null;
                throw new AuthenticationException(exURI.getMessage());
            }
            SNWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SPNEGOScheme:    Calling GSSInitializeContext, token size: " + this.baToken.length);
            this.baToken = this.ctxGSS.initSecContext(this.baToken, 0, this.baToken.length);
            SNWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SPNEGOScheme:    GSSInitializeContext token bytes returned: " + this.baToken.length);
        }
        catch (GSSException exGSS) {
            SNWODPLog.getLogger("Connection").log(LogLevel.ERROR, "SPNEGOScheme:    Failed to initialize GSSContext");
            this.baToken = null;
            if (exGSS.getMajor() == 13) {
                throw new CredentialsNotAvailableException(exGSS.getMessage(), (Throwable)exGSS);
            }
            if (exGSS.getMajor() == 9 || exGSS.getMajor() == 8) {
                throw new InvalidCredentialsException(exGSS.getMessage(), (Throwable)exGSS);
            }
            if (exGSS.getMajor() == 10 || exGSS.getMajor() == 19 || exGSS.getMajor() == 20) {
                throw new AuthChallengeException(exGSS.getMessage(), (Throwable)exGSS);
            }
            throw new AuthenticationException(exGSS.getMessage());
        }
        String sOutToken = Base64.encode((byte[])this.baToken);
        String sOutAuthorization = SPNEGO_RESPONSE_PREFIX + sOutToken;
        SNWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SPNEGOScheme:  EXIT Authenticate - returning: \"" + sOutAuthorization.substring(0, 30) + "...\"");
        return sOutAuthorization;
    }
}

