/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1;

import com.cognos.xqe.data.providers.olap.tm1.TM1Connection;
import com.cognos.xqe.data.providers.olap.tm1.TM1Log;
import com.cognos.xqe.trace.LogLevel;
import com.ibm.cognos.tm1.SecurityMode;

class SecurityModeMap {
    private static final long DUMP_SECURITY_MODE_STAT_PERIOD = 10000L;
    private static long mDumpTime = System.currentTimeMillis();
    private int mReferenced = 0;
    private SecurityMode mSecurityMode;
    private long mCreateTime;
    private long mLastTime;

    SecurityModeMap(SecurityMode securityMode) {
        this.mSecurityMode = securityMode;
        this.mLastTime = this.mCreateTime = System.currentTimeMillis();
    }

    SecurityMode getMode() {
        ++this.mReferenced;
        this.mLastTime = System.currentTimeMillis();
        this.dump(this.mLastTime);
        return this.mSecurityMode;
    }

    private void dump(long currentTime) {
        if (TM1Log.CONN_SECURITY_MODE_STATS.isOn(LogLevel.INFO) && currentTime - mDumpTime >= 10000L) {
            mDumpTime = currentTime;
            StringBuilder sb = new StringBuilder("Statistics for cached TM1 security modes...");
            for (String key : TM1Connection.sSecurityModeMapTM1.keySet()) {
                SecurityModeMap securityModeMap = (SecurityModeMap)TM1Connection.sSecurityModeMapTM1.get(key);
                if (null == securityModeMap) continue;
                sb.append("\n  CreateTime:");
                sb.append(currentTime - securityModeMap.mCreateTime);
                sb.append("  LastTime:");
                sb.append(currentTime - securityModeMap.mLastTime);
                sb.append("  Referenced:");
                sb.append(securityModeMap.mReferenced);
                sb.append("  Key:");
                sb.append(key);
                sb.append("  Mode:");
                sb.append(securityModeMap.mSecurityMode.toString());
            }
            TM1Log.CONN_SECURITY_MODE_STATS.log(LogLevel.INFO, sb.toString());
        }
    }
}

