/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.IDataProvider;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.connection.parameters.CAMCryptoHandleParameter;
import com.cognos.xqe.data.providers.connection.parameters.DataSourceParameter;
import com.cognos.xqe.data.providers.connection.parameters.ProductLocaleParameter;
import com.cognos.xqe.data.providers.connection.parameters.UserClassIDsParameter;
import com.cognos.xqe.data.providers.olap.DefaultConnection;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.data.providers.olap.tm1.SecurityModeMap;
import com.cognos.xqe.data.providers.olap.tm1.TM1DataProvider;
import com.cognos.xqe.data.providers.olap.tm1.TM1Log;
import com.cognos.xqe.data.providers.olap.tm1.TM1MessageKeys;
import com.cognos.xqe.data.providers.olap.tm1.TM1ODPException;
import com.cognos.xqe.data.providers.olap.tm1.UserGroupsMap;
import com.cognos.xqe.data.providers.olap.tm1.connection.MetadataCacheContext;
import com.cognos.xqe.data.providers.olap.tm1.connection.TM1AdminHostParameter;
import com.cognos.xqe.data.providers.olap.tm1.connection.TM1NameSpaceParameter;
import com.cognos.xqe.data.providers.olap.tm1.connection.TM1PasswordParameter;
import com.cognos.xqe.data.providers.olap.tm1.connection.TM1ServerNameParameter;
import com.cognos.xqe.data.providers.olap.tm1.connection.TM1UserNameParameter;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1CubeCache;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1ExceptionConverter;
import com.cognos.xqe.data.providers.secbridge.IImpersonator;
import com.cognos.xqe.data.providers.secbridge.ImpersonatorFactory;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionParameter;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.concurrent.Gate;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.eviction.ConcurrentSimpleDLinkLRUMap;
import com.ibm.cognos.tm1.API;
import com.ibm.cognos.tm1.AttributeDefinition;
import com.ibm.cognos.tm1.SecurityMode;
import com.ibm.cognos.tm1.Server;
import com.ibm.cognos.tm1.TM1Exception;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TM1Connection
extends DefaultConnection {
    private static final String USER_GROUP_SEPARATOR = ";";
    private static final String USER_GROUP_KEY = "%s\\%s\\%s";
    private static final long USER_GROUP_GATE_WAIT_TIME = 10L;
    private static final ConcurrentHashMap<String, Gate> USER_GROUP_GATE = new ConcurrentHashMap();
    private static final String SERVER_ID_KEY = "%s\\%s";
    private static final long SEC_MODE_GATE_WAIT_TIME = 10L;
    private static final ConcurrentHashMap<String, Gate> SEC_MODE_GATE = new ConcurrentHashMap();
    private static final int USER_GROUP_CACHE_SIZE = 5000;
    protected static ConcurrentSimpleDLinkLRUMap<String, UserGroupsMap> sUserGroupsMapTM1 = new ConcurrentSimpleDLinkLRUMap(5000, true);
    protected static ConcurrentMap<String, SecurityModeMap> sSecurityModeMapTM1 = new ConcurrentHashMap<String, SecurityModeMap>();
    private static ConcurrentHashMap<String, AttributeDefinition[]> sCubeAttributeDefinitionMap = new ConcurrentHashMap();
    private Server mServer;
    private int mConnectionID = 0;
    private String mServerAdminHost = null;
    private String mServerName = null;
    private String mCAMPassport = null;
    private String mNameSpace = null;
    private String mUserName = null;
    private String mPassword = null;
    private String mSessionProperties = null;
    private SecurityMode mServerSecurityMode = SecurityMode.Basic;
    private String mUserGroups = null;
    private Locale mProductLocale = null;
    private final MetadataCacheContext mMetadataCacheContext;
    private final TM1CubeCache mCubeCache = new TM1CubeCache(this);
    private static final String USE_FILLER_MEMBER = "HierarchyUseFillerMember=1";
    private static final String USE_FILLER_MEMBER_KEY = "queryExecution.hierarchyUseFillerMember[@value]";
    private boolean validationReq = false;
    private final boolean connectToTM1wAsyncTimeout = Boolean.valueOf(this.getDataProvider().getProperty("connectToTM1wAsyncTimeout"));
    private final long connectionEstablishedTimeout = Long.valueOf(this.getDataProvider().getProperty("connectionEstablishedTimeout"));
    boolean bConnectionStatus = true;
    private static final ExecutorService TIMER_SERVICE = Executors.newCachedThreadPool();

    public TM1Connection(TM1DataProvider theDataProvider, ConnectionParameters parameters) {
        super((IOLAPDataProvider)theDataProvider);
        this.setConnectionParameters(parameters);
        this.mConnectionID = System.identityHashCode((Object)this);
        this.mServerName = this.getParameter(TM1ServerNameParameter.class);
        this.mServerAdminHost = this.getParameter(TM1AdminHostParameter.class);
        this.mProductLocale = this.getProductLocale();
        this.mServerSecurityMode = TM1Connection.getStaticTM1ServerSecurityMode(this.mServerAdminHost, this.mServerName, this.mProductLocale);
        this.mNameSpace = this.getParameter(TM1NameSpaceParameter.class);
        this.mMetadataCacheContext = new MetadataCacheContext(this.mCubeCache);
        ExecutionEnvironment env = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (null == env) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
        }
        this.mCAMPassport = ((RequestEnvironment)env.getRequestEnvironment()).getCAMPassport();
        try {
            this.updateConnectionTime();
            this.connect();
            this.updateConnectionTime();
            TM1Log.TM1LogWrapper.log(TM1Log.CONN_LOG_ON_OFF, LogLevel.TRACE, "[CONNECTION_ID=%d] Established a TM1 connection with host [%s], server [%s] and parameters [%s].", this.mConnectionID, this.mServerAdminHost, this.mServerName, parameters.toString());
        }
        catch (TM1Exception e) {
            TM1ODPException providerException = TM1ExceptionConverter.convert(e, this.mServerName);
            switch (e.getErrorCode()) {
                case SystemServerClientNotFound: 
                case SystemServerClientPasswordInvalid: 
                case SystemServerClientPasswordExpired: {
                    TM1Log.TM1LogWrapper.log(TM1Log.CONN_LOG_ON_OFF, LogLevel.ERROR, "[CONNECTION_ID=%d] Failed to establish a TM1 connection with host [%s] and server [%s] - invalid credentials.", this.mConnectionID, this.mServerAdminHost, this.mServerName);
                    IDataSource dataSource = (IDataSource)parameters.valueOf(DataSourceParameter.class, IDataSource.class);
                    IDataSourceConnection dsConnection = dataSource.getDataSourceConnection();
                    dsConnection.invalidateResolvedSignon();
                    throw new LogonFailureException(dataSource, LogonFailureException.SubCodeEnum.INVALID_CREDENTIALS);
                }
                case SystemServerClientExceedMaxLogonNumber: {
                    TM1Log.TM1LogWrapper.log(TM1Log.CONN_LOG_ON_OFF, LogLevel.ERROR, "[CONNECTION_ID=%d] Failed to establish a TM1 connection with host [%s] and server [%s] - max connections.", this.mConnectionID, this.mServerAdminHost, this.mServerName);
                    throw new LogonFailureException(LogonFailureException.SubCodeEnum.MAX_CONNECTIONS, (Throwable)((Object)providerException));
                }
                case ServerNotFound: 
                case SystemServerNotFound: {
                    TM1Log.TM1LogWrapper.log(TM1Log.CONN_LOG_ON_OFF, LogLevel.ERROR, "[CONNECTION_ID=%d] Failed to establish a TM1 connection with host [%s] and server [%s] - invalid server.", this.mConnectionID, this.mServerAdminHost, this.mServerName);
                    throw new LogonFailureException(LogonFailureException.SubCodeEnum.INVALID_SERVER, (Throwable)((Object)providerException));
                }
                case SystemServerConnectionFailed: {
                    TM1Log.TM1LogWrapper.log(TM1Log.CONN_LOG_ON_OFF, LogLevel.ERROR, "[CONNECTION_ID=%d] Failed to establish a TM1 connection with host [%s] and server [%s] - no connection.", this.mConnectionID, this.mServerAdminHost, this.mServerName);
                    throw new LogonFailureException(LogonFailureException.SubCodeEnum.NO_CONNECTION, (Throwable)((Object)providerException));
                }
            }
            TM1Log.TM1LogWrapper.log(TM1Log.CONN_LOG_ON_OFF, LogLevel.ERROR, "[CONNECTION_ID=%d] Failed to establish a TM1 connection with host [%s] and server [%s] - unknown.", this.mConnectionID, this.mServerAdminHost, this.mServerName);
            throw new LogonFailureException(LogonFailureException.SubCodeEnum.UNKNOWN, (Throwable)((Object)providerException));
        }
        if (this.getConnectionBlackListDetails().isEmpty()) {
            this.setTM1ServerUserGroups();
            this.addUserGroups(this.getConnectionParameters());
        }
    }

    public static API getAPI() {
        return TM1DataProvider.getAPI();
    }

    public void close() {
        try {
            if (null != this.mServer) {
                this.mServer.dispose(true);
            }
            this.mServer = null;
        }
        catch (Throwable throwable) {
            this.mServer = null;
            TM1Log.TM1LogWrapper.log(TM1Log.CONN_LOG_ON_OFF, LogLevel.TRACE, "[CONNECTION_ID=%d] Closed a TM1 connection with host [%s] and server [%s].", this.mConnectionID, this.mServerAdminHost, this.mServerName);
            throw throwable;
        }
        TM1Log.TM1LogWrapper.log(TM1Log.CONN_LOG_ON_OFF, LogLevel.TRACE, "[CONNECTION_ID=%d] Closed a TM1 connection with host [%s] and server [%s].", this.mConnectionID, this.mServerAdminHost, this.mServerName);
    }

    private void addHierarchyUseFillerMember() {
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        if (config.getBooleanProperty(USE_FILLER_MEMBER_KEY, false)) {
            this.mSessionProperties = this.mSessionProperties + USE_FILLER_MEMBER;
        }
    }

    protected void connect() throws TM1Exception {
        this.mSessionProperties = "";
        this.addHierarchyUseFillerMember();
        switch (this.mServerSecurityMode) {
            case Basic: {
                this.connectBasic();
                break;
            }
            case CAM: {
                this.connectCAM();
                break;
            }
            case Distributed: {
                this.connectDistributed();
                break;
            }
            case Mixed: {
                this.connectMixed();
                break;
            }
            case WIA: {
                this.connectWIA();
                break;
            }
            default: {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL);
            }
        }
    }

    public final TM1CubeCache getCubeCache() {
        return this.mCubeCache;
    }

    final String getParameter(Class<? extends IConnectionParameter<?>> parameterType) {
        ConnectionParameters parameters = this.getConnectionParameters();
        String value = (String)parameters.valueOf(parameterType, String.class);
        if (value == null || value.length() == 0) {
            value = "";
        }
        return value;
    }

    final Locale getProductLocale() {
        ConnectionParameters parameters = this.getConnectionParameters();
        return (Locale)parameters.valueOf(ProductLocaleParameter.class, Locale.class);
    }

    private void connectBasic() throws TM1Exception {
        this.mUserName = this.getParameter(TM1UserNameParameter.class);
        this.mPassword = this.getParameter(TM1PasswordParameter.class);
        TM1Log.TM1LogWrapper.log(TM1Log.CONN_LOG_ON_OFF, LogLevel.TRACE, "Opening a Basic TM1 connection with host [%s], server [%s], user [%s], locale [%s], and sess_props [%s].", this.mServerAdminHost, this.mServerName, this.mUserName, this.mProductLocale.toString(), this.mSessionProperties);
        if (!this.connectToTM1wAsyncTimeout) {
            this.mServer = TM1Connection.getAPI().logon(this.mServerAdminHost, this.mServerName, this.mUserName, this.mPassword, null, this.mSessionProperties);
        } else {
            this.connectViaSeparateThread();
        }
    }

    private void connectCAM() throws TM1Exception {
        if (this.mCAMPassport.isEmpty()) {
            throw new XQERuntimeException(XQEMessageKeys.WSB_CAM_NEGOTIATION_FAILURE);
        }
        TM1Log.TM1LogWrapper.log(TM1Log.CONN_LOG_ON_OFF, LogLevel.TRACE, "Opening a CAM TM1 connection host [%s], server [%s], CAMPassport [%s], CAFID [%s], locale [%s], and sess_props [%s].", this.mServerAdminHost, this.mServerName, this.mCAMPassport, "", this.mProductLocale.toString(), this.mSessionProperties);
        String cafID = "";
        if (!this.connectToTM1wAsyncTimeout) {
            this.mServer = TM1Connection.getAPI().logonCAM(this.mServerAdminHost, this.mServerName, this.mCAMPassport, "", null, this.mSessionProperties);
        } else {
            this.connectViaSeparateThread();
        }
    }

    private void connectViaSeparateThread() {
        try {
            Future<Object> task = TIMER_SERVICE.submit(new Callable<Object>(){

                @Override
                public Boolean call() throws TM1Exception {
                    TM1Connection.this.callTM1Logon();
                    return null;
                }
            });
            task.get(this.connectionEstablishedTimeout, TimeUnit.MILLISECONDS);
        }
        catch (TM1ODPException e) {
            throw e;
        }
        catch (TimeoutException e) {
            this.bConnectionStatus = false;
            TM1Log.TM1LogWrapper.log(TM1Log.CONN_LOG_ON_OFF, LogLevel.ERROR, "[CONNECTION_ID=%d] Failed to establish a TM1 connection with host [%s] and server [%s]- the timer service timed out for logon.", this.mConnectionID, this.mServerAdminHost, this.mServerName);
            TM1ODPException providerException = new TM1ODPException(TM1MessageKeys.CON_SERVER_NOT_RESPONDING, this.mServerName, this.mServerAdminHost);
            throw new LogonFailureException(LogonFailureException.SubCodeEnum.NO_CONNECTION, (Throwable)((Object)providerException));
        }
        catch (Exception e) {
            TM1Log.TM1LogWrapper.log(TM1Log.CONN_LOG_ON_OFF, LogLevel.ERROR, "[CONNECTION_ID=%d] Failed to establish TM1 connection with host [%s] and server [%s]- the timer service failed for connnection - %s.", this.mConnectionID, this.mServerAdminHost, this.mServerName, e.getLocalizedMessage());
            TM1ODPException providerException = new TM1ODPException(TM1MessageKeys.CON_SERVER_NOT_RESPONDING, this.mServerName, this.mServerAdminHost);
            throw new LogonFailureException(LogonFailureException.SubCodeEnum.UNKNOWN, (Throwable)((Object)providerException));
        }
    }

    private void callTM1Logon() throws TM1Exception {
        switch (this.mServerSecurityMode) {
            case Basic: {
                this.mServer = TM1Connection.getAPI().logon(this.mServerAdminHost, this.mServerName, this.mUserName, this.mPassword, null, this.mSessionProperties);
                break;
            }
            case CAM: {
                String cafID = "";
                this.mServer = TM1Connection.getAPI().logonCAM(this.mServerAdminHost, this.mServerName, this.mCAMPassport, cafID, null, this.mSessionProperties);
                break;
            }
            default: {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL);
            }
        }
        if (!this.bConnectionStatus) {
            this.close();
        }
    }

    private void connectDistributed() throws TM1Exception {
        throw new XQERuntimeException(XQEMessageKeys.GEN_NotYetSupported_INTERNAL, "connectDistributed()");
    }

    private void connectMixed() throws TM1Exception {
        String ssoDelegationHandle = (String)this.getConnectionParameters().valueOf(CAMCryptoHandleParameter.class, String.class);
        if (null != ssoDelegationHandle) {
            TM1Log.TM1LogWrapper.log(TM1Log.CONN_LOG_ON_OFF, LogLevel.TRACE, "Opening a Mixed WIA TM1 connection with host [%s], server [%s], handle [%s], locale [%s], and sess_props [%s].", this.mServerAdminHost, this.mServerName, ssoDelegationHandle, this.mProductLocale.toString(), this.mSessionProperties);
            this.connectWIA();
        } else if (null != this.mNameSpace && 0 != this.mNameSpace.length()) {
            TM1Log.TM1LogWrapper.log(TM1Log.CONN_LOG_ON_OFF, LogLevel.TRACE, "Opening a Mixed WIA TM1 connection with host [%s], server [%s], namespace [%s], locale [%s], and sess_props [%s].", this.mServerAdminHost, this.mServerName, this.mNameSpace, this.mProductLocale.toString(), this.mSessionProperties);
            this.connectWIA();
        } else {
            this.mUserName = this.getParameter(TM1UserNameParameter.class);
            if (null != this.mUserName && this.mUserName.indexOf(92) > 0) {
                TM1Log.TM1LogWrapper.log(TM1Log.CONN_LOG_ON_OFF, LogLevel.TRACE, "Opening a Mixed WIA TM1 connection with host [%s], server [%s], user [%s], locale [%s], and sess_props [%s].", this.mServerAdminHost, this.mServerName, this.mUserName, this.mProductLocale.toString(), this.mSessionProperties);
                this.connectWIA();
            } else {
                TM1Log.TM1LogWrapper.log(TM1Log.CONN_LOG_ON_OFF, LogLevel.TRACE, "Opening a Mixed Basic TM1 connection with host [%s], server [%s], locale [%s], and sess_props [%s].", this.mServerAdminHost, this.mServerName, this.mProductLocale.toString(), this.mSessionProperties);
                this.connectBasic();
            }
        }
    }

    public <T> T invokeNativeCallWithWinImpersonation(Callable<T> task, String domainName, String userName, String password) throws TM1Exception {
        IImpersonator winImpersonater = ImpersonatorFactory.createWinImpersonater((String)domainName, (String)userName, (String)password, (int)Integer.valueOf(LocaleConverter.toLCID((Locale)this.mProductLocale)));
        try {
            Object object = winImpersonater.runPrivilegedTask(task);
            return (T)object;
        }
        catch (TM1Exception ex) {
            throw ex;
        }
        catch (Throwable ex) {
            String errMsg = "Failed to open a WIA TM1 connection with host [%s], server [%s], user [%s], password [%d], locale [%s], and sess_props [%s], ";
            if (0 == this.mPassword.length()) {
                TM1Log.TM1LogWrapper.log(TM1Log.CONN_LOG_ON_OFF, LogLevel.TRACE, errMsg + "missing password.", this.mServerAdminHost, this.mServerName, this.mUserName, this.mPassword.length(), this.mProductLocale.toString(), this.mSessionProperties);
                throw new XQERuntimeException(TM1MessageKeys.CON_SSO_WIA_FAILED_PASSWORD, ex, (Object)this.mServerAdminHost, (Object)this.mServerName, (Object)userName);
            }
            if (0 == domainName.length()) {
                TM1Log.TM1LogWrapper.log(TM1Log.CONN_LOG_ON_OFF, LogLevel.TRACE, errMsg + "missing domain.", this.mServerAdminHost, this.mServerName, this.mUserName, this.mPassword.length(), this.mProductLocale.toString(), this.mSessionProperties);
                throw new XQERuntimeException(TM1MessageKeys.CON_SSO_WIA_FAILED_DOMAIN, ex, (Object)this.mServerAdminHost, (Object)this.mServerName, (Object)userName);
            }
            TM1Log.TM1LogWrapper.log(TM1Log.CONN_LOG_ON_OFF, LogLevel.TRACE, errMsg + "unknown exeception.", this.mServerAdminHost, this.mServerName, this.mUserName, this.mPassword.length(), this.mProductLocale.toString(), this.mSessionProperties);
            throw new XQERuntimeException(TM1MessageKeys.CON_SSO_WIA_FAILED, ex, (Object)this.mServerAdminHost, (Object)this.mServerName, (Object)userName);
        }
        finally {
            winImpersonater.release();
        }
    }

    public <T> T invokeNativeCallWithCAMImpersonation(Callable<T> task, String ssoDelegationHandle) throws TM1Exception {
        IImpersonator camImpersonater = ImpersonatorFactory.createCAMImpersonater((String)ssoDelegationHandle, (int)Integer.valueOf(LocaleConverter.toLCID((Locale)this.mProductLocale)));
        try {
            Object object = camImpersonater.runPrivilegedTask(task);
            return (T)object;
        }
        catch (TM1Exception ex) {
            throw ex;
        }
        catch (Throwable ex) {
            TM1Log.TM1LogWrapper.log(TM1Log.CONN_LOG_ON_OFF, LogLevel.TRACE, "Failed to open a CAM TM1 connection with host [%s], server [%s], unknown exeception.", this.mServerAdminHost, this.mServerName);
            throw new XQERuntimeException(TM1MessageKeys.CON_SSO_CAM_FAILED, ex, (Object)this.mServerAdminHost, (Object)this.mServerName);
        }
        finally {
            camImpersonater.release();
        }
    }

    private void connectWIA() throws TM1Exception {
        String ssoDelegationHandle = (String)this.getConnectionParameters().valueOf(CAMCryptoHandleParameter.class, String.class);
        Callable<Object> logonWIATask = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                TM1Connection.this.mServer = TM1Connection.getAPI().logonWIA(TM1Connection.this.mServerAdminHost, TM1Connection.this.mServerName, null, TM1Connection.this.mSessionProperties);
                return null;
            }
        };
        if (null != ssoDelegationHandle) {
            TM1Log.TM1LogWrapper.log(TM1Log.CONN_LOG_ON_OFF, LogLevel.TRACE, "Opening a WIA TM1 connection with host [%s], server [%s], CAMPassport [%s], locale [%s], and sess_props [%s].", this.mServerAdminHost, this.mServerName, ssoDelegationHandle, this.mProductLocale.toString(), this.mSessionProperties);
            this.invokeNativeCallWithCAMImpersonation(logonWIATask, ssoDelegationHandle);
        } else {
            this.mUserName = this.getParameter(TM1UserNameParameter.class);
            this.mPassword = this.getParameter(TM1PasswordParameter.class);
            String domainName = "";
            String userName = "";
            if (null != this.mUserName) {
                int slashPos = this.mUserName.indexOf(92);
                if (0 < slashPos) {
                    domainName = this.mUserName.substring(0, slashPos);
                }
                userName = this.mUserName.substring(slashPos + 1);
            }
            if (0 == userName.length()) {
                TM1Log.TM1LogWrapper.log(TM1Log.CONN_LOG_ON_OFF, LogLevel.TRACE, "Failed to open a WIA TM1 connection (missing user) with host [%s], server [%s], user [%s], password [%d], locale [%s], and sess_props [%s].", this.mServerAdminHost, this.mServerName, this.mUserName, this.mPassword.length(), this.mProductLocale.toString(), this.mSessionProperties);
                throw new XQERuntimeException(TM1MessageKeys.CON_SSO_WIA_FAILED_USERNAME, (Object)this.mServerAdminHost, (Object)this.mServerName, (Object)userName);
            }
            TM1Log.TM1LogWrapper.log(TM1Log.CONN_LOG_ON_OFF, LogLevel.TRACE, "Opening a WIA TM1 connection with host [%s], server [%s], user [%s], password [%d], locale [%s], and sess_props [%s].", this.mServerAdminHost, this.mServerName, this.mUserName, this.mPassword.length(), this.mProductLocale.toString(), this.mSessionProperties);
            this.invokeNativeCallWithWinImpersonation(logonWIATask, domainName, userName, this.mPassword);
        }
    }

    public Server getServer() {
        return this.mServer;
    }

    public Object[] getContext() {
        return new Object[]{this.mMetadataCacheContext};
    }

    static String getCachedTM1ServerUserGroups(String serverAdminHost, String serverName, String camPassport) {
        String userGroupsKey = String.format(USER_GROUP_KEY, serverAdminHost, serverName, camPassport);
        UserGroupsMap userGroupsMap = (UserGroupsMap)sUserGroupsMapTM1.get((Object)userGroupsKey);
        String userGroups = null;
        if (null != userGroupsMap) {
            userGroups = userGroupsMap.getUserGroups();
        }
        TM1Log.TM1LogWrapper.log(TM1Log.CONN_USER_GROUPS, LogLevel.TRACE, "Cached user groups for the keyed connection [%s] are [%s].", userGroupsKey, userGroups);
        return userGroups;
    }

    private void setTM1ServerUserGroups() {
        if (!this.securityModeHasUserGroups()) {
            this.mUserGroups = null;
        } else {
            this.mUserGroups = TM1Connection.getCachedTM1ServerUserGroups(this.mServerAdminHost, this.mServerName, this.mCAMPassport);
            if (null == this.mUserGroups) {
                String userGroupsKey = String.format(USER_GROUP_KEY, this.mServerAdminHost, this.mServerName, this.mCAMPassport);
                Gate newGate = new Gate();
                newGate.close();
                Gate gate = USER_GROUP_GATE.putIfAbsent(userGroupsKey, newGate);
                if (gate != null) {
                    try {
                        gate.await(10L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.mUserGroups = TM1Connection.getCachedTM1ServerUserGroups(this.mServerAdminHost, this.mServerName, this.mCAMPassport);
                }
                try {
                    if (null == this.mUserGroups) {
                        String[] userGroups = this.mServer.listUserGroups();
                        this.mUserGroups = "";
                        for (int i = 0; userGroups.length > i; ++i) {
                            if (0 < i) {
                                this.mUserGroups = this.mUserGroups + USER_GROUP_SEPARATOR;
                            }
                            this.mUserGroups = this.mUserGroups + userGroups[i];
                        }
                        TM1Log.TM1LogWrapper.log(TM1Log.CONN_USER_GROUPS, LogLevel.TRACE, "New user groups for the keyed connection [%s] are [%s].", userGroupsKey, this.mUserGroups);
                        sUserGroupsMapTM1.putIfAbsent((Object)userGroupsKey, (Object)new UserGroupsMap(this.mUserGroups));
                    }
                }
                catch (TM1Exception e) {
                    TM1Log.TM1LogWrapper.log(TM1Log.CONN_USER_GROUPS, LogLevel.ERROR, "Unable to determine user groups for the keyed connection [%s].", userGroupsKey);
                    throw TM1ExceptionConverter.convert(e, this);
                }
                finally {
                    gate = USER_GROUP_GATE.remove(userGroupsKey);
                    if (gate != null) {
                        gate.open();
                    }
                }
            }
        }
    }

    public static boolean securityModeHasUserGroups(ConnectionParameters parameters) {
        String adminHost = (String)parameters.valueOf(TM1AdminHostParameter.class, String.class);
        String serverName = (String)parameters.valueOf(TM1ServerNameParameter.class, String.class);
        Locale productLocale = (Locale)parameters.valueOf(ProductLocaleParameter.class, Locale.class);
        SecurityMode mode = TM1Connection.getStaticTM1ServerSecurityMode(adminHost, serverName, productLocale);
        return TM1Connection.securityModeHasUserGroups(mode, adminHost, serverName, parameters);
    }

    public boolean securityModeHasUserGroups() {
        return TM1Connection.securityModeHasUserGroups(this.mServerSecurityMode, this.mServerAdminHost, this.mServerName, this.getConnectionParameters());
    }

    private static boolean securityModeHasUserGroups(SecurityMode mode, String adminHost, String serverName, ConnectionParameters parameters) {
        switch (mode) {
            case Basic: {
                TM1Log.TM1LogWrapper.log(TM1Log.CONN_USER_GROUPS, LogLevel.TRACE, "User groups for the host [%s] and server [%s] mode [%s] is not supported.", adminHost, serverName, mode.toString());
                return false;
            }
            case Mixed: {
                String ssoDelegationHandle = (String)parameters.valueOf(CAMCryptoHandleParameter.class, String.class);
                if (ssoDelegationHandle != null) break;
                TM1Log.TM1LogWrapper.log(TM1Log.CONN_USER_GROUPS, LogLevel.TRACE, "User groups for the host [%s] and server [%s] mode [%s] is unsupported.", adminHost, serverName, mode.toString());
                return false;
            }
        }
        TM1Log.TM1LogWrapper.log(TM1Log.CONN_USER_GROUPS, LogLevel.TRACE, "User groups for the host [%s] and server [%s] mode [%s] is supported.", adminHost, serverName, mode.toString());
        return true;
    }

    public boolean isValid() {
        try {
            boolean isValid = null != this.mServer && this.mServer.validateConnection();
            this.validationReq = false;
            return isValid;
        }
        catch (TM1Exception ex) {
            TM1Log.TM1LogWrapper.log(TM1Log.CONN_VALIDATE, LogLevel.ERROR, "[CONNECTION_ID=%d] Validation error with TM1 connection with host [%s] and server [%s].", this.mConnectionID, this.mServerAdminHost, this.mServerName);
            return false;
        }
    }

    public void setValidationOn() {
        this.validationReq = true;
    }

    public boolean needValidation() {
        return this.validationReq;
    }

    public boolean isCubeLoaded() {
        return this.mMetadataCacheContext.isCubeLoaded();
    }

    private static String getServerIdKey(String adminHost, String serverName) {
        return String.format(SERVER_ID_KEY, adminHost, serverName);
    }

    public static SecurityMode getStaticTM1ServerSecurityMode(String adminHost, String serverName, Locale locale) {
        SecurityMode securityMode = SecurityMode.Distributed;
        String adminServerKey = TM1Connection.getServerIdKey(adminHost, serverName);
        SecurityModeMap securityModeMap = (SecurityModeMap)sSecurityModeMapTM1.get(adminServerKey);
        if (null == securityModeMap) {
            Gate newGate = new Gate();
            newGate.close();
            Gate gate = SEC_MODE_GATE.putIfAbsent(adminServerKey, newGate);
            if (gate != null) {
                try {
                    gate.await(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                securityModeMap = (SecurityModeMap)sSecurityModeMapTM1.get(adminServerKey);
            }
            try {
                if (null == securityModeMap) {
                    securityMode = TM1Connection.getAPI().getServerSecurityMode(adminHost, serverName);
                    sSecurityModeMapTM1.putIfAbsent(adminServerKey, new SecurityModeMap(securityMode));
                    TM1Log.TM1LogWrapper.log(TM1Log.CONN_SECURITY_MODE, LogLevel.TRACE, "New security mode for the keyed connection [%s] is [%s].", adminServerKey, securityMode.toString());
                }
            }
            catch (TM1Exception e) {
                TM1Log.TM1LogWrapper.log(TM1Log.CONN_SECURITY_MODE, LogLevel.ERROR, "Unable to determine security mode for the keyed connection [%s].", adminServerKey);
                throw TM1ExceptionConverter.convert(e, adminHost, serverName, locale);
            }
            finally {
                gate = SEC_MODE_GATE.remove(adminServerKey);
                if (gate != null) {
                    gate.open();
                }
            }
        }
        if (null != securityModeMap) {
            securityMode = securityModeMap.getMode();
            TM1Log.TM1LogWrapper.log(TM1Log.CONN_SECURITY_MODE, LogLevel.TRACE, "Cached security mode for the keyed connection [%s] is [%s].", adminServerKey, securityMode.toString());
        }
        return securityMode;
    }

    public UserClassIDsParameter addUserGroups(ConnectionParameters params) {
        UserClassIDsParameter param = null;
        if (null != this.mUserGroups) {
            param = new UserClassIDsParameter(this.mUserGroups);
            params.put((IConnectionParameter)param);
        }
        return param;
    }

    public static UserClassIDsParameter addStaticUserGroups(ConnectionParameters params) {
        ExecutionEnvironment env = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (null == env) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
        }
        String serverAdminHost = (String)params.valueOf(TM1AdminHostParameter.class, String.class);
        String serverName = (String)params.valueOf(TM1ServerNameParameter.class, String.class);
        String camPassport = ((RequestEnvironment)env.getRequestEnvironment()).getCAMPassport();
        String userGroups = TM1Connection.getCachedTM1ServerUserGroups(serverAdminHost, serverName, camPassport);
        UserClassIDsParameter userClassIdsParameter = null;
        if (null == userGroups) {
            IDataProvider provider = ProviderManager.getInstance().getProvider("TM");
            IPooledConnection connection = provider.borrowConnection(params, (IExecutionEnvironment)env);
            TM1Connection tm1Connection = (TM1Connection)((Object)connection.getConnection());
            userClassIdsParameter = tm1Connection.addUserGroups(params);
            connection.returnConnection();
        } else {
            userClassIdsParameter = new UserClassIDsParameter(userGroups);
            params.put((IConnectionParameter)userClassIdsParameter);
        }
        return userClassIdsParameter;
    }

    public static AttributeDefinition getCubeAttributeDefinition(Server server, String attributeName) throws TM1Exception {
        String serverKey = TM1Connection.getServerIdKey(server.getAdminHost(), server.getName());
        AttributeDefinition[] definitions = null;
        if (sCubeAttributeDefinitionMap.containsKey(serverKey)) {
            definitions = sCubeAttributeDefinitionMap.get(serverKey);
        } else {
            definitions = server.listCubeAttributeDefinitions();
            sCubeAttributeDefinitionMap.put(serverKey, definitions);
        }
        for (AttributeDefinition definition : definitions) {
            if (!definition.getName().equalsIgnoreCase(attributeName)) continue;
            return definition;
        }
        return null;
    }

    boolean isServerIn102CompatibilityMode() {
        try {
            AttributeDefinition compatibleAttribute = TM1Connection.getCubeAttributeDefinition(this.getServer(), "CompatibleWithBI10_2GA");
            return compatibleAttribute != null;
        }
        catch (TM1Exception e) {
            TM1Log.TM1LogWrapper.log(TM1Log.CONN_VALIDATE, LogLevel.WARN, "[CONNECTION_ID=%d%s%s%s%s%s%d%s%s%s%s%s", this.mConnectionID, "] TM1 exception while retrieving the cube attribute definitions for host [", this.mServerAdminHost, "] and server [", this.mServerName, "]. Exception is (", e.getErrorCode(), "):(", e.getMessage(), "). The status of the custom cube attribute ", "CompatibleWithBI10_2GA", " will be ignored.");
            return false;
        }
    }

    public String getServerAdminHost() {
        return this.mServerAdminHost;
    }

    public String getServerName() {
        return this.mServerName;
    }

    public Locale getProductLocale1() {
        return this.mProductLocale;
    }

    public List<XQEMessage> getConnectionDetails() {
        return this.checkAndGetDetails("TM1ClientVersion", String.valueOf(TM1Connection.getAPI().getVersion()), "TM1ServerVersion", String.valueOf(this.getServer().getVersion()));
    }

    public List<XQEMessage> getConnectionBlackListDetails() {
        return this.checkAndGetBlackListDetails(String.valueOf(TM1Connection.getAPI().getVersion()), String.valueOf(this.getServer().getVersion()));
    }

    public static enum ServerCapabilities {
        MINIMUM_SUPPORTED_TM1_SERVER_VERSION(90520000),
        BASE_TM1_LOLAP_COMPLIANCE(100110000),
        CONVERT_NULL_CELLS_TO_UNDEF_VALS(90520003);

        private final int mVersion;

        private ServerCapabilities(int minSupportedVersion) {
            this.mVersion = minSupportedVersion;
        }

        public boolean hasCapability(TM1Connection connection) {
            return connection.getServer().getVersion() >= this.mVersion;
        }
    }
}

