/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1;

import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.datasource.ProviderCapabilites;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.CapabilitiesKey;
import com.cognos.xqe.data.model.CapabilitiesKeyParts;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.ConnectionTestQueryArguments;
import com.cognos.xqe.data.providers.connection.ConnectionFactoryStatisticsDecorator;
import com.cognos.xqe.data.providers.connection.parameters.ForceConnectionCreationParameter;
import com.cognos.xqe.data.providers.connection.parameters.UserClassIDsParameter;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.MDXQueryArguments;
import com.cognos.xqe.data.providers.olap.MetadataQueryArguments;
import com.cognos.xqe.data.providers.olap.OLAPDataProviderBase;
import com.cognos.xqe.data.providers.olap.TracingOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.tm1.TM1Connection;
import com.cognos.xqe.data.providers.olap.tm1.TM1ConnectionFactory;
import com.cognos.xqe.data.providers.olap.tm1.TM1Log;
import com.cognos.xqe.data.providers.olap.tm1.TM1MetadataProvider;
import com.cognos.xqe.data.providers.olap.tm1.connection.ConnectionParameterHelper;
import com.cognos.xqe.data.providers.olap.tm1.connection.TM1AdminHostParameter;
import com.cognos.xqe.data.providers.olap.tm1.connection.TM1ConnectionExpirationPolicy;
import com.cognos.xqe.data.providers.olap.tm1.connection.TM1ConnectionSelector;
import com.cognos.xqe.data.providers.olap.tm1.connection.TM1ServerNameParameter;
import com.cognos.xqe.data.providers.olap.tm1.data.TM1CubeResultSet;
import com.cognos.xqe.data.providers.olap.tm1.data.TM1MDXQuery;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1ExceptionConverter;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1Utils;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IAliasEntry;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionFactory;
import com.cognos.xqe.pool.connection.IConnectionParameter;
import com.cognos.xqe.pool.connection.IConnectionPool;
import com.cognos.xqe.pool.connection.IConnectionSelector;
import com.cognos.xqe.pool.connection.IExpirationPolicy;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.ConnectionUtil;
import com.cognos.xqe.util.xml.XMLEscCharacter;
import com.ibm.cognos.tm1.API;
import com.ibm.cognos.tm1.Cellset;
import com.ibm.cognos.tm1.SSLConfig;
import com.ibm.cognos.tm1.TM1Exception;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.XMLBuilderParameters;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.dom4j.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TM1DataProvider
extends OLAPDataProviderBase {
    private static final String INCLUDE_CALCULATED_MEMBERS = "<includeCalculatedMembers value=\"true\"/>";
    private static final String ALIAS_TABLE_MAP = "aliasTableMap";
    private static final String ALIAS_TABLE = "aliasTable";
    private static final String LANG = " lang=";
    private static final String NAME = " name=";
    private static final String CELL_PROPERTY = "<cellProperty";
    private static final String FIRST_CELL_PROPERTY = "<cellProperty name=\"(\\w+)\"/>(\\s*)";
    private static final String FORMAT_STRING_CELL_PROPERTY = "<cellProperty name=(\"FORMAT_STRING\")/>(\\s*)";
    private static final String VALUE = " value=";
    private static final String GT_OPERATOR = ">";
    private static final String LT_OPERATOR = "<";
    private static final String QUOTE = "\"";
    private static final String SLASH = "/";
    private static final String DOT = ".";
    private static final String QFW_EXECUTE_BEGIN = "<execute";
    private static final String QFW_EXECUTE_END = "</execute>";
    private static final String NATIVE_TM1_QUERY = "NativeTM1Query:";
    private static final String QFW_PROD_LOCALE = " productLocale= ";
    private static final String USE_PXJ_THRESHOLD = "UseProviderCrossJoinThreshold";
    private static final String USE_PXJ_THRESHOLD_VALUE = "10000";
    private static final String USE_PXJ_THRESHOLD_KEY = "queryExecution.useProviderCrossJoinThreshold[@value]";
    private static final String CONVERT_NULL_CELLS_TO_UNDEF_VALS = "ConvertNullCellsToUndefVals";
    private static final String FALSE = "false";
    private static final String SSLCONFIG = "sslconfig";
    private static final String SSLCONFIG_ADMINHOST_VALUE = "adminhost.[@value]";
    private static final String SSLCONFIG_CERTIFICATE_AUTHORITY_FILE = "certificateAuthority.[@file]";
    private static final String SSLCONFIG_CERTIFICATE_ID_VALUE = "certificateId.[@value]";
    private static final String SSLCONFIG_CERTIFICATE_REVOCATION_LIST_FILE = "certificateRevocationList.[@file]";
    private static final String PXJ_NOT_SET_MSG = "UseProviderCrossJoinThreshold will not be set on the mdquery.";
    private static final String INITIAL_CONNECTION_EXPIRATION_THRESHOLD = "initialConnectionExpirationThreshold";
    private static final long DEFAULT_INITIAL_CONNECTION_EXPIRATION_THRESHOLD = 10000L;
    public static final int DEFAULT_NGTM1_CONNECTION_EXPIRATION_CHECK_PERIOD = 10000;
    private static final Properties DEFAULT_NGTM1_PROPERTIES = TM1DataProvider.makeDefaultNGTM1Properties();
    private static API mApi = null;
    private static final int BASE_NGMTM1_VERSION_COMPLIANCE = 90500000;
    private static final String TM1_VERSION_10_1_CAPABILITY = "10.1";
    private static final String TM1_VERSION_10_1_1_CAPABILITY = "10.1.1";
    private final TM1ConnectionFactory mTM1ConnectionFactory;
    private final IConnectionFactory mConnectionFactory;

    public TM1DataProvider(String instanceName, Properties properties) {
        super(instanceName, properties, (IConnectionSelector)new TM1ConnectionSelector());
        TM1DataProvider.getAPI();
        this.mTM1ConnectionFactory = new TM1ConnectionFactory(this);
        this.mConnectionFactory = new ConnectionFactoryStatisticsDecorator((IConnectionFactory)this.mTM1ConnectionFactory, instanceName);
    }

    protected Properties getDefaultProperties(Properties properties) {
        Properties defaultProperties = super.getDefaultProperties(properties);
        defaultProperties.putAll((Map<?, ?>)DEFAULT_NGTM1_PROPERTIES);
        return properties;
    }

    protected static Properties makeDefaultNGTM1Properties() {
        Properties properties = new Properties();
        properties.setProperty("connectionExpirationCheckPeriod", Integer.toString(10000));
        properties.setProperty(INITIAL_CONNECTION_EXPIRATION_THRESHOLD, Long.toString(10000L));
        return properties;
    }

    public ICubeResultSet query(XDataContext xDataContext, MDXQueryArguments theQueryArguments) {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)xDataContext.getEnvironment();
        ConnectionParameters connParams = this.createConnectionParameters((IExecutionEnvironment)execEnv, theQueryArguments);
        try {
            IPooledConnection pooledConn = this.borrowConnection(connParams, (IExecutionEnvironment)execEnv);
            TM1Connection tm1Conn = (TM1Connection)((Object)pooledConn.getConnection());
            MDXQuery mdxQuery = theQueryArguments.getMDXQuery();
            boolean nativeQuery = mdxQuery.getMDX().startsWith(NATIVE_TM1_QUERY);
            String queryString = nativeQuery ? mdxQuery.getMDX().replaceFirst(NATIVE_TM1_QUERY, "") : "CognosMDXClient: " + TM1DataProvider.getMDXQueryString(execEnv, tm1Conn, mdxQuery);
            try {
                TM1MDXQuery query = new TM1MDXQuery(tm1Conn, execEnv);
                Cellset cellSet = query.execute(queryString, false);
                return new TM1CubeResultSet(this, pooledConn, cellSet, xDataContext, theQueryArguments);
            }
            catch (TM1Exception ex) {
                pooledConn.returnConnection();
                throw TM1ExceptionConverter.convert(ex, tm1Conn);
            }
            catch (RuntimeException ex) {
                pooledConn.returnConnection();
                throw ex;
            }
        }
        catch (LogonFailureException ex) {
            if (ex.getDataSource() == null) {
                ex.setDataSource(theQueryArguments.getDataSource());
            }
            IDataSource dataSource = theQueryArguments.getDataSource();
            IDataSourceConnection dsConnection = dataSource.getDataSourceConnection();
            dsConnection.invalidateResolvedSignon();
            throw ex;
        }
    }

    protected static String getMDXQueryString(ExecutionEnvironment env, TM1Connection connection, MDXQuery mdxQuery) {
        String pxjThresholdSetting;
        StringBuffer buffer = new StringBuffer();
        buffer.append(QFW_EXECUTE_BEGIN);
        Locale productLocale = ((RequestEnvironment)env.getRequestEnvironment()).getProductLocale();
        if (productLocale != null) {
            buffer.append(QFW_PROD_LOCALE);
            buffer.append(QUOTE);
            buffer.append(productLocale);
            buffer.append(QUOTE);
        }
        buffer.append(GT_OPERATOR);
        String executeQuery = mdxQuery.getMDQuery();
        executeQuery = executeQuery.replaceAll("<suppress>\\s*<suppressNone/>\\s*</suppress>\\s*", "");
        if (executeQuery.contains(CELL_PROPERTY) && executeQuery.contains("FORMAT_STRING")) {
            executeQuery = executeQuery.replaceFirst(FORMAT_STRING_CELL_PROPERTY, "<cellProperty name=\"TM1FORMAT_STRING\"/>$2\t<cellProperty name=$1/>$2");
        }
        if (executeQuery.contains(CELL_PROPERTY) && !executeQuery.contains("CELL_ORDINAL")) {
            executeQuery = executeQuery.replaceFirst(FIRST_CELL_PROPERTY, "<cellProperty name=\"($1)\"/>$2<cellProperty name=\"CELL_ORDINAL\"/>$2");
        }
        buffer.append(executeQuery);
        if (mdxQuery.getIncludeCalculatedMembers()) {
            buffer.append(INCLUDE_CALCULATED_MEMBERS);
        }
        Locale runLocale = ((RequestEnvironment)env.getRequestEnvironment()).getRunLocale();
        List aliasTable = mdxQuery.getAliasTable();
        if (aliasTable != null) {
            buffer.append(LT_OPERATOR);
            buffer.append(ALIAS_TABLE_MAP);
            buffer.append(GT_OPERATOR);
            for (IAliasEntry entry : aliasTable) {
                String key = entry.getKey();
                if (!key.equals(runLocale.getLanguage())) continue;
                buffer.append(LT_OPERATOR);
                buffer.append(ALIAS_TABLE);
                buffer.append(LANG);
                buffer.append(QUOTE);
                buffer.append(entry.getKey());
                buffer.append(QUOTE);
                buffer.append(NAME);
                buffer.append(QUOTE);
                buffer.append(XMLEscCharacter.escapeString((String)entry.getValue()));
                buffer.append(QUOTE);
                buffer.append(SLASH);
                buffer.append(GT_OPERATOR);
            }
            buffer.append(LT_OPERATOR);
            buffer.append(SLASH);
            buffer.append(ALIAS_TABLE_MAP);
            buffer.append(GT_OPERATOR);
        }
        if (mdxQuery.getNullExpressionBehavior() != null) {
            buffer.append(LT_OPERATOR);
            buffer.append("nullExpressionBehavior");
            buffer.append(VALUE);
            buffer.append(QUOTE);
            buffer.append(mdxQuery.getNullExpressionBehavior().toString());
            buffer.append(QUOTE);
            buffer.append(SLASH);
            buffer.append(GT_OPERATOR);
        }
        if ((pxjThresholdSetting = TM1DataProvider.getPXJThresholdValue(mdxQuery, executeQuery)) != null) {
            buffer.append(LT_OPERATOR);
            buffer.append(USE_PXJ_THRESHOLD);
            buffer.append(VALUE);
            buffer.append(QUOTE);
            buffer.append(pxjThresholdSetting);
            buffer.append(QUOTE);
            buffer.append(SLASH);
            buffer.append(GT_OPERATOR);
        }
        if (TM1Connection.ServerCapabilities.CONVERT_NULL_CELLS_TO_UNDEF_VALS.hasCapability(connection)) {
            buffer.append(LT_OPERATOR);
            buffer.append(CONVERT_NULL_CELLS_TO_UNDEF_VALS);
            buffer.append(VALUE);
            buffer.append(QUOTE);
            buffer.append(FALSE);
            buffer.append(QUOTE);
            buffer.append(SLASH);
            buffer.append(GT_OPERATOR);
        }
        buffer.append(QFW_EXECUTE_END);
        return buffer.toString();
    }

    private static String getPXJThresholdValue(MDXQuery mdxQuery, String mdquery) {
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        Boolean pxjEnabledProperty = mdxQuery.getBooleanPropertyValue("PXJEnabled");
        if (pxjEnabledProperty != null) {
            if (pxjEnabledProperty.booleanValue()) {
                String pxjSetting = config.getStringProperty(USE_PXJ_THRESHOLD_KEY, USE_PXJ_THRESHOLD_VALUE);
                if (TM1Log.DATA_SUPPRESS_PXJ.isOn(LogLevel.INFO)) {
                    StringBuilder sb = new StringBuilder("PXJEnabled is set to \"true\" on the MDXQuery node. ");
                    sb.append("Setting UseProviderCrossJoinThreshold on the mdquery to ").append(pxjSetting).append(DOT);
                    TM1Log.DATA_SUPPRESS_PXJ.log(LogLevel.INFO, sb.toString());
                }
                return pxjSetting;
            }
            TM1Log.DATA_SUPPRESS_PXJ.log(LogLevel.TRACE, "PXJEnabled is set to \"false\" on the MDXQuery node. UseProviderCrossJoinThreshold will not be set on the mdquery.");
            return null;
        }
        if (Boolean.FALSE.equals(mdxQuery.getNullSuppressionQueryHint())) {
            TM1Log.DATA_SUPPRESS_PXJ.log(LogLevel.TRACE, "The property 'nullSuppressionAcrossEdges' is set to \"false\" on the MDXQuery node. UseProviderCrossJoinThreshold will not be set on the mdquery.");
            return null;
        }
        String pxjThresholdSetting = config.getStringProperty(USE_PXJ_THRESHOLD_KEY, null);
        if (pxjThresholdSetting == null) {
            if (TM1Log.DATA_SUPPRESS_PXJ.isOn(LogLevel.TRACE)) {
                StringBuilder sb = new StringBuilder("There is no entry for ").append(USE_PXJ_THRESHOLD_KEY);
                sb.append(" in XQE's configuration file. ").append(PXJ_NOT_SET_MSG);
                TM1Log.DATA_SUPPRESS_PXJ.log(LogLevel.TRACE, sb.toString());
            }
            return null;
        }
        if (!mdquery.contains("<suppressNulls")) {
            TM1Log.DATA_SUPPRESS_PXJ.log(LogLevel.TRACE, "There is no <suppressNulls/> clause in the mdquery. UseProviderCrossJoinThreshold will not be set on the mdquery.");
            return null;
        }
        if (TM1Log.DATA_SUPPRESS_PXJ.isOn(LogLevel.INFO)) {
            StringBuilder sb = new StringBuilder(USE_PXJ_THRESHOLD);
            sb.append(" will be set to ").append(pxjThresholdSetting).append(" on the mdquery.");
            TM1Log.DATA_SUPPRESS_PXJ.log(LogLevel.INFO, sb.toString());
        }
        return pxjThresholdSetting;
    }

    public ConnectionParameters createConnectionParameters(IExecutionEnvironment env, MDXQueryArguments queryArgs) {
        return TM1DataProvider.createConnectionParams(env, queryArgs);
    }

    protected static ConnectionParameters createConnectionParams(ConnectionTestQueryArguments args) {
        ExecutionEnvironment env = (ExecutionEnvironment)args.getExecutionEnvironment();
        Element connectionElement = env.getConnectionElement();
        return ConnectionParameterHelper.constructConnectionParameters(env, connectionElement, args.getDataSource(), args.getRunLocale());
    }

    protected static ConnectionParameters createConnectionParams(IExecutionEnvironment env, MDXQueryArguments args) {
        Element connectionElement = env.getConnectionElement();
        return ConnectionParameterHelper.constructConnectionParameters((ExecutionEnvironment)env, connectionElement, args.getDataSource(), args.getRunLocale());
    }

    protected static ConnectionParameters createConnectionParams(MetadataQueryArguments args) {
        ExecutionEnvironment env = (ExecutionEnvironment)args.getExecutionEnvironment();
        Element connectionElement = env.getConnectionElement();
        return ConnectionParameterHelper.constructConnectionParameters(env, connectionElement, args.getDataSource(), args.getDesignLocale());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<XQEMessage> testConnection(ConnectionTestQueryArguments theQueryArguments) {
        List<XQEMessage> connectionDetails = null;
        TM1Connection connection = null;
        try {
            connection = (TM1Connection)((Object)this.mTM1ConnectionFactory.createConnection(TM1DataProvider.createConnectionParams(theQueryArguments)));
            connectionDetails = connection.getConnectionDetails();
            this.mTM1ConnectionFactory.destroyConnection(connection);
        }
        catch (Throwable throwable) {
            this.mTM1ConnectionFactory.destroyConnection(connection);
            throw throwable;
        }
        return connectionDetails;
    }

    public IOLAPMetadataProvider getMetadataProvider(MetadataQueryArguments theQueryArguments) {
        IDataSource dataSource = theQueryArguments.getDataSource();
        Locale metadataLocale = theQueryArguments.getDesignLocale();
        try {
            TM1MetadataProvider provider = new TM1MetadataProvider(this, dataSource, metadataLocale, TM1DataProvider.createConnectionParams(theQueryArguments));
            provider = new TracingOLAPMetadataProvider((IOLAPMetadataProvider)provider, "NGTM1");
            return provider;
        }
        catch (LogonFailureException e) {
            if (e.getDataSource() == null) {
                e.setDataSource(theQueryArguments.getDataSource());
            }
            throw e;
        }
    }

    public IConnectionFactory getConnectionFactory() {
        return this.mConnectionFactory;
    }

    public IExpirationPolicy getConnectionExpirationPolicy() {
        int connectionExpirationThreshold = this.getIntegerProperty("connectionExpirationThreshold", 300, false);
        long connectionLifetimeThreshold = this.getLongProperty("connectionLifetimeThreshold", 0L, false);
        long initialConnectionExpirationThreshold = this.getLongProperty(INITIAL_CONNECTION_EXPIRATION_THRESHOLD, 10000L, false);
        return new TM1ConnectionExpirationPolicy(connectionLifetimeThreshold, connectionExpirationThreshold, initialConnectionExpirationThreshold);
    }

    public IConnectionSelector getConnectionSelector(String providerType, Object securityContext) {
        return this.selector;
    }

    public IPooledConnection borrowConnection(ConnectionParameters connectionParameters, IExecutionEnvironment executionEnvironment) {
        if (null == executionEnvironment) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
        }
        boolean forcingNewConnection = false;
        if (TM1Connection.securityModeHasUserGroups(connectionParameters)) {
            String serverName;
            String camPassport = executionEnvironment.getRequestEnvironment().getCAMPassport();
            String adminHost = (String)connectionParameters.valueOf(TM1AdminHostParameter.class, String.class);
            String cachedUserGroups = TM1Connection.getCachedTM1ServerUserGroups(adminHost, serverName = (String)connectionParameters.valueOf(TM1ServerNameParameter.class, String.class), camPassport);
            if (null == cachedUserGroups) {
                connectionParameters.put((IConnectionParameter)new ForceConnectionCreationParameter());
                forcingNewConnection = true;
            } else {
                connectionParameters.put((IConnectionParameter)new UserClassIDsParameter(cachedUserGroups));
            }
        }
        IConnectionPool pool = executionEnvironment.getConnectionPool();
        String providerName = this.getProviderInstanceName();
        IConnectionFactory factory = this.getConnectionFactory();
        IPooledConnection pooledConnection = null;
        TM1Connection connection = null;
        boolean connectionNotFound = true;
        while (connectionNotFound) {
            pooledConnection = pool.borrowConnection(providerName, connectionParameters, this.selector, factory);
            connection = (TM1Connection)((Object)pooledConnection.getConnection());
            boolean isValid = true;
            boolean validationExecuted = false;
            if (connection.needValidation()) {
                isValid = connection.isValid();
                validationExecuted = true;
            }
            Integer connectionId = System.identityHashCode((Object)connection);
            if (!isValid) {
                connection.invalidate();
                connection.returnToPool();
                TM1Log.TM1LogWrapper.log(TM1Log.CONN_SELECTOR, LogLevel.WARN, "[CONNECTION_ID=%d] Validation failed connnect invalidated", connectionId);
                continue;
            }
            connectionNotFound = false;
            if (!validationExecuted) continue;
            TM1Log.TM1LogWrapper.log(TM1Log.CONN_SELECTOR, LogLevel.INFO, "[CONNECTION_ID=%d] Validation passed connnect validated", connectionId);
        }
        connection.setPooledConnection(pooledConnection);
        if (forcingNewConnection) {
            connectionParameters.remove(ForceConnectionCreationParameter.class);
        }
        return pooledConnection;
    }

    protected void releaseImpl() {
        boolean doNothing = true;
        if (doNothing) {
            return;
        }
        if (null != mApi) {
            mApi.dispose();
        }
        mApi = null;
        TM1Log.TM1LogWrapper.log(TM1Log.INIT_TERM_TM1PROVIDER, LogLevel.WARN, "Disposed the NGTM1 Java API.", new Object[0]);
    }

    protected static API getAPI() {
        if (null == mApi) {
            mApi = TM1DataProvider.initializeNGTM1API();
        }
        return mApi;
    }

    private static API initializeNGTM1API() {
        API api = null;
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        String binPath = config == null ? DOT : config.getBinDirectory();
        try {
            api = SystemUtils.IS_OS_WINDOWS ? API.initialize((String)binPath, (int)90500000, (String)"-a ngtm1ca.dll") : API.initialize((String)binPath, (int)90500000, (String)"-a libngtm1ca.so");
            TM1DataProvider.applyTM1SSLConfigOptions(api);
            TM1Log.TM1LogWrapper.log(TM1Log.INIT_TERM_TM1PROVIDER, LogLevel.WARN, "Initialized the NGTM1 Java API. Client version is %d.", api.getVersion());
        }
        catch (TM1Exception e) {
            TM1Log.TM1LogWrapper.log(TM1Log.INIT_TERM_TM1PROVIDER, LogLevel.ERROR, e, "Failed to initialize the NGTM1 Java API. TM1 error was: ", new Object[0]);
            throw TM1ExceptionConverter.convert(e);
        }
        catch (Throwable e) {
            TM1Log.TM1LogWrapper.log(TM1Log.INIT_TERM_TM1PROVIDER, LogLevel.ERROR, e, "Failed to initialize the NGTM1 Java API. Error was: ", new Object[0]);
            throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, e);
        }
        return api;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void applyTM1SSLConfigOptions(API api) throws TM1Exception {
        XQEConfigurationManager configManager = XQEConfigurationManager.getInstance();
        XQEConfiguration config = configManager.getConfiguration(ServiceEnumeration.XQEODP);
        if (config == null) {
            return;
        }
        File configDir = new File(config.getConfigDirectory());
        File sslConfigFile = new File(configDir, "tm1.sslconfigs.xml");
        if (!sslConfigFile.canRead()) {
            TM1Log.TM1LogWrapper.log(TM1Log.INIT_TERM_TM1PROVIDER, LogLevel.WARN, sslConfigFile.getPath() + " cannot be read, skipping TM1 SSL configuration.", new Object[0]);
            return;
        }
        XMLConfiguration sslconfigs = null;
        Parameters params = new Parameters();
        DocumentBuilder docBuilder = TM1DataProvider.getDocumentBuilder(configDir);
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(XMLConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((XMLBuilderParameters)((XMLBuilderParameters)params.xml().setFileName(sslConfigFile.getPath())).setSchemaValidation(true)).setDocumentBuilder(docBuilder)});
        try {
            sslconfigs = (XMLConfiguration)builder.getConfiguration();
        }
        catch (ConfigurationException cex) {
            XQERuntimeException xqeException = (XQERuntimeException)cex.getCause();
            TM1Log.TM1LogWrapper.log(TM1Log.INIT_TERM_TM1PROVIDER, LogLevel.WARN, "Configuration exception reading %s. Error was: \n%s", sslConfigFile.getPath(), xqeException.getCause().getMessage());
            throw xqeException;
        }
        List sslconfig = sslconfigs.configurationsAt(SSLCONFIG);
        for (HierarchicalConfiguration c : sslconfig) {
            String adminhost = c.getString(SSLCONFIG_ADMINHOST_VALUE, "");
            String ca = c.getString(SSLCONFIG_CERTIFICATE_AUTHORITY_FILE, "");
            String id = c.getString(SSLCONFIG_CERTIFICATE_ID_VALUE, "");
            String rl = c.getString(SSLCONFIG_CERTIFICATE_REVOCATION_LIST_FILE, "");
            if (!new File(ca).canRead()) {
                TM1Log.TM1LogWrapper.log(TM1Log.INIT_TERM_TM1PROVIDER, LogLevel.WARN, "Invalid config parameter: %s (File containing TM1 SSL certificate authority cannot be read.)", ca);
                continue;
            }
            if (!StringUtils.isEmpty((String)rl) && !new File(rl).canRead()) {
                TM1Log.TM1LogWrapper.log(TM1Log.INIT_TERM_TM1PROVIDER, LogLevel.WARN, "Invalid config parameter: %s (File containing TM1 SSL certificate revocation list cannot be read.)", rl);
                continue;
            }
            SSLConfig sslConfig = null;
            try {
                sslConfig = SSLConfig.createSSLConfig((String)ca, (String)id, (String)rl);
                api.setSSLConfig(adminhost, sslConfig);
            }
            catch (Throwable throwable) {
                TM1Log.TM1LogWrapper.log(TM1Log.INIT_TERM_TM1PROVIDER, LogLevel.INFO, "NGAPI SSLConfig adminhost:%s ca:%s id:%s rl:%s", adminhost, ca, id, rl);
                TM1Utils.disposeQuietly(sslConfig);
                throw throwable;
            }
            TM1Log.TM1LogWrapper.log(TM1Log.INIT_TERM_TM1PROVIDER, LogLevel.INFO, "NGAPI SSLConfig adminhost:%s ca:%s id:%s rl:%s", adminhost, ca, id, rl);
            TM1Utils.disposeQuietly(sslConfig);
        }
    }

    private static DocumentBuilder getDocumentBuilder(File configDir) {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        SchemaFactory xsdFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        File xsdConfigFile = new File(configDir, "tm1.sslconfigs.xsd");
        try {
            Schema schema = xsdFactory.newSchema(xsdConfigFile);
            factory.setSchema(schema);
            builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException ex) throws SAXException {
                    throw new XQERuntimeException((Throwable)ex);
                }

                @Override
                public void fatalError(SAXParseException ex) throws SAXException {
                    throw new XQERuntimeException((Throwable)ex);
                }

                @Override
                public void warning(SAXParseException ex) throws SAXException {
                    throw new XQERuntimeException((Throwable)ex);
                }
            });
        }
        catch (ParserConfigurationException e) {
            throw new XQERuntimeException((Throwable)e);
        }
        catch (SAXException e) {
            throw new XQERuntimeException((Throwable)e);
        }
        return builder;
    }

    public void resolveDataSourceCapabilities(IExecutionEnvironment executionEnv, IDataSource dataSource, Locale designLocale) {
        boolean bDataBaseOnly;
        MetadataQueryArguments queryArgs = new MetadataQueryArguments(dataSource, executionEnv, designLocale);
        ConnectionParameters connParams = TM1DataProvider.createConnectionParams(queryArgs);
        IPooledConnection pooledConnection = this.borrowConnection(connParams, executionEnv);
        TM1Connection connection = (TM1Connection)((Object)pooledConnection.getConnection());
        String version = null;
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        boolean compatibilityModeOverride = false;
        if (config != null) {
            compatibilityModeOverride = config.getBooleanProperty("TM1_102CompatibilityMode", false);
        }
        boolean bl = bDataBaseOnly = executionEnv.getMultiRequestContext().getRequestProcessing() == MultiRequestContext.RequestProcessing.DATABASEONLY;
        version = TM1Connection.ServerCapabilities.BASE_TM1_LOLAP_COMPLIANCE.hasCapability(connection) ? (connection.isServerIn102CompatibilityMode() || compatibilityModeOverride || bDataBaseOnly ? TM1_VERSION_10_1_CAPABILITY : TM1_VERSION_10_1_1_CAPABILITY) : TM1_VERSION_10_1_CAPABILITY;
        connection = null;
        pooledConnection.returnConnection();
        CapabilitiesKey key = new CapabilitiesKey(null, version, null, ConnectionUtil.getConnectionString((IDataSource)dataSource));
        IDataSourceCapabilities dataSourceCapabilities = ProviderCapabilites.getInstance().getCapabilities(key);
        dataSource.setCapabilities(dataSourceCapabilities);
        if (null == dataSourceCapabilities) {
            dataSourceCapabilities = dataSource.createCapabilities(new CapabilitiesKeyParts(version), null);
            ProviderCapabilites.getInstance().addCapabilities(key, dataSourceCapabilities);
        }
    }

    public Object getCubeUniqueId(ConnectionParameters params, MDXQueryArguments args) {
        TM1AdminHostParameter adminHost = (TM1AdminHostParameter)params.get(TM1AdminHostParameter.class);
        if (adminHost != null) {
            TM1ServerNameParameter server = (TM1ServerNameParameter)params.get(TM1ServerNameParameter.class);
            String cubeName = args.getCube().getName();
            LinkedList<Object> key = new LinkedList<Object>();
            key.add(adminHost.value());
            key.add(server.value());
            key.add(cubeName);
            return key;
        }
        return null;
    }

    public Object getSecurityContext(ConnectionParameters params) {
        if (TM1Connection.securityModeHasUserGroups(params)) {
            return TM1Connection.addStaticUserGroups(params);
        }
        return null;
    }
}

