/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1;

import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.olap.common.CAMPassportParameter;
import com.cognos.xqe.data.providers.connection.parameters.CatalogParameter;
import com.cognos.xqe.data.providers.connection.parameters.CubeParameter;
import com.cognos.xqe.data.providers.connection.parameters.RunLocaleParameter;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.MetadataOperation;
import com.cognos.xqe.data.providers.olap.MetadataProviderEnvironmentHelper;
import com.cognos.xqe.data.providers.olap.OLAPDataProviderBase;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.olap.cache.CacheParameters;
import com.cognos.xqe.data.providers.olap.securecache.SALContext;
import com.cognos.xqe.data.providers.olap.tm1.TM1Connection;
import com.cognos.xqe.data.providers.olap.tm1.TM1DataProvider;
import com.cognos.xqe.data.providers.olap.tm1.connection.TM1UserNameParameter;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1MetadataSession;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1ExceptionConverter;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.record.ActionRecord;
import com.cognos.xqe.metadata.record.AliasRecord;
import com.cognos.xqe.metadata.record.CatalogRecord;
import com.cognos.xqe.metadata.record.CubeRecord;
import com.cognos.xqe.metadata.record.DimensionRecord;
import com.cognos.xqe.metadata.record.HierarchyRecord;
import com.cognos.xqe.metadata.record.LevelRecord;
import com.cognos.xqe.metadata.record.MacroRecord;
import com.cognos.xqe.metadata.record.MeasureRecord;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.metadata.record.NamedSetRecord;
import com.cognos.xqe.metadata.record.PropertyRecord;
import com.cognos.xqe.metadata.record.VariableRecord;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionParameter;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.ibm.cognos.tm1.TM1Exception;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringEscapeUtils;

public class TM1MetadataProvider
extends MetadataProviderEnvironmentHelper<TM1Connection>
implements IOLAPMetadataProvider {
    private final IDataSource mDataSource;
    private final Locale mLocale;
    private static EnumSet<RestrictionType> sPrepareRestrictionSet = EnumSet.of(RestrictionType.CUBE, new RestrictionType[]{RestrictionType.DIMENSION_UNIQUE_NAME, RestrictionType.HIERARCHY_UNIQUE_NAME, RestrictionType.LEVEL_UNIQUE_NAME, RestrictionType.MEASURE_UNIQUE_NAME, RestrictionType.MEMBER_UNIQUE_NAME});

    public TM1MetadataProvider(TM1DataProvider tm1DataProvider, IDataSource dataSource, Locale locale, ConnectionParameters connParams) {
        super((OLAPDataProviderBase)tm1DataProvider, connParams);
        this.mDataSource = dataSource;
        this.mLocale = locale;
    }

    public CacheParameters getCacheParameters(IRestrictions restrictions) {
        IConnectionParameter param;
        String catalogName = (String)restrictions.getTypedValueOf(RestrictionType.CATALOG, String.class);
        String cubeName = (String)restrictions.getTypedValueOf(RestrictionType.CUBE, String.class);
        ConnectionParameters connParams = this.connectionParameters.duplicate();
        connParams.remove(CatalogParameter.class);
        connParams.remove(CubeParameter.class);
        CacheParameters cacheParams = new CacheParameters();
        cacheParams.put(connParams);
        if (null != catalogName) {
            cacheParams.put("catalog", (Object)catalogName);
        }
        if (null != cubeName) {
            cacheParams.put("cube", (Object)cubeName);
        }
        if ((param = connParams.get(RunLocaleParameter.class)) != null) {
            cacheParams.put(param);
        }
        return cacheParams;
    }

    public List<ActionRecord> getActions(IRestrictions restrictions) {
        if (!this.isRestrictionContainsCatalog(restrictions)) {
            restrictions.add(RestrictionType.CATALOG, (Object)"CATALOG");
        }
        TM1MetadataProvider.validateRequiredRestrictions((MetadataOperation)MetadataOperation.ACTIONS, (IRestrictions)restrictions);
        this.prepareRestrictions(restrictions);
        return Collections.emptyList();
    }

    protected List<AliasRecord> getAliases(ExecutionEnvironment executionEnvironment, TM1Connection connection, IRestrictions restrictions) {
        if (!this.isRestrictionContainsCatalog(restrictions)) {
            restrictions.add(RestrictionType.CATALOG, (Object)"CATALOG");
        }
        TM1MetadataProvider.validateRequiredRestrictions((MetadataOperation)MetadataOperation.ALIASES, (IRestrictions)restrictions);
        this.prepareRestrictions(restrictions);
        try {
            TM1MetadataSession handler = new TM1MetadataSession(connection, this.mLocale, executionEnvironment);
            return handler.getAliasRecords(restrictions);
        }
        catch (TM1Exception e) {
            throw TM1ExceptionConverter.convert(e, connection);
        }
    }

    protected List<CatalogRecord> getCatalogs(ExecutionEnvironment executionEnvironment, TM1Connection connection, IRestrictions restrictions) {
        TM1MetadataProvider.validateRequiredRestrictions((MetadataOperation)MetadataOperation.CATALOGS, (IRestrictions)restrictions);
        this.prepareRestrictions(restrictions);
        try {
            TM1MetadataSession handler = new TM1MetadataSession(connection, this.mLocale, executionEnvironment);
            return handler.getCatalogRecords(restrictions);
        }
        catch (TM1Exception e) {
            throw TM1ExceptionConverter.convert(e, connection);
        }
    }

    protected List<CubeRecord> getCubes(ExecutionEnvironment executionEnvironment, TM1Connection connection, IRestrictions restrictions) {
        if (!this.isRestrictionContainsCatalog(restrictions)) {
            restrictions.add(RestrictionType.CATALOG, (Object)"CATALOG");
        }
        TM1MetadataProvider.validateRequiredRestrictions((MetadataOperation)MetadataOperation.CUBES, (IRestrictions)restrictions);
        this.prepareRestrictions(restrictions);
        try {
            TM1MetadataSession handler = new TM1MetadataSession(connection, this.mLocale, executionEnvironment);
            return handler.getCubeRecords(restrictions);
        }
        catch (TM1Exception e) {
            throw TM1ExceptionConverter.convert(e, connection);
        }
    }

    protected String getCubeDefaultMeasure(ExecutionEnvironment executionEnvironment, TM1Connection connection, IRestrictions restrictions) {
        if (!this.isRestrictionContainsCatalog(restrictions)) {
            restrictions.add(RestrictionType.CATALOG, (Object)"CATALOG");
        }
        TM1MetadataProvider.validateRequiredRestrictions((MetadataOperation)MetadataOperation.CUBEDEFAULTMEASURE, (IRestrictions)restrictions);
        this.prepareRestrictions(restrictions);
        try {
            TM1MetadataSession handler = new TM1MetadataSession(connection, this.mLocale, executionEnvironment);
            return handler.getCubeDefaultMeasure(restrictions);
        }
        catch (TM1Exception e) {
            throw TM1ExceptionConverter.convert(e, connection);
        }
    }

    protected List<DimensionRecord> getDimensions(ExecutionEnvironment executionEnvironment, TM1Connection connection, IRestrictions restrictions) {
        if (!this.isRestrictionContainsCatalog(restrictions)) {
            restrictions.add(RestrictionType.CATALOG, (Object)"CATALOG");
        }
        TM1MetadataProvider.validateRequiredRestrictions((MetadataOperation)MetadataOperation.DIMENSIONS, (IRestrictions)restrictions);
        this.prepareRestrictions(restrictions);
        try {
            TM1MetadataSession handler = new TM1MetadataSession(connection, this.mLocale, executionEnvironment);
            return handler.getDimensionRecords(restrictions);
        }
        catch (TM1Exception e) {
            throw TM1ExceptionConverter.convert(e, connection);
        }
    }

    protected List<HierarchyRecord> getHierarchies(ExecutionEnvironment executionEnvironment, TM1Connection connection, IRestrictions restrictions) {
        if (!this.isRestrictionContainsCatalog(restrictions)) {
            restrictions.add(RestrictionType.CATALOG, (Object)"CATALOG");
        }
        TM1MetadataProvider.validateRequiredRestrictions((MetadataOperation)MetadataOperation.HIERARCHIES, (IRestrictions)restrictions);
        this.prepareRestrictions(restrictions);
        try {
            TM1MetadataSession handler = new TM1MetadataSession(connection, this.mLocale, executionEnvironment);
            return handler.getHierarchyRecords(restrictions);
        }
        catch (TM1Exception e) {
            throw TM1ExceptionConverter.convert(e, connection);
        }
    }

    protected List<MemberRecord> getHierarchyRootMembers(ExecutionEnvironment executionEnvironment, TM1Connection connection, IRestrictions restrictions) {
        if (!this.isRestrictionContainsCatalog(restrictions)) {
            restrictions.add(RestrictionType.CATALOG, (Object)"CATALOG");
        }
        TM1MetadataProvider.validateRequiredRestrictions((MetadataOperation)MetadataOperation.HIERARCHYROOTMEMBERS, (IRestrictions)restrictions);
        this.prepareRestrictions(restrictions);
        try {
            TM1MetadataSession handler = new TM1MetadataSession(connection, this.mLocale, executionEnvironment);
            return handler.getHierarchyRootMemberRecords(restrictions);
        }
        catch (TM1Exception e) {
            throw TM1ExceptionConverter.convert(e, connection);
        }
    }

    public List<MemberRecord> getHierarchyCalculatedMembers(IRestrictions restrictions) {
        return Collections.emptyList();
    }

    protected List<LevelRecord> getLevels(ExecutionEnvironment executionEnvironment, TM1Connection connection, IRestrictions restrictions) {
        if (!this.isRestrictionContainsCatalog(restrictions)) {
            restrictions.add(RestrictionType.CATALOG, (Object)"CATALOG");
        }
        TM1MetadataProvider.validateRequiredRestrictions((MetadataOperation)MetadataOperation.LEVELS, (IRestrictions)restrictions);
        this.prepareRestrictions(restrictions);
        try {
            TM1MetadataSession handler = new TM1MetadataSession(connection, this.mLocale, executionEnvironment);
            return handler.getLevelRecords(restrictions);
        }
        catch (TM1Exception e) {
            throw TM1ExceptionConverter.convert(e, connection);
        }
    }

    public List<MacroRecord> getMacros(IRestrictions restrictions) {
        return Collections.emptyList();
    }

    protected List<MeasureRecord> getMeasures(ExecutionEnvironment executionEnvironment, TM1Connection connection, IRestrictions restrictions) {
        if (!this.isRestrictionContainsCatalog(restrictions)) {
            restrictions.add(RestrictionType.CATALOG, (Object)"CATALOG");
        }
        TM1MetadataProvider.validateRequiredRestrictions((MetadataOperation)MetadataOperation.MEASURES, (IRestrictions)restrictions);
        this.prepareRestrictions(restrictions);
        try {
            TM1MetadataSession handler = new TM1MetadataSession(connection, this.mLocale, executionEnvironment);
            return handler.getMeasureRecords(restrictions);
        }
        catch (TM1Exception e) {
            throw TM1ExceptionConverter.convert(e, connection);
        }
    }

    protected List<MemberRecord> getMembers(ExecutionEnvironment executionEnvironment, TM1Connection connection, IRestrictions restrictions) {
        if (!this.isRestrictionContainsCatalog(restrictions)) {
            restrictions.add(RestrictionType.CATALOG, (Object)"CATALOG");
        }
        TM1MetadataProvider.validateRequiredRestrictions((MetadataOperation)MetadataOperation.MEMBERS, (IRestrictions)restrictions);
        this.prepareRestrictions(restrictions);
        String mun = (String)restrictions.getValueOf(RestrictionType.MEMBER_UNIQUE_NAME, null);
        EnumSet treeOps = (EnumSet)restrictions.getValueOf(RestrictionType.TREEOP);
        if (mun == null && treeOps != null && !treeOps.isEmpty()) {
            throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionMissing, RestrictionType.MEMBER_UNIQUE_NAME.toString());
        }
        try {
            TM1MetadataSession handler = new TM1MetadataSession(connection, this.mLocale, executionEnvironment);
            return handler.getMemberRecords(restrictions);
        }
        catch (TM1Exception e) {
            throw TM1ExceptionConverter.convert(e, connection);
        }
    }

    private boolean isRestrictionContainsCatalog(IRestrictions restrictions) {
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG, null);
        return catalogName == null;
    }

    public List<NamedSetRecord> getNamedSets(IRestrictions restrictions) {
        return Collections.emptyList();
    }

    public List<MemberRecord> getNamedSetMembers(IRestrictions restrictions) {
        return Collections.emptyList();
    }

    public List<String> getNamedSetLevelUniqueNames(IRestrictions restrictions) {
        return Collections.emptyList();
    }

    protected List<PropertyRecord> getProperties(ExecutionEnvironment executionEnvironment, TM1Connection connection, IRestrictions restrictions) {
        if (!this.isRestrictionContainsCatalog(restrictions)) {
            restrictions.add(RestrictionType.CATALOG, (Object)"CATALOG");
        }
        TM1MetadataProvider.validateRequiredRestrictions((MetadataOperation)MetadataOperation.PROPERTIES, (IRestrictions)restrictions);
        this.prepareRestrictions(restrictions);
        try {
            TM1MetadataSession handler = new TM1MetadataSession(connection, this.mLocale, executionEnvironment);
            return handler.getPropertyRecords(restrictions);
        }
        catch (TM1Exception e) {
            throw TM1ExceptionConverter.convert(e, connection);
        }
    }

    public List<VariableRecord> getVariables(IRestrictions restrictions) {
        return Collections.emptyList();
    }

    public List<String> getDatasourceLocales(IRestrictions restrictions) {
        return Collections.emptyList();
    }

    public void releaseImpl() {
    }

    public SALContext getMetadataQueryContext(ExecutionEnvironment theEexecutionEnvironment, TM1Connection connection, String userId, MetadataOperation opType, short securityContextMode, IRestrictions restrictions) {
        String securityContext = null;
        ConnectionParameters connParams = connection.getConnectionParameters();
        String dim = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME, null);
        TM1UserNameParameter userNameParam = (TM1UserNameParameter)connParams.get(TM1UserNameParameter.class);
        String uId = null;
        if (userNameParam != null) {
            uId = (String)userNameParam.value();
        }
        if (uId == null) {
            CAMPassportParameter paramCamPassport = (CAMPassportParameter)connParams.get(CAMPassportParameter.class);
            uId = (String)paramCamPassport.value();
        }
        String userGroupList = uId;
        if (connection.securityModeHasUserGroups()) {
            userGroupList = (String)connection.addUserGroups(connParams).value();
        }
        int secContexMode3 = 3;
        securityContext = securityContextMode == 3 ? (dim == null ? uId : (userGroupList != null ? userGroupList : uId)) : (securityContextMode == 2 ? (userGroupList != null ? userGroupList : uId) : uId);
        return new SALContext(securityContext, null, null);
    }

    public boolean isReplacementVariableUsedFor(IRestrictions restrictions) {
        return false;
    }

    private void prepareRestrictions(IRestrictions restrictions) {
        for (RestrictionType restrictionType : sPrepareRestrictionSet) {
            String restriction = (String)restrictions.getValueOf(restrictionType);
            if (restriction == null) continue;
            restrictions.add(restrictionType, (Object)StringEscapeUtils.unescapeXml((String)restriction));
        }
    }
}

