/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1;

import com.cognos.xqe.data.providers.olap.tm1.TM1Connection;
import com.cognos.xqe.data.providers.olap.tm1.TM1Log;
import com.cognos.xqe.trace.LogLevel;

class UserGroupsMap {
    private static final long DUMP_USER_GROUP_STAT_PERIOD = 10000L;
    private static long mDumpTime = System.currentTimeMillis();
    private int mReferenced = 0;
    private String mUserGroups;
    private long mCreateTime;
    private long mLastTime;

    UserGroupsMap(String userGroups) {
        this.mUserGroups = userGroups;
        this.mLastTime = this.mCreateTime = System.currentTimeMillis();
    }

    String getUserGroups() {
        ++this.mReferenced;
        this.mLastTime = System.currentTimeMillis();
        this.dump(this.mLastTime);
        return this.mUserGroups;
    }

    private void dump(long currentTime) {
        if (TM1Log.CONN_USER_GROUPS_STATS.isOn(LogLevel.INFO) && currentTime - mDumpTime >= 10000L) {
            mDumpTime = currentTime;
            StringBuilder sb = new StringBuilder("Statistics for cached TM1 user groups...");
            for (String key : TM1Connection.sSecurityModeMapTM1.keySet()) {
                UserGroupsMap userGroups = (UserGroupsMap)TM1Connection.sUserGroupsMapTM1.get((Object)key);
                if (null == userGroups) continue;
                sb.append("\n CreateTime:");
                sb.append(currentTime - userGroups.mCreateTime);
                sb.append(" LastTime:");
                sb.append(currentTime - userGroups.mLastTime);
                sb.append(" Referenced:");
                sb.append(userGroups.mReferenced);
                sb.append(" Key:");
                sb.append(key);
                sb.append(" UserGroups:");
                sb.append(userGroups.mUserGroups);
            }
            TM1Log.CONN_USER_GROUPS_STATS.log(LogLevel.INFO, sb.toString());
        }
    }
}

