/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.connection;

import com.cognos.xqe.data.providers.olap.tm1.TM1Connection;
import com.cognos.xqe.pool.connection.DefaultExpirationPolicy;
import com.cognos.xqe.pool.connection.IExpirationPolicy;
import com.cognos.xqe.pool.connection.IPooledConnection;

public class TM1ConnectionExpirationPolicy
extends DefaultExpirationPolicy {
    private final long mInitialExpirationThreshold;

    public TM1ConnectionExpirationPolicy(long lifetimeExpirationThreshold, long idleExpirationThreshold, long initialExpirationThreshold) {
        super(lifetimeExpirationThreshold, idleExpirationThreshold);
        this.mInitialExpirationThreshold = initialExpirationThreshold;
    }

    public IExpirationPolicy.ExpirationResponse canExpire(IPooledConnection pooledConnection) {
        IExpirationPolicy.ExpirationResponse parentPolicyResponse = super.canExpire(pooledConnection);
        if (!parentPolicyResponse.equals((Object)IExpirationPolicy.ExpirationResponse.DO_NOTHING)) {
            return parentPolicyResponse;
        }
        TM1Connection tm1Connection = (TM1Connection)((Object)pooledConnection.getConnection());
        if (this.mInitialExpirationThreshold > 0L && !tm1Connection.isCubeLoaded() && pooledConnection.idleSince(System.currentTimeMillis() - this.mInitialExpirationThreshold)) {
            return IExpirationPolicy.ExpirationResponse.RELEASE_IF_IDLE;
        }
        return IExpirationPolicy.ExpirationResponse.DO_NOTHING;
    }
}

