/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.data;

import com.cognos.xqe.data.providers.olap.tm1.data.TM1FormatInfo;
import com.cognos.xqe.format.FormatPropertyDefinition;
import com.cognos.xqe.format.FormatPropertySet;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.format.FormatServiceUtils;
import com.cognos.xqe.format.XQEFormatService;
import com.cognos.xqe.format.string.FormatParserType;
import com.cognos.xqe.format.string.IFormatInfo;
import com.cognos.xqe.format.string.IFormatParser;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import java.util.GregorianCalendar;
import java.util.Locale;

@Deprecated
public class TM1CellFormatParser
implements IFormatParser {
    private static final String SEMICOLON = ";";
    private static final String POUND = "#";
    private static final String PERCENT = "%";
    protected static final String STR_CONST = "const";
    private static final String STR_TM1_FORMAT_STRING_CURRENCY = "\\$#,###";
    private static final String STR_TM1_FORMAT_STRING_FIXED = "0";
    private static final String STR_TM1_FORMAT_STRING_COMMA = "#,##0";
    private static final String STR_TM1_FORMAT_STRING_NUMBER = "#0";
    private static final String STR_TM1_FORMAT_STRING_SCIENTIFIC = "E+##";
    protected static final String STR_TM1_FORMAT_STRING_DATE_DDDD_MMMM_DD_YYYY = "dddd, mmmm dd, yyyy";
    protected static final String STR_TM1_FORMAT_STRING_DATE_MMMM_DD_YYYY = "mmmm dd, yyyy";
    protected static final String STR_TM1_FORMAT_STRING_DATE_DDDD_DD_MMMM_YYYY = "dddd, dd mmmm, yyyy";
    protected static final String STR_TM1_FORMAT_STRING_DATE_DD_MMMM_YYYY = "dd mmmm, yyyy";
    protected static final String STR_TM1_FORMAT_STRING_TIME_H_NN_SS_AMPM = "h:nn:ss AMPM";
    protected static final String STR_TM1_FORMAT_STRING_TIME_HH_NN_SS_AMPM = "hh:nn:ss AMPM";
    protected static final String STR_TM1_FORMAT_STRING_TIME_H_NN_SS = "h:nn:ss";
    protected static final String STR_TM1_FORMAT_STRING_TIME_HH_NN_SS = "hh:nn:ss";
    private static final String SHORT = "short";
    private static final String MEDIUM = "medium";
    private static final String LONG = "long";
    private static final String FULL = "full";
    private static final String MONTH_DAY_YEAR = "MDY";
    private static final String DAY_MONTH_YEAR = "DMY";
    private static final String TWO_DIGITS = "2-digits";
    private static final String ONE_DIGIT = "1-digit";
    private static final String TWELVE_HOUR = "12-hour";
    private static final String TWENTY_FOUR_HOUR = "24-hour";
    private static final String STR_START_PAREN = "(";
    protected static final String STR_EMPTY_PARENTHESES = "()";
    private static final int MILLISECONDS_PER_DAY = 86400000;
    private static final int DAYS_FROM_1900_TO_UTC = 25567;
    private static final int HUNDRED = 100;
    private static final int THOUSAND = 1000;
    private static final int TEN_THOUSAND = 10000;
    private static final double THOUSAND_DOUBLE = 1000.0;
    private static final double TWENTY_FOUR = 24.0;
    private static final double SIXTY = 60.0;
    private static final String LOGMSG_CANNOT_PARSE_STRING = "Could not parse String object ";
    protected final FormatService mService;

    public TM1CellFormatParser(FormatService service) {
        this.mService = service;
    }

    public Object getFormatCacheKey(IFormatInfo info, Locale locale) {
        boolean isValid = null != info;
        return FormatServiceUtils.generateFormatCacheKey((FormatParserType)FormatParserType.TM1, (boolean)isValid, (IFormatInfo)info, (Locale)locale);
    }

    public FormatPropertySet parseFormat(IFormatInfo info, Locale locale) throws Exception {
        XQELogger tm1Logger = XQEFormatService.FSLOGGER_STRING_PARSING;
        if (null == info) {
            return null;
        }
        TM1FormatInfo tm1Info = (TM1FormatInfo)info;
        String tm1FormatString = tm1Info.getFormatString();
        if (tm1Logger.isOn(LogLevel.TRACE)) {
            tm1Logger.log(LogLevel.TRACE, " tm1FormatString " + tm1FormatString);
        }
        FormatPropertySet set = new FormatPropertySet(this.mService);
        String positiveString = "";
        String negativeString = "";
        int semicolonPos = tm1FormatString.indexOf(SEMICOLON);
        positiveString = semicolonPos != -1 ? tm1FormatString.substring(0, semicolonPos) : tm1FormatString;
        if (semicolonPos != -1) {
            int negStringStartPoint = semicolonPos + 1;
            negativeString = (semicolonPos = tm1FormatString.indexOf(SEMICOLON, negStringStartPoint)) != -1 ? tm1FormatString.substring(negStringStartPoint, semicolonPos) : tm1FormatString.substring(negStringStartPoint);
        }
        if (positiveString.startsWith(STR_CONST)) {
            set.setFormatType("numberFormat");
        } else if (positiveString.startsWith(STR_TM1_FORMAT_STRING_CURRENCY)) {
            set.setFormatType("currencyFormat");
            set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"useGrouping", (Object)true));
            this.addDecimalSizeProperty(positiveString, set);
        } else if (positiveString.startsWith(STR_TM1_FORMAT_STRING_FIXED)) {
            set.setFormatType("numberFormat");
            set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"useGrouping", (Object)false));
            this.addDecimalSizeProperty(positiveString, set);
        } else if (positiveString.startsWith(STR_TM1_FORMAT_STRING_NUMBER)) {
            set.setFormatType("numberFormat");
            this.addDecimalSizeProperty(positiveString, set);
        } else if (positiveString.startsWith(STR_TM1_FORMAT_STRING_COMMA)) {
            set.setFormatType("numberFormat");
            set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"useGrouping", (Object)true));
            this.addDecimalSizeProperty(positiveString, set);
        } else if (positiveString.startsWith(POUND) && positiveString.endsWith(PERCENT)) {
            set.setFormatType("percentFormat");
            set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"useGrouping", (Object)false));
            this.addDecimalSizeProperty(positiveString, set);
        } else if (positiveString.startsWith(POUND) && positiveString.endsWith(STR_TM1_FORMAT_STRING_SCIENTIFIC)) {
            set.setFormatType("numberFormat");
            set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"useScientific", (Object)true));
            this.addDecimalSizeProperty(positiveString, set);
        } else if (positiveString.startsWith(STR_TM1_FORMAT_STRING_DATE_DDDD_MMMM_DD_YYYY)) {
            this.setDateProperties(set, FULL, MONTH_DAY_YEAR, TWO_DIGITS);
        } else if (positiveString.startsWith(STR_TM1_FORMAT_STRING_DATE_MMMM_DD_YYYY)) {
            this.setDateProperties(set, LONG, MONTH_DAY_YEAR, TWO_DIGITS);
        } else if (positiveString.startsWith(STR_TM1_FORMAT_STRING_DATE_DDDD_DD_MMMM_YYYY)) {
            this.setDateProperties(set, FULL, DAY_MONTH_YEAR, TWO_DIGITS);
        } else if (positiveString.startsWith(STR_TM1_FORMAT_STRING_DATE_DD_MMMM_YYYY)) {
            this.setDateProperties(set, LONG, DAY_MONTH_YEAR, TWO_DIGITS);
        } else if (positiveString.startsWith(STR_TM1_FORMAT_STRING_TIME_H_NN_SS_AMPM)) {
            this.setTimeProperties(set, true, false, ONE_DIGIT, TWELVE_HOUR);
        } else if (positiveString.startsWith(STR_TM1_FORMAT_STRING_TIME_HH_NN_SS_AMPM)) {
            this.setTimeProperties(set, true, false, TWO_DIGITS, TWELVE_HOUR);
        } else if (positiveString.startsWith(STR_TM1_FORMAT_STRING_TIME_H_NN_SS)) {
            this.setTimeProperties(set, false, false, ONE_DIGIT, TWENTY_FOUR_HOUR);
        } else if (positiveString.startsWith(STR_TM1_FORMAT_STRING_TIME_HH_NN_SS)) {
            this.setTimeProperties(set, false, false, TWO_DIGITS, TWENTY_FOUR_HOUR);
        }
        if (negativeString.length() > 0 && negativeString.startsWith(STR_START_PAREN)) {
            set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"sign", (Object)STR_EMPTY_PARENTHESES));
        }
        if (set.getFormatTypeName() != null) {
            String localeStr = null;
            localeStr = locale.getCountry().length() > 0 ? String.format("%s-%s", locale.getLanguage(), locale.getCountry().toLowerCase()) : locale.getLanguage();
            set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"xml:lang", (Object)localeStr));
        }
        return set;
    }

    private int determineDecimalPlacesTM1(String format) {
        int decimalPos = format.indexOf(".");
        if (decimalPos == -1) {
            return 0;
        }
        int firstZeroPos = format.indexOf(STR_TM1_FORMAT_STRING_FIXED, decimalPos);
        if (firstZeroPos != -1) {
            String tempString = format.substring(firstZeroPos + 1);
            int firstNonZeroPos = tempString.lastIndexOf(STR_TM1_FORMAT_STRING_FIXED) + firstZeroPos + 2;
            if (firstNonZeroPos == -1) {
                return format.length() - firstZeroPos;
            }
            if (firstNonZeroPos == format.length() || firstNonZeroPos < format.length() && format.substring(firstNonZeroPos, firstNonZeroPos + 1).compareTo(POUND) != 0) {
                return firstNonZeroPos - firstZeroPos;
            }
        }
        return -1;
    }

    private void addDecimalSizeProperty(String decimalFormatString, FormatPropertySet set) {
        int decimalPlaces = this.determineDecimalPlacesTM1(decimalFormatString);
        if (decimalPlaces != -1) {
            set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"decimalSize", (Object)decimalPlaces));
        }
    }

    private void setDateProperties(FormatPropertySet set, String style, String displayOrder, String showDays) {
        set.setFormatType("dateFormat");
        set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"dateStyle", (Object)style));
        set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"displayOrder", (Object)displayOrder));
        set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"showDays", (Object)showDays));
    }

    private void setTimeProperties(FormatPropertySet set, boolean showAmPm, boolean showTimeZone, String showHours, String clock) {
        boolean showMinutes = true;
        boolean showSeconds = true;
        boolean showMilliseconds = false;
        set.setFormatType("timeFormat");
        set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"showAmPm", (Object)showAmPm));
        set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"showTimeZone", (Object)showTimeZone));
        set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"showHours", (Object)showHours));
        set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"showMinutes", (Object)showMinutes));
        set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"showSeconds", (Object)showSeconds));
        set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"showMilliseconds", (Object)showMilliseconds));
        set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"clock", (Object)clock));
    }

    public static int convertTM1DateTimeToNumericDate(Locale runLocale, double tm1DateTime) {
        double newTime = (tm1DateTime - 25567.0 - 2.0) * 8.64E7;
        GregorianCalendar calendar = new GregorianCalendar(runLocale);
        calendar.setTimeInMillis((long)newTime);
        int numDate = calendar.get(1) * 1000;
        numDate += (calendar.get(2) + 1) * 100;
        return numDate += calendar.get(5);
    }

    public static int convertTM1DateTimeToNumericTime(double tm1DateTime) {
        double tmp = tm1DateTime;
        Integer itmp = (int)tm1DateTime;
        tmp -= (double)itmp.intValue();
        int hour = (int)Math.floor(tmp *= 24.0);
        tmp = (tmp - (double)hour) * 60.0;
        int minute = (int)Math.floor(tmp);
        tmp = (tmp - (double)minute) * 60.0;
        int second = (int)Math.floor(tmp);
        tmp = (tmp - (double)hour) * 1000.0;
        int numTime = hour * 10000 + minute * 100 + second;
        return numTime;
    }
}

