/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.data;

import com.cognos.xqe.data.providers.ProviderCellBase;
import com.cognos.xqe.data.providers.ProviderCellIteratorBase;
import com.cognos.xqe.data.providers.ProviderResultSetBase;
import com.cognos.xqe.data.providers.olap.tm1.data.TM1CellFormatParser;
import com.cognos.xqe.data.providers.olap.tm1.data.TM1CellsetFields;
import com.cognos.xqe.data.providers.olap.tm1.data.TM1CubeResultSet;
import com.cognos.xqe.data.providers.olap.tm1.data.TM1FormatInfo;
import com.cognos.xqe.data.providers.olap.tm1.util.ITM1RowsetView;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1ExceptionConverter;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1RowsetAccessor;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1Utils;
import com.cognos.xqe.data.types.BooleanType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.DoubleType;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.data.types.LongType;
import com.cognos.xqe.data.types.StringType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.format.string.IFormatInfo;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.runtree.XDataContext;
import com.ibm.cognos.tm1.CellStatus;
import com.ibm.cognos.tm1.Cellset;
import com.ibm.cognos.tm1.FieldType;
import com.ibm.cognos.tm1.Rowset;
import com.ibm.cognos.tm1.TM1Exception;

public class TM1CellIterator
extends ProviderCellIteratorBase {
    private final Cellset mCellset;
    private final ITM1RowsetView<TM1CellsetFields> mAccessor;
    private boolean mHasNext = false;
    private ProviderCellBase mNextCell = null;

    public TM1CellIterator(TM1CubeResultSet rs, Cellset cellset, XDataContext xDataContext, Integer nodeId) throws TM1Exception {
        super((ProviderResultSetBase)rs, xDataContext, nodeId);
        try {
            this.mCellset = cellset;
            this.mCellset.reset();
            this.mAccessor = TM1RowsetAccessor.create((Rowset)this.mCellset, TM1CellsetFields.class);
            this.fetchNext();
        }
        catch (TM1Exception ex) {
            super.release();
            throw ex;
        }
        catch (RuntimeException ex) {
            super.release();
            throw ex;
        }
    }

    private boolean fetchNext() throws TM1Exception {
        this.mHasNext = false;
        this.mNextCell = null;
        block8: while (this.mCellset.getNext()) {
            long rule;
            CellStatus status = this.mCellset.getCellStatus();
            Value value = null;
            if (CellStatus.Null == status) continue;
            FormatId formatId = FormatId.INVALID_FORMAT_FID;
            String tempSting = null;
            try {
                tempSting = this.mAccessor.getStringField(TM1CellsetFields.TM1FORMAT_STRING);
            }
            catch (Exception ex) {
                tempSting = null;
            }
            if (null == tempSting || tempSting.isEmpty()) {
                tempSting = this.mAccessor.getStringField(TM1CellsetFields.FORMAT_STRING);
            }
            String formatString = tempSting;
            FieldType fieldType = this.mAccessor.getFieldType(TM1CellsetFields.VALUE);
            long cellOrdinal = this.mAccessor.getIntegerField(TM1CellsetFields.CELL_ORDINAL);
            FormatService service = FormatService.getInstance();
            TM1FormatInfo info = new TM1FormatInfo(formatString);
            formatId = service.registerTM1CellFormat((IFormatInfo)info, this.getFormatLocale());
            if (CellStatus.Data == status) {
                switch (fieldType) {
                    case Boolean: {
                        BooleanType dataType = DataTypeFactory.getBooleanType();
                        value = (Value)dataType.createValue();
                        value.set(this.mAccessor.getBooleanField(TM1CellsetFields.VALUE));
                        break;
                    }
                    case Double: {
                        double tempValue = this.mAccessor.getDoubleField(TM1CellsetFields.VALUE);
                        String formatTypeName = service.getFormatTypeName(formatId);
                        if (formatId != null && formatTypeName.compareTo("dateFormat") == 0) {
                            int date = TM1CellFormatParser.convertTM1DateTimeToNumericDate(this.getFormatLocale(), tempValue);
                            IntegerType dataType = DataTypeFactory.getIntegerType();
                            value = (Value)dataType.createValue();
                            value.set(date);
                            break;
                        }
                        if (formatId != null && formatTypeName.compareTo("timeFormat") == 0) {
                            int time = TM1CellFormatParser.convertTM1DateTimeToNumericTime(tempValue);
                            IntegerType dataType = DataTypeFactory.getIntegerType();
                            value = (Value)dataType.createValue();
                            value.set(time);
                            break;
                        }
                        DoubleType dataType = DataTypeFactory.getDoubleType();
                        value = (Value)dataType.createValue();
                        value.set(tempValue);
                        break;
                    }
                    case Integer: {
                        LongType dataType = DataTypeFactory.getLongType();
                        value = (Value)dataType.createValue();
                        value.set(this.mAccessor.getIntegerField(TM1CellsetFields.VALUE));
                        break;
                    }
                    case String: {
                        String strValue = this.mAccessor.getStringField(TM1CellsetFields.VALUE);
                        if (TM1Utils.isNullString(strValue) || TM1Utils.isEmptyString(strValue)) continue block8;
                        if (TM1Utils.isErrorString(strValue)) {
                            StringType dataType = DataTypeFactory.getStringType();
                            value = (Value)dataType.createValue();
                            value.setState(ValueState.ERROR);
                            break;
                        }
                        if (TM1Utils.isDivZeroString(strValue)) {
                            DoubleType dataType = DataTypeFactory.getDoubleType();
                            value = (Value)dataType.createValue();
                            value.setState(ValueState.DIV_BY_ZERO);
                            break;
                        }
                        if (TM1Utils.isZeroNumberString(strValue)) {
                            DoubleType dataType = DataTypeFactory.getDoubleType();
                            value = (Value)dataType.createValue();
                            value.set(0.0);
                            value.setState(ValueState.OK);
                            break;
                        }
                        StringType dataType = DataTypeFactory.getStringType();
                        value = (Value)dataType.createValue();
                        value.set(strValue);
                        break;
                    }
                    default: {
                        StringType dataType = DataTypeFactory.getStringType();
                        value = (Value)dataType.createValue();
                        value.setState(ValueState.ERROR);
                        break;
                    }
                }
            } else {
                StringType dataType = DataTypeFactory.getStringType();
                value = (Value)dataType.createValue();
                value.setState(ValueState.ERROR);
            }
            value.setFormatId(formatId);
            this.mNextCell = new ProviderCellBase(cellOrdinal, (IValue)value);
            if (this.mAccessor.containsField(TM1CellsetFields.TM1RULEDERIVED) && (rule = this.mAccessor.getIntegerField(TM1CellsetFields.TM1RULEDERIVED)) != 0L) {
                this.mNextCell.setCellProperty(TM1CellsetFields.TM1RULEDERIVED.getFieldName(), (Object)rule);
                if (value.isOK()) {
                    value.setState(ValueState.CALC);
                }
            }
            this.mHasNext = true;
            break;
        }
        return this.mHasNext;
    }

    public ICell nextImpl() {
        if (this.mHasNext) {
            ProviderCellBase result = this.mNextCell;
            this.currentOrdinal = result.getOrdinal();
            try {
                this.fetchNext();
            }
            catch (TM1Exception ex) {
                throw TM1ExceptionConverter.convert(ex);
            }
            return result;
        }
        return null;
    }

    public boolean hasNext() {
        return this.mHasNext;
    }

    public void releaseImpl() {
    }
}

