/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.data;

import com.cognos.xqe.data.providers.DataProviderBase;
import com.cognos.xqe.data.providers.IProviderContextContainer;
import com.cognos.xqe.data.providers.ProviderResultSetBase;
import com.cognos.xqe.data.providers.olap.DefaultConnection;
import com.cognos.xqe.data.providers.olap.MDXQueryArguments;
import com.cognos.xqe.data.providers.olap.tm1.TM1Connection;
import com.cognos.xqe.data.providers.olap.tm1.TM1DataProvider;
import com.cognos.xqe.data.providers.olap.tm1.data.TM1AxisIterator;
import com.cognos.xqe.data.providers.olap.tm1.data.TM1CellIterator;
import com.cognos.xqe.data.providers.olap.tm1.data.TM1ScrollableCellIterator;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1ExceptionConverter;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.provider.Member;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.XScrollableCellIterator;
import com.cognos.xqe.runtree.XScrollableIterator;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.ibm.cognos.tm1.Axis;
import com.ibm.cognos.tm1.Cellset;
import com.ibm.cognos.tm1.Rowset;
import com.ibm.cognos.tm1.TM1Exception;
import java.util.HashMap;
import java.util.Map;

public class TM1CubeResultSet
extends ProviderResultSetBase
implements ICubeResultSet,
IProviderContextContainer {
    private final IPooledConnection mPooledConnection;
    private final Cellset mCellset;
    private final Axis[] mAxes;
    private int numAxes;
    private final ICube mModelCube;
    private final int mSlicerAxisOrdinal;
    private final Map<String, Member> mMemberCache = new HashMap<String, Member>();

    public TM1CubeResultSet(TM1DataProvider provider, IPooledConnection pooledConnection, Cellset cellset, XDataContext xDataContext, MDXQueryArguments queryArguments) {
        super((DataProviderBase)provider, xDataContext, queryArguments.getRunLocale());
        this.mPooledConnection = pooledConnection;
        this.mCellset = cellset;
        this.mAxes = cellset.getAxes();
        this.mModelCube = queryArguments.getCube();
        int numRequestedEdges = queryArguments.getMDXQuery().getNumberOfEdges();
        this.numAxes = this.mAxes[this.mAxes.length - 1].getDimensionNames().length == 0 ? this.mAxes.length - 1 : this.mAxes.length;
        this.mSlicerAxisOrdinal = this.numAxes > numRequestedEdges ? --this.numAxes : -1;
    }

    Cellset getCellset() {
        return this.mCellset;
    }

    Axis[] getAxes() {
        return this.mAxes;
    }

    public ICube getCube() {
        return this.mModelCube;
    }

    public XIterator getAxisIterator(int axisNumber) {
        try {
            return new TM1AxisIterator(this, this.mAxes[axisNumber], this.getDataContext(), this.nodeId);
        }
        catch (TM1Exception ex) {
            throw TM1ExceptionConverter.convert(ex, (TM1Connection)((Object)this.mPooledConnection.getConnection()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAxisSize(int axisNumber) {
        long l;
        Rowset rs = this.mAxes[axisNumber].getTupleRowset(new String[0]);
        try {
            l = rs.getCount();
        }
        catch (Throwable throwable) {
            try {
                rs.dispose();
                throw throwable;
            }
            catch (TM1Exception ex) {
                throw TM1ExceptionConverter.convert(ex, (TM1Connection)((Object)this.mPooledConnection.getConnection()));
            }
        }
        rs.dispose();
        return l;
    }

    public XCellIterator getCellIterator() {
        try {
            return new TM1CellIterator(this, this.mCellset, this.getDataContext(), this.nodeId);
        }
        catch (TM1Exception ex) {
            throw TM1ExceptionConverter.convert(ex, (TM1Connection)((Object)this.mPooledConnection.getConnection()));
        }
    }

    public IDimension[] getDimensions(int axisNumber) {
        String[] dimNames = this.mAxes[axisNumber].getDimensionNames();
        IDimension[] cubeDimensions = new IDimension[dimNames.length];
        for (int i = 0; i < dimNames.length; ++i) {
            String dimName = dimNames[i];
            cubeDimensions[i] = this.mModelCube.getDimension(UniqueNameGenerator.createSingleNamePart((String)dimName));
        }
        return cubeDimensions;
    }

    public int getNumAxes() {
        return this.numAxes;
    }

    public int getNumDataItemForSummary(int rowsetId) {
        return 0;
    }

    public int getNumTabularMeasures() {
        return 0;
    }

    public XScrollableIterator getScrollableAxisIterator(int axisNumber) {
        throw new UnsupportedOperationException();
    }

    public XScrollableCellIterator getScrollableCellIterator() {
        try {
            return new TM1ScrollableCellIterator(this, this.mCellset, this.getDataContext(), this.nodeId);
        }
        catch (TM1Exception ex) {
            throw TM1ExceptionConverter.convert(ex, (TM1Connection)((Object)this.mPooledConnection.getConnection()));
        }
    }

    public ITuple getSlicer() {
        if (-1 == this.mSlicerAxisOrdinal) {
            return null;
        }
        XIterator axisIter = this.getAxisIterator(this.mSlicerAxisOrdinal);
        try {
            ITuple iTuple = (ITuple)axisIter.next();
            return iTuple;
        }
        finally {
            axisIter.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseImpl() {
        try {
            try {
                for (Axis a : this.mAxes) {
                    a.dispose();
                }
                this.mCellset.dispose();
            }
            finally {
                this.mPooledConnection.returnConnection();
                this.mMemberCache.clear();
            }
        }
        finally {
            super.releaseImpl();
        }
    }

    void putCachedMember(Member member) {
        this.mMemberCache.put(member.getUniqueName(), member);
    }

    Member getCachedMember(String mun) {
        return this.mMemberCache.get(mun);
    }

    public Object[] getContext() {
        DefaultConnection connection = (DefaultConnection)this.mPooledConnection.getConnection();
        return connection.getContext();
    }
}

