/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.data;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.providers.olap.tm1.TM1Connection;
import com.cognos.xqe.data.providers.olap.tm1.TM1Log;
import com.cognos.xqe.data.providers.olap.tm1.data.TM1ViewLogger;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.ExceptionUtil;
import com.ibm.cognos.tm1.AsyncJob;
import com.ibm.cognos.tm1.Cellset;
import com.ibm.cognos.tm1.StateType;
import com.ibm.cognos.tm1.TM1Exception;

public class TM1MDXQuery {
    private static final int RECOVERABLE_CANCEL_MIN_CLIENT_VERSION = 90520100;
    private static final int RECOVERABLE_CANCEL_MIN_SERVER_VERSION = 90520100;
    private static final int QUERY_WAIT_TIME = 20;
    private static final int MAX_CANCEL_WAIT_TIME = 30000;
    private static final int FIRST_CANCEL_WAIT_TIME = 100;
    private static final int CANCEL_WAIT_INCREMENT_FACTOR = 2;
    private final TM1Connection mConnection;
    private final ExecutionEnvironment mEnvironment;

    public TM1MDXQuery(TM1Connection connection, ExecutionEnvironment environment) {
        this.mConnection = connection;
        this.mEnvironment = environment;
    }

    public Cellset execute(String mdx, boolean prefetchData) throws TM1Exception {
        int connectionId = System.identityHashCode((Object)this.mConnection);
        String datasetName = null;
        if (this.mEnvironment != null && this.mEnvironment.getDataContext() != null) {
            datasetName = this.mEnvironment.getDataContext().getRsapiDatasetName();
        }
        TM1Log.TM1LogWrapper.log(TM1Log.DATA_MDX, LogLevel.TRACE, "Began query execution [CONNECTION_ID=%d, PREFETCH_DATA=%b, RsapiDatasetName=%s].", connectionId, prefetchData, datasetName);
        TM1Log.TM1LogWrapper.log(TM1Log.DATA_MDX, LogLevel.INFO, "MDX query string: \n%s", mdx);
        long startTime = System.currentTimeMillis();
        AsyncJob mdxJob = null;
        try {
            mdxJob = prefetchData ? this.mConnection.getServer().executeMDXBegin(mdx) : this.mConnection.getServer().executeMDXBegin(mdx, new long[0], false);
            int cancelWaitTime = 100;
            int timeLeftToCancel = 30000;
            while (mdxJob.getState() == StateType.Running) {
                if (this.mEnvironment.getCancelManager().isRequestCancelled()) {
                    if (TM1Connection.getAPI().getVersion() < 90520100 || this.mConnection.getServer().getVersion() < 90520100) break;
                    TM1Log.TM1LogWrapper.log(TM1Log.DATA_MDX_CANCEL, LogLevel.INFO, "Sending a cancel request to the server [CONNECTION_ID=%d].", connectionId);
                    mdxJob.cancel();
                    if (timeLeftToCancel <= 0 || cancelWaitTime > timeLeftToCancel) {
                        TM1Log.TM1LogWrapper.log(TM1Log.DATA_MDX_CANCEL, LogLevel.WARN, "Query cancel request timed out exceeded [CONNECTION_ID=%d].", connectionId);
                        break;
                    }
                    TM1Log.TM1LogWrapper.log(TM1Log.DATA_MDX_CANCEL, LogLevel.TRACE, "Waiting on cancel request [CONNECTION_ID=%d] %d.", connectionId, cancelWaitTime);
                    mdxJob.wait(cancelWaitTime);
                    cancelWaitTime = Math.min(cancelWaitTime * 2, timeLeftToCancel -= cancelWaitTime);
                    continue;
                }
                mdxJob.wait(20);
            }
            if (this.mEnvironment.getCancelManager().isRequestCancelled()) {
                if (TM1Connection.getAPI().getVersion() < 90520100) {
                    TM1Log.TM1LogWrapper.log(TM1Log.DATA_MDX_CANCEL, LogLevel.WARN, "Abandonning the connection [CONNECTION_ID=%d] - the TM1 client does not support recoverable cancel.", connectionId);
                    TM1Log.TM1LogWrapper.log(TM1Log.CONN_VALIDATE, LogLevel.WARN, "Invalidating the connection [CONNECTION_ID=%d] - the TM1 client does not support recoverable cancel.", connectionId);
                    this.mConnection.invalidate();
                } else if (this.mConnection.getServer().getVersion() < 90520100) {
                    TM1Log.TM1LogWrapper.log(TM1Log.DATA_MDX_CANCEL, LogLevel.WARN, "Abandonning the connection [CONNECTION_ID=%d] - the TM1 server does not support recoverable cancel.", connectionId);
                    TM1Log.TM1LogWrapper.log(TM1Log.CONN_VALIDATE, LogLevel.WARN, "Invalidating the connection [CONNECTION_ID=%d] - the TM1 server does not support recoverable cancel.", connectionId);
                    this.mConnection.invalidate();
                } else if (mdxJob.getState() == StateType.Completed) {
                    TM1Log.TM1LogWrapper.log(TM1Log.DATA_MDX_CANCEL, LogLevel.TRACE, "The server successfully cancelled the current query [CONNECTION_ID=%d] - query completed.", connectionId);
                } else if (mdxJob.getState() == StateType.Cancelled) {
                    TM1Log.TM1LogWrapper.log(TM1Log.DATA_MDX_CANCEL, LogLevel.TRACE, "The server successfully cancelled the current query [CONNECTION_ID=%d] - query canceled.", connectionId);
                } else if (mdxJob.getState() == StateType.Failed) {
                    TM1Log.TM1LogWrapper.log(TM1Log.DATA_MDX_CANCEL, LogLevel.WARN, "Abandonning the connection [CONNECTION_ID=%d] due to MDX request failure.", connectionId);
                    TM1Log.TM1LogWrapper.log(TM1Log.CONN_VALIDATE, LogLevel.WARN, "Invalidating the connection [CONNECTION_ID=%d] due to MDX request failure.", connectionId);
                    this.mConnection.invalidate();
                } else {
                    TM1Log.TM1LogWrapper.log(TM1Log.DATA_MDX_CANCEL, LogLevel.WARN, "Abandonning the connection [CONNECTION_ID=%d] due to exceeding cancel request timeout.", connectionId);
                    TM1Log.TM1LogWrapper.log(TM1Log.CONN_VALIDATE, LogLevel.WARN, "Invalidating the connection [CONNECTION_ID=%d] due to exceeding cancel request timeout.", connectionId);
                    this.mConnection.invalidate();
                }
                throw new OperationCanceledException();
            }
            if (mdxJob.getState() == StateType.Completed) {
                Cellset cellset = this.mConnection.getServer().executeMDXEnd(mdxJob);
                long elapsedTime = System.currentTimeMillis() - startTime;
                TM1Log.TM1LogWrapper.log(TM1Log.DATA_MDX, LogLevel.TRACE, "Finished query execution [CONNECTION_ID=%d, PREFETCH_DATA=%b, RsapiDatasetName=%s] in %d milliseconds.", connectionId, prefetchData, datasetName, elapsedTime);
                TM1ViewLogger viewLogger = new TM1ViewLogger(cellset);
                viewLogger.logCellset();
                Cellset cellset2 = cellset;
                return cellset2;
            }
            if (mdxJob.getState() == StateType.Failed) {
                TM1Exception error = mdxJob.getException();
                TM1Log.TM1LogWrapper.log(TM1Log.DATA_MDX, LogLevel.ERROR, "Query execution [CONNECTION_ID=%d, PREFETCH_DATA=%b, RsapiDatasetName=%s] failed with error: \n%s", connectionId, prefetchData, datasetName, ExceptionUtil.getStackTrace((Throwable)error));
                throw error;
            }
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Unexpected MDX state type returned by the TM1 api.");
        }
        finally {
            if (mdxJob != null) {
                mdxJob.dispose();
            }
        }
    }
}

