/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.data;

import com.cognos.xqe.data.providers.olap.tm1.TM1Log;
import com.cognos.xqe.data.providers.olap.tm1.util.TabularPrinter;
import com.cognos.xqe.trace.LogLevel;
import com.ibm.cognos.tm1.Axis;
import com.ibm.cognos.tm1.Cellset;
import com.ibm.cognos.tm1.Field;
import com.ibm.cognos.tm1.FieldType;
import com.ibm.cognos.tm1.Rowset;
import com.ibm.cognos.tm1.TM1Exception;
import java.io.StringWriter;
import java.util.Arrays;

public class TM1ViewLogger {
    private final Cellset mCellset;
    private static final String NEWLINE_AXIS_COLON = "\n Axis:";
    private static final String NEWLINE = "\n";
    private static final String SPACE_FIELDS = " fields";
    private static final String COLON_NEWLINE = ":\n";
    private static final String DOT = ".";

    public TM1ViewLogger(Cellset cellset) {
        this.mCellset = cellset;
    }

    public void logCellset() throws TM1Exception {
        if (this.mCellset == null) {
            TM1Log.TM1LogWrapper.log(TM1Log.DATA_VIEW, LogLevel.ERROR, "The Cellset is null.", new Object[0]);
            return;
        }
        int viewId = System.identityHashCode(this.mCellset);
        TM1Log.TM1LogWrapper.log(TM1Log.DATA_VIEW, LogLevel.INFO, "Cellset [CELLSET_ID=%s] has %d axes and %d cells.", viewId, this.mCellset.getAxisCount(), this.mCellset.getCount());
        this.logAxisInfo();
        this.logCellInfo();
    }

    private void logAxisInfo() throws TM1Exception {
        if (TM1Log.DATA_VIEW_AXES.isOn(LogLevel.INFO)) {
            boolean isAxesTraceLevelOn = TM1Log.DATA_VIEW_AXES.isOn(LogLevel.TRACE);
            Axis[] axes = this.mCellset.getAxes();
            for (int axisInx = 0; axisInx < axes.length; ++axisInx) {
                Axis axis = axes[axisInx];
                StringBuilder axisBuffer = new StringBuilder();
                axisBuffer.append(NEWLINE_AXIS_COLON).append(axisInx).append(", dimensions:");
                axisBuffer.append(Arrays.toString(axis.getDimensionNames()));
                Rowset tupleRowset = axis.getTupleRowset();
                long rowsetSize = tupleRowset.getCount();
                Field[] fields = tupleRowset.getFields();
                FieldType[] fieldTypes = this.getFieldTypes(fields);
                int numFields = fields.length;
                axisBuffer.append(NEWLINE).append(rowsetSize).append(" tuples, ").append(fields.length).append(SPACE_FIELDS);
                if (rowsetSize == 0L || numFields == 0) {
                    axisBuffer.append(DOT);
                    TM1Log.DATA_VIEW_AXES.log(LogLevel.INFO, axisBuffer.toString());
                    continue;
                }
                axisBuffer.append(COLON_NEWLINE);
                TabularPrinter tabularPrinter = new TabularPrinter(numFields, 2);
                tabularPrinter.addHeader(this.buildFieldHeader(fields));
                if (isAxesTraceLevelOn) {
                    while (tupleRowset.getNext()) {
                        tabularPrinter.addRow(this.buildRow(tupleRowset, fieldTypes));
                    }
                }
                tabularPrinter.computeColumnWidths();
                StringWriter headerWriter = new StringWriter(tabularPrinter.getTotalColumnWidth());
                tabularPrinter.setOutput(headerWriter);
                tabularPrinter.printHeaders();
                axisBuffer.append(headerWriter.toString());
                TM1Log.DATA_VIEW_AXES.log(LogLevel.INFO, axisBuffer.toString());
                if (!isAxesTraceLevelOn) continue;
                StringWriter rowStream = new StringWriter((int)((long)tabularPrinter.getTotalColumnWidth() * rowsetSize));
                rowStream.append(NEWLINE);
                tabularPrinter.setOutput(rowStream);
                tabularPrinter.printBorder();
                tabularPrinter.printRows();
                TM1Log.DATA_VIEW_AXES.log(LogLevel.TRACE, rowStream.toString());
            }
        }
    }

    private String[] buildFieldHeader(Field[] fields) {
        int fieldInx = 0;
        String[] fieldInfoArray = new String[fields.length];
        for (Field field : fields) {
            StringBuilder fieldInfoBuilder = new StringBuilder();
            fieldInfoBuilder.append(fieldInx);
            switch (field.Type) {
                case Integer: {
                    fieldInfoBuilder.append("I:");
                    break;
                }
                case String: {
                    fieldInfoBuilder.append("S:");
                    break;
                }
                case Double: {
                    fieldInfoBuilder.append("D:");
                    break;
                }
                case Boolean: {
                    fieldInfoBuilder.append("B:");
                    break;
                }
                case Error: {
                    fieldInfoBuilder.append("E:");
                    break;
                }
                default: {
                    fieldInfoBuilder.append("U:");
                }
            }
            fieldInfoBuilder.append(field.Name);
            fieldInfoArray[fieldInx] = fieldInfoBuilder.toString();
            ++fieldInx;
        }
        return fieldInfoArray;
    }

    private String[] buildRow(Rowset tupleRowset, FieldType[] fieldTypes) throws TM1Exception {
        String[] row = new String[fieldTypes.length];
        block7: for (int fieldInx = 0; fieldInx < fieldTypes.length; ++fieldInx) {
            switch (fieldTypes[fieldInx]) {
                case Integer: {
                    row[fieldInx] = String.valueOf(tupleRowset.getIntegerField((long)fieldInx));
                    continue block7;
                }
                case String: {
                    row[fieldInx] = tupleRowset.getStringField((long)fieldInx);
                    continue block7;
                }
                case Double: {
                    row[fieldInx] = String.valueOf(tupleRowset.getDoubleField((long)fieldInx));
                    continue block7;
                }
                case Boolean: {
                    row[fieldInx] = String.valueOf(tupleRowset.getBooleanField((long)fieldInx));
                    continue block7;
                }
                case Error: {
                    row[fieldInx] = "Error";
                    continue block7;
                }
                default: {
                    row[fieldInx] = "Unknown";
                }
            }
        }
        return row;
    }

    private FieldType[] getFieldTypes(Field[] fields) {
        FieldType[] fieldTypes = new FieldType[fields.length];
        for (int fieldInx = 0; fieldInx < fields.length; ++fieldInx) {
            fieldTypes[fieldInx] = fields[fieldInx].Type;
        }
        return fieldTypes;
    }

    private void logCellInfo() throws TM1Exception {
        if (TM1Log.DATA_VIEW_CELLS.isOn(LogLevel.INFO)) {
            boolean isCellsTraceLevelOn = TM1Log.DATA_VIEW_CELLS.isOn(LogLevel.TRACE);
            StringBuilder cellBuffer = new StringBuilder();
            long numCells = this.mCellset.getCount();
            Field[] fields = this.mCellset.getFields();
            FieldType[] fieldTypes = this.getFieldTypes(fields);
            int numFields = fields.length;
            cellBuffer.append(NEWLINE).append(numCells).append(" cells, ").append(numFields).append(SPACE_FIELDS);
            if (numCells == 0L || numFields == 0) {
                cellBuffer.append(DOT);
                TM1Log.DATA_VIEW_CELLS.log(LogLevel.INFO, cellBuffer.toString());
            } else {
                cellBuffer.append(COLON_NEWLINE);
                TabularPrinter tabularPrinter = new TabularPrinter(numFields, 2);
                tabularPrinter.addHeader(this.buildFieldHeader(fields));
                if (isCellsTraceLevelOn) {
                    long valueFieldInx = this.mCellset.getFieldIndex("VALUE");
                    while (this.mCellset.getNext()) {
                        if (valueFieldInx != -1L) {
                            fieldTypes[(int)valueFieldInx] = this.mCellset.getFieldType(valueFieldInx);
                        }
                        tabularPrinter.addRow(this.buildRow((Rowset)this.mCellset, fieldTypes));
                    }
                }
                tabularPrinter.computeColumnWidths();
                StringWriter headerWriter = new StringWriter(tabularPrinter.getTotalColumnWidth());
                tabularPrinter.setOutput(headerWriter);
                tabularPrinter.printHeaders();
                cellBuffer.append(headerWriter.toString());
                TM1Log.DATA_VIEW_CELLS.log(LogLevel.INFO, cellBuffer.toString());
                if (isCellsTraceLevelOn) {
                    StringWriter cellWriter = new StringWriter((int)((long)tabularPrinter.getTotalColumnWidth() * numCells));
                    cellWriter.append(NEWLINE);
                    tabularPrinter.setOutput(cellWriter);
                    tabularPrinter.printBorder();
                    tabularPrinter.printRows();
                    TM1Log.DATA_VIEW_CELLS.log(LogLevel.TRACE, cellWriter.toString());
                }
            }
        }
    }
}

