/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.metadata;

import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Dimension;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Hierarchy;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Level;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Metadata;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1MetadataType;
import com.cognos.xqe.data.providers.olap.tm1.util.ITM1Field;
import com.cognos.xqe.data.providers.olap.tm1.util.ITM1RowsetView;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1Utils;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.ibm.cognos.tm1.FieldType;
import com.ibm.cognos.tm1.TM1Exception;
import java.io.PrintWriter;

public final class TM1Attribute
extends TM1Metadata {
    private final RoleTypeEnum mRole;
    private FieldType mDataType;
    private String mDescription;

    public static TM1Attribute createHierarchyBusinessKey(TM1Hierarchy hierarchy, String dashNamePostfix) {
        TM1Attribute attribute = new TM1Attribute(hierarchy, RoleTypeEnum.BUSINESS_KEY);
        attribute.mProviderCaption = hierarchy.getName() + ' ' + dashNamePostfix;
        attribute.mName = "MEMBER_KEY";
        attribute.mProviderUniqueName = "MEMBER_KEY";
        attribute.mDescription = "";
        attribute.mDataType = FieldType.String;
        return attribute;
    }

    public static TM1Attribute createLevelBusinessKey(TM1Level level, String dashNamePostfix) {
        TM1Attribute attribute = new TM1Attribute(level, RoleTypeEnum.BUSINESS_KEY);
        attribute.mProviderCaption = level.getName() + ' ' + dashNamePostfix;
        attribute.mName = "MEMBER_KEY";
        attribute.mProviderUniqueName = "MEMBER_KEY";
        attribute.mDescription = "";
        attribute.mDataType = FieldType.String;
        return attribute;
    }

    public TM1Attribute(TM1Dimension dimension, RoleTypeEnum role) {
        super(dimension);
        this.mRole = role;
    }

    public TM1Attribute(TM1Hierarchy hierarchy, RoleTypeEnum role) {
        super(hierarchy);
        this.mRole = role;
    }

    public TM1Attribute(TM1Level level, RoleTypeEnum role) {
        super(level);
        this.mRole = role;
    }

    @Override
    public TM1MetadataType getType() {
        return TM1MetadataType.ATTRIBUTE;
    }

    @Override
    public String getUniqueName() {
        if (null == this.mUniqueName) {
            this.mUniqueName = RoleTypeEnum.MEMBER_CUSTOM_PROPERTY == this.mRole ? TM1Utils.createMDDSPUN(this.getDimension(), this.getName()) : this.mProviderUniqueName;
        }
        return this.mUniqueName;
    }

    public boolean isDimensionAttribute() {
        return TM1MetadataType.DIMENSION == this.getParent().getType();
    }

    public boolean isHierarchyAttribute() {
        return TM1MetadataType.HIERARCHY == this.getParent().getType();
    }

    public boolean isLevelAttribute() {
        return TM1MetadataType.LEVEL == this.getParent().getType();
    }

    public boolean isAlias() {
        return "alias".equals(this.mDescription);
    }

    public TM1Dimension getDimension() {
        switch (this.getParent().getType()) {
            case DIMENSION: {
                return (TM1Dimension)this.getParent();
            }
            case HIERARCHY: {
                return ((TM1Hierarchy)this.getParent()).getDimension();
            }
            case LEVEL: {
                return ((TM1Level)this.getParent()).getHierarchy().getDimension();
            }
        }
        return null;
    }

    public TM1Hierarchy getHierarchy() {
        switch (this.getParent().getType()) {
            case HIERARCHY: {
                return (TM1Hierarchy)this.getParent();
            }
            case LEVEL: {
                return ((TM1Level)this.getParent()).getHierarchy();
            }
        }
        return null;
    }

    public TM1Level getLevel() {
        switch (this.getParent().getType()) {
            case LEVEL: {
                return (TM1Level)this.getParent();
            }
        }
        return null;
    }

    public FieldType getDataType() {
        return this.mDataType;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public RoleTypeEnum getRoleType() {
        return this.mRole;
    }

    public void populate(ITM1RowsetView<TM1AttributeFields> view) throws TM1Exception {
        this.mProviderUniqueName = this.mName = view.getStringField(TM1AttributeFields.PROPERTY_NAME);
        this.mProviderCaption = view.getStringField(TM1AttributeFields.PROPERTY_CAPTION);
        this.mDescription = view.getStringField(TM1AttributeFields.DESCRIPTION);
        int dataTypeNum = (int)view.getIntegerField(TM1AttributeFields.DATA_TYPE);
        switch (dataTypeNum) {
            case 5: {
                this.mDataType = FieldType.Double;
                break;
            }
            case 129: {
                this.mDataType = FieldType.String;
                break;
            }
            default: {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Unexpected attribute data type: " + this.mDataType);
            }
        }
    }

    @Override
    public void dump(PrintWriter writer, int indent) {
        TM1Attribute.printHeader(writer, indent, "TM1Attribute");
        TM1Attribute.printField(writer, indent, "name", this.getName());
        TM1Attribute.printField(writer, indent, "caption", this.getCaption());
        TM1Attribute.printField(writer, indent, "dataType", this.getDataType().toString());
        TM1Attribute.printField(writer, indent, "description", this.getDescription());
        TM1Attribute.printField(writer, indent, "role", this.getRoleType().toRoleValue());
    }

    public static enum TM1AttributeFields implements ITM1Field
    {
        CUBE_NAME,
        DIMENSION_UNIQUE_NAME,
        PROPERTY_TYPE,
        PROPERTY_NAME,
        PROPERTY_CAPTION,
        DATA_TYPE,
        DESCRIPTION;

        private final String mFieldName;

        private TM1AttributeFields() {
            this.mFieldName = this.name();
        }

        private TM1AttributeFields(String fieldName) {
            this.mFieldName = fieldName;
        }

        @Override
        public String getFieldName() {
            return this.mFieldName;
        }
    }
}

