/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.metadata;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.providers.olap.tm1.TM1Connection;
import com.cognos.xqe.data.providers.olap.tm1.TM1Log;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Cube;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1CubeTimestamps;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1MetadataSession;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.trace.LogLevel;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TM1CubeCache {
    private static final long DEFAULT_STALE_CHECK_INTERVAL = 5000L;
    private final TM1Connection mConnection;
    private final Map<String, TM1Cube> mCubesByName = new HashMap<String, TM1Cube>();
    private long mStaleCheckInterval = 5000L;
    private volatile long mLastStaleCheckTime = 0L;

    public TM1CubeCache(TM1Connection connection) {
        this.mConnection = connection;
    }

    public long getStaleCheckInterval() {
        return this.mStaleCheckInterval;
    }

    public void setStaleCheckInterval(long staleCheckInterval) {
        this.mStaleCheckInterval = staleCheckInterval;
    }

    public long getLastStaleCheckTime() {
        return this.mLastStaleCheckTime;
    }

    public synchronized boolean containsCube() {
        return !this.mCubesByName.isEmpty();
    }

    public synchronized boolean containsCube(String cubeName) {
        return this.mCubesByName.containsKey(cubeName);
    }

    public synchronized TM1Cube getCube(String cubeName) {
        return this.mCubesByName.get(cubeName);
    }

    public synchronized void putCube(TM1Cube cube) {
        this.mCubesByName.put(cube.getName(), cube);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> checkStaleCubes(ExecutionEnvironment execEnv) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.mLastStaleCheckTime >= this.mStaleCheckInterval) {
            Integer connectionID = System.identityHashCode((Object)this.mConnection);
            TM1Log.TM1LogWrapper.log(TM1Log.META_CACHE, LogLevel.TRACE, "Running a staleness check on cube cache for connection ID %d.", connectionID);
            RequestEnvironment reqEnv = (RequestEnvironment)execEnv.getRequestEnvironment();
            TM1MetadataSession session = new TM1MetadataSession(this.mConnection, reqEnv.getRunLocale(), execEnv);
            LinkedList<String> staleCubeNames = new LinkedList<String>();
            this.mLastStaleCheckTime = currentTime;
            TM1CubeCache tM1CubeCache = this;
            synchronized (tM1CubeCache) {
                for (TM1Cube cachedCube : this.mCubesByName.values()) {
                    try {
                        TM1CubeTimestamps currentTimestamps = session.getCubeTimestamps(cachedCube.getName());
                        if (0 == currentTimestamps.compareLastSchemaUpdate(cachedCube.getTimestamps())) continue;
                        staleCubeNames.add(cachedCube.getName());
                    }
                    catch (Exception ex) {
                        staleCubeNames.add(cachedCube.getName());
                    }
                }
                for (String cubeName : staleCubeNames) {
                    TM1Log.TM1LogWrapper.log(TM1Log.META_CACHE, LogLevel.WARN, "Expunging stale cube metadata [CUBE_NAME=%s] from cube cache for connection ID %d.", cubeName, connectionID);
                    this.mCubesByName.remove(cubeName);
                }
            }
            return staleCubeNames;
        }
        return Collections.emptyList();
    }
}

