/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.metadata;

import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Cube;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Dimension;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Hierarchy;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Member;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1MemberMDXQuery;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Metadata;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1MetadataSession;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;

public class TM1DepthMemberQuery
extends TM1MemberMDXQuery {
    private final int mDepth;

    public TM1DepthMemberQuery(TM1MetadataSession session, int depth) {
        super(session);
        this.mDepth = depth;
    }

    @Override
    public void setSearchContext(TM1Metadata searchContext) {
        switch (searchContext.getType()) {
            case MEMBER: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported context type:" + searchContext.getType().toString());
            }
        }
        this.mSearchContext = searchContext;
    }

    @Override
    protected String generateMDX() {
        TM1Cube cube;
        TM1Dimension dimension;
        TM1Member member;
        switch (this.mSearchContext.getType()) {
            case MEMBER: {
                member = (TM1Member)this.mSearchContext;
                TM1Hierarchy hierarchy = member.getLevel().getHierarchy();
                dimension = hierarchy.getDimension();
                cube = dimension.getCube();
                break;
            }
            default: {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL);
            }
        }
        StringBuilder mdxBuffer = new StringBuilder();
        mdxBuffer.append("SELECT { DESCENDANTS(");
        mdxBuffer.append(member.getProviderUniqueName());
        mdxBuffer.append(", ");
        mdxBuffer.append(this.mDepth);
        mdxBuffer.append(", SELF) }");
        mdxBuffer.append(" PROPERTIES MEMBER_NAME, MEMBER_ORDINAL, CHILDREN_CARDINALITY, PARENT_UNIQUE_NAME, LEVEL_NUMBER");
        String qualifiedAliasName = this.getQualifiedAliasName(dimension);
        if (qualifiedAliasName != null) {
            mdxBuffer.append(", ").append(qualifiedAliasName);
        }
        mdxBuffer.append(" ON AXIS(0), {} ON AXIS(1) FROM [").append(cube.getName()).append(']');
        return mdxBuffer.toString();
    }
}

