/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.metadata;

import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Attribute;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Cube;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Hierarchy;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Member;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Metadata;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1MetadataType;
import com.cognos.xqe.data.providers.olap.tm1.util.ITM1Field;
import com.cognos.xqe.data.providers.olap.tm1.util.ITM1RowsetView;
import com.ibm.cognos.tm1.TM1Exception;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class TM1Dimension
extends TM1Metadata {
    private long mCardinality;
    private int mOrdinal;
    private String mDefaultHierarchyName;
    private int mNumLevels;
    private boolean mMeasureDimension;
    private boolean mTimeDimension;
    private Boolean hasMemberCaptionAttribute;
    private final Map<String, TM1Hierarchy> mHierarchiesByHUN = new LinkedHashMap<String, TM1Hierarchy>();
    private final Map<String, TM1Attribute> mAttributesByName = new LinkedHashMap<String, TM1Attribute>();

    public TM1Dimension(TM1Cube cube) {
        super(cube);
    }

    public TM1Cube getCube() {
        return (TM1Cube)this.getParent();
    }

    @Override
    public TM1MetadataType getType() {
        return TM1MetadataType.DIMENSION;
    }

    @Override
    public String getUniqueName() {
        if (null == this.mUniqueName) {
            this.mUniqueName = this.mProviderUniqueName;
        }
        return this.mUniqueName;
    }

    public long getCardinality() {
        return this.mCardinality;
    }

    public int getOrdinal() {
        return this.mOrdinal;
    }

    public String getDefaultHierarchyName() {
        return this.mDefaultHierarchyName;
    }

    public int getNumLevels() {
        return this.mNumLevels;
    }

    public boolean isMeasureDimension() {
        return this.mMeasureDimension;
    }

    public boolean isTimeDimension() {
        return this.mTimeDimension;
    }

    public boolean hasMemberCaptionAttribute() {
        if (this.hasMemberCaptionAttribute == null) {
            this.hasMemberCaptionAttribute = false;
            for (String name : this.mAttributesByName.keySet()) {
                if (!name.equalsIgnoreCase(TM1Member.TM1MemberFields.MEMBER_CAPTION.name())) continue;
                this.hasMemberCaptionAttribute = true;
                break;
            }
        }
        return this.hasMemberCaptionAttribute;
    }

    public Collection<TM1Hierarchy> getHierarchies() {
        return Collections.unmodifiableCollection(this.mHierarchiesByHUN.values());
    }

    public TM1Hierarchy getDefaultHierarchy() {
        for (TM1Hierarchy hierarchy : this.getHierarchies()) {
            if (!hierarchy.getName().equals(this.mDefaultHierarchyName)) continue;
            return hierarchy;
        }
        return null;
    }

    public TM1Hierarchy findHierarchy(String hun) {
        return this.mHierarchiesByHUN.get(hun);
    }

    public Collection<TM1Attribute> getAttributes() {
        return Collections.unmodifiableCollection(this.mAttributesByName.values());
    }

    public TM1Attribute findAttribute(String name) {
        return this.mAttributesByName.get(name);
    }

    public void populate(ITM1RowsetView<TM1DimensionFields> view) throws TM1Exception {
        this.mName = view.getStringField(TM1DimensionFields.DIMENSION_NAME);
        this.mProviderUniqueName = view.getStringField(TM1DimensionFields.DIMENSION_UNIQUE_NAME);
        this.mProviderCaption = view.getStringField(TM1DimensionFields.DIMENSION_NAME);
        this.mCardinality = view.getIntegerField(TM1DimensionFields.DIMENSION_CARDINALITY);
        this.mOrdinal = (int)view.getIntegerField(TM1DimensionFields.DIMENSION_ORDINAL);
        this.mDefaultHierarchyName = view.getStringField(TM1DimensionFields.DEFAULT_HIERARCHY);
        this.mNumLevels = (int)view.getIntegerField(TM1DimensionFields.NUM_LEVELS);
        this.mMeasureDimension = this.mProviderUniqueName.equals(this.getCube().getMeasureDUN());
        this.mTimeDimension = this.mProviderUniqueName.equals(this.getCube().getTimeDUN());
    }

    @Override
    public void dump(PrintWriter writer, int indent) {
        TM1Dimension.printHeader(writer, indent, "TM1Dimension");
        TM1Dimension.printField(writer, indent, "name", this.getName());
        TM1Dimension.printField(writer, indent, "uniqueName", this.getProviderUniqueName());
        TM1Dimension.printField(writer, indent, "caption", this.getCaption());
        TM1Dimension.printField(writer, indent, "ordinal", Integer.toString(this.getOrdinal()));
        TM1Dimension.printField(writer, indent, "cardinality", Long.toString(this.getCardinality()));
        TM1Dimension.printField(writer, indent, "numLevels", Integer.toString(this.getNumLevels()));
        TM1Dimension.printField(writer, indent, "defaultHierarchyName", this.getDefaultHierarchyName());
        for (TM1Attribute attribute : this.getAttributes()) {
            attribute.dump(writer, indent + 2);
        }
        for (TM1Hierarchy hierarchy : this.getHierarchies()) {
            hierarchy.dump(writer, indent + 2);
        }
    }

    void addHierarchy(TM1Hierarchy hierarchy) {
        this.mHierarchiesByHUN.put(hierarchy.getProviderUniqueName(), hierarchy);
        if (null == this.mDefaultHierarchyName || this.mDefaultHierarchyName.length() == 0) {
            this.mDefaultHierarchyName = hierarchy.getName();
        }
    }

    void addAttribute(TM1Attribute attribute) {
        this.mAttributesByName.put(attribute.getName(), attribute);
    }

    public static enum TM1DimensionFields implements ITM1Field
    {
        CUBE_NAME,
        DIMENSION_NAME,
        DIMENSION_UNIQUE_NAME,
        DIMENSION_CAPTION,
        DIMENSION_CARDINALITY,
        DIMENSION_ORDINAL,
        DEFAULT_HIERARCHY,
        NUM_LEVELS;

        private final String mFieldName;

        private TM1DimensionFields() {
            this.mFieldName = this.name();
        }

        private TM1DimensionFields(String fieldName) {
            this.mFieldName = fieldName;
        }

        @Override
        public String getFieldName() {
            return this.mFieldName;
        }
    }
}

