/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.metadata;

import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Dimension;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Level;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Metadata;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1MetadataType;
import com.cognos.xqe.data.providers.olap.tm1.util.ITM1Field;
import com.cognos.xqe.data.providers.olap.tm1.util.ITM1RowsetView;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1Utils;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.exception.XQERuntimeException;
import com.ibm.cognos.tm1.FieldType;
import com.ibm.cognos.tm1.TM1Exception;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public final class TM1Member
extends TM1Metadata {
    private long mOrdinal;
    private int mLevelNumber;
    private long mChildrenCardinality;
    private String mParentMUN;
    private int mParentLevelNumber;
    private String mDescription;
    private final Map<String, String> mAliasValues = new TreeMap<String, String>();
    private Map<String, Object> mDynamicFields = new HashMap<String, Object>();

    public TM1Member(TM1Level level) {
        super(level);
    }

    @Override
    public TM1MetadataType getType() {
        return TM1MetadataType.MEMBER;
    }

    @Override
    public String getUniqueName() {
        if (null == this.mUniqueName) {
            this.mUniqueName = TM1Utils.convertProviderMUNToMDDSMUN(this.getLevel().getHierarchy().getCommonMUNPrefix(), this.getProviderUniqueName());
        }
        return this.mUniqueName;
    }

    public TM1Level getLevel() {
        return (TM1Level)this.getParent();
    }

    public TM1Dimension getDimension() {
        return this.getLevel().getHierarchy().getDimension();
    }

    public long getChildrenCardinality() {
        return this.mChildrenCardinality;
    }

    public int getLevelNumber() {
        return this.mLevelNumber;
    }

    public long getOrdinal() {
        return this.mOrdinal;
    }

    public String getParentMUN() {
        return this.mParentMUN;
    }

    public int getParentLevelNumber() {
        return this.mParentLevelNumber;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public Map<String, String> getAliasValues() {
        return Collections.unmodifiableMap(this.mAliasValues);
    }

    public void populate(ITM1RowsetView<TM1MemberFields> view, String[] dimProperties) throws TM1Exception {
        this.mName = view.getStringField(TM1MemberFields.MEMBER_NAME);
        this.mProviderUniqueName = view.getStringField(TM1MemberFields.MEMBER_UNIQUE_NAME);
        this.mOrdinal = view.getIntegerField(TM1MemberFields.MEMBER_ORDINAL);
        if (this.getDimension().hasMemberCaptionAttribute()) {
            this.mProviderCaption = view.getStringField(TM1MemberFields.MEMBER_CAPTION);
            if (this.mProviderCaption.length() == 0) {
                this.mProviderCaption = this.mName;
            }
        } else {
            this.mProviderCaption = this.mName;
        }
        if (view.containsField(TM1MemberFields.DESCRIPTION.name())) {
            this.mDescription = view.getStringField(TM1MemberFields.DESCRIPTION.name());
        }
        if (this.mDescription == null || this.mDescription.isEmpty()) {
            this.mDescription = this.mName;
        }
        this.mLevelNumber = (int)view.getIntegerField(TM1MemberFields.LEVEL_NUMBER);
        this.mChildrenCardinality = view.getIntegerField(TM1MemberFields.CHILDREN_CARDINALITY);
        this.mParentMUN = view.getStringField(TM1MemberFields.PARENT_UNIQUE_NAME);
        this.mParentLevelNumber = this.mLevelNumber - 1;
        for (String aliasName : this.getLevel().getHierarchy().getAliasNames()) {
            if (!view.containsField(aliasName)) continue;
            String value = view.getStringField(aliasName);
            this.mAliasValues.put(aliasName, value);
        }
        if (dimProperties != null) {
            for (String property : dimProperties) {
                Object value;
                if (!view.containsField(property)) continue;
                FieldType type = view.getFieldType(property);
                switch (type) {
                    case Boolean: {
                        value = view.getBooleanField(property);
                        break;
                    }
                    case Integer: {
                        value = view.getIntegerField(property);
                        break;
                    }
                    case String: {
                        value = view.getStringField(property);
                        break;
                    }
                    case Double: {
                        value = view.getDoubleField(property);
                        break;
                    }
                    case Error: 
                    case Unknown: {
                        value = DataValueFactory.createNullValue();
                        value.setState(ValueState.ERROR);
                        break;
                    }
                    default: {
                        throw new XQERuntimeException();
                    }
                }
                this.mDynamicFields.put(property, value);
            }
        }
    }

    @Override
    public void dump(PrintWriter writer, int indent) {
        TM1Member.printHeader(writer, indent, "TM1Member");
        TM1Member.printField(writer, indent, "name", this.getName());
        TM1Member.printField(writer, indent, "uniqueName", this.getName());
        TM1Member.printField(writer, indent, "caption", this.getCaption());
        TM1Member.printField(writer, indent, "aliasValues", this.getAliasValues().toString());
        TM1Member.printField(writer, indent, "ordinal", Long.toString(this.getOrdinal()));
        TM1Member.printField(writer, indent, "parentMUN", this.getParentMUN());
        TM1Member.printField(writer, indent, "levelNumber", Integer.toString(this.getLevelNumber()));
        TM1Member.printField(writer, indent, "parentLevelNumber", Integer.toString(this.getParentLevelNumber()));
        TM1Member.printField(writer, indent, "childrenCardinality", Long.toString(this.getChildrenCardinality()));
    }

    public Map<String, Object> getDynamicFields() {
        return this.mDynamicFields;
    }

    public static enum TM1MemberFields implements ITM1Field
    {
        MEMBER_NAME,
        MEMBER_UNIQUE_NAME,
        MEMBER_CAPTION,
        MEMBER_ORDINAL,
        LEVEL_NUMBER,
        CHILDREN_CARDINALITY,
        PARENT_UNIQUE_NAME,
        PARENT_LEVEL("parentLevelNumber"),
        PARENT_KEY("parentKey"),
        LABEL("label"),
        DESCRIPTION("description");

        private final String mFieldName;

        private TM1MemberFields() {
            this.mFieldName = this.name();
        }

        private TM1MemberFields(String fieldName) {
            this.mFieldName = fieldName;
        }

        @Override
        public String getFieldName() {
            return this.mFieldName;
        }
    }
}

