/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.metadata;

import com.cognos.xqe.data.providers.olap.tm1.TM1MessageKeys;
import com.cognos.xqe.data.providers.olap.tm1.TM1ODPException;
import com.cognos.xqe.data.providers.olap.tm1.data.TM1MDXQuery;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Dimension;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Hierarchy;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Level;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Member;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Metadata;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1MetadataSession;
import com.cognos.xqe.data.providers.olap.tm1.util.ITM1RowsetView;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1AliasTable;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1RowsetAccessor;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1Utils;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.ibm.cognos.tm1.Cellset;
import com.ibm.cognos.tm1.Rowset;
import com.ibm.cognos.tm1.TM1Exception;
import java.util.ArrayList;
import java.util.List;

public abstract class TM1MemberMDXQuery {
    protected final TM1MetadataSession mSession;
    protected TM1Metadata mSearchContext = null;
    protected TM1AliasTable mAliasTable = null;
    protected String[] mDimProps;

    public TM1MemberMDXQuery(TM1MetadataSession session) {
        this.mSession = session;
    }

    public void setSearchContext(TM1Metadata searchContext) {
        switch (searchContext.getType()) {
            case HIERARCHY: 
            case LEVEL: 
            case MEMBER: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported context type:" + searchContext.getType().toString());
            }
        }
        this.mSearchContext = searchContext;
    }

    public void setAliasTable(TM1AliasTable aliasTable) {
        this.mAliasTable = aliasTable;
    }

    public void setDimensionProperties(String[] props) {
        this.mDimProps = props;
    }

    public String getAliasName(TM1Dimension dimension) {
        if (null != this.mAliasTable) {
            return this.mAliasTable.getAttributeName(dimension.getName(), this.mSession.getLocale().getLanguage());
        }
        return null;
    }

    public String getQualifiedAliasName(TM1Dimension dimension) {
        String aliasName = this.getAliasName(dimension);
        if (null != aliasName) {
            return TM1Utils.createMDDSPUN(dimension, aliasName);
        }
        return null;
    }

    protected abstract String generateMDX();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TM1Member> execute() throws TM1Exception {
        ArrayList<TM1Member> result;
        TM1Hierarchy hierarchy;
        if (null == this.mSearchContext) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Member search context was not specified.");
        }
        String mdxString = this.generateMDX();
        switch (this.mSearchContext.getType()) {
            case HIERARCHY: {
                hierarchy = (TM1Hierarchy)this.mSearchContext;
                break;
            }
            case LEVEL: {
                hierarchy = ((TM1Level)this.mSearchContext).getHierarchy();
                break;
            }
            case MEMBER: {
                hierarchy = ((TM1Member)this.mSearchContext).getLevel().getHierarchy();
                break;
            }
            default: {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL);
            }
        }
        TM1MDXQuery query = new TM1MDXQuery(this.mSession.getConnection(), this.mSession.getExecutionEnvironment());
        Cellset cellset = query.execute(mdxString, false);
        try {
            Rowset rs = cellset.getAxisRowset(0);
            try {
                TM1RowsetAccessor<TM1Member.TM1MemberFields> rsa = TM1RowsetAccessor.create(rs, TM1Member.TM1MemberFields.class);
                ITM1RowsetView<TM1Member.TM1MemberFields> view = rsa.createQualifiedView(hierarchy.getDimension().getName());
                result = new ArrayList<TM1Member>((int)view.getRowCount());
                while (view.next()) {
                    int levelNum = (int)view.getIntegerField(TM1Member.TM1MemberFields.LEVEL_NUMBER);
                    TM1Level level = hierarchy.findLevel(levelNum);
                    if (null == level) {
                        throw new TM1ODPException(TM1MessageKeys.MET_LEVEL_NUMBER_NOT_FOUND, Integer.toString(levelNum), hierarchy.getUniqueName());
                    }
                    TM1Member member = new TM1Member(level);
                    member.populate(view, this.mDimProps);
                    result.add(member);
                }
            }
            finally {
                rs.dispose();
            }
        }
        finally {
            cellset.dispose();
        }
        return result;
    }
}

