/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.metadata.query;

import com.cognos.xqe.data.providers.olap.tm1.TM1MessageKeys;
import com.cognos.xqe.data.providers.olap.tm1.TM1ODPException;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Attribute;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Cube;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Dimension;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1MetadataSession;
import com.cognos.xqe.data.providers.olap.tm1.metadata.query.MetadataQuery;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.record.AliasRecord;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocalizedString;
import com.ibm.cognos.tm1.TM1Exception;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AliasRecordQuery
extends MetadataQuery<AliasRecord> {
    private String mCubeName = null;

    public AliasRecordQuery(TM1MetadataSession session) {
        super(session);
    }

    public void setCubeName(String cubeName) {
        this.mCubeName = cubeName;
    }

    @Override
    public List<AliasRecord> execute() throws TM1Exception {
        this.checkRangeRestrictions();
        if (null == this.mCubeName) {
            throw new TM1ODPException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "A cube name was not specified.");
        }
        if (this.mRangeSize < 1) {
            return Collections.emptyList();
        }
        TM1Cube cube = this.getLoader().loadCube(this.mCubeName, this.getCubeCache());
        if (null == cube) {
            throw new TM1ODPException(TM1MessageKeys.MET_CANNOT_FIND_CUBE, this.mCubeName);
        }
        ArrayList<TM1Attribute> aliasesFound = new ArrayList<TM1Attribute>();
        for (TM1Dimension dimension : cube.getDimensions()) {
            for (TM1Attribute attribute : dimension.getAttributes()) {
                if (!"alias".equals(attribute.getDescription())) continue;
                aliasesFound.add(attribute);
            }
        }
        int effectiveSize = Math.min(this.mRangeSize, aliasesFound.size() - this.mRangeFrom);
        if (effectiveSize <= 0) {
            return Collections.emptyList();
        }
        ArrayList<AliasRecord> records = new ArrayList<AliasRecord>(effectiveSize);
        for (int i = this.mRangeFrom; i < this.mRangeFrom + effectiveSize; ++i) {
            records.add(this.buildRecord((TM1Attribute)aliasesFound.get(i)));
        }
        return records;
    }

    private AliasRecord buildRecord(TM1Attribute alias) {
        TM1Dimension dimension = alias.getDimension();
        TM1Cube cube = dimension.getCube();
        AliasRecord record = new AliasRecord();
        record.setCatalogName("CATALOG");
        record.setCubeName(cube.getName());
        record.setDimensionUniqueName(dimension.getUniqueName());
        record.setName(alias.getUniqueName());
        record.setUniqueName(alias.getUniqueName());
        record.setCaption((ILocalizedString)new LocalizedString(this.mLocale, alias.getUniqueName()));
        return record;
    }
}

