/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.metadata.query;

import com.cognos.xqe.data.providers.olap.tm1.TM1MessageKeys;
import com.cognos.xqe.data.providers.olap.tm1.TM1ODPException;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Cube;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Dimension;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1MetadataSession;
import com.cognos.xqe.data.providers.olap.tm1.metadata.query.MetadataQuery;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1Utils;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.record.DimensionRecord;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocalizedString;
import com.ibm.cognos.tm1.TM1Exception;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DimensionRecordQuery
extends MetadataQuery<DimensionRecord> {
    private String mCubeName = null;
    private String mDUN = null;

    public DimensionRecordQuery(TM1MetadataSession session) {
        super(session);
    }

    public void setCubeName(String cubeName) {
        this.mCubeName = cubeName;
    }

    public void setDUN(String dun) {
        this.mDUN = dun;
    }

    @Override
    public List<DimensionRecord> execute() throws TM1Exception {
        this.checkRangeRestrictions();
        if (null == this.mCubeName) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "A cube name was not specified.");
        }
        if (this.mRangeSize < 1) {
            return Collections.emptyList();
        }
        TM1Cube cube = this.getLoader().loadCube(this.mCubeName, this.getCubeCache());
        if (null == cube) {
            throw new TM1ODPException(TM1MessageKeys.MET_CANNOT_FIND_CUBE, this.mCubeName);
        }
        ArrayList<TM1Dimension> dimensionsFound = new ArrayList<TM1Dimension>();
        if (null != this.mDUN) {
            TM1Dimension dimension = TM1Utils.findDimension(cube, this.mDUN, false);
            if (null != dimension) {
                dimensionsFound.add(dimension);
            }
        } else {
            dimensionsFound.addAll(cube.getDimensions());
        }
        int effectiveSize = Math.min(this.mRangeSize, dimensionsFound.size() - this.mRangeFrom);
        if (effectiveSize <= 0) {
            return Collections.emptyList();
        }
        ArrayList<DimensionRecord> records = new ArrayList<DimensionRecord>(effectiveSize);
        for (int i = this.mRangeFrom; i < this.mRangeFrom + effectiveSize; ++i) {
            records.add(this.buildRecord((TM1Dimension)dimensionsFound.get(i)));
        }
        return records;
    }

    private DimensionRecord buildRecord(TM1Dimension dimension) {
        TM1Cube cube = dimension.getCube();
        DimensionRecord record = new DimensionRecord();
        record.setCatalogName("CATALOG");
        record.setCubeName(cube.getName());
        record.setName(dimension.getName());
        record.setCaption((ILocalizedString)new LocalizedString(this.mLocale, dimension.getCaption()));
        record.setUniqueName(dimension.getUniqueName());
        record.setDescription(dimension.getCaption());
        record.setCardinality((int)dimension.getCardinality());
        record.setDefaultHierarchyUniqueName(dimension.getDefaultHierarchy().getUniqueName());
        if (dimension.isMeasureDimension()) {
            record.setType(DimensionTypeEnum.MEASURE);
        } else if (dimension.isTimeDimension()) {
            record.setType(DimensionTypeEnum.TIME);
        } else {
            record.setType(DimensionTypeEnum.REGULAR);
        }
        record.setHidden(Boolean.valueOf(false));
        record.setUniqueId(dimension.getName());
        record.setDynamicField("PPDS_KEY", (Object)dimension.getName());
        return record;
    }

    @Override
    public void release() {
    }
}

