/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.metadata.query;

import com.cognos.xqe.data.providers.olap.tm1.TM1MessageKeys;
import com.cognos.xqe.data.providers.olap.tm1.TM1ODPException;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Cube;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Dimension;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Hierarchy;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1MetadataSession;
import com.cognos.xqe.data.providers.olap.tm1.metadata.query.MetadataQuery;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1Utils;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.record.HierarchyRecord;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocalizedString;
import com.ibm.cognos.tm1.TM1Exception;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HierarchyRecordQuery
extends MetadataQuery<HierarchyRecord> {
    private String mCubeName = null;
    private String mDUN = null;
    private String mHUN = null;

    public HierarchyRecordQuery(TM1MetadataSession session) {
        super(session);
    }

    public void setCubeName(String cubeName) {
        this.mCubeName = cubeName;
    }

    public void setDUN(String dun) {
        this.mDUN = dun;
    }

    public void setHUN(String hun) {
        this.mHUN = hun;
    }

    @Override
    public List<HierarchyRecord> execute() throws TM1Exception {
        this.checkRangeRestrictions();
        if (null == this.mCubeName) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "A cube name was not specified.");
        }
        if (this.mRangeSize < 1) {
            return Collections.emptyList();
        }
        TM1Cube cube = this.getLoader().loadCube(this.mCubeName, this.getCubeCache());
        if (null == cube) {
            throw new TM1ODPException(TM1MessageKeys.MET_CANNOT_FIND_CUBE, this.mCubeName);
        }
        ArrayList<TM1Hierarchy> hierarchiesFound = new ArrayList<TM1Hierarchy>();
        if (null != this.mHUN) {
            TM1Hierarchy hierarchy = TM1Utils.findHierarchy(cube, this.mHUN, false);
            if (null != hierarchy) {
                hierarchiesFound.add(hierarchy);
            }
        } else if (null != this.mDUN) {
            TM1Dimension dimension = TM1Utils.findDimension(cube, this.mDUN, false);
            if (null != dimension) {
                hierarchiesFound.addAll(dimension.getHierarchies());
            }
        } else {
            for (TM1Dimension dimension : cube.getDimensions()) {
                hierarchiesFound.addAll(dimension.getHierarchies());
            }
        }
        int effectiveSize = Math.min(this.mRangeSize, hierarchiesFound.size() - this.mRangeFrom);
        if (effectiveSize <= 0) {
            return Collections.emptyList();
        }
        ArrayList<HierarchyRecord> records = new ArrayList<HierarchyRecord>(effectiveSize);
        for (int i = this.mRangeFrom; i < this.mRangeFrom + effectiveSize; ++i) {
            records.add(this.buildRecord((TM1Hierarchy)hierarchiesFound.get(i)));
        }
        return records;
    }

    private HierarchyRecord buildRecord(TM1Hierarchy hierarchy) {
        TM1Dimension dimension = hierarchy.getDimension();
        TM1Cube cube = dimension.getCube();
        HierarchyRecord record = new HierarchyRecord();
        record.setCatalogName("CATALOG");
        record.setCubeName(cube.getName());
        record.setDimensionUniqueName(dimension.getUniqueName());
        record.setName(hierarchy.getName());
        record.setCaption((ILocalizedString)new LocalizedString(this.mLocale, hierarchy.getCaption()));
        record.setUniqueName(hierarchy.getUniqueName());
        record.setDescription(hierarchy.getCaption());
        record.setCardinality((int)hierarchy.getCardinality());
        record.setRagged(hierarchy.isRagged());
        record.setBalanced(hierarchy.isBalanced());
        record.setParentChild(hierarchy.isParentChild());
        String defaultMUN = TM1Utils.convertProviderMUNToMDDSMUN(hierarchy.getCommonMUNPrefix(), hierarchy.getDefaultMemberUN());
        record.setDefaultMemberUniqueName(defaultMUN);
        if (hierarchy.getAllMemberUN().length() > 0) {
            String allMUN = TM1Utils.convertProviderMUNToMDDSMUN(hierarchy.getCommonMUNPrefix(), hierarchy.getAllMemberUN());
            record.setHighestRollupMemberUniqueName(allMUN);
        }
        record.setHidden(Boolean.valueOf(false));
        record.setUniqueId(hierarchy.getName());
        record.setDynamicField("PPDS_KEY", (Object)hierarchy.getName());
        return record;
    }

    @Override
    public void release() {
    }
}

