/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.metadata.query;

import com.cognos.xqe.data.providers.olap.tm1.TM1MessageKeys;
import com.cognos.xqe.data.providers.olap.tm1.TM1ODPException;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Cube;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Dimension;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Hierarchy;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Level;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Member;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1MetadataSession;
import com.cognos.xqe.data.providers.olap.tm1.metadata.query.MetadataQuery;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1AliasTable;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1Utils;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.record.MeasureRecord;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocalizedString;
import com.ibm.cognos.tm1.TM1Exception;
import com.ibm.cognos.tm1.TreeOperator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

public class MeasureRecordQuery
extends MetadataQuery<MeasureRecord> {
    private String mCubeName = null;
    private String mMUN = null;
    private boolean mRootsOnly = false;
    private boolean mIncludeSelf = true;
    private boolean mIncludeChildren = false;
    private TM1AliasTable mAliasTable = null;

    public MeasureRecordQuery(TM1MetadataSession session) {
        super(session);
    }

    public void setCubeName(String cubeName) {
        this.mCubeName = cubeName;
    }

    public void setMUN(String mun) {
        this.mMUN = mun;
    }

    public void setRootsOnly(boolean isRootsOnly) {
        this.mRootsOnly = isRootsOnly;
    }

    public void setIncludeSelf(boolean includeSelf) {
        this.mIncludeSelf = includeSelf;
    }

    public void setIncludeChildren(boolean includeChildren) {
        this.mIncludeChildren = includeChildren;
    }

    public void setAliasTable(TM1AliasTable aliasTable) {
        this.mAliasTable = aliasTable;
    }

    @Override
    public List<MeasureRecord> execute() throws TM1Exception {
        this.checkRangeRestrictions();
        if (null == this.mCubeName) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "A cube name was not specified.");
        }
        if (this.mRangeSize < 1) {
            return Collections.emptyList();
        }
        TM1Cube cube = this.getLoader().loadCube(this.mCubeName, this.getCubeCache());
        if (null == cube) {
            throw new TM1ODPException(TM1MessageKeys.MET_CANNOT_FIND_CUBE, this.mCubeName);
        }
        TM1Dimension measureDim = cube.getMeasureDimension();
        if (null == measureDim) {
            throw new TM1ODPException(TM1MessageKeys.MET_NO_MEASURE_DIMENSION, this.mCubeName);
        }
        ArrayList<TM1Member> measuresFound = new ArrayList<TM1Member>();
        this.findMeasures(measureDim, measuresFound);
        int effectiveSize = Math.min(this.mRangeSize, measuresFound.size() - this.mRangeFrom);
        if (effectiveSize <= 0) {
            return Collections.emptyList();
        }
        ArrayList<MeasureRecord> records = new ArrayList<MeasureRecord>(effectiveSize);
        for (int i = this.mRangeFrom; i < this.mRangeFrom + effectiveSize; ++i) {
            records.add(this.buildRecord((TM1Member)measuresFound.get(i)));
        }
        return records;
    }

    private void findMeasures(TM1Dimension dimension, List<TM1Member> result) throws TM1Exception {
        TM1Hierarchy hierarchy = dimension.getDefaultHierarchy();
        if (null == hierarchy) {
            throw new TM1ODPException(TM1MessageKeys.MET_NO_HIEARCHY_DIMENSION, dimension.getProviderUniqueName());
        }
        if (null != this.mMUN) {
            String providerMUN = TM1Utils.convertMDDSMUNToProviderMUN(this.mMUN);
            EnumSet<TreeOperator> treeOps = EnumSet.noneOf(TreeOperator.class);
            if (this.mIncludeSelf) {
                treeOps.add(TreeOperator.Self);
            }
            if (this.mIncludeChildren) {
                treeOps.add(TreeOperator.Children);
            }
            this.getLoader().loadMembersTreeOp(hierarchy, providerMUN, treeOps, EMPTY_PROPERTY_ARRAY, result);
        } else if (this.mRootsOnly) {
            result.addAll(hierarchy.getAccessibleRoots());
        } else {
            this.getLoader().loadMembersTreeOp(hierarchy, null, null, EMPTY_PROPERTY_ARRAY, result);
        }
    }

    private MeasureRecord buildRecord(TM1Member measure) {
        TM1Level level = measure.getLevel();
        TM1Hierarchy hierarchy = level.getHierarchy();
        TM1Dimension dimension = hierarchy.getDimension();
        TM1Cube cube = dimension.getCube();
        MeasureRecord record = new MeasureRecord();
        String mddsHUN = TM1Utils.joinUniqueNames(dimension.getProviderUniqueName(), hierarchy.getProviderUniqueName());
        String mddsLUN = TM1Utils.joinUniqueNames(dimension.getProviderUniqueName(), level.getProviderUniqueName());
        String mddsMUN = TM1Utils.convertProviderMUNToMDDSMUN(hierarchy.getCommonMUNPrefix(), measure.getProviderUniqueName());
        record.setCatalogName("CATALOG");
        record.setCubeName(cube.getName());
        record.setDimensionUniqueName(dimension.getProviderUniqueName());
        record.setHierarchyUniqueName(mddsHUN);
        record.setLevelUniqueName(mddsLUN);
        record.setDataType((IDataType)DataTypeFactory.getDoubleType());
        record.setRegularAggregate(AggregateTypeEnum.UNKNOWN);
        record.setName(measure.getName());
        record.setUniqueName(mddsMUN);
        record.setDescription(measure.getDescription());
        record.setUniqueId(measure.getName());
        record.setDynamicField("PPDS_KEY", (Object)measure.getName());
        LocalizedString caption = TM1Utils.buildLocalizedCaption(this.getSession().getLocale(), measure.getCaption(), this.mAliasTable, dimension.getName(), measure.getAliasValues());
        record.setCaption((ILocalizedString)caption);
        return record;
    }

    @Override
    public void release() {
    }
}

