/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.metadata.query;

import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.olap.tm1.TM1MessageKeys;
import com.cognos.xqe.data.providers.olap.tm1.TM1ODPException;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Cube;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1DepthMemberQuery;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Dimension;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Hierarchy;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Level;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Member;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1MemberSearch;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1MetadataLoader;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1MetadataSession;
import com.cognos.xqe.data.providers.olap.tm1.metadata.query.MetadataQuery;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1AliasTable;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1Utils;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.RollupTypeEnum;
import com.cognos.xqe.metadata.TreeOperatorEnum;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.transformation.ma.provider.MASearchCriteria;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocalizedString;
import com.ibm.cognos.tm1.TM1Exception;
import com.ibm.cognos.tm1.TreeOperator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class MemberRecordQuery
extends MetadataQuery<MemberRecord> {
    private static final String BRACE = "[";
    private static final String MEMBER_KEY = "MEMBER_KEY";
    private static final String OR_DELIMITER = " or ";
    private String mCubeName = null;
    private String mDUN = null;
    private String mHUN = null;
    private String mLUN = null;
    private Integer mLevelNumber = null;
    private String mMUN = null;
    private EnumSet<TreeOperatorEnum> mTreeOps = null;
    private Collection<String> mPPDSCodes = null;
    private MASearchCriteria mSearchCriteria = null;
    private TM1AliasTable mAliasTable = null;
    private Map<String, String> mPropNameToUniqueName = null;
    private String[] dimProperties;
    private Boolean mNeedToAdjustLevelNumbers = null;
    private AdjustedDepthTable mAdjustedDepthTable = null;

    public MemberRecordQuery(TM1MetadataSession session) {
        super(session);
    }

    public void setCubeName(String cubeName) {
        this.mCubeName = cubeName;
    }

    public void setDUN(String dun) {
        this.mDUN = dun;
    }

    public void setHUN(String hun) {
        this.mHUN = hun;
    }

    public void setLUN(String lun) {
        this.mLUN = lun;
    }

    public void setLevelNumber(Integer levelNumber) {
        this.mLevelNumber = levelNumber;
    }

    public void setMUN(String mun) {
        this.mMUN = mun;
    }

    public void setTreeOps(EnumSet<TreeOperatorEnum> treeOps) {
        this.mTreeOps = treeOps;
    }

    public void setPPDSCodes(Collection<String> ppdsCodes) {
        this.mPPDSCodes = ppdsCodes;
    }

    public void setSearchCriteria(MASearchCriteria searchCriteria) {
        this.mSearchCriteria = searchCriteria;
    }

    public void setAliasTable(TM1AliasTable aliasTable) {
        this.mAliasTable = aliasTable;
    }

    @Override
    public List<MemberRecord> execute() throws TM1Exception {
        this.checkRangeRestrictions();
        if (null == this.mCubeName) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "A cube name was not specified.");
        }
        if (this.mRangeSize < 1) {
            return Collections.emptyList();
        }
        TM1Cube cube = this.getLoader().loadCube(this.mCubeName, this.getCubeCache());
        if (null == cube) {
            throw new TM1ODPException(TM1MessageKeys.MET_CANNOT_FIND_CUBE, this.mCubeName);
        }
        EnumSet<TreeOperator> tm1TreeOps = null != this.mTreeOps ? MemberRecordQuery.convertTreeOps(this.mTreeOps) : EnumSet.noneOf(TreeOperator.class);
        ArrayList<TM1Member> membersFound = new ArrayList<TM1Member>();
        if (null != this.mSearchCriteria) {
            this.memberSearch(cube, tm1TreeOps, membersFound);
        } else if (null != this.mMUN) {
            this.findMembersWithTreeOps(cube, tm1TreeOps, membersFound);
        } else {
            this.findMembers(cube, membersFound);
        }
        List<TM1Member> filteredMembers = this.filterPPDSCodes(membersFound);
        int effectiveSize = Math.min(this.mRangeSize, filteredMembers.size() - this.mRangeFrom);
        if (effectiveSize <= 0) {
            return Collections.emptyList();
        }
        if (this.needToAdjustLevelNumbers(cube, filteredMembers)) {
            this.buildAdjustedDepthTable(cube, membersFound);
        }
        ArrayList<MemberRecord> records = new ArrayList<MemberRecord>(effectiveSize);
        for (int i = this.mRangeFrom; i < this.mRangeFrom + effectiveSize; ++i) {
            records.add(this.buildRecord(filteredMembers.get(i)));
        }
        return records;
    }

    private void buildAdjustedDepthTable(TM1Cube cube, List<TM1Member> queryResult) throws TM1Exception {
        this.mAdjustedDepthTable = new AdjustedDepthTable();
        if (queryResult.isEmpty()) {
            return;
        }
        if (this.mSearchCriteria != null) {
            for (TM1Member member : queryResult) {
                if (this.mAdjustedDepthTable.containsMUN(member.getParentMUN())) {
                    this.mAdjustedDepthTable.addMember(member);
                    continue;
                }
                this.addAncestorsToAdjustedDepthTable(member);
            }
            return;
        }
        if (this.mMUN != null) {
            TM1Member member = TM1Utils.findMember(this.getSession(), cube, this.mMUN, true);
            this.addAncestorsToAdjustedDepthTable(member);
        } else if (this.mLUN != null || this.mLevelNumber != null) {
            this.addAncestorLevelsToAdjustedDepthTable(cube);
        }
        this.mAdjustedDepthTable.addMembers(queryResult.iterator());
    }

    private void addAncestorLevelsToAdjustedDepthTable(TM1Cube cube) throws TM1Exception {
        LinkedList<TM1Level> levels = new LinkedList<TM1Level>();
        if (this.mLUN != null) {
            levels.add(TM1Utils.findLevel(cube, this.mLUN, true));
        } else if (this.mLevelNumber != null) {
            int levelNumber = this.mLevelNumber;
            if (this.mHUN != null) {
                TM1Hierarchy hierarchy = TM1Utils.findHierarchy(cube, this.mHUN, true);
                levels.add(this.getLowestLevelForDepth(hierarchy, levelNumber));
            } else if (this.mDUN != null) {
                Collection<TM1Hierarchy> hierarchies = TM1Utils.findDimension(cube, this.mDUN, true).getHierarchies();
                for (TM1Hierarchy hierarchy : hierarchies) {
                    levels.add(this.getLowestLevelForDepth(hierarchy, levelNumber));
                }
            } else {
                Collection<TM1Dimension> dimensions = cube.getDimensions();
                for (TM1Dimension dimension : dimensions) {
                    Collection<TM1Hierarchy> hierarchies = dimension.getHierarchies();
                    for (TM1Hierarchy hierarchy : hierarchies) {
                        levels.add(this.getLowestLevelForDepth(hierarchy, levelNumber));
                    }
                }
            }
        } else {
            throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionMissing, RestrictionType.LEVEL_UNIQUE_NAME.toString() + OR_DELIMITER + RestrictionType.LEVEL_NUMBER.toString());
        }
        for (TM1Level level : levels) {
            TM1Hierarchy hierarchy = level.getHierarchy();
            if (!hierarchy.isRagged()) continue;
            for (int levelNum = 0; levelNum < level.getLevelNumber(); ++levelNum) {
                TM1Level ancestorLevel = hierarchy.findLevel(levelNum);
                ArrayList<TM1Member> levelMembers = new ArrayList<TM1Member>((int)ancestorLevel.getCardinality());
                this.getLoader().loadLevelMembers(ancestorLevel, this.dimProperties, levelMembers);
                this.mAdjustedDepthTable.addMembers(levelMembers.iterator());
            }
        }
    }

    private void addAncestorsToAdjustedDepthTable(TM1Member member) throws TM1Exception {
        TM1Hierarchy hierarchy = member.getLevel().getHierarchy();
        if (hierarchy.isRagged()) {
            if (member.getLevelNumber() == 0 || hierarchy.getAccessibleRoots().contains(member)) {
                this.mAdjustedDepthTable.addMember(member);
            } else {
                EnumSet<TreeOperator> treeOps = EnumSet.of(TreeOperator.Self, TreeOperator.Ancestors);
                ArrayList<TM1Member> ancestors = new ArrayList<TM1Member>();
                this.getLoader().loadMembersTreeOp(member.getLevel().getHierarchy(), member.getProviderUniqueName(), treeOps, this.dimProperties, ancestors);
                this.mAdjustedDepthTable.addMembers(new InvertedList(ancestors).iterator());
            }
        }
    }

    private boolean needToAdjustLevelNumbers(TM1Cube cube) throws TM1Exception {
        return this.needToAdjustLevelNumbers(cube, null);
    }

    private boolean needToAdjustLevelNumbers(TM1Cube cube, List<TM1Member> queryResult) throws TM1Exception {
        if (this.mNeedToAdjustLevelNumbers != null) {
            return this.mNeedToAdjustLevelNumbers;
        }
        boolean someMissingRoots = false;
        if (this.mLUN != null) {
            TM1Level level = TM1Utils.findLevel(cube, this.mLUN, true);
            someMissingRoots = this.needToAdjustLevelNumbers(level.getHierarchy());
        } else if (this.mHUN != null) {
            TM1Hierarchy hierarchy = TM1Utils.findHierarchy(cube, this.mHUN, true);
            someMissingRoots = this.needToAdjustLevelNumbers(hierarchy);
        } else if (this.mMUN != null) {
            TM1Member member = null;
            if (queryResult != null) {
                for (TM1Member result : queryResult) {
                    if (!result.getProviderUniqueName().equals(this.mMUN)) continue;
                    member = result;
                    break;
                }
            }
            if (member == null) {
                member = TM1Utils.findMember(this.getSession(), cube, this.mMUN, true);
            }
            someMissingRoots = this.needToAdjustLevelNumbers(member.getLevel().getHierarchy());
        } else if (this.mDUN != null) {
            TM1Dimension dimension = TM1Utils.findDimension(cube, this.mDUN, true);
            for (TM1Hierarchy hierarchy : dimension.getHierarchies()) {
                if (!this.needToAdjustLevelNumbers(hierarchy)) continue;
                someMissingRoots = true;
                break;
            }
        } else {
            for (TM1Dimension dimension : cube.getDimensions()) {
                for (TM1Hierarchy hierarchy : dimension.getHierarchies()) {
                    if (!this.needToAdjustLevelNumbers(hierarchy)) continue;
                    someMissingRoots = true;
                    break;
                }
                if (!someMissingRoots) continue;
                break;
            }
        }
        this.mNeedToAdjustLevelNumbers = someMissingRoots;
        return someMissingRoots;
    }

    private boolean needToAdjustLevelNumbers(TM1Hierarchy hierarchy) {
        return hierarchy.isParentChild() && hierarchy.isRagged();
    }

    private TM1Level getLowestLevelForDepth(TM1Hierarchy hierarchy, int depth) {
        int maxLevelNumber = 0;
        for (TM1Member root : hierarchy.getAccessibleRoots()) {
            int currentMaxLevelNumber = Math.min(hierarchy.getLevels().size() - 1, root.getLevelNumber() + depth);
            maxLevelNumber = Math.max(maxLevelNumber, currentMaxLevelNumber);
        }
        return hierarchy.findLevel(maxLevelNumber);
    }

    private void memberSearch(TM1Cube cube, EnumSet<TreeOperator> treeOps, List<TM1Member> result) throws TM1Exception {
        if (null == treeOps) {
            throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionMissing, RestrictionType.TREEOP.toString());
        }
        TM1MemberSearch memberSearch = new TM1MemberSearch(this.getSession());
        if (null != this.mMUN) {
            TM1Member member = TM1Utils.findMember(this.getSession(), cube, this.mMUN, false);
            if (null == member) {
                return;
            }
            memberSearch.setSearchContext(member);
        } else if (null != this.mLUN) {
            memberSearch.setSearchContext(TM1Utils.findLevel(cube, this.mLUN, true));
        } else if (null != this.mHUN) {
            memberSearch.setSearchContext(TM1Utils.findHierarchy(cube, this.mHUN, true));
            memberSearch.setLevelNumber(this.mLevelNumber);
        } else {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Member search context was not specified.");
        }
        memberSearch.setSearchCriteria(this.mSearchCriteria);
        memberSearch.setTreeOps(treeOps);
        memberSearch.setAliasTable(this.mAliasTable);
        memberSearch.setDimensionProperties(this.dimProperties);
        result.addAll(memberSearch.execute());
    }

    private void findMembersWithTreeOps(TM1Cube cube, EnumSet<TreeOperator> treeOps, List<TM1Member> result) throws TM1Exception {
        if (null == treeOps) {
            throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionMissing, RestrictionType.TREEOP.toString());
        }
        String providerMUN = TM1Utils.convertMDDSMUNToProviderMUN(this.mMUN);
        String providerDUN = TM1Utils.extractProviderDUNFromMDDSMUN(this.mMUN);
        String providerHUN = TM1Utils.extractProviderHUNFromMDDSMUN(this.mMUN);
        TM1Dimension dimension = cube.findDimension(providerDUN);
        if (null == dimension) {
            throw new TM1ODPException(TM1MessageKeys.MET_NONEXISTANT_DIMENSION, providerDUN);
        }
        TM1Hierarchy hierarchy = dimension.findHierarchy(providerHUN);
        if (null == hierarchy) {
            throw new TM1ODPException(TM1MessageKeys.MET_NONEXISTANT_HIERARCHY, providerHUN);
        }
        if (treeOps.contains(TreeOperator.Siblings)) {
            List<TM1Member> accessibleRoots = hierarchy.getAccessibleRoots();
            for (TM1Member root : accessibleRoots) {
                if (!root.getProviderUniqueName().equals(providerMUN)) continue;
                if (this.dimProperties != null && this.dimProperties.length > 0) {
                    accessibleRoots = this.getLoader().loadAccessibleRootMembers(hierarchy, this.dimProperties);
                }
                result.addAll(accessibleRoots);
                if (!treeOps.contains(TreeOperator.Self)) {
                    result.remove(root);
                }
                return;
            }
        }
        this.getLoader().loadMembersTreeOp(hierarchy, providerMUN, treeOps, this.dimProperties, result);
    }

    private void findMembers(TM1Cube cube, List<TM1Member> result) throws TM1Exception {
        if (null != this.mLUN) {
            TM1Level level = TM1Utils.findLevel(cube, this.mLUN, true);
            this.getLoader().loadLevelMembers(level, this.dimProperties, result);
        } else if (null != this.mHUN) {
            TM1Hierarchy hierarchy = TM1Utils.findHierarchy(cube, this.mHUN, true);
            this.findMembers(hierarchy, result);
        } else if (null != this.mDUN) {
            TM1Dimension dimension = TM1Utils.findDimension(cube, this.mDUN, true);
            for (TM1Hierarchy hierarchy : dimension.getHierarchies()) {
                this.findMembers(hierarchy, result);
            }
        } else {
            for (TM1Dimension dimension : cube.getDimensions()) {
                for (TM1Hierarchy hierarchy : dimension.getHierarchies()) {
                    this.findMembers(hierarchy, result);
                }
            }
        }
    }

    private void findMembers(TM1Hierarchy hierarchy, List<TM1Member> result) throws TM1Exception {
        if (null != this.mLevelNumber) {
            int levelNumber = this.mLevelNumber;
            if (levelNumber == 0) {
                if (this.dimProperties != null && this.dimProperties.length > 0) {
                    result.addAll(this.getLoader().loadAccessibleRootMembers(hierarchy, this.dimProperties));
                } else {
                    result.addAll(hierarchy.getAccessibleRoots());
                }
                return;
            }
            if (hierarchy.isParentChild() && hierarchy.isRagged()) {
                for (TM1Member root : hierarchy.getAccessibleRoots()) {
                    TM1DepthMemberQuery depthMemberQuery = new TM1DepthMemberQuery(this.getSession(), levelNumber);
                    depthMemberQuery.setSearchContext(root);
                    depthMemberQuery.setAliasTable(this.mAliasTable);
                    depthMemberQuery.setDimensionProperties(this.dimProperties);
                    result.addAll(depthMemberQuery.execute());
                }
            } else {
                TM1Level level = hierarchy.findLevel(levelNumber);
                if (null != level) {
                    this.getLoader().loadLevelMembers(level, this.dimProperties, result);
                }
            }
        } else {
            this.getLoader().loadHierarchyMembers(hierarchy, this.dimProperties, result);
        }
    }

    private List<TM1Member> filterPPDSCodes(List<TM1Member> members) {
        if (null == this.mPPDSCodes) {
            return members;
        }
        if (this.mPPDSCodes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TM1Member> result = new ArrayList<TM1Member>(Math.min(members.size(), this.mPPDSCodes.size()));
        for (TM1Member m : members) {
            if (!this.mPPDSCodes.contains(m.getName())) continue;
            result.add(m);
        }
        return result;
    }

    private static EnumSet<TreeOperator> convertTreeOps(EnumSet<TreeOperatorEnum> xqeTreeOps) {
        EnumSet<TreeOperator> result = EnumSet.noneOf(TreeOperator.class);
        block8: for (TreeOperatorEnum op : xqeTreeOps) {
            switch (op) {
                case ANCESTORS: {
                    result.add(TreeOperator.Ancestors);
                    continue block8;
                }
                case CHILDREN: {
                    result.add(TreeOperator.Children);
                    continue block8;
                }
                case DESCENDANTS: {
                    result.add(TreeOperator.Descendants);
                    continue block8;
                }
                case PARENT: {
                    result.add(TreeOperator.Parent);
                    continue block8;
                }
                case SELF: {
                    result.add(TreeOperator.Self);
                    continue block8;
                }
                case SIBLINGS: {
                    result.add(TreeOperator.Siblings);
                    continue block8;
                }
            }
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Unsupported TreeOperatorEnum: " + op.toString());
        }
        return result;
    }

    private MemberRecord buildRecord(TM1Member member) throws TM1Exception {
        TM1Level level = member.getLevel();
        TM1Hierarchy hierarchy = level.getHierarchy();
        TM1Dimension dimension = hierarchy.getDimension();
        TM1Cube cube = dimension.getCube();
        MemberRecord record = new MemberRecord();
        record.setCatalogName("CATALOG");
        record.setCubeName(cube.getName());
        record.setDimensionUniqueName(dimension.getUniqueName());
        record.setHierarchyUniqueName(hierarchy.getUniqueName());
        if (this.needToAdjustLevelNumbers(cube)) {
            int adjustedLevelNumber = this.mAdjustedDepthTable.getAdjustedLevelNumber(member);
            record.setLevelNumber(adjustedLevelNumber);
            TM1Level adjustedLevel = hierarchy.findLevel(adjustedLevelNumber);
            record.setLevelUniqueName(adjustedLevel.getUniqueName());
        } else {
            record.setLevelNumber(member.getLevelNumber());
            record.setLevelUniqueName(level.getUniqueName());
        }
        record.setName(member.getName());
        record.setUniqueName(member.getUniqueName());
        record.setDescription(member.getDescription());
        record.setChildCardinality((int)member.getChildrenCardinality());
        record.setRollupType(RollupTypeEnum.ROLLUP);
        record.setUniqueId(member.getName());
        record.setDynamicField("PPDS_KEY", (Object)member.getName());
        if (null != member.getParentMUN() && member.getParentMUN().length() > 0) {
            record.setParentCount(1);
            record.setParentUniqueName(TM1Utils.convertProviderMUNToMDDSMUN(hierarchy.getCommonMUNPrefix(), member.getParentMUN()));
            record.setParentLevelNumber(record.getLevelNumber() - 1);
        } else {
            record.setParentCount(0);
            record.setParentLevelNumber(-1);
        }
        LocalizedString caption = TM1Utils.buildLocalizedCaption(this.getSession().getLocale(), member.getCaption(), this.mAliasTable, dimension.getName(), member.getAliasValues());
        record.setCaption((ILocalizedString)caption);
        Map<String, Object> dynamicFields = member.getDynamicFields();
        for (String prop : dynamicFields.keySet()) {
            if (!this.mPropNameToUniqueName.containsKey(prop)) continue;
            String propName = this.mPropNameToUniqueName.get(prop);
            record.setDynamicField(propName, dynamicFields.get(prop));
        }
        if (this.mPropNameToUniqueName.containsKey(MEMBER_KEY) && (!dynamicFields.containsKey(MEMBER_KEY) || dynamicFields.get(MEMBER_KEY) == null || dynamicFields.get(MEMBER_KEY).toString().isEmpty())) {
            record.setDynamicField(MEMBER_KEY, (Object)TM1Utils.extractLastUniqueNamePart(record.getUniqueName()));
        }
        return record;
    }

    @Override
    public void release() {
    }

    public void setDynamicProperties(String propString) {
        if (this.mPropNameToUniqueName == null) {
            this.mPropNameToUniqueName = new HashMap<String, String>();
        }
        if (propString == null) {
            this.dimProperties = new String[0];
        } else {
            this.dimProperties = propString.split(",");
            for (int i = 0; i < this.dimProperties.length; ++i) {
                String prop = this.dimProperties[i].trim();
                String propName = prop.startsWith(BRACE) ? prop.substring(prop.lastIndexOf(BRACE) + 1, prop.length() - 1) : prop;
                if (TM1MetadataLoader.isDefaultField(prop) || prop.equals(TM1Member.TM1MemberFields.PARENT_LEVEL.name())) continue;
                this.mPropNameToUniqueName.put(propName, prop);
            }
            String[] temp = new String[]{};
            this.dimProperties = this.mPropNameToUniqueName.keySet().toArray(temp);
        }
    }

    private final class InvertedList<T>
    implements Iterable<T> {
        ListIterator<T> iterator;

        private InvertedList(List<T> list) {
            this.iterator = list.listIterator(list.size());
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return InvertedList.this.iterator.hasPrevious();
                }

                @Override
                public T next() {
                    return InvertedList.this.iterator.previous();
                }

                @Override
                public void remove() {
                    InvertedList.this.iterator.remove();
                }
            };
        }
    }

    private class AdjustedDepthTable {
        Map<String, Integer> membersToDepth = new HashMap<String, Integer>();

        private AdjustedDepthTable() {
        }

        void addMembers(Iterator<TM1Member> iterator) {
            while (iterator.hasNext()) {
                this.addMember(iterator.next());
            }
        }

        void addMember(TM1Member member) {
            String parentMUN = member.getParentMUN();
            if (member.getLevelNumber() > 0 && parentMUN != null && !parentMUN.isEmpty() && this.membersToDepth.containsKey(parentMUN)) {
                this.membersToDepth.put(member.getProviderUniqueName(), this.membersToDepth.get(parentMUN) + 1);
            } else {
                this.membersToDepth.put(member.getProviderUniqueName(), 0);
            }
        }

        int getAdjustedLevelNumber(TM1Member member) {
            Integer levelNumber = this.membersToDepth.get(member.getProviderUniqueName());
            if (levelNumber == null) {
                return member.getLevelNumber();
            }
            return levelNumber;
        }

        boolean containsMUN(String memberUniqueName) {
            return this.membersToDepth.containsKey(memberUniqueName);
        }
    }
}

