/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.metadata.query;

import com.cognos.xqe.data.providers.olap.tm1.TM1Connection;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1CubeCache;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1MetadataLoader;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1MetadataSession;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.util.IReleasable;
import com.cognos.xqe.util.LocaleConverter;
import com.ibm.cognos.tm1.Server;
import com.ibm.cognos.tm1.TM1Exception;
import java.util.List;
import java.util.Locale;

public abstract class MetadataQuery<RESULT_TYPE>
implements IReleasable {
    protected static final Locale DEFAULT_LOCALE = LocaleConverter.strToLocale((String)"en-us");
    public static final String[] EMPTY_PROPERTY_ARRAY = new String[0];
    private final TM1MetadataSession mSession;
    protected Locale mLocale = DEFAULT_LOCALE;
    protected int mRangeFrom = 0;
    protected int mRangeSize = Integer.MAX_VALUE;

    protected MetadataQuery(TM1MetadataSession session) {
        this.mSession = session;
    }

    public final void setLocale(Locale locale) {
        this.mLocale = null == locale ? DEFAULT_LOCALE : locale;
    }

    public final void setRangeFrom(int from) {
        this.mRangeFrom = from;
    }

    public final void setRangeSize(int size) {
        this.mRangeSize = size;
    }

    protected final boolean isInRange(int index) {
        return index >= this.mRangeFrom && index < this.mRangeFrom + this.mRangeSize;
    }

    protected final TM1MetadataSession getSession() {
        return this.mSession;
    }

    protected final TM1Connection getConnection() {
        return this.mSession.getConnection();
    }

    protected final Server getServer() {
        return this.mSession.getServer();
    }

    protected final TM1MetadataLoader getLoader() {
        return this.mSession.getLoader();
    }

    protected final TM1CubeCache getCubeCache() {
        return this.getConnection().getCubeCache();
    }

    protected void checkRangeRestrictions() {
        if (this.mRangeFrom < 0 || this.mRangeSize < 0) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Illegal from/size restriction range.");
        }
    }

    public abstract List<RESULT_TYPE> execute() throws TM1Exception;

    public void release() {
    }
}

