/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.metadata.query;

import com.cognos.xqe.data.providers.olap.tm1.TM1MessageKeys;
import com.cognos.xqe.data.providers.olap.tm1.TM1ODPException;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Attribute;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Cube;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Dimension;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Hierarchy;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Level;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1MetadataSession;
import com.cognos.xqe.data.providers.olap.tm1.metadata.query.MetadataQuery;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1Utils;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.record.PropertyRecord;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocalizedString;
import com.ibm.cognos.tm1.TM1Exception;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PropertyRecordQuery
extends MetadataQuery<PropertyRecord> {
    private String mCubeName = null;
    private String mDUN = null;
    private String mHUN = null;
    private String mLUN = null;
    private String mPUN = null;

    public PropertyRecordQuery(TM1MetadataSession session) {
        super(session);
    }

    public void setCubeName(String cubeName) {
        this.mCubeName = cubeName;
    }

    public void setDUN(String dun) {
        this.mDUN = dun;
    }

    public void setHUN(String hun) {
        this.mHUN = hun;
    }

    public void setLUN(String lun) {
        this.mLUN = lun;
    }

    public void setPUN(String pun) {
        this.mPUN = pun;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<PropertyRecord> execute() throws TM1Exception {
        void var5_11;
        this.checkRangeRestrictions();
        if (null == this.mCubeName) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "A cube name was not specified.");
        }
        if (this.mRangeSize < 1) {
            return Collections.emptyList();
        }
        TM1Cube cube = this.getLoader().loadCube(this.mCubeName, this.getCubeCache());
        if (null == cube) {
            throw new TM1ODPException(TM1MessageKeys.MET_CANNOT_FIND_CUBE, this.mCubeName);
        }
        ArrayList<TM1Attribute> attributesFound = new ArrayList<TM1Attribute>();
        if (null != this.mPUN && !"MEMBER_KEY".equals(this.mPUN)) {
            TM1Attribute attribute = TM1Utils.findAttribute(cube, this.mPUN);
            if (null != attribute) {
                attributesFound.add(attribute);
            }
        } else if (null != this.mLUN) {
            Iterator<TM1Hierarchy> hierarchy;
            TM1Level level = TM1Utils.findLevel(cube, this.mLUN, false);
            if (null != level && !((TM1Hierarchy)((Object)(hierarchy = level.getHierarchy()))).getDimension().isMeasureDimension() && !((TM1Hierarchy)((Object)hierarchy)).isParentChild()) {
                attributesFound.addAll(level.getAttributes());
            }
        } else if (null != this.mHUN) {
            TM1Hierarchy hierarchy = TM1Utils.findHierarchy(cube, this.mHUN, false);
            if (null != hierarchy && !hierarchy.getDimension().isMeasureDimension()) {
                attributesFound.addAll(hierarchy.getAttributes());
                if (!hierarchy.isParentChild()) {
                    for (TM1Level tM1Level : hierarchy.getLevels()) {
                        attributesFound.addAll(tM1Level.getAttributes());
                    }
                }
            }
        } else if (null != this.mDUN) {
            TM1Dimension dimension = TM1Utils.findDimension(cube, this.mDUN, false);
            if (null != dimension && !dimension.isMeasureDimension()) {
                attributesFound.addAll(dimension.getAttributes());
                for (TM1Hierarchy tM1Hierarchy : dimension.getHierarchies()) {
                    attributesFound.addAll(tM1Hierarchy.getAttributes());
                    if (tM1Hierarchy.isParentChild()) continue;
                    for (TM1Level level : tM1Hierarchy.getLevels()) {
                        attributesFound.addAll(level.getAttributes());
                    }
                }
            }
        } else {
            for (TM1Dimension dimension : cube.getDimensions()) {
                if (dimension.isMeasureDimension()) continue;
                attributesFound.addAll(dimension.getAttributes());
                for (TM1Hierarchy hierarchy : dimension.getHierarchies()) {
                    attributesFound.addAll(hierarchy.getAttributes());
                    if (hierarchy.isParentChild()) continue;
                    for (TM1Level level : hierarchy.getLevels()) {
                        attributesFound.addAll(level.getAttributes());
                    }
                }
            }
        }
        int effectiveSize = Math.min(this.mRangeSize, attributesFound.size() - this.mRangeFrom);
        if (effectiveSize <= 0) {
            return Collections.emptyList();
        }
        ArrayList<PropertyRecord> records = new ArrayList<PropertyRecord>(effectiveSize);
        int n = this.mRangeFrom;
        while (var5_11 < this.mRangeFrom + effectiveSize) {
            records.add(this.buildRecord((TM1Attribute)attributesFound.get((int)var5_11)));
            ++var5_11;
        }
        return records;
    }

    private PropertyRecord buildRecord(TM1Attribute attribute) {
        PropertyRecord record = new PropertyRecord();
        record.setCatalogName("CATALOG");
        record.setUniqueName(attribute.getUniqueName());
        record.setName(attribute.getName());
        record.setCaption((ILocalizedString)new LocalizedString(this.mLocale, attribute.getCaption()));
        record.setRoleType(attribute.getRoleType());
        record.setDescription(attribute.getDescription());
        if (attribute.isDimensionAttribute()) {
            TM1Dimension dimension = attribute.getDimension();
            TM1Cube cube = dimension.getCube();
            record.setCubeName(cube.getName());
            record.setDimensionUniqueName(dimension.getUniqueName());
        } else if (attribute.isHierarchyAttribute()) {
            TM1Hierarchy hierarchy = attribute.getHierarchy();
            TM1Dimension dimension = hierarchy.getDimension();
            TM1Cube cube = dimension.getCube();
            record.setCubeName(cube.getName());
            record.setDimensionUniqueName(dimension.getUniqueName());
            record.setHierarchyUniqueName(hierarchy.getUniqueName());
        } else {
            TM1Level level = attribute.getLevel();
            TM1Hierarchy hierarchy = level.getHierarchy();
            TM1Dimension dimension = hierarchy.getDimension();
            TM1Cube cube = dimension.getCube();
            record.setCubeName(cube.getName());
            record.setDimensionUniqueName(dimension.getUniqueName());
            record.setHierarchyUniqueName(hierarchy.getUniqueName());
            record.setLevelUniqueName(level.getUniqueName());
        }
        record.setDataType(TM1Utils.convertFieldTypeToDataType(attribute.getDataType()));
        record.setUniqueId(attribute.getName());
        return record;
    }
}

