/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.util;

import com.cognos.xqe.data.providers.olap.tm1.TM1MessageKeys;
import com.cognos.xqe.data.providers.olap.tm1.TM1ODPException;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class TM1AliasTable {
    private final Map<String, Map<String, String>> mDimToLocaleTable = new HashMap<String, Map<String, String>>();

    public static TM1AliasTable parse(Map<Object, String> aliases) {
        if (null == aliases) {
            return null;
        }
        TM1AliasTable table = new TM1AliasTable();
        for (Map.Entry<Object, String> e : aliases.entrySet()) {
            String[] attributes;
            String localeStr = e.getKey().toString();
            String attributeUN = e.getValue();
            if (attributeUN == null || attributeUN.length() == 0 || "null".equals(attributeUN)) continue;
            for (String attr : attributes = attributeUN.split(";")) {
                if (attr.isEmpty()) continue;
                try {
                    String[] parts = UniqueNameParser.parse((String)attr);
                    if (parts.length != 2) {
                        throw new TM1ODPException(TM1MessageKeys.MET_INVALID_ALIAS_ATTRIBUTE_UNIQUE_NAME, attributeUN);
                    }
                    table.insert(parts[0], localeStr, parts[1]);
                }
                catch (UniqueNameParserException ex) {
                    throw XQERuntimeException.wrap((Throwable)ex);
                }
            }
        }
        return table;
    }

    private TM1AliasTable() {
    }

    private void insert(String dimensionName, String localeName, String attributeName) {
        Map<String, String> localeTable = this.mDimToLocaleTable.get(dimensionName);
        if (null == localeTable) {
            localeTable = new HashMap<String, String>();
            this.mDimToLocaleTable.put(dimensionName, localeTable);
        }
        localeTable.put(localeName, attributeName);
    }

    public Set<String> getLocals(String dimensionName) {
        Map<String, String> localeTable = this.mDimToLocaleTable.get(dimensionName);
        if (null != localeTable) {
            return localeTable.keySet();
        }
        return Collections.emptySet();
    }

    public String getAttributeName(String dimensionName, String localeName) {
        Map<String, String> localeTable = this.mDimToLocaleTable.get(dimensionName);
        if (null != localeTable) {
            return localeTable.get(localeName);
        }
        return null;
    }
}

